/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.util;

import ca.ucalgary.bluejay.client.lineartarget.CircularArea;
import ca.ucalgary.bluejay.gui.BluejayUObjectWindow;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;

public class BluejaySVGGraphics2D
extends Graphics2D {
    private Color mainColor;
    private Font mainFont;
    private BasicStroke mainStroke;
    private Dimension mainCanvasDimension;
    private Rectangle mainViewbox;
    private static Graphics dummyFontMetricGraphics;
    private Stack transformStack;
    private int numOpenGroupTags;
    private String suggestedGroupTag;
    private String currentGroupTag;
    private static final double RAD_PER_DEGREE = Math.PI / 180;
    private static final double ALMOST_ZERO = 1.0E-6;
    private static final int SWEEP_CENTER_ON_LEFT_HAND = 0;
    private static final int SWEEP_CENTER_ON_RIGHT_HAND = 1;
    private static final double DEGREE_ANGLE_AT_WHICH_ARC_IS_VISIBLY_CURVED = 1.0;
    private static final double SMALL_SAFETY_MARGIN_DEG_ANGLE = 1.12;
    private static final DecimalFormat df;
    private String outputFileName;
    private BluejayUObjectWindow outputSvgWindow;
    private StringBuffer currentGroupBuffer;
    private Vector allGroupsContent;
    private boolean haveNotDisposedYet;

    private BluejaySVGGraphics2D() {
    }

    public BluejaySVGGraphics2D(String string) {
        this.outputFileName = string.trim();
        this.outputSvgWindow = null;
        this.initialize();
    }

    public BluejaySVGGraphics2D(BluejayUObjectWindow bluejayUObjectWindow) {
        this.outputFileName = null;
        this.outputSvgWindow = bluejayUObjectWindow;
        this.initialize();
    }

    private void initialize() {
        this.haveNotDisposedYet = true;
        this.transformStack = new Stack();
        this.allGroupsContent = new Vector();
        this.currentGroupBuffer = new StringBuffer();
        this.numOpenGroupTags = 0;
        this.suggestedGroupTag = "";
        this.currentGroupTag = "";
        this.mainColor = Color.black;
        this.mainStroke = new BasicStroke();
        this.mainCanvasDimension = null;
        this.mainViewbox = null;
        BufferedImage bufferedImage = new BufferedImage(11, 11, 4);
        dummyFontMetricGraphics = bufferedImage.getGraphics();
        this.mainFont = dummyFontMetricGraphics.getFont();
    }

    public void setSize(Dimension dimension) {
        this.mainCanvasDimension = new Dimension(dimension);
    }

    public void setViewbox(Rectangle rectangle) {
        this.mainViewbox = rectangle == null ? null : new Rectangle(rectangle);
    }

    private void openGroupTagIfNeeded() {
        int n = this.transformStack.size();
        String string = n > 0 ? "\t<g transform=\"" : "\t<g";
        for (int i = 0; i < n; ++i) {
            Object object;
            Object e = this.transformStack.elementAt(i);
            if (e instanceof SVGTranslation) {
                object = (SVGTranslation)e;
                string = string + "translate(" + ((SVGTranslation)object).tx + " " + ((SVGTranslation)object).ty + ") ";
                continue;
            }
            if (!(e instanceof SVGRotation)) continue;
            object = (SVGRotation)e;
            string = string + "translate(" + df.format(((SVGRotation)object).cx) + " " + df.format(((SVGRotation)object).cy) + ") " + "rotate(" + df.format(((SVGRotation)object).angleRad / (Math.PI / 180)) + ") " + "translate(-" + df.format(((SVGRotation)object).cx) + " -" + df.format(((SVGRotation)object).cy) + ") ";
        }
        if (!(string = string + (n > 0 ? "\">\n" : ">\n")).equals(this.currentGroupTag)) {
            if (this.numOpenGroupTags > 0) {
                this.currentGroupBuffer.append("\t</g>\n");
                --this.numOpenGroupTags;
            }
            this.allGroupsContent.add(this.currentGroupBuffer.toString());
            this.currentGroupBuffer = new StringBuffer();
            this.currentGroupTag = string;
            this.currentGroupBuffer.append(this.currentGroupTag);
            ++this.numOpenGroupTags;
        }
    }

    private String colorToString() {
        String string = "rgb(" + this.mainColor.getRed() + "," + this.mainColor.getGreen() + "," + this.mainColor.getBlue() + ")";
        return string;
    }

    private String strokeWidthToString() {
        double d = this.mainStroke.getLineWidth();
        if ((d - 1.0) * (d - 1.0) < 1.0E-4) {
            return "";
        }
        return "stroke-width=\"" + df.format(d) + "\"";
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        System.err.println("Warning: BluejaySVGGraphics2D.clearRect(...) not implemented");
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        System.err.println("Warning: BluejaySVGGraphics2D.clipRect(...) not implemented");
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        System.err.println("Warning: BluejaySVGGraphics2D.copyArea(...) not implemented");
    }

    public Graphics create() {
        System.err.println("Warning: BluejaySVGGraphics2D.create(...) not implemented");
        return null;
    }

    public Graphics create(int n, int n2, int n3, int n4) {
        System.err.println("Warning: BluejaySVGGraphics2D.create(...) not implemented");
        return null;
    }

    public void dispose() {
        try {
            if (this.haveNotDisposedYet) {
                while (this.numOpenGroupTags > 0) {
                    this.currentGroupBuffer.append("\t</g>\n");
                    --this.numOpenGroupTags;
                }
                this.currentGroupBuffer.append("</svg>\n");
                this.allGroupsContent.add(this.currentGroupBuffer.toString());
                this.currentGroupBuffer = new StringBuffer();
                if (this.mainViewbox == null) {
                    this.mainViewbox = new Rectangle(0, 0, this.mainCanvasDimension.width, this.mainCanvasDimension.height);
                }
                String string = "<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.0//EN\"\n\"http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd\">\n<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"\n\twidth=\"" + this.mainCanvasDimension.width + "\" height=\"" + this.mainCanvasDimension.height + "\" viewBox=\"" + this.mainViewbox.x + " " + this.mainViewbox.y + " " + this.mainViewbox.width + " " + this.mainViewbox.height + "\" " + "xml:space=\"preserve\">\n";
                if (this.outputFileName != null && !"".equals(this.outputFileName)) {
                    FileWriter fileWriter = new FileWriter(new File(this.outputFileName));
                    fileWriter.write(string);
                    int n = this.allGroupsContent.size();
                    for (int i = 0; i < n; ++i) {
                        fileWriter.write((String)this.allGroupsContent.elementAt(i));
                    }
                    fileWriter.close();
                } else if (this.outputSvgWindow != null) {
                    this.outputSvgWindow.write(string);
                    this.outputSvgWindow.flush();
                    int n = this.allGroupsContent.size();
                    for (int i = 0; i < n; ++i) {
                        this.outputSvgWindow.write((String)this.allGroupsContent.elementAt(i));
                    }
                    this.outputSvgWindow.flush();
                }
                this.haveNotDisposedYet = false;
                this.transformStack.removeAllElements();
                this.allGroupsContent.removeAllElements();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        System.err.println("Warning: BluejaySVGGraphics2D.draw3DRect(...) not implemented");
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        System.err.println("Warning: BluejaySVGGraphics2D.drawArc(...) not implemented");
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        System.err.println("Warning: BluejaySVGGraphics2D.drawBytes(...) not implemented");
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        System.err.println("Warning: BluejaySVGGraphics2D.drawChars(...) not implemented");
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        System.err.println("Warning: BluejaySVGGraphics2D.drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) not implemented");
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        System.err.println("Warning: BluejaySVGGraphics2D.drawImage(Image img, int x, int y, ImageObserver observer) not implemented");
        Exception exception = new Exception("MUST fix SVG DrawImage(Image img, int x, int y, ImageObserver observer)!!!");
        exception.printStackTrace();
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        System.err.println("Warning: BluejaySVGGraphics2D.drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) not implemented");
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        System.err.println("Warning: BluejaySVGGraphics2D.drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) not implemented");
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        System.err.println("Warning: BluejaySVGGraphics2D.drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) not implemented");
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        System.err.println("Warning: BluejaySVGGraphics2D.drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) not implemented");
        return false;
    }

    private String lineToString(double d, double d2, double d3, double d4) {
        double d5 = Math.sqrt((d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2));
        double d6 = 0.5 * (d3 - d) / d5;
        double d7 = 0.5 * (d4 - d2) / d5;
        double d8 = d - d6;
        double d9 = d2 - d7;
        double d10 = d3 + d6;
        double d11 = d4 + d7;
        String string = "\t\t<path d=\"M " + df.format(d8) + " " + df.format(d9) + " " + "L " + df.format(d10) + " " + df.format(d11) + "\" " + "stroke=\"" + this.colorToString() + "\" " + this.strokeWidthToString() + "/>\n";
        return string;
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.openGroupTagIfNeeded();
        this.currentGroupBuffer.append(this.lineToString(n, n2, n3, n4));
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.openGroupTagIfNeeded();
        double d = (double)n + (double)n3 / 2.0;
        double d2 = (double)n2 + (double)n4 / 2.0;
        double d3 = (double)n3 / 2.0;
        double d4 = (double)n4 / 2.0;
        this.currentGroupBuffer.append("\t\t<ellipse cx=\"" + df.format(d) + "\" cy=\"" + df.format(d2) + "\" " + "rx=\"" + df.format(d3) + "\" ry=\"" + df.format(d4) + "\"\n" + "\t\t\tfill=\"none\" stroke=\"" + this.colorToString() + "\" " + this.strokeWidthToString() + "/>\n");
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        System.err.println("Warning: BluejaySVGGraphics2D.drawPolygon(...) not implemented");
    }

    public void drawPolygon(Polygon polygon) {
        System.err.println("Warning: BluejaySVGGraphics2D.drawPolygon(...) not implemented");
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        System.err.println("Warning: BluejaySVGGraphics2D.drawPolyline(...) not implemented");
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.openGroupTagIfNeeded();
        this.currentGroupBuffer.append("\t\t<rect x=\"" + n + "\" y=\"" + n2 + "\" width=\"" + n3 + "\" height=\"" + n4 + "\"\n" + "\t\t\tfill=\"none\" stroke=\"" + this.colorToString() + "\" " + this.strokeWidthToString() + "/>\n");
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        System.err.println("Warning: BluejaySVGGraphics2D.drawRoundRect(...) not implemented");
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        System.err.println("Warning: BluejaySVGGraphics2D.drawString(...) not implemented");
    }

    public void drawString(String string, int n, int n2) {
        this.openGroupTagIfNeeded();
        String string2 = string.replaceAll("&", "&amp;").replaceAll("<", "&lt;");
        this.currentGroupBuffer.append("\t\t<text x=\"" + n + "\" y=\"" + n2 + "\" font-family=\"" + this.mainFont.getFamily() + "\" " + "font-size=\"" + this.getFontMetrics().getAscent() + "\" fill=\"" + this.colorToString() + "\" >\n" + string2 + "\n\t\t</text>\n");
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        System.err.println("Warning: BluejaySVGGraphics2D.fill3DRect(...) not implemented");
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        System.err.println("Warning: BluejaySVGGraphics2D.fillArc(...) not implemented");
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.openGroupTagIfNeeded();
        double d = (double)n + (double)n3 / 2.0;
        double d2 = (double)n2 + (double)n4 / 2.0;
        double d3 = (double)n3 / 2.0;
        double d4 = (double)n4 / 2.0;
        this.currentGroupBuffer.append("\t\t<ellipse cx=\"" + df.format(d) + "\" cy=\"" + df.format(d2) + "\" " + "rx=\"" + df.format(d3) + "\" ry=\"" + df.format(d4) + "\" " + "fill=\"" + this.colorToString() + "\"  />\n");
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.openGroupTagIfNeeded();
        this.currentGroupBuffer.append("\t\t<polygon fill=\"" + this.colorToString() + "\" stroke=\"" + this.colorToString() + "\" stroke-width=\"1\" points=\"");
        for (int i = 0; i < n; ++i) {
            this.currentGroupBuffer.append(" " + nArray[i] + "," + nArray2[i]);
        }
        this.currentGroupBuffer.append("\" />\n");
        System.err.println("BAPTISTE:::::: BluejaySVGGraphics2D.fillPolygon(...) Is implemented let see how it works");
    }

    public void fillPolygon(Polygon polygon) {
        System.err.println("Warning: BluejaySVGGraphics2D.fillPolygon(...) not implemented");
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.openGroupTagIfNeeded();
        this.currentGroupBuffer.append("\t\t<rect x=\"" + n + "\" y=\"" + n2 + "\" width=\"" + n3 + "\" height=\"" + n4 + "\" " + "fill=\"" + this.colorToString() + "\" />\n");
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        System.err.println("Warning: BluejaySVGGraphics2D.fillRoundRect(...) not implemented");
    }

    public void finalize() {
        this.dispose();
    }

    public Shape getClip() {
        System.err.println("Warning: BluejaySVGGraphics2D.getClip(...) not implemented");
        return null;
    }

    public Rectangle getClipBounds() {
        System.err.println("Warning: BluejaySVGGraphics2D.getClipBounds(...) not implemented");
        return null;
    }

    public Rectangle getClipBounds(Rectangle rectangle) {
        System.err.println("Warning: BluejaySVGGraphics2D.getClipBounds(...) not implemented");
        return null;
    }

    public Color getColor() {
        return this.mainColor;
    }

    public Font getFont() {
        return this.mainFont;
    }

    public FontMetrics getFontMetrics() {
        System.err.println("BAPTISTE ::: dummyFontMetricGraphics = " + dummyFontMetricGraphics + "\t\t\n mainFont = " + this.mainFont);
        return dummyFontMetricGraphics.getFontMetrics(this.mainFont);
    }

    public FontMetrics getFontMetrics(Font font) {
        return dummyFontMetricGraphics.getFontMetrics(font);
    }

    public boolean hitClip(int n, int n2, int n3, int n4) {
        System.err.println("Warning: BluejaySVGGraphics2D.hitClip(...) not implemented");
        return false;
    }

    public void setClip(int n, int n2, int n3, int n4) {
        System.err.println("Warning: BluejaySVGGraphics2D.setClip(...) not implemented");
    }

    public void setClip(Shape shape) {
        System.err.println("Warning: BluejaySVGGraphics2D.setClip(...) not implemented");
    }

    public void setColor(Color color) {
        this.mainColor = color;
    }

    public void setFont(Font font) {
        this.mainFont = font;
    }

    public void setPaintMode() {
        System.err.println("Warning: BluejaySVGGraphics2D.setPaintMode(...) not implemented");
    }

    public void setXORMode(Color color) {
        System.err.println("Warning: BluejaySVGGraphics2D.setXORMode(...) not implemented");
    }

    public String toString() {
        System.err.println("Warning: BluejaySVGGraphics2D.toString(...) not implemented");
        return null;
    }

    public void translate(int n, int n2) {
        Object e;
        if (n == 0 && n2 == 0) {
            return;
        }
        boolean bl = true;
        if (!this.transformStack.empty() && (e = this.transformStack.peek()) instanceof SVGTranslation) {
            SVGTranslation sVGTranslation = (SVGTranslation)e;
            sVGTranslation.tx += n;
            sVGTranslation.ty += n2;
            if (sVGTranslation.tx == 0 && sVGTranslation.ty == 0) {
                this.transformStack.pop();
            }
            bl = false;
        }
        if (bl) {
            this.transformStack.push(new SVGTranslation(n, n2));
        }
    }

    public void addRenderingHints(Map map) {
        System.err.println("Warning: BluejaySVGGraphics2D.addRenderingHints(...) not implemented");
    }

    public void clip(Shape shape) {
        System.err.println("Warning: BluejaySVGGraphics2D.clip(...) not implemented");
    }

    public void draw(Shape shape) {
        if (shape instanceof Line2D.Double) {
            this.openGroupTagIfNeeded();
            Line2D.Double double_ = (Line2D.Double)shape;
            this.currentGroupBuffer.append(this.lineToString(double_.x1, double_.y1, double_.x2, double_.y2));
        } else if (shape instanceof Ellipse2D.Double) {
            this.openGroupTagIfNeeded();
            Ellipse2D.Double double_ = (Ellipse2D.Double)shape;
            double d = double_.x + double_.width / 2.0;
            double d2 = double_.y + double_.height / 2.0;
            double d3 = double_.width / 2.0;
            double d4 = double_.height / 2.0;
            this.currentGroupBuffer.append("\t\t<ellipse cx=\"" + df.format(d) + "\" cy=\"" + df.format(d2) + "\" " + "rx=\"" + df.format(d3) + "\" ry=\"" + df.format(d4) + "\"\n" + "\t\t\tfill=\"none\" stroke=\"" + this.colorToString() + "\" " + this.strokeWidthToString() + "/>\n");
        } else {
            if (shape instanceof Arc2D.Double) {
                this.openGroupTagIfNeeded();
                Arc2D.Double double_ = (Arc2D.Double)shape;
                Point2D.Double double_2 = new Point2D.Double(double_.getCenterX(), double_.getCenterY());
                double d = double_.getWidth() / 2.0;
                double d5 = double_.getAngleExtent();
                double d6 = double_.getAngleStart() * (Math.PI / 180);
                double d7 = d6 + d5 * (Math.PI / 180);
                Point2D.Double double_3 = new Point2D.Double(Math.cos(-d6), Math.sin(-d6));
                Point2D.Double double_4 = new Point2D.Double(Math.cos(-d7), Math.sin(-d7));
                Point2D.Double double_5 = new Point2D.Double(double_2.x + d * double_3.x, double_2.y + d * double_3.y);
                Point2D.Double double_6 = new Point2D.Double(double_2.x + d * double_4.x, double_2.y + d * double_4.y);
                if (d5 < 0.0) {
                    return;
                }
                if (d5 >= 360.0) {
                    return;
                }
                if (d5 < 1.0) {
                    this.currentGroupBuffer.append("\t\t<path d=\"M " + df.format(double_5.x) + "," + df.format(double_5.y) + "\t" + "L " + df.format(double_6.x) + "," + df.format(double_6.y) + "\n" + "\t\t\tstroke=\"" + this.colorToString() + "\" " + this.strokeWidthToString() + " fill=\"none\"/>\n");
                    return;
                }
                if (d5 < 180.0) {
                    this.currentGroupBuffer.append("\t\t<path d=\"M " + df.format(double_5.x) + "," + df.format(double_5.y) + "\n" + this.getBezierArcString(double_2, d, d5, double_5, double_6, double_3, double_4) + " \" \n" + "\t\t\tstroke=\"" + this.colorToString() + "\" " + this.strokeWidthToString() + " fill=\"none\"/>\n");
                    return;
                }
                double d8 = d5 - 180.0;
                Point2D.Double double_7 = new Point2D.Double(-double_3.x, -double_3.y);
                Point2D.Double double_8 = new Point2D.Double(double_2.x + d * double_7.x, double_2.y + d * double_7.y);
                this.currentGroupBuffer.append("\t\t<path d=\"M " + df.format(double_5.x) + "," + df.format(double_5.y) + "\n" + this.getBezierArcString(double_2, d, 180.0, double_5, double_8, double_3, double_7) + this.getBezierArcString(double_2, d, d8, double_8, double_6, double_7, double_4) + "\t\t\tL " + df.format(double_5.x) + "," + df.format(double_5.y) + " \" \n" + "\t\t\tstroke=\"" + this.colorToString() + "\" " + this.strokeWidthToString() + " fill=\"none\"/>\n");
                return;
            }
            if (shape instanceof Rectangle2D.Double) {
                this.openGroupTagIfNeeded();
                Rectangle2D.Double double_ = (Rectangle2D.Double)shape;
                this.currentGroupBuffer.append("\t\t<rect x=\"" + df.format(double_.x) + "\" y=\"" + df.format(double_.y) + "\" " + "width=\"" + df.format(double_.width) + "\" height=\"" + df.format(double_.height) + "\"\n" + "\t\t\tfill=\"none\" stroke=\"" + this.colorToString() + "\" " + this.strokeWidthToString() + "/>\n");
            } else {
                System.err.println("Warning: BluejaySVGGraphics2D.draw(Shape s) not implemented");
            }
        }
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        System.err.println("Warning: BluejaySVGGraphics2D.drawGlyphVector(...) not implemented");
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        System.err.println("Warning: BluejaySVGGraphics2D.drawImage(BufferedImage img, BufferedImageOp op, int x, int y) not implemented");
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        System.err.println("Warning: BluejaySVGGraphics2D.drawImage(Image img, AffineTransform xform, ImageObserver obs) not implemented");
        return false;
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        System.err.println("Warning: BluejaySVGGraphics2D.drawRenderableImage(...) not implemented");
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        System.err.println("Warning: BluejaySVGGraphics2D.drawRenderedImage(...) not implemented");
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        System.err.println("Warning: BluejaySVGGraphics2D.drawString(...) not implemented");
    }

    public void drawString(String string, float f, float f2) {
        this.openGroupTagIfNeeded();
        String string2 = string.replaceAll("&", "&amp;").replaceAll("<", "&lt;");
        this.currentGroupBuffer.append("\t\t<text x=\"" + f + "\" y=\"" + f2 + "\" font-family=\"" + this.mainFont.getFamily() + "\" " + "font-size=\"" + this.getFontMetrics().getAscent() + "\" fill=\"" + this.colorToString() + "\" >\n" + string2 + "\n\t\t</text>\n");
        System.err.println("BAPTISTE::::: BluejaySVGGraphics2D.drawString(...) is now implemented");
    }

    private String getBezierArcString(Point2D.Double double_, double d, double d2, Point2D.Double double_2, Point2D.Double double_3, Point2D.Double double_4, Point2D.Double double_5) {
        int n = d2 > 0.0 ? 1 : -1;
        double d3 = (double)n * d2 * (Math.PI / 180) / 2.0;
        double d4 = 1.3333333333333333 * (1.0 - Math.cos(d3)) / Math.sin(d3);
        Point2D.Double double_6 = new Point2D.Double((double)n * double_4.y, (double)(-n) * double_4.x);
        Point2D.Double double_7 = new Point2D.Double((double)(-n) * double_5.y, (double)n * double_5.x);
        double d5 = d * d4;
        Point2D.Double double_8 = new Point2D.Double(double_2.x + d5 * double_6.x, double_2.y + d5 * double_6.y);
        Point2D.Double double_9 = new Point2D.Double(double_3.x + d5 * double_7.x, double_3.y + d5 * double_7.y);
        String string = "\t\t\tC " + df.format(double_8.x) + "," + df.format(double_8.y) + "\t" + df.format(double_9.x) + "," + df.format(double_9.y) + "\t" + df.format(double_3.x) + "," + df.format(double_3.y) + "\n";
        return string;
    }

    public void fill(Shape shape) {
        if (shape instanceof CircularArea && ((CircularArea)shape).getAreaType() == 1003) {
            this.openGroupTagIfNeeded();
            CircularArea circularArea = (CircularArea)shape;
            Point2D.Double double_ = new Point2D.Double(circularArea.getCenterX(), circularArea.getCenterY());
            double d = circularArea.getInnerRadius();
            double d2 = circularArea.getOuterRadius();
            double d3 = circularArea.getExtentAngle();
            double d4 = circularArea.getStartAngle() * (Math.PI / 180);
            double d5 = d4 + d3 * (Math.PI / 180);
            Point2D.Double double_2 = new Point2D.Double(Math.cos(-d4), Math.sin(-d4));
            Point2D.Double double_3 = new Point2D.Double(Math.cos(-d5), Math.sin(-d5));
            Point2D.Double double_4 = new Point2D.Double(double_.x + d2 * double_2.x, double_.y + d2 * double_2.y);
            Point2D.Double double_5 = new Point2D.Double(double_.x + d2 * double_3.x, double_.y + d2 * double_3.y);
            Point2D.Double double_6 = new Point2D.Double(double_.x + d * double_2.x, double_.y + d * double_2.y);
            Point2D.Double double_7 = new Point2D.Double(double_.x + d * double_3.x, double_.y + d * double_3.y);
            if (d3 < 0.0) {
                return;
            }
            if (d3 >= 360.0) {
                return;
            }
            if (d3 < 1.0) {
                this.currentGroupBuffer.append("\t\t<path d=\"M " + df.format(double_4.x) + "," + df.format(double_4.y) + "\t" + "L " + df.format(double_5.x) + "," + df.format(double_5.y) + "\n" + "\t\t\tL " + df.format(double_7.x) + "," + df.format(double_7.y) + "\t" + "L " + df.format(double_6.x) + "," + df.format(double_6.y) + " z\" \n" + "\t\t\tfill=\"" + this.colorToString() + "\" />\n");
                return;
            }
            if (d3 < 180.0) {
                this.currentGroupBuffer.append("\t\t<path d=\"M " + df.format(double_4.x) + "," + df.format(double_4.y) + "\n" + this.getBezierArcString(double_, d2, d3, double_4, double_5, double_2, double_3) + "\t\t\tL " + df.format(double_7.x) + "," + df.format(double_7.y) + "\n" + this.getBezierArcString(double_, d, -d3, double_7, double_6, double_3, double_2) + "\t\t\tL " + df.format(double_4.x) + "," + df.format(double_4.y) + " \" \n" + "\t\t\tfill=\"" + this.colorToString() + "\" />\n");
                return;
            }
            double d6 = d3 - 180.0;
            Point2D.Double double_8 = new Point2D.Double(-double_2.x, -double_2.y);
            Point2D.Double double_9 = new Point2D.Double(double_.x + d2 * double_8.x, double_.y + d2 * double_8.y);
            Point2D.Double double_10 = new Point2D.Double(double_.x + d * double_8.x, double_.y + d * double_8.y);
            this.currentGroupBuffer.append("\t\t<path d=\"M " + df.format(double_4.x) + "," + df.format(double_4.y) + "\n" + this.getBezierArcString(double_, d2, 180.0, double_4, double_9, double_2, double_8) + this.getBezierArcString(double_, d2, d6, double_9, double_5, double_8, double_3) + "\t\t\tL " + df.format(double_7.x) + "," + df.format(double_7.y) + "\n" + this.getBezierArcString(double_, d, -d6, double_7, double_10, double_3, double_8) + this.getBezierArcString(double_, d, -180.0, double_10, double_6, double_8, double_2) + "\t\t\tL " + df.format(double_4.x) + "," + df.format(double_4.y) + " \" \n" + "\t\t\tfill=\"" + this.colorToString() + "\" />\n");
            return;
        }
        if (shape instanceof Rectangle2D.Double) {
            this.openGroupTagIfNeeded();
            Rectangle2D.Double double_ = (Rectangle2D.Double)shape;
            this.currentGroupBuffer.append("\t\t<rect x=\"" + df.format(double_.x) + "\" y=\"" + df.format(double_.y) + "\" " + "width=\"" + df.format(double_.width) + "\" height=\"" + df.format(double_.height) + "\" " + "fill=\"" + this.colorToString() + "\"/>\n");
        } else {
            Exception exception = new Exception("BluejaySVGGraphics2D.fill(Shape s) not implemented for non-CircularArea or for s.getAreaType()!=CircularArea.SEGMENT");
            exception.printStackTrace();
        }
    }

    public void fill_OLD(Shape shape) {
        if (shape instanceof CircularArea && ((CircularArea)shape).getAreaType() == 1003) {
            this.openGroupTagIfNeeded();
            CircularArea circularArea = (CircularArea)shape;
            double d = circularArea.getCenterX();
            double d2 = circularArea.getCenterY();
            double d3 = circularArea.getInnerRadius();
            double d4 = circularArea.getOuterRadius();
            double d5 = circularArea.getStartAngle() * (Math.PI / 180);
            double d6 = d5 + circularArea.getExtentAngle() * (Math.PI / 180);
            double d7 = Math.cos(-d5);
            double d8 = Math.sin(-d5);
            double d9 = Math.cos(-d6);
            double d10 = Math.sin(-d6);
            double d11 = d + d4 * d7;
            double d12 = d2 + d4 * d8;
            double d13 = d + d4 * d9;
            double d14 = d2 + d4 * d10;
            double d15 = d + d3 * d7;
            double d16 = d2 + d3 * d8;
            double d17 = d + d3 * d9;
            double d18 = d2 + d3 * d10;
            double d19 = circularArea.getExtentAngle();
            if (d19 < 1.0) {
                this.currentGroupBuffer.append("\t\t<path d=\"M " + df.format(d11) + "," + df.format(d12) + "\t" + "L " + df.format(d13) + "," + df.format(d14) + "\n" + "\t\t\tL " + df.format(d17) + "," + df.format(d18) + "\t" + "L " + df.format(d15) + "," + df.format(d16) + " z\" \n" + "\t\t\tfill=\"" + this.colorToString() + "\" />\n");
            } else {
                int n;
                int n2 = d19 < 180.0 ? 0 : 1;
                double d20 = -(circularArea.getStartAngle() + d19 / 2.0 + 90.0);
                double d21 = d20 + 180.0;
                if (n2 == 1) {
                    double d22 = (d20 + 1.12 + 720.0) % 360.0;
                    double d23 = (d21 - 1.12 + 720.0) % 360.0;
                } else {
                    double d24 = (d20 - 1.12 + 720.0) % 360.0;
                    double d25 = (d21 + 1.12 + 720.0) % 360.0;
                }
                double d26 = (d11 + d15) / 2.0;
                double d27 = (d12 + d16) / 2.0;
                double d28 = (d13 + d17) / 2.0;
                double d29 = (d14 + d18) / 2.0;
                double d30 = (d4 + d3) / 2.0;
                double d31 = d4 - d3;
                if (n2 == 1) {
                    double d32 = (d20 + 1.0E-6 + 720.0) % 360.0;
                    n = (int)(d32 / 90.0 + 1.0) * 90;
                } else {
                    double d33 = (d20 - 1.0E-6 + 720.0) % 360.0;
                    n = (int)(d33 / 90.0) * 90;
                }
                this.currentGroupBuffer.append("\t\t<path d=\"M " + df.format(d26) + "," + df.format(d27) + "\t" + "A " + df.format(d30) + "," + df.format(d30) + " " + n + "\t" + n2 + "," + 0 + " " + df.format(d28) + "," + df.format(d29) + " \" \n" + "\t\t\tstroke=\"" + this.colorToString() + "\" " + "\tstroke-width=\"" + df.format(d31) + "\" " + "stroke-linecap=\"butt\"/>\n");
            }
        } else if (shape instanceof Rectangle2D.Double) {
            this.openGroupTagIfNeeded();
            Rectangle2D.Double double_ = (Rectangle2D.Double)shape;
            this.currentGroupBuffer.append("\t\t<rect x=\"" + df.format(double_.x) + "\" y=\"" + df.format(double_.y) + "\" " + "width=\"" + df.format(double_.width) + "\" height=\"" + df.format(double_.height) + "\" " + "fill=\"" + this.colorToString() + "\"/>\n");
        } else {
            Exception exception = new Exception("BluejaySVGGraphics2D.fill(Shape s) not implemented for non-CircularArea or for s.getAreaType()!=CircularArea.SEGMENT");
            exception.printStackTrace();
        }
    }

    public Color getBackground() {
        System.err.println("Warning: BluejaySVGGraphics2D.getBackground(...) not implemented");
        return null;
    }

    public Composite getComposite() {
        System.err.println("Warning: BluejaySVGGraphics2D.getComposite(...) not implemented");
        return null;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        System.err.println("Warning: BluejaySVGGraphics2D.getDeviceConfiguration(...) not implemented");
        return null;
    }

    public FontRenderContext getFontRenderContext() {
        System.err.println("Warning: BluejaySVGGraphics2D.getFontRenderContext(...) not implemented");
        return null;
    }

    public Paint getPaint() {
        System.err.println("Warning: BluejaySVGGraphics2D.getPaint(...) not implemented");
        return null;
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        System.err.println("Warning: BluejaySVGGraphics2D.getRenderingHint(...) not implemented");
        return null;
    }

    public RenderingHints getRenderingHints() {
        System.err.println("Warning: BluejaySVGGraphics2D.getRenderingHints(...) not implemented");
        return null;
    }

    public Stroke getStroke() {
        System.err.println("Warning: BluejaySVGGraphics2D.getStroke(...) not implemented");
        return null;
    }

    public AffineTransform getTransform() {
        System.err.println("Warning: BluejaySVGGraphics2D.getTransform(...) not implemented");
        return null;
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        System.err.println("Warning: BluejaySVGGraphics2D.hit(...) not implemented");
        return false;
    }

    public void rotate(double d) {
        System.err.println("Warning: BluejaySVGGraphics2D.rotate(...) not implemented");
    }

    public void rotate(double d, double d2, double d3) {
        Object e;
        boolean bl = true;
        if (!this.transformStack.empty() && (e = this.transformStack.peek()) instanceof SVGRotation) {
            SVGRotation sVGRotation = (SVGRotation)e;
            if ((sVGRotation.cx - d2) * (sVGRotation.cx - d2) + (sVGRotation.cy - d3) * (sVGRotation.cy - d3) < 1.0E-6) {
                sVGRotation.angleRad += d;
                if (sVGRotation.angleRad * sVGRotation.angleRad < 1.0E-6) {
                    this.transformStack.pop();
                }
                bl = false;
            }
        }
        if (bl) {
            this.transformStack.push(new SVGRotation(d, d2, d3));
        }
    }

    public void scale(double d, double d2) {
        System.err.println("Warning: BluejaySVGGraphics2D.(...) not implemented");
    }

    public void setBackground(Color color) {
        System.err.println("Warning: BluejaySVGGraphics2D.(...) not implemented");
    }

    public void setComposite(Composite composite) {
        System.err.println("Warning: BluejaySVGGraphics2D.setComposite(...) not implemented");
    }

    public void setPaint(Paint paint) {
        System.err.println("Warning: BluejaySVGGraphics2D.setPaint(...) not implemented");
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
    }

    public void setRenderingHints(Map map) {
        System.err.println("Warning: BluejaySVGGraphics2D.setRenderingHints(...) not implemented");
    }

    public void setStroke(Stroke stroke) {
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            this.mainStroke = new BasicStroke(basicStroke.getLineWidth(), basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase());
        } else {
            Exception exception = new Exception("BluejaySVGGraphics2D.setStroke(...) not implemented for non-BasicStroke");
            exception.printStackTrace();
        }
    }

    public void setTransform(AffineTransform affineTransform) {
        System.err.println("Warning: BluejaySVGGraphics2D.setTransform(...) not implemented");
    }

    public void shear(double d, double d2) {
        System.err.println("Warning: BluejaySVGGraphics2D.shear(...) not implemented");
    }

    public void transform(AffineTransform affineTransform) {
        System.err.println("Warning: BluejaySVGGraphics2D.transform(...) not implemented");
    }

    public void translate(double d, double d2) {
        System.err.println("Warning: BluejaySVGGraphics2D.translate(...) not implemented");
    }

    static {
        df = new DecimalFormat("0.000");
    }

    private class SVGRotation {
        public double angleRad;
        public double cx;
        public double cy;

        private SVGRotation() {
        }

        public SVGRotation(double d, double d2, double d3) {
            this.angleRad = d;
            this.cx = d2;
            this.cy = d3;
        }
    }

    private class SVGTranslation {
        public int tx;
        public int ty;

        private SVGTranslation() {
        }

        public SVGTranslation(int n, int n2) {
            this.tx = n;
            this.ty = n2;
        }
    }
}

