/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.proxy;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSLTransformer {
    public static final String DEFAULT_XSL_URL = "http://bluejay.ucalgary.ca/data/TIGR/tigrSkeletonizer2.xsl";
    private StringWriter sw = new StringWriter();

    public Reader transform(URL uRL) throws IOException, TransformerException {
        Properties properties = System.getProperties();
        properties.put("javax.xml.transform.TransformerFactory", "org.apache.xalan.xsltc.trax.TransformerFactoryImpl");
        System.setProperties(properties);
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Templates templates = transformerFactory.newTemplates(new StreamSource(DEFAULT_XSL_URL));
            Transformer transformer = templates.newTransformer();
            if (uRL.toString().endsWith("gz")) {
                transformer.transform(new StreamSource(new GZIPInputStream(uRL.openStream())), new StreamResult(this.sw));
            } else {
                transformer.transform(new StreamSource(uRL.openStream()), new StreamResult(this.sw));
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.err.println("XSLTransformer.transform(): OutOfMemoryError: skeletonization failed, returning prematurely...");
        }
        return new StringReader(this.sw.toString());
    }
}

