/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.session;

import ca.ucalgary.bluejay.session.CacheMgmt;
import ca.ucalgary.bluejay.session.CacheReturn;
import ca.ucalgary.bluejay.session.ConnectionPool;
import ca.ucalgary.bluejay.session.History;
import ca.ucalgary.bluejay.session.ICategories;
import ca.ucalgary.bluejay.session.InvestigationDeletedException;
import ca.ucalgary.bluejay.session.LoginInfo;
import ca.ucalgary.bluejay.session.MileStonesList;
import ca.ucalgary.bluejay.session.NOTimplementedException;
import ca.ucalgary.bluejay.session.NameExistsException;
import ca.ucalgary.bluejay.session.PasswordMismatchException;
import ca.ucalgary.bluejay.session.ProxyException;
import ca.ucalgary.bluejay.session.SessionExpiredException;
import ca.ucalgary.bluejay.session.URLReturn;
import ca.ucalgary.bluejay.session.UserAlreadyExistsException;
import ca.ucalgary.bluejay.session.UserDoesNotExistException;
import ca.ucalgary.bluejay.session.WaypointsInfo;
import com.skaringa.javaxml.DeserializerException;
import com.skaringa.javaxml.NoImplementationException;
import com.skaringa.javaxml.SerializerException;
import com.skaringa.javaxml.impl.sax.ObjectTransformerSAXImpl;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;

public class BluejayServer {
    private ConnectionPool cPool = new ConnectionPool();
    private CacheMgmt cache = new CacheMgmt();
    private Random rand = new Random();
    private String urlRoot;

    public BluejayServer() {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ca.ucalgary.bluejay.session.data.serverProperties");
            this.urlRoot = resourceBundle.getString("urlRoot");
            if (this.urlRoot.charAt(this.urlRoot.length() - 1) != '/') {
                this.urlRoot = this.urlRoot + '/';
            }
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("bluejayServer0 " + missingResourceException.getMessage());
            return;
        }
    }

    public String startUpInfo(String string, String string2) throws UserDoesNotExistException, PasswordMismatchException, SQLException, IllegalStateException, SerializerException, NoImplementationException {
        LoginInfo loginInfo = new LoginInfo();
        MessageContext messageContext = MessageContext.getCurrentContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = httpServletRequest.getSession();
        Connection connection = this.cPool.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Vector<Integer> vector;
            Vector<String> vector2;
            int n;
            if (httpSession.isNew()) {
                statement = connection.createStatement();
                resultSet = statement.executeQuery("SELECT uID, password FROM USER WHERE eMail='" + string + "'");
                if (!resultSet.next()) {
                    this.myInvalidate(httpSession);
                    this.cPool.releaseConnection(connection);
                    throw new UserDoesNotExistException("user doesn't exist");
                }
                n = resultSet.getInt("uID");
                if (!string2.equals(resultSet.getString("password"))) {
                    this.myInvalidate(httpSession);
                    this.cPool.releaseConnection(connection);
                    throw new PasswordMismatchException("password don't match");
                }
                resultSet = statement.executeQuery("SELECT name, iID FROM INVESTIGATION WHERE uID=" + n + " AND stillAlive='y'");
                vector2 = new Vector<String>();
                vector = new Vector<Integer>();
                while (resultSet.next()) {
                    vector2.addElement(resultSet.getString("name"));
                    vector.addElement(new Integer(resultSet.getInt("iID")));
                }
            } else {
                this.myInvalidate(httpSession);
                this.cPool.releaseConnection(connection);
                return this.startUpInfo(string, string2);
            }
            vector.trimToSize();
            vector2.trimToSize();
            loginInfo.setInvesNames(vector2);
            loginInfo.setInvesIndices(vector);
            resultSet = statement.executeQuery("SELECT last_invID FROM USER WHERE uID=" + n);
            resultSet.next();
            int n2 = resultSet.getInt("last_invID");
            loginInfo.setCurrInvesID(new Integer(n2));
            httpSession.setMaxInactiveInterval(7200);
            httpSession.setAttribute("uID", new Integer(n));
            httpSession.setAttribute("iID", new Integer(n2));
        }
        catch (SQLException sQLException) {
            this.cPool.releaseConnection(connection);
            throw new SQLException(sQLException.getMessage());
        }
        this.cPool.releaseConnection(connection);
        return this.stringRep(loginInfo);
    }

    public int addUser(String string, String string2) throws UserAlreadyExistsException, SQLException {
        Object object;
        string = "'" + string + "'";
        string2 = "'" + string2 + "'";
        String string3 = null;
        Connection connection = this.cPool.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        int n = 5;
        int n2 = 20;
        try {
            object = ResourceBundle.getBundle("ca.ucalgary.bluejay.session.data.defaultUserProps");
            n = Integer.parseInt(((ResourceBundle)object).getString("maxI"));
            n2 = Integer.parseInt(((ResourceBundle)object).getString("maxS"));
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("addUser1" + numberFormatException.getMessage());
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("addUser1" + missingResourceException.getMessage());
        }
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT uID FROM USER WHERE eMail=" + string);
            if (resultSet.next()) {
                this.cPool.releaseConnection(connection);
                throw new UserAlreadyExistsException("email exists");
            }
            object = new Date(System.currentTimeMillis());
            String string4 = "'" + ((Date)object).toString() + "'";
            string3 = "INSERT INTO USER VALUES(NULL," + string + "," + string4 + "," + string4 + "," + n + "," + n2 + "," + 0 + "," + string2 + "," + 0 + ")";
            statement.executeUpdate(string3);
            resultSet = statement.executeQuery("SELECT uID FROM USER WHERE eMail=" + string);
            resultSet.next();
            int n3 = resultSet.getInt("uID");
            string3 = "INSERT INTO BOOKMARKS VALUES(" + n3 + ",NULL,NULL)";
            statement.executeUpdate(string3);
        }
        catch (SQLException sQLException) {
            this.cPool.releaseConnection(connection);
            throw new SQLException(sQLException.getMessage());
        }
        this.cPool.releaseConnection(connection);
        return 0;
    }

    public int setUserAttributes(String string) throws NOTimplementedException {
        return -1;
    }

    public int logout() throws IllegalStateException, SessionExpiredException {
        MessageContext messageContext = MessageContext.getCurrentContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession.isNew()) {
            throw new SessionExpiredException("session already expired");
        }
        this.myInvalidate(httpSession);
        return 0;
    }

    public int leavingPage(int n, int n2, String string) throws SQLException, IOException {
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            connection = this.cPool.getConnection();
            Statement statement = connection.createStatement();
            statement.executeUpdate("UPDATE VISITS SET tSpent=" + n2 + " WHERE vID=" + n);
            resultSet = statement.executeQuery("SELECT cacheID FROM VISITS WHERE vID=" + n);
            resultSet.next();
            int n3 = resultSet.getInt("cacheID");
            resultSet = statement.executeQuery("SELECT totalTime FROM CACHE WHERE cacheID=" + n3);
            resultSet.next();
            int n4 = resultSet.getInt("totalTime") + n2;
            statement.executeUpdate("UPDATE CACHE SET totalTime=" + n4 + " WHERE cacheID=" + n3);
            if (string != null && !string.equals("")) {
                resultSet = statement.executeQuery("SELECT cachePath FROM CACHE WHERE cacheID=" + n3);
                resultSet.next();
                String string2 = resultSet.getString("cachePath");
                this.cache.updateAppearance(string2, string);
            }
        }
        catch (SQLException sQLException) {
            this.cPool.releaseConnection(connection);
            throw new SQLException(sQLException.getMessage());
        }
        this.cPool.releaseConnection(connection);
        return 0;
    }

    public int ratePage(int n, int n2) throws SQLException {
        Connection connection = null;
        try {
            connection = this.cPool.getConnection();
            Statement statement = connection.createStatement();
            statement.executeUpdate("UPDATE VISITS SET rating=" + n2 + " WHERE vID=" + n);
        }
        catch (SQLException sQLException) {
            this.cPool.releaseConnection(connection);
            throw new SQLException(sQLException.getMessage());
        }
        this.cPool.releaseConnection(connection);
        return 0;
    }

    public String getInvestigationCategories() throws SQLException, SerializerException, NoImplementationException {
        Connection connection = this.cPool.getConnection();
        ICategories iCategories = new ICategories();
        Vector<String> vector = new Vector<String>();
        Vector<Integer> vector2 = new Vector<Integer>();
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT catName, catID FROM ICATEGORIES WHERE stillValid='y'");
            while (resultSet.next()) {
                vector.addElement(resultSet.getString("catName"));
                vector2.addElement(new Integer(resultSet.getInt("catID")));
            }
            vector.trimToSize();
            vector2.trimToSize();
            iCategories.setNames(vector);
            iCategories.setIDs(vector2);
        }
        catch (SQLException sQLException) {
            this.cPool.releaseConnection(connection);
            throw new SQLException(sQLException.getMessage());
        }
        this.cPool.releaseConnection(connection);
        return this.stringRep(iCategories);
    }

    public int newInvestigation(String string, int n) throws SQLException, NameExistsException, SessionExpiredException {
        MessageContext messageContext = MessageContext.getCurrentContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession.isNew()) {
            throw new SessionExpiredException("session expired");
        }
        int n2 = (Integer)httpSession.getAttribute("uID");
        Connection connection = this.cPool.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        int n3 = 0;
        try {
            statement = connection.createStatement();
            Date date = new Date(System.currentTimeMillis());
            String string2 = "'" + date.toString() + "'";
            string = "'" + string + "'";
            resultSet = statement.executeQuery("SELECT iID FROM INVESTIGATION WHERE name=" + string + " AND uID=" + n2 + " AND stillAlive='y'");
            if (resultSet.next()) {
                this.cPool.releaseConnection(connection);
                throw new NameExistsException("Investigation name already exists");
            }
            String string3 = "INSERT INTO INVESTIGATION VALUES(NULL," + string + "," + n2 + "," + n + "," + string2 + "," + string2 + ",NULL,NULL,NULL,NULL,0,'y','n',NULL)";
            statement.executeUpdate(string3);
            resultSet = statement.executeQuery("SELECT iID FROM INVESTIGATION WHERE name=" + string + " AND uID=" + n2 + " AND stillAlive='y'");
            resultSet.next();
            n3 = resultSet.getInt("iID");
            this.cache.createInvestigation(n2, n3);
        }
        catch (SQLException sQLException) {
            this.cPool.releaseConnection(connection);
            throw new SQLException(sQLException.getMessage());
        }
        this.cPool.releaseConnection(connection);
        return n3;
    }

    private void myInvalidate(HttpSession httpSession) throws IllegalStateException {
        httpSession.invalidate();
    }

    public int destroyInvestigation() throws SessionExpiredException, SQLException {
        MessageContext messageContext = MessageContext.getCurrentContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession.isNew()) {
            throw new SessionExpiredException("session expired");
        }
        int n = (Integer)httpSession.getAttribute("uID");
        int n2 = (Integer)httpSession.getAttribute("iID");
        Connection connection = this.cPool.getConnection();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.executeUpdate("UPDATE INVESTIGATION SET stillAlive='n' WHERE iID=" + n2);
            this.cache.deleteInvestigation(this.cPool, n, n2);
        }
        catch (SQLException sQLException) {
            this.cPool.releaseConnection(connection);
            throw new SQLException(sQLException.getMessage());
        }
        this.cPool.releaseConnection(connection);
        return 0;
    }

    public String getBookmarks() throws SessionExpiredException, SQLException {
        MessageContext messageContext = MessageContext.getCurrentContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession.isNew()) {
            throw new SessionExpiredException("session expired");
        }
        int n = (Integer)httpSession.getAttribute("uID");
        Connection connection = this.cPool.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT details FROM BOOKMARKS WHERE uID=" + n);
            resultSet.next();
            string = resultSet.getString("details");
        }
        catch (SQLException sQLException) {
            this.cPool.releaseConnection(connection);
            throw new SQLException(sQLException.getMessage());
        }
        this.cPool.releaseConnection(connection);
        return string;
    }

    public int setBookmarks(String string) throws SessionExpiredException, SQLException {
        string = "'" + string + "'";
        MessageContext messageContext = MessageContext.getCurrentContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession.isNew()) {
            throw new SessionExpiredException("session expired");
        }
        int n = (Integer)httpSession.getAttribute("uID");
        Connection connection = this.cPool.getConnection();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.executeUpdate("UPDATE BOOKMARKS SET details=" + string + " WHERE uID=" + n);
        }
        catch (SQLException sQLException) {
            this.cPool.releaseConnection(connection);
            throw new SQLException(sQLException.getMessage());
        }
        this.cPool.releaseConnection(connection);
        return 0;
    }

    public int suspendInvestigation() {
        return 0;
    }

    public String getURL(String string, String string2, String string3) throws SessionExpiredException, SQLException, IOException, ProxyException, SerializerException, NoImplementationException {
        String[] stringArray = this.parseString(string2);
        String[] stringArray2 = this.parseString(string3);
        MessageContext messageContext = MessageContext.getCurrentContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession.isNew()) {
            throw new SessionExpiredException("session expired");
        }
        int n = (Integer)httpSession.getAttribute("uID");
        int n2 = (Integer)httpSession.getAttribute("iID");
        Integer n3 = (Integer)httpSession.getAttribute("vID");
        String string4 = this.getSuffix(n, n2);
        URLReturn uRLReturn = new URLReturn();
        uRLReturn.setURL(this.urlRoot + string4);
        Connection connection = this.cPool.getConnection();
        Statement statement = null;
        try {
            int n4;
            Object object;
            statement = connection.createStatement();
            if (n3 == null) {
                object = statement.executeQuery("SELECT last_visitID FROM INVESTIGATION WHERE iID=" + n2);
                object.next();
                n4 = object.getInt("last_visitID");
            } else {
                n4 = n3;
            }
            object = this.cache.getURL(string, stringArray, stringArray2, string4);
            Date date = new Date(System.currentTimeMillis());
            String string5 = "'" + date.toString() + "'";
            Date date2 = new Date(((CacheReturn)object).toCheckAfter);
            String string6 = "'" + date2.toString() + "'";
            Date date3 = new Date(((CacheReturn)object).lModified);
            String string7 = "'" + date3.toString() + "'";
            System.out.println("Before, url= " + string);
            string = string.replaceAll("'", "%27");
            System.out.println("After, url= " + string);
            String string8 = "INSERT INTO CACHE VALUES(NULL,'" + string + "','" + string4 + "'," + string6 + "," + string7 + "," + n2 + "," + n + ",'" + string4 + "','n','y'," + ((CacheReturn)object).docRetTime + "," + ((CacheReturn)object).docConTime + "," + string5 + ",'G',0)";
            statement.executeUpdate(string8);
            ResultSet resultSet = statement.executeQuery("SELECT cacheID FROM CACHE WHERE cachePath='" + string4 + "'");
            resultSet.next();
            int n5 = resultSet.getInt("cacheID");
            string8 = "INSERT INTO VISITS VALUES(NULL," + n + "," + string5 + ",NULL," + n4 + ",NULL," + "NULL," + n2 + "," + n5 + ")";
            statement.executeUpdate(string8);
            resultSet = statement.executeQuery("SELECT vID FROM VISITS WHERE backward_vID=" + n4);
            resultSet.next();
            int n6 = resultSet.getInt("vID");
            uRLReturn.setVID(n6);
            httpSession.setAttribute("vID", new Integer(n6));
            resultSet = statement.executeQuery("SELECT totalSpace, maxSpace FROM USER WHERE uID=" + n);
            resultSet.next();
            int n7 = resultSet.getInt("totalSpace") + ((CacheReturn)object).fileSize;
            int n8 = resultSet.getInt("maxSpace") * 1024 * 1024;
            statement.executeUpdate("UPDATE INVESTIGATION SET last_visitID=" + n6 + " WHERE iID=" + n2);
            if (n7 > n8) {
                this.cache.freeCache(this.cPool, n, n8, n7);
            }
        }
        catch (SQLException sQLException) {
            this.cPool.releaseConnection(connection);
            throw new SQLException(sQLException.getMessage());
        }
        catch (IOException iOException) {
            this.cPool.releaseConnection(connection);
            throw new IOException(iOException.getMessage());
        }
        this.cPool.releaseConnection(connection);
        return this.stringRep(uRLReturn);
    }

    public String postURL(String string, String string2, String string3, String string4, String string5) throws SessionExpiredException, SQLException, IOException, ProxyException, SerializerException, NoImplementationException {
        String[] stringArray = this.parseString(string2);
        String[] stringArray2 = this.parseString(string3);
        String[] stringArray3 = this.parseString(string4);
        String[] stringArray4 = this.parseString(string5);
        MessageContext messageContext = MessageContext.getCurrentContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession.isNew()) {
            throw new SessionExpiredException("session expired");
        }
        int n = (Integer)httpSession.getAttribute("uID");
        int n2 = (Integer)httpSession.getAttribute("iID");
        int n3 = (Integer)httpSession.getAttribute("vID");
        String string6 = this.getSuffix(n, n2);
        URLReturn uRLReturn = new URLReturn();
        uRLReturn.setURL(this.urlRoot + string6);
        Connection connection = this.cPool.getConnection();
        Statement statement = null;
        try {
            CacheReturn cacheReturn = this.cache.postURL(string, stringArray3, stringArray4, stringArray, stringArray2, string6);
            statement = connection.createStatement();
            Date date = new Date(System.currentTimeMillis());
            String string7 = "'" + date.toString() + "'";
            Date date2 = new Date(cacheReturn.toCheckAfter);
            String string8 = "'" + date2.toString() + "'";
            Date date3 = new Date(cacheReturn.lModified);
            String string9 = "'" + date3.toString() + "'";
            String string10 = "INSERT INTO CACHE VALUES(NULL,'" + string + "','" + string6 + "'," + string8 + "," + string9 + "," + n2 + "," + n + ",'" + string6 + "','n','y'," + cacheReturn.docRetTime + "," + cacheReturn.docConTime + "," + string7 + ",'P')";
            statement.executeUpdate(string10);
            ResultSet resultSet = statement.executeQuery("SELECT cacheID FROM CACHE WHERE cachePath='" + string6 + "'");
            resultSet.next();
            int n4 = resultSet.getInt("cacheID");
            string10 = "INSERT INTO VISITS VALUES(NULL," + n + "," + string7 + ",NULL," + n3 + ",NULL," + "NULL," + n2 + "," + n4 + ")";
            statement.executeUpdate(string10);
            resultSet = statement.executeQuery("SELECT vID FROM VISITS WHERE backward_vID=" + n3);
            resultSet.next();
            int n5 = resultSet.getInt("vID");
            uRLReturn.setVID(n5);
            httpSession.setAttribute("vID", new Integer(n5));
            resultSet = statement.executeQuery("SELECT totalSpace, maxSpace FROM USER WHERE uID=" + n);
            resultSet.next();
            int n6 = resultSet.getInt("totalSpace") + cacheReturn.fileSize;
            int n7 = resultSet.getInt("maxSpace") * 1024 * 1024;
            statement.executeUpdate("UPDATE INVESTIGATION SET last_visitID=" + n5 + " WHERE iID=" + n2);
            if (n6 > n7) {
                this.cache.freeCache(this.cPool, n, n7, n6);
            }
        }
        catch (SQLException sQLException) {
            this.cPool.releaseConnection(connection);
            throw new SQLException(sQLException.getMessage());
        }
        catch (IOException iOException) {
            this.cPool.releaseConnection(connection);
            throw new IOException(iOException.getMessage());
        }
        this.cPool.releaseConnection(connection);
        return this.stringRep(uRLReturn);
    }

    public int goTo(int n) throws SessionExpiredException, SQLException, IOException, ProxyException {
        MessageContext messageContext = MessageContext.getCurrentContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession.isNew()) {
            throw new SessionExpiredException("session expired");
        }
        int n2 = (Integer)httpSession.getAttribute("uID");
        int n3 = (Integer)httpSession.getAttribute("iID");
        Integer n4 = (Integer)httpSession.getAttribute("vID");
        Connection connection = this.cPool.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        int n5 = 0;
        int n6 = 0;
        try {
            statement = connection.createStatement();
            if (n4 == null) {
                resultSet = statement.executeQuery("SELECT last_visitID FROM INVESTIGATION WHERE iID=" + n3);
                resultSet.next();
                n5 = resultSet.getInt("last_visitID");
            } else {
                n5 = n4;
            }
            Date date = new Date(System.currentTimeMillis());
            String string = "'" + date.toString() + "'";
            resultSet = statement.executeQuery("SELECT cacheID FROM VISITS WHERE vID=" + n);
            resultSet.next();
            int n7 = resultSet.getInt("cacheID");
            String string2 = "INSERT INTO VISITS VALUES(NULL," + n2 + "," + string + ",NULL," + n5 + ",NULL," + "NULL," + n3 + "," + n7 + ")";
            statement.executeUpdate(string2);
            resultSet = statement.executeQuery("SELECT vID FROM VISITS WHERE backward_vID=" + n5);
            resultSet.next();
            n6 = resultSet.getInt("vID");
            statement.executeUpdate("UPDATE VISITS SET forward_vID=" + n6 + " WHERE vID=" + n5);
            statement.executeUpdate("UPDATE INVESTIGATION SET last_visitID=" + n6 + " WHERE iID=" + n3);
            httpSession.setAttribute("vID", new Integer(n6));
            resultSet = statement.executeQuery("SELECT stillSavedFlag FROM CACHE WHERE cacheID=" + n7);
            resultSet.next();
            String string3 = resultSet.getString("stillSavedFlag");
            if (string3.equals("n")) {
                this.cache.refresh(connection, n6);
            } else {
                statement.executeUpdate("UPDATE CACHE SET lastVisit=" + string + " WHERE cacheID=" + n7);
            }
        }
        catch (SQLException sQLException) {
            this.cPool.releaseConnection(connection);
            throw new SQLException(sQLException.getMessage());
        }
        this.cPool.releaseConnection(connection);
        return n6;
    }

    public int reload() throws SessionExpiredException, SQLException, IOException, ProxyException {
        MessageContext messageContext = MessageContext.getCurrentContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession.isNew()) {
            throw new SessionExpiredException("session expired");
        }
        int n = (Integer)httpSession.getAttribute("vID");
        Connection connection = this.cPool.getConnection();
        try {
            this.cache.refresh(connection, n);
        }
        catch (SQLException sQLException) {
            this.cPool.releaseConnection(connection);
            throw new SQLException(sQLException.getMessage());
        }
        this.cPool.releaseConnection(connection);
        return 0;
    }

    public String resumeInvestigation(int n) throws SessionExpiredException, SQLException, InvestigationDeletedException, SerializerException, NoImplementationException {
        MessageContext messageContext = MessageContext.getCurrentContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession.isNew()) {
            throw new SessionExpiredException("session expired");
        }
        int n2 = (Integer)httpSession.getAttribute("uID");
        History history = new History();
        Connection connection = this.cPool.getConnection();
        Connection connection2 = this.cPool.getConnection();
        try {
            Statement statement = null;
            Statement statement2 = null;
            statement = connection.createStatement();
            statement2 = connection2.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT stillAlive FROM INVESTIGATION WHERE iID=" + n);
            resultSet.next();
            if (resultSet.getString("stillAlive").equals("n")) {
                this.cPool.releaseConnection(connection);
                throw new InvestigationDeletedException("Trying to access a deleted investigation");
            }
            resultSet = statement.executeQuery("SELECT vID, cacheID FROM VISITS WHERE iID=" + n + " ORDER BY vID");
            statement.executeUpdate("UPDATE USER SET last_invID=" + n + " WHERE uID=" + n2);
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            Vector<Integer> vector3 = new Vector<Integer>();
            while (resultSet.next()) {
                ResultSet resultSet2 = statement2.executeQuery("SELECT urlOriginal, cachePath FROM CACHE WHERE cacheID=" + resultSet.getInt("cacheID"));
                resultSet2.next();
                vector3.addElement(new Integer(resultSet.getInt("vID")));
                vector.addElement(resultSet2.getString("urlOriginal"));
                vector2.addElement(this.urlRoot + resultSet2.getString("cachePath"));
            }
            vector.trimToSize();
            vector2.trimToSize();
            vector3.trimToSize();
            history.setInternetURLs(vector);
            history.setCacheURLs(vector2);
            history.setvIDs(vector3);
            httpSession.setAttribute("iID", new Integer(n));
        }
        catch (SQLException sQLException) {
            this.cPool.releaseConnection(connection);
            this.cPool.releaseConnection(connection2);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            sQLException.printStackTrace(printWriter);
            throw new SQLException(sQLException.getMessage() + stringWriter.toString());
        }
        this.cPool.releaseConnection(connection);
        this.cPool.releaseConnection(connection2);
        return this.stringRep(history);
    }

    protected String getSuffix(int n, int n2) {
        Integer n3 = new Integer(n);
        String string = System.getProperty("file.separator");
        String string2 = n3.toString() + string;
        n3 = new Integer(n2);
        string2 = string2 + n3.toString() + string;
        long l = this.rand.nextLong();
        if (l < 0L) {
            l = -l;
        }
        Long l2 = new Long(l);
        string2 = string2 + l2.toString();
        return string2;
    }

    public int changeEmail(String string) throws SessionExpiredException, SQLException, UserAlreadyExistsException {
        string = "'" + string + "'";
        MessageContext messageContext = MessageContext.getCurrentContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession.isNew()) {
            throw new SessionExpiredException("session already expired");
        }
        int n = (Integer)httpSession.getAttribute("uID");
        Connection connection = this.cPool.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT uID FROM USER WHERE eMail=" + string);
            if (resultSet.next()) {
                this.cPool.releaseConnection(connection);
                throw new UserAlreadyExistsException("email exists");
            }
            statement.executeUpdate("UPDATE USER SET eMail=" + string + " WHERE uID=" + n);
        }
        catch (SQLException sQLException) {
            this.cPool.releaseConnection(connection);
            throw new SQLException(sQLException.getMessage());
        }
        this.cPool.releaseConnection(connection);
        return 0;
    }

    public int changePassword(String string, String string2) throws SessionExpiredException, SQLException, PasswordMismatchException {
        MessageContext messageContext = MessageContext.getCurrentContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession.isNew()) {
            throw new SessionExpiredException("session already expired");
        }
        int n = (Integer)httpSession.getAttribute("uID");
        Connection connection = this.cPool.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT password FROM USER WHERE uID=" + n);
            resultSet.next();
            String string3 = resultSet.getString("password");
            if (!string3.equals(string)) {
                this.cPool.releaseConnection(connection);
                throw new PasswordMismatchException("old password incorrect");
            }
            statement.executeUpdate("UPDATE USER SET password='" + string2 + "' WHERE uID=" + n);
        }
        catch (SQLException sQLException) {
            this.cPool.releaseConnection(connection);
            throw new SQLException(sQLException.getMessage());
        }
        this.cPool.releaseConnection(connection);
        return 0;
    }

    public int updateNote(String string) throws SessionExpiredException, SQLException {
        string = "'" + string + "'";
        MessageContext messageContext = MessageContext.getCurrentContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession.isNew()) {
            throw new SessionExpiredException("session already expired");
        }
        int n = (Integer)httpSession.getAttribute("iID");
        Connection connection = this.cPool.getConnection();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.executeUpdate("UPDATE INVESTIGATION SET note=" + string + " WHERE iID=" + n);
        }
        catch (SQLException sQLException) {
            this.cPool.releaseConnection(connection);
            throw new SQLException(sQLException.getMessage());
        }
        this.cPool.releaseConnection(connection);
        return 0;
    }

    public String getNote() throws SessionExpiredException, SQLException {
        MessageContext messageContext = MessageContext.getCurrentContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession.isNew()) {
            throw new SessionExpiredException("session already expired");
        }
        int n = (Integer)httpSession.getAttribute("iID");
        Connection connection = this.cPool.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT note FROM INVESTIGATION WHERE iID=" + n);
            resultSet.next();
            string = resultSet.getString("note");
        }
        catch (SQLException sQLException) {
            this.cPool.releaseConnection(connection);
            throw new SQLException(sQLException.getMessage());
        }
        this.cPool.releaseConnection(connection);
        return string;
    }

    public String getMileStones() throws SQLException, SessionExpiredException, SerializerException, NoImplementationException {
        MessageContext messageContext = MessageContext.getCurrentContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession.isNew()) {
            throw new SessionExpiredException("session already expired");
        }
        int n = (Integer)httpSession.getAttribute("iID");
        Connection connection = this.cPool.getConnection();
        Connection connection2 = this.cPool.getConnection();
        Statement statement = null;
        Statement statement2 = null;
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        MileStonesList mileStonesList = new MileStonesList();
        Vector<Integer> vector = new Vector<Integer>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        try {
            statement = connection.createStatement();
            statement2 = connection2.createStatement();
            resultSet = statement.executeQuery("SELECT mID, cacheID FROM MILESTONES WHERE iID=" + n);
            while (resultSet.next()) {
                resultSet2 = statement2.executeQuery("SELECT urlOriginal, cachePath FROM INVESTIGATION WHERE cacheID=" + resultSet.getInt("cacheID"));
                resultSet2.next();
                vector.addElement(new Integer(resultSet.getInt("mID")));
                vector2.addElement(resultSet2.getString("urlOriginal"));
                vector3.addElement(this.urlRoot + resultSet2.getString("cachePath"));
            }
            vector.trimToSize();
            vector2.trimToSize();
            vector3.trimToSize();
            mileStonesList.setInternetURLs(vector2);
            mileStonesList.setCacheURLs(vector3);
            mileStonesList.setmIDs(vector);
        }
        catch (SQLException sQLException) {
            this.cPool.releaseConnection(connection);
            this.cPool.releaseConnection(connection2);
            throw new SQLException(sQLException.getMessage());
        }
        this.cPool.releaseConnection(connection);
        this.cPool.releaseConnection(connection2);
        return this.stringRep(mileStonesList);
    }

    public int setMileStone(String string) throws SQLException, SessionExpiredException, IOException {
        MessageContext messageContext = MessageContext.getCurrentContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession.isNew()) {
            throw new SessionExpiredException("session already expired");
        }
        int n = (Integer)httpSession.getAttribute("uID");
        int n2 = (Integer)httpSession.getAttribute("iID");
        int n3 = (Integer)httpSession.getAttribute("vID");
        Connection connection = this.cPool.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        int n4 = 0;
        try {
            Date date = new Date(System.currentTimeMillis());
            String string2 = "'" + date.toString() + "'";
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT cacheID FROM VISITS WHERE vID=" + n3);
            resultSet.next();
            int n5 = resultSet.getInt("cacheID");
            resultSet = statement.executeQuery("SELECT urlOriginal, cachePath, docRetTime, docConTime, HTTPprotocol FROM CACHE WHERE cacheID=" + n5);
            resultSet.next();
            String string3 = this.getSuffix(n, n2);
            String string4 = resultSet.getString("urlOriginal");
            String string5 = resultSet.getString("cachePath");
            int n6 = resultSet.getInt("docRetTime");
            int n7 = resultSet.getInt("docConTime");
            String string6 = resultSet.getString("HTTPprotocol");
            int n8 = this.cache.copyTo(string5, string3);
            resultSet = statement.executeQuery("SELECT totalSpace FROM USER WHERE uID=" + n);
            resultSet.next();
            int n9 = resultSet.getInt("totalSpace") + n8;
            statement.executeUpdate("UPDATE USER SET totalSpace=" + n9 + " WHERE uID=" + n);
            String string7 = "INSERT INTO CACHE VALUES(NULL,'" + string4 + "','" + string3 + "',NULL,NULL," + n2 + "," + n + ",'" + string3 + "','y','y'," + n6 + "," + n7 + "," + string2 + ",'" + string6 + "'," + 0 + ")";
            statement.executeUpdate(string7);
            resultSet = statement.executeQuery("SELECT cacheID FROM CACHE WHERE cachePath='" + string3 + "'");
            resultSet.next();
            n5 = resultSet.getInt("cacheID");
            string7 = "INSERT INTO MILESTONES VALUES(NULL," + n2 + ",NULL," + string2 + "," + string2 + ",'" + string + "'," + n5 + "," + 0 + ")";
            statement.executeUpdate(string7);
            resultSet = statement.executeQuery("SELECT mID FROM MILESTONES WHERE cacheID=" + n5);
            resultSet.next();
            n4 = resultSet.getInt("mID");
        }
        catch (SQLException sQLException) {
            this.cPool.releaseConnection(connection);
            throw new SQLException(sQLException.getMessage());
        }
        this.cPool.releaseConnection(connection);
        return n4;
    }

    public int goToMileStone(int n) throws SQLException, SessionExpiredException, IOException {
        MessageContext messageContext = MessageContext.getCurrentContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession.isNew()) {
            throw new SessionExpiredException("session expired");
        }
        int n2 = (Integer)httpSession.getAttribute("uID");
        int n3 = (Integer)httpSession.getAttribute("iID");
        Integer n4 = (Integer)httpSession.getAttribute("vID");
        Connection connection = this.cPool.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        int n5 = 0;
        int n6 = 0;
        try {
            statement = connection.createStatement();
            if (n4 == null) {
                resultSet = statement.executeQuery("SELECT last_visitID FROM INVESTIGATION WHERE iID=" + n3);
                resultSet.next();
                n6 = resultSet.getInt("last_visitID");
            } else {
                n6 = n4;
            }
            resultSet = statement.executeQuery("SELECT cacheID, noOfHits FROM MILESTONES WHERE mID=" + n);
            resultSet.next();
            int n7 = resultSet.getInt("cacheID");
            int n8 = resultSet.getInt("noOfHits") + 1;
            statement.executeUpdate("UPDATE MILESTONES SET noOfHits=" + n8 + " WHERE mID=" + n);
            resultSet = statement.executeQuery("SELECT urlOriginal, cachePath, docRetTime, docConTime, HTTPprotocol FROM CACHE WHERE cacheID=" + n7);
            resultSet.next();
            String string = this.getSuffix(n2, n3);
            String string2 = resultSet.getString("cachePath");
            this.cache.copyTo(string2, string);
            Date date = new Date(System.currentTimeMillis());
            String string3 = "'" + date.toString() + "'";
            String string4 = "INSERT INTO CACHE VALUES(NULL,'" + resultSet.getString("urlOriginal") + "','" + string + "',NULL,NULL," + n3 + "," + n2 + ",'" + string + "','n','y'," + resultSet.getInt("docRetTime") + "," + resultSet.getInt("docConTime") + "," + string3 + ",'" + resultSet.getString("HTTPprotocol") + "'," + 0 + ")";
            statement.executeUpdate(string4);
            resultSet = statement.executeQuery("SELECT cacheID FROM CACHE WHERE cachePath='" + string + "'");
            resultSet.next();
            n7 = resultSet.getInt("cacheID");
            string4 = "INSERT INTO VISITS VALUES(NULL," + n2 + "," + string3 + ",NULL," + n6 + ",NULL," + "NULL," + n3 + "," + n7 + ")";
            statement.executeUpdate(string4);
            resultSet = statement.executeQuery("SELECT vID FROM VISITS WHERE backward_vID=" + n6);
            resultSet.next();
            n5 = resultSet.getInt("vID");
            statement.executeUpdate("UPDATE VISITS SET forward_vID=" + n5 + " WHERE vID=" + n6);
            statement.executeUpdate("UPDATE INVESTIGATION SET last_visitID=" + n5 + " WHERE iID=" + n3);
            httpSession.setAttribute("vID", new Integer(n5));
        }
        catch (SQLException sQLException) {
            this.cPool.releaseConnection(connection);
            throw new SQLException(sQLException.getMessage());
        }
        this.cPool.releaseConnection(connection);
        return n5;
    }

    public int deleteMileStone(int n) throws SQLException, SessionExpiredException, IOException {
        MessageContext messageContext = MessageContext.getCurrentContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession.isNew()) {
            throw new SessionExpiredException("session expired");
        }
        int n2 = (Integer)httpSession.getAttribute("uID");
        Connection connection = this.cPool.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT cacheID FROM MILESTONES WHERE mID=" + n);
            resultSet.next();
            int n3 = resultSet.getInt("cacheID");
            resultSet = statement.executeQuery("SELECT cachePath FROM CACHE WHERE cacheID=" + n3);
            resultSet.next();
            String string = resultSet.getString("cachePath");
            statement.executeUpdate("UPDATE CACHE SET stillSavedFlag='n' WHERE cacheID=" + n3);
            int n4 = this.cache.deleteFiles(string);
            resultSet = statement.executeQuery("SELECT totalSpace FROM USER WHERE uID=" + n2);
            resultSet.next();
            int n5 = resultSet.getInt("totalSpace") - n4;
            statement.executeUpdate("UPDATE USER SET totalSpace=" + n5 + " WHERE uID=" + n2);
        }
        catch (SQLException sQLException) {
            this.cPool.releaseConnection(connection);
            throw new SQLException(sQLException.getMessage());
        }
        this.cPool.releaseConnection(connection);
        return 0;
    }

    private String[] parseString(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        vector.trimToSize();
        int n = vector.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            String string2;
            stringArray[i] = string2 = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    private String stringRep(Object object) throws SerializerException, NoImplementationException {
        ObjectTransformerSAXImpl objectTransformerSAXImpl = new ObjectTransformerSAXImpl();
        return objectTransformerSAXImpl.serializeToString(object);
    }

    private Object deserialize(String string) throws DeserializerException, NoImplementationException {
        ObjectTransformerSAXImpl objectTransformerSAXImpl = new ObjectTransformerSAXImpl();
        Object object = objectTransformerSAXImpl.deserializeFromString(string);
        return object;
    }

    public void finalize() {
        this.cPool.closeConnections();
    }

    public String noOP() {
        String string = "YAHOO!!";
        return string;
    }

    public int addWaypoint(String string, String string2, String string3, String string4) throws SQLException, SessionExpiredException, IOException {
        MessageContext messageContext = MessageContext.getCurrentContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession.isNew()) {
            throw new SessionExpiredException("session already expired");
        }
        int n = (Integer)httpSession.getAttribute("uID");
        int n2 = (Integer)httpSession.getAttribute("iID");
        Connection connection = this.cPool.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        int n3 = 0;
        try {
            statement = connection.createStatement();
            String string5 = "INSERT INTO WAYPOINTS VALUES(NULL," + n + "," + n2 + ",'" + string + "','" + string3 + "','" + string4 + "','" + string2 + "')";
            statement.executeUpdate(string5);
            resultSet = statement.executeQuery("SELECT wID FROM WAYPOINTS WHERE uID=" + n + " AND iID=" + n2 + " AND urlOriginal='" + string3 + "' AND elementID='" + string2 + "' AND name='" + string + "';");
            resultSet.next();
            n3 = resultSet.getInt("wID");
        }
        catch (SQLException sQLException) {
            n3 = -1;
            this.cPool.releaseConnection(connection);
            throw new SQLException(sQLException.getMessage());
        }
        this.cPool.releaseConnection(connection);
        return n3;
    }

    public int removeWaypoint(int n) throws SQLException, SessionExpiredException, IOException {
        MessageContext messageContext = MessageContext.getCurrentContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession.isNew()) {
            throw new SessionExpiredException("session expired");
        }
        Connection connection = this.cPool.getConnection();
        Statement statement = null;
        Object var7_7 = null;
        try {
            statement = connection.createStatement();
            String string = "DELETE FROM WAYPOINTS WHERE wID=" + n + ";";
            statement.executeUpdate(string);
            System.err.println("toExecute = " + string);
        }
        catch (SQLException sQLException) {
            this.cPool.releaseConnection(connection);
            throw new SQLException(sQLException.getMessage());
        }
        this.cPool.releaseConnection(connection);
        return 0;
    }

    public int changeWaypointName(int n, String string) throws SQLException, SessionExpiredException, IOException {
        MessageContext messageContext = MessageContext.getCurrentContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession.isNew()) {
            throw new SessionExpiredException("session expired");
        }
        Connection connection = this.cPool.getConnection();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.executeUpdate("UPDATE WAYPOINTS SET name='" + string + "' WHERE wID=" + n);
        }
        catch (SQLException sQLException) {
            this.cPool.releaseConnection(connection);
            throw new SQLException(sQLException.getMessage());
        }
        this.cPool.releaseConnection(connection);
        return 0;
    }

    public String loadWaypointsInfo(String string) throws SQLException, SessionExpiredException, IOException, IllegalStateException, SerializerException, NoImplementationException {
        WaypointsInfo waypointsInfo = new WaypointsInfo();
        MessageContext messageContext = MessageContext.getCurrentContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession.isNew()) {
            throw new SessionExpiredException("session already expired");
        }
        int n = (Integer)httpSession.getAttribute("uID");
        int n2 = (Integer)httpSession.getAttribute("iID");
        Connection connection = this.cPool.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        int n3 = 0;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT name, wID, elementID FROM WAYPOINTS WHERE uID=" + n + " AND iID=" + n2 + " AND urlOriginal='" + string + "';");
            Vector<String> vector = new Vector<String>();
            Vector<Integer> vector2 = new Vector<Integer>();
            Vector<String> vector3 = new Vector<String>();
            while (resultSet.next()) {
                vector.addElement(resultSet.getString("name"));
                vector2.addElement(new Integer(resultSet.getInt("wID")));
                vector3.addElement(resultSet.getString("elementID"));
            }
            vector2.trimToSize();
            vector.trimToSize();
            vector3.trimToSize();
            waypointsInfo.setWaypointNames(vector);
            waypointsInfo.setWaypointIDs(vector2);
            waypointsInfo.setWaypointElementIDs(vector3);
        }
        catch (SQLException sQLException) {
            n3 = -1;
            this.cPool.releaseConnection(connection);
            throw new SQLException(sQLException.getMessage());
        }
        this.cPool.releaseConnection(connection);
        return this.stringRep(waypointsInfo);
    }

    public int setPersonalization(String string, String string2, String string3) throws SQLException, UserDoesNotExistException, IllegalStateException, DeserializerException, NoImplementationException {
        Connection connection;
        block6: {
            Hashtable hashtable = (Hashtable)this.deserialize(string2);
            HashSet hashSet = (HashSet)this.deserialize(string3);
            MessageContext messageContext = MessageContext.getCurrentContext();
            HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            HttpSession httpSession = httpServletRequest.getSession();
            connection = this.cPool.getConnection();
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                if (httpSession.isNew()) {
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery("SELECT uID FROM USER WHERE eMail='" + string + "'");
                    if (!resultSet.next()) {
                        this.myInvalidate(httpSession);
                        this.cPool.releaseConnection(connection);
                        throw new UserDoesNotExistException("user doesn't exist");
                    }
                    int n = resultSet.getInt("uID");
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string4 = (String)enumeration.nextElement();
                        double d = (Double)hashtable.get(string4);
                        resultSet = statement.executeQuery("SELECT score FROM UPROFILE WHERE uID='" + n + "' AND word='" + string4 + "'");
                        if (resultSet.next()) {
                            statement.executeUpdate("UPDATE UPROFILE SET score=" + d + " WHERE uID='" + n + "' AND word='" + string4);
                            continue;
                        }
                        String string5 = "INSERT INTO UPROFILE VALUES(" + n + ",'" + string4 + "'," + d + ")";
                        statement.executeUpdate(string5);
                    }
                    break block6;
                }
                this.myInvalidate(httpSession);
                this.cPool.releaseConnection(connection);
                return 0;
            }
            catch (SQLException sQLException) {
                this.cPool.releaseConnection(connection);
                throw new SQLException(sQLException.getMessage());
            }
        }
        this.cPool.releaseConnection(connection);
        return 0;
    }
}

