/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.session;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.client.impl.BluejayDTDElementInstance;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.WaypointsTab;
import ca.ucalgary.bluejay.gui.menu.ViewMenuManager;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.w3c.dom.Node;

public class WaypointsGUI
implements ActionListener {
    private BluejayDObjectList dlist;
    private WaypointsTab waypointsWidget;
    private ViewMenuManager viewMenu;
    private String currGeneName;
    private String xptr;
    private int target;
    private int start;
    private int end;
    private int position;
    private int genomeNum;
    private double lenRatio;
    private String elementID;
    private String waypointName;
    private JToggleButton currentButton;
    private static final int MAX_WAYPOINT_NAME_LENGTH = 100;
    private static final int MAX_GENE_NAME_DISPLAY_LENGTH = 47;
    private static final int VERTICAL_SPACE = 10;

    public WaypointsGUI(BluejayDObjectList bluejayDObjectList, WaypointsTab waypointsTab, ViewMenuManager viewMenuManager, Node node, int n) {
        this.dlist = bluejayDObjectList;
        this.waypointsWidget = waypointsTab;
        this.viewMenu = viewMenuManager;
        this.position = n;
        this.start = 0;
        this.end = 0;
        this.target = 0;
        this.genomeNum = 0;
        this.lenRatio = 1.0;
        DTDElementInstance dTDElementInstance = (DTDElementInstance)node;
        this.genomeNum = dTDElementInstance.getSlaveNum();
        this.lenRatio = dTDElementInstance.getLenRatio();
        this.elementID = ((BluejayDTDElementInstance)dTDElementInstance).getWaypointElementID();
        this.currGeneName = dTDElementInstance.getPainter().getToolTip(dTDElementInstance);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (!(node2 instanceof DTDElementInstance) || !((DTDElementInstance)node2).getLocalName().equals("seq_location")) continue;
            this.target = dTDElementInstance.getTarget();
            this.start = Integer.parseInt(((DTDElementInstance)node2).getAttribute("least_start"));
            this.end = Integer.parseInt(((DTDElementInstance)node2).getAttribute("greatest_end"));
        }
    }

    public JMenu createLinkPopup() {
        JMenu jMenu = new JMenu("Waypoint Options");
        JMenuItem jMenuItem = new JMenuItem("Create Waypoint");
        jMenuItem.setActionCommand("create_waypoint");
        jMenuItem.addActionListener(this);
        JMenuItem jMenuItem2 = new JMenuItem("Align at Waypoint");
        jMenuItem2.setActionCommand("align_waypoint");
        jMenuItem2.addActionListener(this);
        JMenuItem jMenuItem3 = new JMenuItem("Edit Waypoint");
        jMenuItem3.setActionCommand("edit_waypoint");
        jMenuItem3.addActionListener(this);
        JMenuItem jMenuItem4 = new JMenuItem("Focus on Waypoint");
        jMenuItem4.setActionCommand("focus_waypoint");
        jMenuItem4.addActionListener(this);
        JMenuItem jMenuItem5 = new JMenuItem("Cut at Waypoint");
        jMenuItem5.setActionCommand("cut_waypoint");
        jMenuItem5.addActionListener(this);
        JMenuItem jMenuItem6 = new JMenuItem("Remove Waypoint");
        jMenuItem6.setActionCommand("remove_waypoint");
        jMenuItem6.addActionListener(this);
        JMenuItem jMenuItem7 = this.waypointsWidget.isSelectedWaypoint(this.elementID) ? new JMenuItem("Deselect Waypoint") : new JMenuItem("Select Waypoint");
        jMenuItem7.setActionCommand("select_waypoint");
        jMenuItem7.addActionListener(this);
        if (this.waypointsWidget.getWaypointElementIds().contains(this.elementID)) {
            if (this.dlist.getComparisonPool().getPoolSize() > 1) {
                jMenu.add(jMenuItem2);
            }
            jMenu.add(jMenuItem3);
            jMenu.add(jMenuItem4);
            jMenu.add(jMenuItem5);
            jMenu.add(jMenuItem6);
            jMenu.add(jMenuItem7);
        } else {
            jMenu.add(jMenuItem);
            jMenu.add(jMenuItem3);
            jMenu.add(jMenuItem4);
            jMenu.add(jMenuItem5);
            jMenu.add(jMenuItem6);
            jMenu.add(jMenuItem7);
            jMenuItem3.setEnabled(false);
            jMenuItem4.setEnabled(false);
            jMenuItem5.setEnabled(false);
            jMenuItem6.setEnabled(false);
            jMenuItem7.setEnabled(false);
        }
        return jMenu;
    }

    public void createWaypoint() {
        int n;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel("Waypoint Name:");
        jLabel.setAlignmentX(0.0f);
        JTextField jTextField = new JTextField("Waypoint" + (this.waypointsWidget.getNumWaypoints() + 1));
        jTextField.setAlignmentX(0.0f);
        jTextField.setColumns(10);
        JLabel jLabel2 = new JLabel("Gene Name: ");
        jLabel2.setAlignmentX(0.0f);
        JTextField jTextField2 = null;
        jTextField2 = this.currGeneName.length() > 47 ? new JTextField(this.currGeneName.substring(0, 47).concat("...")) : new JTextField(this.currGeneName);
        jTextField2.setAlignmentX(0.0f);
        jTextField2.setEditable(false);
        jTextField2.setToolTipText(this.currGeneName);
        JLabel jLabel3 = new JLabel("Gene Position:");
        jLabel3.setAlignmentX(0.0f);
        JTextField jTextField3 = new JTextField("start = " + this.start + ", end = " + this.end);
        jTextField3.setAlignmentX(0.0f);
        jTextField3.setEditable(false);
        JLabel jLabel4 = new JLabel("Waypoint Position:");
        jLabel4.setAlignmentX(0.0f);
        JTextField jTextField4 = this.dlist.getAbstractLinearGraphics().isInTextMode() ? new JTextField(Integer.toString(this.position)) : new JTextField(Integer.toString(this.start));
        jTextField4.setAlignmentX(0.0f);
        JLabel jLabel5 = new JLabel("Waypoint Icon:");
        JPanel jPanel2 = this.waypointsWidget.getIconPanel(this, null);
        jPanel2.setAlignmentX(0.0f);
        JLabel jLabel6 = new JLabel("");
        jLabel6.setAlignmentX(0.0f);
        jLabel6.setForeground(Color.RED);
        jPanel.add(jLabel);
        jPanel.add(jTextField);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(jLabel2);
        jPanel.add(jTextField2);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(jLabel3);
        jPanel.add(jTextField3);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(jLabel4);
        jPanel.add(jTextField4);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(jLabel5);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(jLabel6);
        while ((n = JOptionPane.showOptionDialog(this.dlist.getFrame(), jPanel, "Create Waypoint", 2, -1, null, new String[]{"Okay", "Cancel"}, "Okay")) == 0) {
            this.waypointName = jTextField.getText();
            if (this.waypointName.length() < 100) {
                int n2;
                if (this.waypointsWidget.isDuplicateWaypointName(this.waypointName.trim(), this.genomeNum)) {
                    jLabel6.setText("Waypoint name already exists.");
                    continue;
                }
                try {
                    n2 = Integer.parseInt(jTextField4.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    jLabel6.setText("Waypoint position must be an integer.");
                    continue;
                }
                if (n2 < this.start || n2 > this.end) {
                    jLabel6.setText("Waypoint position must be within the gene.");
                    continue;
                }
                this.waypointsWidget.addWaypoint(this.waypointName, this.currGeneName, this.xptr, this.target, this.start, this.end, n2, this.genomeNum, this.lenRatio, this.elementID);
                if (this.currentButton != null) {
                    ImageIcon imageIcon = (ImageIcon)this.currentButton.getIcon();
                    this.waypointsWidget.setImage(this.elementID, imageIcon.getImage());
                    this.waypointsWidget.setDescription(this.elementID, imageIcon.getDescription());
                }
                this.viewMenu.showWaypointsTab(true);
                break;
            }
            jLabel6.setText("Waypoint name must be less than 100 characters.");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            if (actionEvent.getActionCommand() == "create_waypoint") {
                this.createWaypoint();
            } else if (actionEvent.getActionCommand() == "align_waypoint") {
                this.waypointsWidget.alignWaypoint(this.target, this.elementID);
            } else if (actionEvent.getActionCommand() == "select_waypoint") {
                this.waypointsWidget.selectWaypoint(this.elementID);
                this.viewMenu.showWaypointsTab(true);
            } else if (actionEvent.getActionCommand() == "edit_waypoint") {
                this.waypointsWidget.editWaypoint(this.elementID);
            } else if (actionEvent.getActionCommand() == "focus_waypoint") {
                this.waypointsWidget.goToWaypoint(this.target, this.elementID);
            } else if (actionEvent.getActionCommand() == "cut_waypoint") {
                this.waypointsWidget.cutAtWaypoint(this.start, this.elementID);
            } else if (actionEvent.getActionCommand() == "remove_waypoint") {
                this.waypointsWidget.removeWaypoint(this.elementID);
            } else {
                System.err.println("WaypointsGUI.actionPerformed: strange action command");
            }
        }
        if (actionEvent.getSource() instanceof JToggleButton) {
            this.currentButton = (JToggleButton)actionEvent.getSource();
        }
    }
}

