/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.util;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JApplet;

public class SplashWindow
extends Window {
    private static SplashWindow instance;
    private static int titleX;
    private static int titleY;
    private static int statusX;
    private static int statusY;
    private static int quoteX;
    private static int quoteY;
    private Image image;
    private boolean paintCalled = false;
    private static String titleText;
    private static String statusText;
    private static String quoteOfTheDay;

    private SplashWindow(Frame frame, Image image) {
        super(frame);
        int n;
        this.image = image;
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        URL uRL = this.getClass().getClassLoader().getResource("docs/quotes.txt");
        if (uRL != null) {
            try {
                InputStream inputStream = uRL.openStream();
                n = 0;
                char c = (char)inputStream.read();
                while (c != '\uffffffff' && c != '\n') {
                    n = n * 10 + Integer.parseInt("" + c);
                    c = (char)inputStream.read();
                }
                for (int i = (int)(Math.random() * (double)n); i > 0; --i) {
                    c = (char)inputStream.read();
                    while (c != '\n' && c != '\uffffffff') {
                        c = (char)inputStream.read();
                    }
                }
                quoteOfTheDay = "";
                c = (char)inputStream.read();
                while (c != '\n' && c != '\uffffffff') {
                    quoteOfTheDay = quoteOfTheDay + c;
                    c = (char)inputStream.read();
                }
            }
            catch (Exception exception) {
                System.err.println("Could not load quote from quotesURL: " + exception);
            }
        }
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n2 = image.getWidth(this);
        n = image.getHeight(this);
        this.setSize(n2, n);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - n2) / 2, (dimension.height - n) / 2);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseClicked(MouseEvent mouseEvent) {
                SplashWindow splashWindow = SplashWindow.this;
                synchronized (splashWindow) {
                    SplashWindow.this.paintCalled = true;
                    SplashWindow.this.notifyAll();
                }
                SplashWindow.this.dispose();
            }
        };
        this.addMouseListener(mouseAdapter);
    }

    public static void setTitlePosition(int n, int n2) {
        titleX = n;
        titleY = n2;
    }

    public static void setStatusPosition(int n, int n2) {
        statusX = n;
        statusY = n2;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        graphics.drawImage(this.image, 0, 0, this);
        if (titleText != null) {
            graphics.drawString(titleText, titleX, titleY);
        }
        if (statusText != null) {
            graphics.drawString(statusText, statusX, statusY);
        }
        if (quoteOfTheDay != null) {
            if (quoteOfTheDay.length() > 80) {
                int n = quoteOfTheDay.indexOf(" ", 70);
                graphics.drawString(quoteOfTheDay.substring(0, n), quoteX, quoteY - 20);
                graphics.drawString(quoteOfTheDay.substring(n), quoteX, quoteY);
            } else {
                graphics.drawString(quoteOfTheDay, quoteX, quoteY);
            }
        }
        if (!this.paintCalled) {
            this.paintCalled = true;
            SplashWindow splashWindow = this;
            synchronized (splashWindow) {
                this.notifyAll();
            }
        }
    }

    public static void setStatus(String string) {
        statusText = string;
        if (instance != null) {
            instance.toFront();
            instance.repaint();
        }
    }

    public static void setStatus(String string, boolean bl) {
        statusText = string;
        if (instance != null && !bl) {
            instance.update(instance.getGraphics());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splash(Image image, String string) {
        if (instance == null && image != null) {
            Frame frame = new Frame();
            titleText = string;
            instance = new SplashWindow(frame, image);
            instance.setVisible(true);
            if (!EventQueue.isDispatchThread() && Runtime.getRuntime().availableProcessors() == 1) {
                SplashWindow splashWindow = instance;
                synchronized (splashWindow) {
                    while (!SplashWindow.instance.paintCalled) {
                        try {
                            instance.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splash(Image image) {
        if (instance == null && image != null) {
            Frame frame = new Frame();
            instance = new SplashWindow(frame, image);
            instance.setVisible(true);
            if (!EventQueue.isDispatchThread() && Runtime.getRuntime().availableProcessors() == 1) {
                SplashWindow splashWindow = instance;
                synchronized (splashWindow) {
                    while (!SplashWindow.instance.paintCalled) {
                        try {
                            instance.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
    }

    public static void splash(URL uRL, String string) {
        if (uRL != null) {
            SplashWindow.splash(Toolkit.getDefaultToolkit().createImage(uRL), string);
        }
    }

    public static void splash(URL uRL) {
        if (uRL != null) {
            SplashWindow.splash(Toolkit.getDefaultToolkit().createImage(uRL));
        }
    }

    public static void disposeSplash() {
        if (instance != null) {
            instance.getOwner().dispose();
            instance = null;
        }
    }

    public static void invokeStaticMethod(String string, String string2, int n) {
        try {
            Class.forName(string).getMethod(string2, Integer.TYPE).invoke(null, n);
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Failed to invoke static method " + string2 + " with int argument");
            internalError.initCause(exception);
            throw internalError;
        }
    }

    public static void invokeStaticMethod(String string, String string2, boolean bl) {
        try {
            Class.forName(string).getMethod(string2, Boolean.TYPE).invoke(null, bl);
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Failed to invoke static method " + string2 + " with boolean argument");
            internalError.initCause(exception);
            throw internalError;
        }
    }

    public static void invokeStaticMethod(String string, String string2, double d) {
        try {
            Class.forName(string).getMethod(string2, Double.TYPE).invoke(null, d);
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Failed to invoke static method " + string2 + " with double precision floating point number argument");
            internalError.initCause(exception);
            throw internalError;
        }
    }

    public static void invokeStaticMethod(String string, String string2) {
        try {
            Class.forName(string).getMethod(string2, new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Failed to invoke static method " + string2 + " with no arguments");
            internalError.initCause(exception);
            throw internalError;
        }
    }

    public static void invokeMain(String string, String[] stringArray) {
        try {
            Class.forName(string).getMethod("main", String[].class).invoke(null, new Object[]{stringArray});
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Failed to invoke main method");
            internalError.initCause(exception);
            throw internalError;
        }
    }

    public static void invokeInit(String string, JApplet jApplet) {
        try {
            Class.forName(string).getMethod("init", JApplet.class).invoke(null, jApplet);
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Failed to invoke init method");
            internalError.initCause(exception);
            throw internalError;
        }
    }

    static {
        titleX = 20;
        titleY = 50;
        statusX = 20;
        statusY = 160;
        quoteX = 20;
        quoteY = 280;
        quoteOfTheDay = "Please wait...";
    }
}

