/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.IDBID;
import com.hp.hpl.jena.db.impl.IPSet;
import com.hp.hpl.jena.db.impl.ResultSetIterator;
import com.hp.hpl.jena.db.impl.SQLCache;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultSetTripleIterator
extends ResultSetIterator {
    protected IDBID m_graphID;
    protected IPSet m_pset;
    protected Triple m_triple;
    protected boolean m_isReif;
    protected Node m_stmtURI;
    protected boolean m_hasType;
    protected static Log logger = LogFactory.getLog(ResultSetTripleIterator.class);

    public ResultSetTripleIterator(IPSet p, IDBID graphID) {
        this.m_pset = p;
        this.setGraphID(graphID);
        this.m_isReif = false;
    }

    public ResultSetTripleIterator(IPSet p, boolean isReif, IDBID graphID) {
        this.m_pset = p;
        this.setGraphID(graphID);
        this.m_isReif = isReif;
    }

    public void setGraphID(IDBID gid) {
        this.m_graphID = gid;
    }

    public void reset(ResultSet resultSet, PreparedStatement sourceStatement, SQLCache cache, String opname) {
        super.reset(resultSet, sourceStatement, cache, opname);
        this.m_triple = null;
    }

    protected void extractRow() throws SQLException {
        boolean rx = true;
        ResultSet rs = this.m_resultSet;
        String subj = rs.getString(1);
        String pred = rs.getString(2);
        String obj = rs.getString(3);
        if (this.m_isReif) {
            this.m_stmtURI = this.m_pset.driver().RDBStringToNode(rs.getString(4));
            this.m_hasType = rs.getString(5).equals("T");
        }
        Triple t = null;
        try {
            t = this.m_pset.extractTripleFromRowData(subj, pred, obj);
        }
        catch (RDFRDBException e) {
            logger.debug("Extracting triple from row encountered exception: ", e);
        }
        this.m_triple = t;
    }

    protected Object getRow() {
        return this.m_triple;
    }

    protected Node getStmtURI() {
        return this.m_stmtURI;
    }

    protected boolean getHasType() {
        return this.m_hasType;
    }

    protected void deleteRow() {
        try {
            this.m_resultSet.deleteRow();
        }
        catch (SQLException e) {
            throw new RDFRDBException("Internal sql error", e);
        }
    }

    public void remove() {
        if (this.m_triple == null) {
            throw new IllegalStateException();
        }
        this.m_pset.deleteTriple(this.m_triple, this.m_graphID);
    }
}

