/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.iri;

import com.hp.hpl.jena.iri.IRIConformanceLevels;
import com.hp.hpl.jena.iri.IRIException;
import com.hp.hpl.jena.iri.RDFURIReference;
import com.hp.hpl.jena.iri.impl.BadIRI;
import com.hp.hpl.jena.iri.impl.EmptyIRI;
import com.hp.hpl.jena.iri.impl.JavaURIWrapper;
import com.hp.hpl.jena.iri.impl.NullIRI;
import com.hp.hpl.jena.iri.impl.XercesURIWrapper;
import com.hp.hpl.jena.rdf.arp.MalformedURIException;
import java.net.URISyntaxException;
import org.xml.sax.Locator;

public class IRIFactory
implements IRIConformanceLevels {
    final Locator locator;
    static IRIFactory d = new IRIFactory();

    public static IRIFactory defaultFactory() {
        return d;
    }

    public IRIFactory() {
        this(new Locator(){

            public String getPublicId() {
                return null;
            }

            public String getSystemId() {
                return null;
            }

            public int getLineNumber() {
                return -1;
            }

            public int getColumnNumber() {
                return -1;
            }
        });
    }

    public IRIFactory(Locator l) {
        this.locator = l;
    }

    public RDFURIReference create(String s) {
        if (s == null) {
            return new NullIRI(this);
        }
        if (s.equals("")) {
            return new EmptyIRI(this);
        }
        try {
            return new JavaURIWrapper(this, s);
        }
        catch (URISyntaxException jnue) {
            IRIException irie1 = this.wrapJavaNetException(jnue);
            try {
                return new XercesURIWrapper(irie1, this, s);
            }
            catch (MalformedURIException xue) {
                IRIException irie2 = this.wrapXercesException(xue);
                return new BadIRI(irie1, irie2, this, s);
            }
        }
    }

    public IRIException wrapXercesException(MalformedURIException xue) {
        return new IRIException(21, this, xue);
    }

    public IRIException wrapJavaNetException(URISyntaxException jnue) {
        return new IRIException(0xA | (IRIFactory.isAlsoBadRDFURIRef(jnue) ? 21 : 0), this, jnue);
    }

    private static boolean isAlsoBadRDFURIRef(URISyntaxException jnue) {
        return !jnue.getReason().startsWith("Illegal character");
    }
}

