/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.iri.impl;

import com.hp.hpl.jena.iri.IRIException;
import com.hp.hpl.jena.iri.IRIFactory;
import com.hp.hpl.jena.iri.RDFURIReference;
import com.hp.hpl.jena.iri.impl.AbsIRI;
import com.hp.hpl.jena.iri.impl.BadIRI;
import com.hp.hpl.jena.iri.impl.JavaURIWrapper;
import com.hp.hpl.jena.iri.impl.XercesURI;
import com.hp.hpl.jena.rdf.arp.MalformedURIException;
import java.util.Collection;

public class XercesURIWrapper
extends AbsIRI {
    final XercesURI iri;
    final IRIException exception;

    public XercesURIWrapper(IRIException e, IRIFactory f, String s) throws MalformedURIException {
        this(e, f, new XercesURI(s));
    }

    public XercesURIWrapper(IRIException e, IRIFactory factory, XercesURI uri) {
        super(factory);
        this.iri = uri;
        this.exception = e;
    }

    private XercesURIWrapper(IRIException e, AbsIRI p, XercesURI uri) {
        super(p);
        this.iri = uri;
        this.exception = e;
    }

    public boolean isAbsolute() {
        return true;
    }

    public boolean isOpaque() {
        return !this.iri.isGenericURI();
    }

    public boolean isRelative() {
        return false;
    }

    public boolean isRDFURIReference() {
        return true;
    }

    public boolean isIRI() {
        return false;
    }

    public boolean isJavaNetURI() {
        return false;
    }

    public boolean isVeryBad() {
        return false;
    }

    public boolean isXSanyURI() {
        return true;
    }

    public RDFURIReference resolve(RDFURIReference rel) {
        return this.resolve(((Object)rel).toString());
    }

    public RDFURIReference resolve(String uri) {
        IRIException newException = this.exception;
        try {
            XercesURI resolved = new XercesURI(this.iri, uri);
            RDFURIReference redo = this.factory.create(resolved.toString());
            if (redo.isJavaNetURI()) {
                return redo;
            }
            if (redo instanceof XercesURIWrapper) {
                newException = ((XercesURIWrapper)redo).exception;
            }
            return new XercesURIWrapper(newException, this.factory, resolved);
        }
        catch (MalformedURIException xue) {
            return new BadIRI(newException, this.factory.wrapXercesException(xue), this.factory, uri);
        }
    }

    RDFURIReference resolveAgainst(JavaURIWrapper base) {
        return this;
    }

    boolean addExceptions(int level, Collection here) {
        this.addException(this.exception, level, here);
        return true;
    }

    public RDFURIReference reparent(AbsIRI p) {
        return new XercesURIWrapper(this.exception, p, this.iri);
    }

    public String getUserinfo() {
        return this.iri.getUserinfo();
    }

    public int getPort() {
        return this.iri.getPort();
    }

    public String getPath() {
        return this.iri.getPath();
    }

    public String getQuery() {
        return this.iri.getQueryString();
    }

    public String getFragment() {
        return this.iri.getFragment();
    }

    public String getHost() {
        return this.iri.getHost();
    }

    public String getScheme() {
        return this.iri.getScheme();
    }

    public String toString() {
        return this.iri.toString();
    }
}

