/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntologyException;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.ProfileRegistry;
import com.hp.hpl.jena.ontology.impl.OntModelImpl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.ModelSpec;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.InfModelSpec;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecImpl;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.DAMLMicroReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLFBRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLMicroReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLMiniReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasonerFactory;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;

public class OntModelSpec
extends ModelSpecImpl
implements ModelSpec {
    public static final OntModelSpec OWL_MEM = new OntModelSpec(ModelFactory.createMemModelMaker(), null, null, ProfileRegistry.OWL_LANG);
    public static final OntModelSpec OWL_MEM_RDFS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, RDFSRuleReasonerFactory.theInstance(), ProfileRegistry.OWL_LANG);
    public static final OntModelSpec OWL_MEM_TRANS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, TransitiveReasonerFactory.theInstance(), ProfileRegistry.OWL_LANG);
    public static final OntModelSpec OWL_MEM_RULE_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, OWLFBRuleReasonerFactory.theInstance(), ProfileRegistry.OWL_LANG);
    public static final OntModelSpec OWL_MEM_MICRO_RULE_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, OWLMicroReasonerFactory.theInstance(), ProfileRegistry.OWL_LANG);
    public static final OntModelSpec OWL_MEM_MINI_RULE_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, OWLMiniReasonerFactory.theInstance(), ProfileRegistry.OWL_LANG);
    public static final OntModelSpec OWL_DL_MEM = new OntModelSpec(ModelFactory.createMemModelMaker(), null, null, ProfileRegistry.OWL_DL_LANG);
    public static final OntModelSpec OWL_DL_MEM_RDFS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, RDFSRuleReasonerFactory.theInstance(), ProfileRegistry.OWL_DL_LANG);
    public static final OntModelSpec OWL_DL_MEM_TRANS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, TransitiveReasonerFactory.theInstance(), ProfileRegistry.OWL_DL_LANG);
    public static final OntModelSpec OWL_DL_MEM_RULE_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, OWLFBRuleReasonerFactory.theInstance(), ProfileRegistry.OWL_DL_LANG);
    public static final OntModelSpec OWL_LITE_MEM = new OntModelSpec(ModelFactory.createMemModelMaker(), null, null, ProfileRegistry.OWL_LITE_LANG);
    public static final OntModelSpec OWL_LITE_MEM_TRANS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, TransitiveReasonerFactory.theInstance(), ProfileRegistry.OWL_LITE_LANG);
    public static final OntModelSpec OWL_LITE_MEM_RDFS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, RDFSRuleReasonerFactory.theInstance(), ProfileRegistry.OWL_LITE_LANG);
    public static final OntModelSpec OWL_LITE_MEM_RULES_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, OWLFBRuleReasonerFactory.theInstance(), ProfileRegistry.OWL_LITE_LANG);
    public static final OntModelSpec DAML_MEM = new OntModelSpec(ModelFactory.createMemModelMaker(), null, null, "http://www.daml.org/2001/03/daml+oil#");
    public static final OntModelSpec DAML_MEM_TRANS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, TransitiveReasonerFactory.theInstance(), "http://www.daml.org/2001/03/daml+oil#");
    public static final OntModelSpec DAML_MEM_RDFS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, RDFSRuleReasonerFactory.theInstance(), "http://www.daml.org/2001/03/daml+oil#");
    public static final OntModelSpec DAML_MEM_RULE_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, DAMLMicroReasonerFactory.theInstance(), "http://www.daml.org/2001/03/daml+oil#");
    public static final OntModelSpec RDFS_MEM = new OntModelSpec(ModelFactory.createMemModelMaker(), null, null, ProfileRegistry.RDFS_LANG);
    public static final OntModelSpec RDFS_MEM_TRANS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, TransitiveReasonerFactory.theInstance(), ProfileRegistry.RDFS_LANG);
    public static final OntModelSpec RDFS_MEM_RDFS_INF = new OntModelSpec(ModelFactory.createMemModelMaker(), null, RDFSRuleReasonerFactory.theInstance(), ProfileRegistry.RDFS_LANG);
    protected OntDocumentManager m_docManager = null;
    protected Reasoner m_reasoner = null;
    protected String m_languageURI;
    protected Profile m_profile = null;
    protected ReasonerFactory m_rFactory = null;
    protected ModelMaker m_importsMaker;
    protected String m_baseModelName;

    public OntModelSpec(ModelMaker importsMaker, OntDocumentManager docMgr, ReasonerFactory rFactory, String languageURI) {
        this(ModelFactory.createMemModelMaker(), importsMaker, docMgr, rFactory, languageURI);
    }

    public OntModelSpec(ModelMaker baseMaker, ModelMaker importsMaker, OntDocumentManager docMgr, ReasonerFactory rFactory, String languageURI) {
        this(null, baseMaker, importsMaker, docMgr, rFactory, languageURI);
    }

    public OntModelSpec(String baseModelName, ModelMaker baseMaker, ModelMaker importsMaker, OntDocumentManager docMgr, ReasonerFactory rFactory, String languageURI) {
        super(baseMaker);
        this.m_baseModelName = baseModelName;
        this.m_importsMaker = importsMaker == null ? ModelFactory.createMemModelMaker() : importsMaker;
        this.setDocumentManager(docMgr);
        this.setReasonerFactory(rFactory);
        if (languageURI == null) {
            throw new IllegalArgumentException("Cannot create OntModelSpec with a null ontology language");
        }
        this.setLanguage(languageURI);
    }

    public OntModelSpec(OntModelSpec spec) {
        this(spec.getBaseModelMaker(), spec.getImportModelMaker(), spec.getDocumentManager(), spec.getReasonerFactory(), spec.getLanguage());
    }

    public ModelMaker getModelMaker() {
        return this.getImportModelMaker();
    }

    public ModelMaker getImportModelMaker() {
        return this.m_importsMaker;
    }

    public ModelMaker getBaseModelMaker() {
        return super.getModelMaker();
    }

    public OntModelSpec(Model description) {
        this(OntModelSpec.findRootByType(description, JenaModelSpec.OntModelSpec), description);
    }

    public OntModelSpec(Resource root, Model description) {
        this(OntModelSpec.getBaseModelName(description, root), OntModelSpec.getBaseMaker(description, root), OntModelSpec.getImportMaker(description, root), OntModelSpec.getDocumentManager(description, root), OntModelSpec.getReasonerFactory(description, root), OntModelSpec.getLanguage(description, root));
    }

    public static OntModelSpec getDefaultSpec(String languageURI) {
        if (languageURI.equals(ProfileRegistry.OWL_LANG)) {
            return OWL_MEM_RDFS_INF;
        }
        if (languageURI.equals(ProfileRegistry.OWL_DL_LANG)) {
            return OWL_DL_MEM_RDFS_INF;
        }
        if (languageURI.equals(ProfileRegistry.OWL_LITE_LANG)) {
            return OWL_LITE_MEM_RDFS_INF;
        }
        if (languageURI.equals("http://www.daml.org/2001/03/daml+oil#")) {
            return DAML_MEM_RULE_INF;
        }
        if (languageURI.equals(ProfileRegistry.RDFS_LANG)) {
            return RDFS_MEM_RDFS_INF;
        }
        throw new OntologyException("Did not recognise this language URI, so cannot determine default model spec: " + languageURI);
    }

    public OntDocumentManager getDocumentManager() {
        if (this.m_docManager == null) {
            this.m_docManager = OntDocumentManager.getInstance();
        }
        return this.m_docManager;
    }

    public void setDocumentManager(OntDocumentManager docMgr) {
        this.m_docManager = docMgr;
    }

    public void setImportModelMaker(ModelMaker maker) {
        this.m_importsMaker = maker;
    }

    public void setModelMaker(ModelMaker m) {
        this.setImportModelMaker(m);
    }

    public void setBaseModelMaker(ModelMaker m) {
        this.maker = m;
    }

    public Reasoner getReasoner() {
        if (this.m_reasoner == null && this.m_rFactory != null) {
            this.m_reasoner = this.m_rFactory.create(null);
        }
        return this.m_reasoner;
    }

    public void setReasoner(Reasoner reasoner) {
        this.m_reasoner = reasoner;
    }

    public void setReasonerFactory(ReasonerFactory rFactory) {
        this.m_rFactory = rFactory;
    }

    public ReasonerFactory getReasonerFactory() {
        return this.m_rFactory;
    }

    public String getLanguage() {
        return this.m_languageURI;
    }

    public void setLanguage(String languageURI) {
        this.m_languageURI = languageURI;
        this.m_profile = ProfileRegistry.getInstance().getProfile(this.m_languageURI);
        if (this.m_profile == null) {
            throw new OntologyException("Could not determine an ontology language profile for URI " + this.m_languageURI);
        }
    }

    public Profile getProfile() {
        return this.m_profile;
    }

    public Model doCreateModel() {
        Model m = this.m_baseModelName == null ? this.maker.createFreshModel() : this.maker.createModel(this.m_baseModelName);
        return new OntModelImpl(this, m);
    }

    public Model implementCreateModelOver(String name) {
        return new OntModelImpl(this, this.maker.createModel(name, false));
    }

    public static ModelMaker getImportMaker(Model description, Resource root) {
        return OntModelSpec.getMaker(description, root, JenaModelSpec.importMaker);
    }

    public static ModelMaker getBaseMaker(Model description, Resource root) {
        return OntModelSpec.getMaker(description, root, JenaModelSpec.maker);
    }

    protected static String getBaseModelName(Model description, Resource root) {
        Statement s = description.getProperty(root, JenaModelSpec.modelName);
        return s == null ? null : s.getString();
    }

    protected static ModelMaker getMaker(Model description, Resource root, Property makerProperty) {
        Statement mStatement = description.getProperty(root, makerProperty);
        return mStatement == null ? ModelFactory.createMemModelMaker() : OntModelSpec.createMaker(mStatement.getResource(), description);
    }

    public static String getLanguage(Model description, Resource root) {
        Statement langStatement = description.getRequiredProperty(root, JenaModelSpec.ontLanguage);
        return langStatement.getResource().getURI();
    }

    public static OntDocumentManager getDocumentManager(Model description, Resource root) {
        Statement docStatement = description.getProperty(root, JenaModelSpec.docManager);
        if (docStatement == null) {
            return null;
        }
        Resource manager = docStatement.getResource();
        Statement policy = description.getProperty(manager, JenaModelSpec.policyPath);
        if (policy == null) {
            return (OntDocumentManager)OntModelSpec.getValue(manager);
        }
        return new OntDocumentManager(policy.getString());
    }

    public static ReasonerFactory getReasonerFactory(Model description, Resource root) {
        Statement factStatement = description.getProperty(root, JenaModelSpec.reasonsWith);
        if (factStatement == null) {
            return null;
        }
        return InfModelSpec.getReasonerFactory(factStatement.getResource(), description);
    }

    public Model addDescription(Model d, Resource self) {
        super.addDescription(d, self);
        this.addImportsDescription(d, self, this.m_importsMaker);
        this.addLanguageDescription(d, self, this.m_languageURI);
        this.addManagerDescription(d, self, this.getDocumentManager());
        this.addReasonerDescription(d, self, this.getReasonerFactory());
        return d;
    }

    public Property getMakerProperty() {
        return JenaModelSpec.importMaker;
    }

    protected void addLanguageDescription(Model d, Resource me, String langURI) {
        d.add(me, JenaModelSpec.ontLanguage, d.createResource(langURI));
    }

    protected void addImportsDescription(Model d, Resource me, ModelMaker m) {
        Resource importSelf = d.createResource();
        d.add(me, JenaModelSpec.importMaker, importSelf);
        m.addDescription(d, importSelf);
    }

    protected void addManagerDescription(Model d, Resource me, OntDocumentManager man) {
        d.add(me, JenaModelSpec.docManager, OntModelSpec.createValue(man));
    }

    protected void addReasonerDescription(Model d, Resource me, ReasonerFactory rf) {
        Resource reasonerSelf = d.createResource();
        d.add(me, JenaModelSpec.reasonsWith, reasonerSelf);
        if (rf != null) {
            d.add(reasonerSelf, JenaModelSpec.reasoner, d.createResource(rf.getURI()));
        }
    }

    public Model createBaseModel() {
        return ModelFactory.createDefaultModel();
    }
}

