/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGQueryTranslator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGQueryEquivalentsTranslator
extends DIGQueryTranslator {
    protected boolean m_subjectFree;

    public DIGQueryEquivalentsTranslator(String predicate, boolean subjectFree) {
        super(null, predicate, null);
        this.m_subjectFree = subjectFree;
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da) {
        DIGConnection dc = da.getConnection();
        Document query = dc.createDigVerb("asks", da.getProfile());
        Element equivalents = da.createQueryElement(query, "equivalents");
        da.addClassDescription(equivalents, this.m_subjectFree ? pattern.getObject() : pattern.getSubject());
        return query;
    }

    public ExtendedIterator translateResponseHook(Document response, TriplePattern query, DIGAdapter da) {
        return this.translateConceptSetResponse(response, query, !this.m_subjectFree, da);
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da, Model premises) {
        return null;
    }

    public boolean checkSubject(Node subject, DIGAdapter da, Model premises) {
        return this.m_subjectFree && !subject.isConcrete() || da.isConcept(subject, premises);
    }

    public boolean checkObject(Node object, DIGAdapter da, Model premises) {
        return !this.m_subjectFree && !object.isConcrete() || da.isConcept(object, premises);
    }

    public boolean checkTriple(TriplePattern pattern, DIGAdapter da, Model premises) {
        return super.checkTriple(pattern, da, premises) && (!pattern.getSubject().isConcrete() || !pattern.getObject().isConcrete());
    }
}

