/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGQueryAncestorsTranslator;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.util.iterator.Filter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGQueryParentsTranslator
extends DIGQueryAncestorsTranslator {
    public DIGQueryParentsTranslator(String predicate, boolean parents) {
        super(predicate, parents);
    }

    public DIGQueryParentsTranslator(String subject, String predicate, String object, boolean parents) {
        super(subject, predicate, object, parents);
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da) {
        DIGConnection dc = da.getConnection();
        Document query = dc.createDigVerb("asks", da.getProfile());
        if (this.m_ancestors) {
            Element parents = da.createQueryElement(query, "parents");
            da.addClassDescription(parents, pattern.getSubject());
        } else {
            Element descendants = da.createQueryElement(query, "children");
            da.addClassDescription(descendants, pattern.getObject());
        }
        return query;
    }

    protected Filter getResultsTripleFilter(TriplePattern query) {
        return new FilterSubjectAndObject(query.getSubject(), query.getObject());
    }

    private class FilterSubjectAndObject
    extends Filter {
        private Node m_subj;
        private Node m_obj;

        private FilterSubjectAndObject(Node subj, Node obj) {
            this.m_subj = subj;
            this.m_obj = obj;
        }

        public boolean accept(Object o) {
            Triple t = (Triple)o;
            return !(this.m_subj != null && this.m_subj != Node_RuleVariable.WILD && this.m_subj != Node.ANY && !t.getSubject().equals(this.m_subj) || this.m_obj != null && this.m_obj != Node_RuleVariable.WILD && this.m_obj != Node.ANY && !t.getObject().equals(this.m_obj));
        }
    }
}

