/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.FinderUtil;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BackwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.Builtin;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.impl.BBRuleContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.BindingVector;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPBRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPRuleStore;
import com.hp.hpl.jena.reasoner.rulesys.impl.TempNodeCache;
import com.hp.hpl.jena.util.OneToManyMap;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LPBackwardRuleInfGraph
extends BaseInfGraph
implements BackwardRuleInfGraphI {
    protected LPBRuleEngine engine;
    protected OneToManyMap derivations;
    protected FGraph fschema;
    protected FGraph fdeductions;
    protected Finder dataFind;
    protected TempNodeCache tempNodecache;
    static Log logger = LogFactory.getLog(LPBackwardRuleInfGraph.class);

    public LPBackwardRuleInfGraph(Reasoner reasoner, LPRuleStore ruleStore, Graph data, Graph schema) {
        super(data, reasoner);
        if (schema != null) {
            this.fschema = new FGraph(schema);
        }
        this.engine = new LPBRuleEngine(this, ruleStore);
        this.tempNodecache = new TempNodeCache(this);
    }

    public Graph getSchemaGraph() {
        return this.fschema.getGraph();
    }

    public void prepare() {
        if (!this.isPrepared) {
            this.fdeductions = new FGraph(Factory.createGraphMem());
            this.extractAxioms();
            this.dataFind = this.fdata;
            if (this.fdeductions != null) {
                this.dataFind = FinderUtil.cascade(this.dataFind, this.fdeductions);
            }
            if (this.fschema != null) {
                this.dataFind = FinderUtil.cascade(this.dataFind, this.fschema);
            }
        }
        this.isPrepared = true;
    }

    public synchronized void rebind(Graph data) {
        this.engine.checkSafeToUpdate();
        this.fdata = new FGraph(data);
        this.isPrepared = false;
    }

    public synchronized void rebind() {
        this.engine.checkSafeToUpdate();
        this.isPrepared = false;
    }

    public synchronized void reset() {
        this.engine.checkSafeToUpdate();
        this.engine.reset();
    }

    public synchronized ExtendedIterator findWithContinuation(TriplePattern pattern, Finder continuation) {
        this.checkOpen();
        if (!this.isPrepared) {
            this.prepare();
        }
        ExtendedIterator result = this.engine.find(pattern);
        if (continuation != null) {
            result = result.andThen(continuation.find(pattern));
        }
        return result.filterDrop(Functor.acceptFilter);
    }

    public ExtendedIterator graphBaseFind(Node subject, Node property, Node object) {
        return this.findWithContinuation(new TriplePattern(subject, property, object), null);
    }

    public ExtendedIterator find(TriplePattern pattern) {
        return this.findWithContinuation(pattern, null);
    }

    public synchronized void performAdd(Triple t) {
        this.engine.checkSafeToUpdate();
        this.fdata.getGraph().add(t);
        this.isPrepared = false;
    }

    public synchronized void performDelete(Triple t) {
        this.engine.checkSafeToUpdate();
        this.fdata.getGraph().delete(t);
        this.isPrepared = false;
    }

    public void setTabled(Node predicate) {
        this.engine.tablePredicate(predicate);
        if (this.isTraceOn()) {
            logger.info("LP TABLE " + predicate);
        }
    }

    public void setDerivationLogging(boolean recordDerivations) {
        this.engine.setDerivationLogging(recordDerivations);
        this.derivations = recordDerivations ? new OneToManyMap() : null;
    }

    public Iterator getDerivation(Triple t) {
        if (this.derivations == null) {
            return new NullIterator();
        }
        return this.derivations.getAll(t);
    }

    public void setTraceOn(boolean state) {
        this.engine.setTraceOn(state);
    }

    public boolean isTraceOn() {
        return this.engine.isTraceOn();
    }

    public void logDerivation(Triple t, Object derivation) {
        this.derivations.put(t, derivation);
    }

    public ExtendedIterator findDataMatches(TriplePattern pattern) {
        return this.dataFind.find(pattern);
    }

    public boolean processBuiltin(ClauseEntry clause, Rule rule, BindingEnvironment env) {
        throw new ReasonerException("Internal error in FBLP rule engine, incorrect invocation of building in rule " + rule);
    }

    public void silentAdd(Triple t) {
        this.fdeductions.getGraph().add(t);
    }

    public Node getTemp(Node instance, Node prop, Node pclass) {
        return this.tempNodecache.getTemp(instance, prop, pclass);
    }

    protected void extractAxioms() {
        Graph axioms = this.fdeductions.getGraph();
        BBRuleContext contextForBuiltins = null;
        Iterator i = this.engine.getRuleStore().getAllRules().iterator();
        while (i.hasNext()) {
            Rule rule = (Rule)i.next();
            if (rule.bodyLength() != 0) continue;
            for (int j = 0; j < rule.headLength(); ++j) {
                Functor f;
                Builtin implementation;
                ClauseEntry axiom = rule.getHeadElement(j);
                if (axiom instanceof TriplePattern) {
                    axioms.add(((TriplePattern)axiom).asTriple());
                    continue;
                }
                if (!(axiom instanceof Functor)) continue;
                if (contextForBuiltins == null) {
                    contextForBuiltins = new BBRuleContext(this);
                }
                if ((implementation = (f = (Functor)axiom).getImplementor()) == null) {
                    throw new ReasonerException("Attempted to invoke undefined functor: " + f);
                }
                Node[] args = f.getArgs();
                contextForBuiltins.setEnv(new BindingVector(args));
                contextForBuiltins.setRule(rule);
                implementation.headAction(args, args.length, contextForBuiltins);
            }
        }
    }
}

