/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.iterator;

import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.FilterDropIterator;
import com.hp.hpl.jena.util.iterator.FilterKeepIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.Map1Iterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class NiceIterator
implements ExtendedIterator {
    private static final NiceIterator emptyInstance = new NiceIterator();

    public void close() {
    }

    public boolean hasNext() {
        return false;
    }

    protected void ensureHasNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
    }

    public Object next() {
        return this.noElements("empty NiceIterator");
    }

    protected Object noElements(String message) {
        throw new NoSuchElementException(message);
    }

    public void remove() {
        throw new UnsupportedOperationException("remove not supported for this iterator");
    }

    public Object removeNext() {
        Object result = this.next();
        this.remove();
        return result;
    }

    public static ExtendedIterator andThen(final Iterator a, Iterator b) {
        final ArrayList<Iterator> L = new ArrayList<Iterator>(2);
        L.add(b);
        return new NiceIterator(){
            private int index = 0;
            private Iterator current = a;

            public boolean hasNext() {
                while (!this.current.hasNext() && this.index < L.size()) {
                    this.current = (Iterator)L.get(this.index++);
                }
                return this.current.hasNext();
            }

            public Object next() {
                return this.hasNext() ? this.current.next() : this.noElements("concatenation");
            }

            public void close() {
                1.close(this.current);
                for (int i = this.index; i < L.size(); ++i) {
                    1.close((Iterator)L.get(i));
                }
            }

            public void remove() {
                this.current.remove();
            }

            public ExtendedIterator andThen(ClosableIterator other) {
                L.add(other);
                return this;
            }
        };
    }

    public ExtendedIterator andThen(ClosableIterator other) {
        return NiceIterator.andThen(this, other);
    }

    public ExtendedIterator filterKeep(Filter f) {
        return new FilterKeepIterator(f, this);
    }

    public ExtendedIterator filterDrop(Filter f) {
        return new FilterDropIterator(f, this);
    }

    public ExtendedIterator mapWith(Map1 map1) {
        return new Map1Iterator(map1, this);
    }

    public static void close(Iterator it) {
        if (it instanceof ClosableIterator) {
            ((ClosableIterator)it).close();
        }
    }

    public static ExtendedIterator emptyIterator() {
        return emptyInstance;
    }
}

