/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.impl.ICUData;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.VersionInfo;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ICUResourceBundleReader
implements ICUBinary.Authenticate {
    private static final byte[] DATA_FORMAT_ID = new byte[]{82, 101, 115, 66};
    private static final String ICU_RESOURCE_SUFFIX = ".res";
    private static final int URES_INDEX_LENGTH = 0;
    private static final int URES_INDEX_STRINGS_TOP = 1;
    private static final int URES_INDEX_RESOURCES_TOP = 2;
    private static final int URES_INDEX_BUNDLE_TOP = 3;
    private static final int URES_INDEX_MAX_TABLE_LENGTH = 4;
    private static final int URES_INDEX_ATTRIBUTES = 5;
    private static final int URES_INDEX_TOP = 6;
    private static final int URES_ATT_NO_FALLBACK = 1;
    private static final boolean DEBUG = false;
    private byte[] dataVersion;
    private int rootRes;
    private int[] indexes;
    private boolean noFallback;
    private byte[] data;

    private ICUResourceBundleReader(InputStream stream, String resolvedName) {
        BufferedInputStream bs = new BufferedInputStream(stream);
        try {
            this.dataVersion = ICUBinary.readHeader(bs, DATA_FORMAT_ID, this);
            this.readData(bs);
            stream.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Data file " + resolvedName + " is corrupt.", ex);
        }
    }

    public static ICUResourceBundleReader getReader(String baseName, String localeName, ClassLoader root) {
        String resolvedName = ICUResourceBundleReader.getFullName(baseName, localeName);
        InputStream stream = ICUData.getStream(root, resolvedName);
        if (stream == null) {
            return null;
        }
        ICUResourceBundleReader reader = new ICUResourceBundleReader(stream, resolvedName);
        return reader;
    }

    private static void writeInt(int i, byte[] bytes, int offset) {
        bytes[offset++] = (byte)(i >> 24);
        bytes[offset++] = (byte)(i >> 16);
        bytes[offset++] = (byte)(i >> 8);
        bytes[offset] = (byte)i;
    }

    private void readData(InputStream stream) throws IOException {
        DataInputStream ds = new DataInputStream(stream);
        this.rootRes = ds.readInt();
        int indexLength = ds.readInt();
        ds.mark((indexLength - 1) * 4);
        this.indexes = new int[indexLength];
        this.indexes[0] = indexLength;
        int i = 1;
        while (i < indexLength) {
            this.indexes[i] = ds.readInt();
            ++i;
        }
        this.noFallback = indexLength > 5 && (this.indexes[5] & 1) != 0;
        int length = this.indexes[3] * 4;
        this.data = new byte[length];
        ICUResourceBundleReader.writeInt(this.rootRes, this.data, 0);
        ICUResourceBundleReader.writeInt(indexLength, this.data, 4);
        ds.reset();
        ds.readFully(this.data, 8, length - 8);
    }

    public static String getFullName(String baseName, String localeName) {
        if (baseName == null || baseName.length() == 0) {
            if (localeName.length() == 0) {
                return String.valueOf(ULocale.getDefault().toString()) + ICU_RESOURCE_SUFFIX;
            }
            return String.valueOf(localeName) + ICU_RESOURCE_SUFFIX;
        }
        if (baseName.indexOf(46) == -1) {
            if (baseName.charAt(baseName.length() - 1) != '/') {
                return String.valueOf(baseName) + "/" + localeName + ICU_RESOURCE_SUFFIX;
            }
            return String.valueOf(baseName) + localeName + ICU_RESOURCE_SUFFIX;
        }
        baseName = baseName.replace('.', '/');
        if (localeName.length() == 0) {
            return String.valueOf(baseName) + ICU_RESOURCE_SUFFIX;
        }
        return String.valueOf(baseName) + "_" + localeName + ICU_RESOURCE_SUFFIX;
    }

    public VersionInfo getVersion() {
        return VersionInfo.getInstance(this.dataVersion[0], this.dataVersion[1], this.dataVersion[2], this.dataVersion[3]);
    }

    public boolean isDataVersionAcceptable(byte[] version2) {
        return version2[0] == 1 && version2[1] >= 1;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getRootResource() {
        return this.rootRes;
    }

    public boolean getNoFallback() {
        return this.noFallback;
    }
}

