/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.client.cache;

import com.ibm.lsid.LSID;
import com.ibm.lsid.client.LSIDAuthority;
import com.ibm.lsid.client.cache.LSIDCache;
import com.ibm.lsid.client.cache.LSIDCacheException;
import com.ibm.lsid.client.cache.LSIDCachingInputStreamListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class LSIDCachingInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 1024;
    private InputStream objectData;
    private OutputStream cacheOut;
    private File cacheFile;
    private File tempFile;
    private LSID lsid;
    private LSIDAuthority authority;
    private LSIDCachingInputStreamListener listener;
    private LSIDCache lsidCache;
    private boolean closed = false;

    public LSIDCachingInputStream(InputStream objectData, File cacheFile, LSIDAuthority authority, LSID lsid) throws LSIDCacheException {
        this.objectData = objectData;
        this.cacheFile = cacheFile;
        this.authority = authority;
        this.lsid = lsid;
        cacheFile.getParentFile().mkdirs();
        this.lsidCache = LSIDCache.getSingletonInstance();
        if (this.lsidCache == null) {
            throw new LSIDCacheException("Error opening Data cache");
        }
        File cacheDir = new File(LSIDCache.getLocation(), "/temp/");
        cacheDir.mkdirs();
        try {
            this.tempFile = File.createTempFile("cache", "tmp", cacheDir);
            this.cacheOut = new BufferedOutputStream(new FileOutputStream(this.tempFile), 1024);
        }
        catch (IOException e) {
            throw new LSIDCacheException("Error opening temporary cache file");
        }
    }

    /*
     * Loose catch block
     */
    public void close() throws IOException {
        block23: {
            if (this.closed) {
                return;
            }
            this.closed = true;
            byte[] buffer = new byte[1024];
            int numbytes = this.objectData.read(buffer);
            while (numbytes != -1) {
                this.cacheOut.write(buffer, 0, numbytes);
                numbytes = this.objectData.read(buffer);
            }
            this.cacheOut.flush();
            this.cacheOut.close();
            this.listener.inputStreamClosed(this.authority, this.lsid);
            if (this.cacheFile.exists()) {
                this.cacheFile.delete();
            }
            this.tempFile.renameTo(this.cacheFile);
            this.tempFile.delete();
            Object var4_4 = null;
            try {
                if (this.cacheOut != null) {
                    this.cacheOut.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (this.objectData != null) {
                    this.objectData.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                super.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            break block23;
            {
                catch (IOException e) {
                    if (this.tempFile != null) {
                        this.tempFile.delete();
                    }
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                try {
                    if (this.cacheOut != null) {
                        this.cacheOut.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (this.objectData != null) {
                        this.objectData.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    super.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
        try {
            int b = this.objectData.read();
            if (b == -1) {
                this.cacheOut.flush();
            } else {
                this.cacheOut.write(b);
            }
            return b;
        }
        catch (IOException e) {
            if (this.tempFile != null) {
                this.tempFile.delete();
            }
            throw e;
        }
    }

    public int read(byte[] bytes, int offset, int length) throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
        try {
            int numbytes = this.objectData.read(bytes, offset, length);
            if (numbytes != -1) {
                this.cacheOut.write(bytes, offset, numbytes);
            }
            return numbytes;
        }
        catch (IOException e) {
            if (this.tempFile != null) {
                this.tempFile.delete();
            }
            throw e;
        }
    }

    public int read(byte[] bytes) throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
        return this.read(bytes, 0, bytes.length);
    }

    public void setInputStreamListener(LSIDCachingInputStreamListener listener) {
        this.listener = listener;
    }
}

