/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.client.metadata.rdf.xslt;

import com.ibm.lsid.LSID;
import com.ibm.lsid.MalformedLSIDException;
import com.ibm.lsid.MetadataResponse;
import com.ibm.lsid.client.LSIDAuthority;
import com.ibm.lsid.client.metadata.LSIDMetadata;
import com.ibm.lsid.client.metadata.LSIDMetadataException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XSLTMetadata
implements LSIDMetadata {
    private static final String RDF_STYLE_SHEET = "rdf-canonicalize.xsl";
    private static final String RDF_NS_URI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String I3CP_NS_URI = "urn:lsid:i3c.org:predicates:";
    private static final String DC_NS_URI = "http://purl.org/dc/elements/1.1/";
    private static final String RDF_PREFIX = "rdf";
    private static final String I3CP_PREFIX = "i3cp";
    private static final String DC_PREFIX = "dc";
    private static final String RDF_DOCS_ELT = "RDF-DOCS";
    private static final String RDF_ELT = "RDF";
    private static final String DESCRIPTION_ELT = "Description";
    private static final String EXPIRES_ATTR = "expires";
    private static final String PATH_TO_DESCRIPTION = "rdf:RDF/rdf:Description";
    private TransformerFactory factory = TransformerFactory.newInstance();
    private Document doc;
    private Element rdfDocs;
    private Element envNS;

    void init() throws LSIDMetadataException {
        try {
            DocumentBuilder builder = new DocumentBuilderFactoryImpl().newDocumentBuilder();
            this.doc = builder.newDocument();
            this.rdfDocs = this.doc.createElement(RDF_DOCS_ELT);
            this.doc.appendChild(this.rdfDocs);
        }
        catch (ParserConfigurationException e) {
            throw new LSIDMetadataException(e, "Internal error preparing rdf store");
        }
        this.envNS = this.doc.createElement("nsmappings");
        this.envNS.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:rdf", RDF_NS_URI);
        this.envNS.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:i3cp", I3CP_NS_URI);
        this.envNS.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:dc", DC_NS_URI);
    }

    public Document getDocument() {
        return this.doc;
    }

    /*
     * Loose catch block
     */
    public void addMetadata(MetadataResponse metadata) throws LSIDMetadataException {
        byte[] result;
        block12: {
            result = null;
            InputStream in = null;
            in = metadata.getMetadata();
            InputStream styleSheet = this.getClass().getResourceAsStream(RDF_STYLE_SHEET);
            Transformer transformer = this.factory.newTransformer(new StreamSource(styleSheet));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            transformer.transform(new StreamSource(in), new StreamResult(out));
            result = out.toByteArray();
            Object var8_9 = null;
            try {
                if (in != null) {
                    in.close();
                }
                break block12;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            break block12;
            {
                catch (TransformerException e) {
                    throw new LSIDMetadataException(e, "Error applying transform to RDF");
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
        }
        try {
            DOMParser parser2 = new DOMParser();
            parser2.parse(new InputSource(new ByteArrayInputStream(result)));
            Document formattedDoc = parser2.getDocument();
            Element root = (Element)formattedDoc.getFirstChild();
            Element improot = (Element)this.doc.importNode(root, true);
            this.rdfDocs.appendChild(improot);
            Date expiration = metadata.getExpires();
            if (expiration != null) {
                improot.setAttribute(EXPIRES_ATTR, String.valueOf(expiration.getTime()));
            }
        }
        catch (Exception e) {
            throw new LSIDMetadataException(e, "Error parsing formatted RDF");
        }
    }

    public LSID getAbstract(LSID lsid) throws LSIDMetadataException {
        try {
            String xpathStr = "rdf:RDF/rdf:Description/i3cp:storedas[@rdf:resource=\"" + lsid + "\"]/parent::node()/@rdf:about";
            Attr node = (Attr)XPathAPI.selectSingleNode(this.rdfDocs, xpathStr, this.envNS);
            if (node == null) {
                return null;
            }
            LSID newlsid = new LSID(node.getNodeValue());
            lsid.setAbstr(newlsid);
            return newlsid;
        }
        catch (TransformerException e) {
            throw new LSIDMetadataException(e, "Error doing Xpath for getAbstract()");
        }
        catch (MalformedLSIDException e) {
            throw new LSIDMetadataException(e, "bad lsid in meta data, getAbstract()");
        }
    }

    public String getFormat(LSID lsid) throws LSIDMetadataException {
        try {
            String xpathStr = "rdf:RDF/rdf:Description[@rdf:about=\"" + lsid + "\"]" + "/dc:format/@rdf:resource";
            Attr node = (Attr)XPathAPI.selectSingleNode(this.rdfDocs, xpathStr, this.envNS);
            if (node == null) {
                return null;
            }
            String format = node.getNodeValue();
            lsid.setFormat(format);
            return format;
        }
        catch (TransformerException e) {
            throw new LSIDMetadataException(e, "Error doing Xpath for getFormat()");
        }
    }

    public LSID[] getInstances(LSID lsid) throws LSIDMetadataException {
        try {
            String xpathStr = "rdf:RDF/rdf:Description[@rdf:about=\"" + lsid + "\"]" + "/i3cp:storedas/@rdf:resource";
            NodeList attrs = XPathAPI.selectNodeList(this.rdfDocs, xpathStr, this.envNS);
            if (attrs == null) {
                return null;
            }
            LSID[] instances = new LSID[attrs.getLength()];
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                LSID newlsid = new LSID(attr.getNodeValue());
                this.getFormat(newlsid);
                newlsid.setAbstr(lsid);
                instances[i] = newlsid;
            }
            return instances;
        }
        catch (TransformerException e) {
            throw new LSIDMetadataException(e, "Error doing Xpath for getInstances()");
        }
        catch (MalformedLSIDException e) {
            throw new LSIDMetadataException(e, "bad lsid in meta data, getInstances()");
        }
    }

    public String getType(LSID lsid) throws LSIDMetadataException {
        try {
            String xpathStr = "rdf:RDF/rdf:Description[@rdf:about=\"" + lsid + "\"]" + "/rdf:type/@rdf:resource";
            Attr node = (Attr)XPathAPI.selectSingleNode(this.rdfDocs, xpathStr, this.envNS);
            if (node == null) {
                return null;
            }
            String type = node.getNodeValue();
            lsid.setType(type);
            return type;
        }
        catch (TransformerException e) {
            throw new LSIDMetadataException(e, "Error doing Xpath for getType()");
        }
    }

    public LSIDAuthority[] getForeignAuthorities(LSID lsid) throws LSIDMetadataException {
        try {
            String xpathStr = "rdf:RDF/rdf:Description[@rdf:about=\"" + lsid + "\"]" + "/i3cp:foreignauthority/child::text()";
            NodeList nodes = XPathAPI.selectNodeList(this.rdfDocs, xpathStr, this.envNS);
            if (nodes == null) {
                return null;
            }
            LSIDAuthority[] auths = new LSIDAuthority[nodes.getLength()];
            for (int i = 0; i < nodes.getLength(); ++i) {
                String nodeStr = nodes.item(i).getNodeValue();
                auths[i] = new LSIDAuthority(nodeStr);
            }
            return auths;
        }
        catch (TransformerException e) {
            throw new LSIDMetadataException(e, "Error doing Xpath for getInstances()");
        }
        catch (MalformedLSIDException e) {
            throw new LSIDMetadataException(e, "bad lsid in meta data, getInstances()");
        }
    }
}

