/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.wsdl;

import com.ibm.lsid.LSID;
import com.ibm.lsid.LSIDCredentials;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.client.LSIDResolver;
import com.ibm.lsid.client.conf.castor.ImportMapChoice;
import com.ibm.lsid.wsdl.DefaultLSIDPort;
import com.ibm.lsid.wsdl.LSIDAuthorityPort;
import com.ibm.lsid.wsdl.LSIDDataPort;
import com.ibm.lsid.wsdl.LSIDMetadataPort;
import com.ibm.lsid.wsdl.LSIDPort;
import com.ibm.lsid.wsdl.LSIDPortFactory;
import com.ibm.lsid.wsdl.LSIDStandardPort;
import com.ibm.lsid.wsdl.WSDLConstants;
import com.ibm.wsdl.DefinitionImpl;
import com.ibm.wsdl.extensions.PopulatedExtensionRegistry;
import com.ibm.wsdl.extensions.file.FileBinding;
import com.ibm.wsdl.extensions.file.FileBindingSerializer;
import com.ibm.wsdl.extensions.file.FileLocation;
import com.ibm.wsdl.extensions.file.FileLocationImpl;
import com.ibm.wsdl.extensions.file.FileLocationSerializer;
import com.ibm.wsdl.extensions.file.FileOperation;
import com.ibm.wsdl.extensions.file.FileOperationSerializer;
import com.ibm.wsdl.extensions.file.FileOutput;
import com.ibm.wsdl.extensions.file.FileOutputSerializer;
import com.ibm.wsdl.extensions.ftp.FTPBinding;
import com.ibm.wsdl.extensions.ftp.FTPBindingSerializer;
import com.ibm.wsdl.extensions.ftp.FTPLocation;
import com.ibm.wsdl.extensions.ftp.FTPLocationImpl;
import com.ibm.wsdl.extensions.ftp.FTPLocationSerializer;
import com.ibm.wsdl.extensions.ftp.FTPOperation;
import com.ibm.wsdl.extensions.ftp.FTPOperationSerializer;
import com.ibm.wsdl.extensions.ftp.FTPOutput;
import com.ibm.wsdl.extensions.ftp.FTPOutputSerializer;
import com.ibm.wsdl.extensions.http.HTTPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.factory.WSDLFactoryImpl;
import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.xml.WSDLReaderImpl;
import com.ibm.wsdl.xml.WSDLWriterImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.xml.sax.InputSource;

public class LSIDWSDLWrapper
implements WSDLConstants {
    private static final HashMap IMPORT_MAPS = new HashMap();
    private String wsdlStr = null;
    private Definition wsdlDef;
    private Hashtable lsidMetadataPorts = new Hashtable();
    private Hashtable lsidDataPorts = new Hashtable();
    private Hashtable lsidAuthorityPorts = new Hashtable();
    private Hashtable wsdlExtensionPorts = new Hashtable();
    private Date expiration;
    private int currPortNum = 1;
    private int currBindingNum = 1;
    static /* synthetic */ Class class$javax$wsdl$Port;
    static /* synthetic */ Class class$javax$wsdl$BindingOutput;
    static /* synthetic */ Class class$javax$wsdl$BindingOperation;
    static /* synthetic */ Class class$javax$wsdl$Binding;

    public LSIDWSDLWrapper(LSID lsid) throws LSIDException {
        this.wsdlDef = new DefinitionImpl();
        this.wsdlDef.setExtensionRegistry(new PopulatedExtensionRegistry());
        String tns = LSIDWSDLWrapper.getTargetNamespace(lsid);
        this.wsdlDef.setTargetNamespace(tns);
        this.wsdlDef.addNamespace("tns", tns);
    }

    public LSIDWSDLWrapper(String wsdl) throws LSIDException {
        this.wsdlStr = wsdl;
        try {
            WSDLReader reader = WSDLFactoryImpl.newInstance().newWSDLReader();
            reader.setExtensionRegistry(new PopulatedExtensionRegistry());
            ExtensionRegistry reg = reader.getExtensionRegistry();
            LSIDWSDLWrapper.registerFTP(reg);
            LSIDWSDLWrapper.registerFile(reg);
            LSIDWSDLLocator locator = new LSIDWSDLLocator(wsdl);
            this.wsdlDef = reader.readWSDL(locator);
        }
        catch (WSDLException e) {
            throw new LSIDException(e, "Error reading wsdl file into wsdl4j");
        }
        this.extractPorts();
    }

    public LSIDWSDLWrapper(InputStream wsdl) throws LSIDException {
        try {
            WSDLReader reader = WSDLFactoryImpl.newInstance().newWSDLReader();
            reader.setExtensionRegistry(new PopulatedExtensionRegistry());
            ExtensionRegistry reg = reader.getExtensionRegistry();
            LSIDWSDLWrapper.registerFTP(reg);
            LSIDWSDLWrapper.registerFile(reg);
            LSIDWSDLLocator locator = new LSIDWSDLLocator(wsdl);
            this.wsdlDef = reader.readWSDL(locator);
        }
        catch (WSDLException e) {
            throw new LSIDException(e, "Error reading wsdl file into wsdl4j");
        }
        this.extractPorts();
    }

    public String getWSDL() {
        try {
            if (this.wsdlStr == null) {
                this.updateStringRepresentation();
            }
        }
        catch (LSIDException e) {
            e.printStackTrace();
            return null;
        }
        return this.wsdlStr;
    }

    public String toString() {
        return this.getWSDL();
    }

    public Definition getDefinition() {
        this.wsdlStr = null;
        return this.wsdlDef;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    public void setDataLocation(LSIDDataPort dataPort) throws LSIDException {
        String portName;
        QName key;
        Map services;
        Service service;
        String serviceName = dataPort.getServiceName();
        if (serviceName == null) {
            serviceName = "LSIDService";
        }
        if ((service = (Service)(services = this.wsdlDef.getServices()).get(key = new QName(this.wsdlDef.getTargetNamespace(), serviceName))) == null) {
            service = this.wsdlDef.createService();
            service.setQName(key);
            this.wsdlDef.addService(service);
        }
        if ((portName = dataPort.getName()) != null) {
            Port port = service.getPort(portName);
            if (port != null) {
                this.wsdlDef.removeBinding(port.getBinding().getQName());
                service.getPorts().remove(portName);
            }
            this.lsidDataPorts.remove(this.getPortKey(dataPort));
        }
        String protocol = dataPort.getProtocol();
        this.configureDataServiceDef(dataPort.getProtocol());
        PortType dataPortType = this.wsdlDef.getPortType(new QName("http://www.omg.org/LSID/2003/Standard/WSDL", "LSIDDataServicePortType"));
        Binding binding = null;
        if (protocol.equals("soap")) {
            binding = this.wsdlDef.getBinding(WSDLConstants.DATA_SOAP_BINDING);
        } else if (protocol.equals("http")) {
            System.err.println(dataPort.getClass());
            System.err.println("path: " + dataPort.getPath());
            binding = dataPort.getPath().equals("urlEncoded") ? this.wsdlDef.getBinding(WSDLConstants.DATA_HTTP_BINDING) : this.wsdlDef.getBinding(WSDLConstants.DATA_HTTP_BINDING_DIRECT);
        } else if (protocol.equals("ftp")) {
            binding = this.wsdlDef.getBinding(WSDLConstants.DATA_FTP_BINDING);
        } else if (protocol.equals("file")) {
            binding = this.wsdlDef.getBinding(WSDLConstants.DATA_FILE_BINDING);
        }
        Port port = this.createPort(binding, dataPort);
        service.addPort(port);
        this.lsidDataPorts.put(this.getPortKey(dataPort), dataPort);
        this.wsdlStr = null;
    }

    public void setMetadataLocation(LSIDMetadataPort metadataPort) throws LSIDException {
        String portName;
        QName key;
        Map services;
        Service service;
        String serviceName = metadataPort.getServiceName();
        if (serviceName == null) {
            serviceName = "LSIDService";
        }
        if ((service = (Service)(services = this.wsdlDef.getServices()).get(key = new QName(this.wsdlDef.getTargetNamespace(), serviceName))) == null) {
            service = this.wsdlDef.createService();
            service.setQName(key);
            this.wsdlDef.addService(service);
        }
        if ((portName = metadataPort.getName()) != null) {
            Port port = service.getPort(portName);
            if (port != null) {
                this.wsdlDef.removeBinding(port.getBinding().getQName());
                service.getPorts().remove(portName);
            }
            this.lsidMetadataPorts.remove(this.getPortKey(metadataPort));
        }
        String protocol = metadataPort.getProtocol();
        this.configureDataServiceDef(metadataPort.getProtocol());
        PortType metadataPortType = this.wsdlDef.getPortType(new QName("http://www.omg.org/LSID/2003/Standard/WSDL", "LSIDMetadataServicePortType"));
        Binding binding = null;
        if (protocol.equals("soap")) {
            binding = this.wsdlDef.getBinding(WSDLConstants.METADATA_SOAP_BINDING);
        } else if (protocol.equals("http")) {
            binding = metadataPort.getPath().equals("urlEncoded") ? this.wsdlDef.getBinding(WSDLConstants.METADATA_HTTP_BINDING) : this.wsdlDef.getBinding(WSDLConstants.METADATA_HTTP_BINDING_DIRECT);
        } else if (protocol.equals("ftp")) {
            binding = this.wsdlDef.getBinding(WSDLConstants.METADATA_FTP_BINDING);
        } else if (protocol.equals("file")) {
            binding = this.wsdlDef.getBinding(WSDLConstants.METADATA_FILE_BINDING);
        }
        Port port = this.createPort(binding, metadataPort);
        service.addPort(port);
        this.lsidMetadataPorts.put(this.getPortKey(metadataPort), metadataPort);
        this.wsdlStr = null;
    }

    public void setAuthorityLocation(LSIDAuthorityPort authorityPort) throws LSIDException {
        String portName;
        QName key;
        Map services;
        Service service;
        String serviceName = authorityPort.getServiceName();
        if (serviceName == null) {
            serviceName = "LSIDService";
        }
        if ((service = (Service)(services = this.wsdlDef.getServices()).get(key = new QName(this.wsdlDef.getTargetNamespace(), serviceName))) == null) {
            service = this.wsdlDef.createService();
            service.setQName(key);
            this.wsdlDef.addService(service);
        }
        if ((portName = authorityPort.getName()) != null) {
            Port port = service.getPort(portName);
            if (port != null) {
                this.wsdlDef.removeBinding(port.getBinding().getQName());
                service.getPorts().remove(portName);
            }
            this.lsidAuthorityPorts.remove(this.getPortKey(authorityPort));
        }
        String protocol = authorityPort.getProtocol();
        this.configureAuthorityServiceDef(protocol);
        PortType authorityPortType = this.wsdlDef.getPortType(new QName("http://www.omg.org/LSID/2003/Standard/WSDL", "LSIDAuthorityServicePortType"));
        Binding binding = null;
        if (protocol.equals("soap")) {
            binding = this.wsdlDef.getBinding(WSDLConstants.AUTHORITY_SOAP_BINDING);
        } else if (protocol.equals("http")) {
            binding = this.wsdlDef.getBinding(WSDLConstants.AUTHORITY_HTTP_BINDING);
        }
        if (binding == null) {
            throw new LSIDException("Unsuported protocol for authority port: " + protocol);
        }
        Port authport = this.createPort(binding, authorityPort);
        service.addPort(authport);
        this.lsidAuthorityPorts.put(this.getPortKey(authorityPort), authorityPort);
        this.wsdlStr = null;
    }

    public Enumeration getServiceNames() {
        Map map = this.wsdlDef.getServices();
        Vector<String> names = new Vector<String>();
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            QName qname = (QName)it.next();
            names.add(qname.getLocalPart());
        }
        return names.elements();
    }

    public Enumeration getMetadataPortNames() {
        return this.lsidMetadataPorts.keys();
    }

    public Enumeration getMetadataPortNamesForService(String servicename) {
        Service service = this.wsdlDef.getService(new QName(this.wsdlDef.getTargetNamespace(), servicename));
        Map ports = service.getPorts();
        Vector<String> keys = new Vector<String>();
        Iterator it = ports.keySet().iterator();
        while (it.hasNext()) {
            String portname = (String)it.next();
            Port port = (Port)ports.get(portname);
            if (!port.getBinding().getPortType().getQName().getLocalPart().equals("LSIDMetadataServicePortType")) continue;
            keys.add(servicename + ":" + portname);
        }
        return keys.elements();
    }

    public Enumeration getMetadataPortNamesForProtocol(String protocol) {
        Vector<String> result = new Vector<String>();
        Enumeration portNames = this.lsidMetadataPorts.keys();
        while (portNames.hasMoreElements()) {
            String portName = (String)portNames.nextElement();
            LSIDMetadataPort lmdp = (LSIDMetadataPort)this.lsidMetadataPorts.get(portName);
            String prot = lmdp.getProtocol();
            if (prot == null || !prot.equals(protocol)) continue;
            result.add(portName);
        }
        return result.elements();
    }

    public LSIDMetadataPort getMetadataPort() {
        LSIDMetadataPort port = this.getMetadataPortForProtocol("http");
        if (port != null) {
            return port;
        }
        port = this.getMetadataPortForProtocol("ftp");
        if (port != null) {
            return port;
        }
        if (!this.lsidMetadataPorts.keys().hasMoreElements()) {
            return null;
        }
        return (LSIDMetadataPort)this.lsidMetadataPorts.get(this.lsidMetadataPorts.keys().nextElement());
    }

    public LSIDMetadataPort getMetadataPort(String name) {
        return (LSIDMetadataPort)this.lsidMetadataPorts.get(name);
    }

    public LSIDMetadataPort getMetadataPortForProtocol(String protocol) {
        Enumeration portNames = this.lsidMetadataPorts.keys();
        while (portNames.hasMoreElements()) {
            LSIDMetadataPort lmdp = (LSIDMetadataPort)this.lsidMetadataPorts.get(portNames.nextElement());
            String prot = lmdp.getProtocol();
            if (prot == null || !prot.equals(protocol)) continue;
            return lmdp;
        }
        return null;
    }

    public Enumeration getDataPortNames() {
        return this.lsidDataPorts.keys();
    }

    public Enumeration getDataPortNamesForProtocol(String protocol) {
        Vector<String> result = new Vector<String>();
        Enumeration portNames = this.lsidDataPorts.keys();
        while (portNames.hasMoreElements()) {
            String portName = (String)portNames.nextElement();
            LSIDDataPort ldp = (LSIDDataPort)this.lsidDataPorts.get(portName);
            if (!ldp.getProtocol().equals(protocol)) continue;
            result.add(portName);
        }
        return result.elements();
    }

    public LSIDDataPort getDataPort() {
        LSIDDataPort port = this.getDataPortForProtocol("http");
        if (port != null) {
            return port;
        }
        port = this.getDataPortForProtocol("ftp");
        if (port != null) {
            return port;
        }
        if (!this.lsidDataPorts.keys().hasMoreElements()) {
            return null;
        }
        return (LSIDDataPort)this.lsidDataPorts.get(this.lsidDataPorts.keys().nextElement());
    }

    public LSIDDataPort getDataPort(String name) {
        return (LSIDDataPort)this.lsidDataPorts.get(name);
    }

    public LSIDDataPort getDataPortForProtocol(String protocol) {
        Enumeration portNames = this.lsidDataPorts.keys();
        while (portNames.hasMoreElements()) {
            LSIDDataPort ldp = (LSIDDataPort)this.lsidDataPorts.get(portNames.nextElement());
            if (!ldp.getProtocol().equals(protocol)) continue;
            return ldp;
        }
        return null;
    }

    public Enumeration getAuthorityPortNames() {
        return this.lsidAuthorityPorts.keys();
    }

    public Enumeration getAuthorityPortNamesForProtocol(String protocol) {
        Vector<String> result = new Vector<String>();
        Enumeration portNames = this.lsidAuthorityPorts.keys();
        while (portNames.hasMoreElements()) {
            String portName = (String)portNames.nextElement();
            LSIDAuthorityPort lap = (LSIDAuthorityPort)this.lsidAuthorityPorts.get(portName);
            String prot = lap.getProtocol();
            if (prot == null || !prot.equals(protocol)) continue;
            result.add(portName);
        }
        return result.elements();
    }

    public LSIDAuthorityPort getAuthorityPort() {
        LSIDAuthorityPort port = this.getAuthorityPortForProtocol("http");
        if (port != null) {
            return port;
        }
        port = this.getAuthorityPortForProtocol("soap");
        if (port != null) {
            return port;
        }
        if (!this.lsidAuthorityPorts.keys().hasMoreElements()) {
            return null;
        }
        return (LSIDAuthorityPort)this.lsidAuthorityPorts.get(this.lsidAuthorityPorts.keys().nextElement());
    }

    public LSIDAuthorityPort getAuthorityPort(String name) {
        return (LSIDAuthorityPort)this.lsidAuthorityPorts.get(name);
    }

    public LSIDAuthorityPort getAuthorityPortForProtocol(String protocol) {
        Enumeration portNames = this.lsidAuthorityPorts.keys();
        while (portNames.hasMoreElements()) {
            LSIDAuthorityPort lap = (LSIDAuthorityPort)this.lsidAuthorityPorts.get(portNames.nextElement());
            String prot = lap.getProtocol();
            if (prot == null || !prot.equals(protocol)) continue;
            return lap;
        }
        return null;
    }

    public Enumeration getExtensionPortNames() {
        return this.wsdlExtensionPorts.keys();
    }

    public Enumeration getExtensionPortNamesByClass(Class portClass) {
        Enumeration keys = this.wsdlExtensionPorts.keys();
        Vector<String> ret = new Vector<String>();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            LSIDPort port = (LSIDPort)this.wsdlExtensionPorts.get(key);
            if (!port.getClass().equals(portClass)) continue;
            ret.add(key);
        }
        return ret.elements();
    }

    public LSIDPort getExtensionPort(String name) {
        return (LSIDPort)this.wsdlExtensionPorts.get(name);
    }

    private void configureDataServiceDef(String protocol) throws LSIDException {
        if (protocol.equals("http")) {
            if (!this.wsdlDef.getNamespaces().containsValue("http://www.omg.org/LSID/2003/DataServiceHTTPBindings")) {
                this.importNamespace("dhb", "http://www.omg.org/LSID/2003/DataServiceHTTPBindings", "LSIDDataServiceHTTPBindings.wsdl");
            }
            if (!this.wsdlDef.getNamespaces().containsValue("http://schemas.xmlsoap.org/wsdl/http/")) {
                this.wsdlDef.addNamespace("http", "http://schemas.xmlsoap.org/wsdl/http/");
            }
        } else if (protocol.equals("ftp")) {
            if (!this.wsdlDef.getNamespaces().containsValue("http://www.omg.org/LSID/2003/DataServiceFTPBindings")) {
                this.importNamespace("dfb", "http://www.omg.org/LSID/2003/DataServiceFTPBindings", "LSIDDataServiceFTPBindings.wsdl");
            }
            if (!this.wsdlDef.getNamespaces().containsValue("http://www.ibm.com/wsdl/ftp/")) {
                this.wsdlDef.addNamespace("ftp", "http://www.ibm.com/wsdl/ftp/");
                ExtensionRegistry reg = this.wsdlDef.getExtensionRegistry();
                LSIDWSDLWrapper.registerFTP(reg);
            }
        } else if (protocol.equals("file")) {
            if (!this.wsdlDef.getNamespaces().containsValue("http://www.omg.org/LSID/2003/DataServiceFileBindings")) {
                this.importNamespace("dfb", "http://www.omg.org/LSID/2003/DataServiceFileBindings", "LSIDDataServiceFileBindings.wsdl");
            }
            if (!this.wsdlDef.getNamespaces().containsValue("http://www.ibm.com/wsdl/file/")) {
                this.wsdlDef.addNamespace("file", "http://www.ibm.com/wsdl/file/");
                ExtensionRegistry reg = this.wsdlDef.getExtensionRegistry();
                LSIDWSDLWrapper.registerFile(reg);
            }
        } else if (protocol.equals("soap")) {
            if (!this.wsdlDef.getNamespaces().containsValue("http://www.omg.org/LSID/2003/DataServiceSOAPBindings")) {
                this.importNamespace("dsb", "http://www.omg.org/LSID/2003/DataServiceSOAPBindings", "LSIDDataServiceSOAPBindings.wsdl");
            }
            if (!this.wsdlDef.getNamespaces().containsValue("http://schemas.xmlsoap.org/wsdl/soap/")) {
                this.wsdlDef.addNamespace("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
            }
        }
    }

    private void configureAuthorityServiceDef(String protocol) throws LSIDException {
        if (protocol.equals("http")) {
            if (!this.wsdlDef.getNamespaces().containsValue("http://www.omg.org/LSID/2003/AuthorityServiceHTTPBindings")) {
                this.importNamespace("ahb", "http://www.omg.org/LSID/2003/AuthorityServiceHTTPBindings", "LSIDAuthorityServiceHTTPBindings.wsdl");
            }
            if (!this.wsdlDef.getNamespaces().containsValue("http://schemas.xmlsoap.org/wsdl/http/")) {
                this.wsdlDef.addNamespace("http", "http://schemas.xmlsoap.org/wsdl/http/");
            }
        } else if (protocol.equals("soap")) {
            if (!this.wsdlDef.getNamespaces().containsValue("http://www.omg.org/LSID/2003/AuthorityServiceSOAPBindings")) {
                this.importNamespace("asb", "http://www.omg.org/LSID/2003/AuthorityServiceSOAPBindings", "LSIDAuthorityServiceSOAPBindings.wsdl");
            }
            if (!this.wsdlDef.getNamespaces().containsValue("http://schemas.xmlsoap.org/wsdl/soap/")) {
                this.wsdlDef.addNamespace("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
            }
        }
    }

    private void importNamespace(String prefix, String ns, String location) throws LSIDException {
        Definition importDef = null;
        try {
            WSDLReaderImpl reader = new WSDLReaderImpl();
            importDef = reader.readWSDL(new LSIDWSDLLocator(location));
        }
        catch (WSDLException e) {
            throw new LSIDException(e, "Error importing namespace: " + ns);
        }
        this.wsdlDef.addNamespace(prefix, ns);
        Import imp = this.wsdlDef.createImport();
        imp.setLocationURI(location);
        imp.setNamespaceURI(ns);
        imp.setDefinition(importDef);
        this.wsdlDef.addImport(imp);
    }

    private void updateStringRepresentation() throws LSIDException {
        StringWriter strWriter = new StringWriter();
        WSDLWriterImpl writer = new WSDLWriterImpl();
        try {
            writer.writeWSDL(this.wsdlDef, strWriter);
        }
        catch (WSDLException e) {
            throw new LSIDException(e, "Error writing WSDL def to string");
        }
        this.wsdlStr = strWriter.getBuffer().toString();
    }

    private void extractPorts() throws LSIDException {
        Map services = this.wsdlDef.getServices();
        Object[] serviceKeys = services.keySet().toArray();
        for (int j = 0; j < serviceKeys.length; ++j) {
            Service service = (Service)services.get(serviceKeys[j]);
            Map ports = service.getPorts();
            Object[] portKeys = ports.keySet().toArray();
            for (int i = 0; i < portKeys.length; ++i) {
                LSIDStandardPortImpl portImpl;
                Port port = (Port)ports.get(portKeys[i]);
                Binding binding = port.getBinding();
                PortType portType = binding.getPortType();
                QName qname = portType.getQName();
                if (qname.getLocalPart().equals("LSIDMetadataServicePortType") && qname.getNamespaceURI().equals("http://www.omg.org/LSID/2003/Standard/WSDL")) {
                    if (!(binding.getQName().equals(WSDLConstants.METADATA_SOAP_BINDING) || binding.getQName().equals(WSDLConstants.METADATA_HTTP_BINDING) || binding.getQName().equals(WSDLConstants.METADATA_FTP_BINDING) || binding.getQName().equals(WSDLConstants.METADATA_FILE_BINDING))) {
                        throw new LSIDException(711, "Unrecognized metadata binding: " + binding.getQName());
                    }
                    portImpl = this.extractPort(service, port, qname);
                    this.lsidMetadataPorts.put(portImpl.getKey(), portImpl);
                    continue;
                }
                if (qname.getLocalPart().equals("LSIDDataServicePortType") && qname.getNamespaceURI().equals("http://www.omg.org/LSID/2003/Standard/WSDL")) {
                    if (!(binding.getQName().equals(WSDLConstants.DATA_SOAP_BINDING) || binding.getQName().equals(WSDLConstants.DATA_HTTP_BINDING) || binding.getQName().equals(WSDLConstants.DATA_FTP_BINDING) || binding.getQName().equals(WSDLConstants.DATA_FILE_BINDING))) {
                        throw new LSIDException(711, "Unrecognized data binding: " + binding.getQName());
                    }
                    portImpl = this.extractPort(service, port, qname);
                    this.lsidDataPorts.put(portImpl.getKey(), portImpl);
                    continue;
                }
                if (qname.getLocalPart().equals("LSIDAuthorityServicePortType") && qname.getNamespaceURI().equals("http://www.omg.org/LSID/2003/Standard/WSDL")) {
                    if (!binding.getQName().equals(WSDLConstants.AUTHORITY_SOAP_BINDING) && !binding.getQName().equals(WSDLConstants.AUTHORITY_HTTP_BINDING)) {
                        throw new LSIDException(711, "Unrecognized authority binding: " + binding.getQName());
                    }
                    portImpl = this.extractPort(service, port, qname);
                    this.lsidAuthorityPorts.put(portImpl.getKey(), portImpl);
                    continue;
                }
                LSIDPortFactory lpf = LSIDResolver.getConfig().getLSIDPortFactory(portType);
                LSIDPort newPort = null;
                newPort = lpf == null ? new DefaultLSIDPort(service.getQName().getLocalPart(), port.getName(), port) : lpf.createPort(service.getQName().getLocalPart(), port);
                this.wsdlExtensionPorts.put(this.getPortKey(newPort), newPort);
            }
        }
    }

    private LSIDStandardPortImpl extractPort(Service service, Port port, QName portTypeName) throws LSIDException {
        String portName = port.getName();
        LSIDStandardPortImpl portImpl = new LSIDStandardPortImpl();
        portImpl.name = portName;
        portImpl.serviceName = service.getQName().getLocalPart();
        ListIterator portElts = port.getExtensibilityElements().listIterator();
        while (portElts.hasNext()) {
            Object portElt = portElts.next();
            if (portElt instanceof SOAPAddress) {
                SOAPAddress soapaddr = (SOAPAddress)portElt;
                portImpl.location = soapaddr.getLocationURI();
                portImpl.protocol = "soap";
                continue;
            }
            if (portElt instanceof HTTPAddress) {
                HTTPAddress httpaddr = (HTTPAddress)portElt;
                portImpl.location = httpaddr.getLocationURI();
                portImpl.protocol = "http";
                QName bindingName = port.getBinding().getQName();
                if (bindingName.equals(WSDLConstants.DATA_HTTP_BINDING_DIRECT)) {
                    portImpl.path = "direct";
                    continue;
                }
                portImpl.path = "urlEncoded";
                continue;
            }
            if (portElt instanceof FTPLocation) {
                FTPLocation ftploc = (FTPLocation)portElt;
                portImpl.location = ftploc.getServer();
                portImpl.path = ftploc.getFilePath();
                portImpl.protocol = "ftp";
                continue;
            }
            if (portElt instanceof FileLocation) {
                FileLocation fileloc = (FileLocation)portElt;
                portImpl.location = fileloc.getFilename();
                portImpl.protocol = "file";
                continue;
            }
            throw new LSIDException("Unknown Port impl");
        }
        return portImpl;
    }

    private Port createPort(Binding binding, LSIDStandardPort port) {
        Port newPort = this.wsdlDef.createPort();
        newPort.setBinding(binding);
        String portName = port.getName();
        String protocol = port.getProtocol();
        if (portName == null) {
            portName = this.newPortName(protocol);
        }
        newPort.setName(portName);
        if (protocol.equals("http")) {
            HTTPAddressImpl addr = new HTTPAddressImpl();
            addr.setLocationURI(port.getLocation());
            newPort.addExtensibilityElement(addr);
        } else if (protocol.equals("ftp")) {
            FTPLocationImpl loc = new FTPLocationImpl(port.getLocation(), port.getPath());
            newPort.addExtensibilityElement((ExtensibilityElement)loc);
        } else if (protocol.equals("file")) {
            FileLocationImpl loc = new FileLocationImpl(port.getLocation());
            newPort.addExtensibilityElement((ExtensibilityElement)loc);
        } else if (protocol.equals("soap")) {
            SOAPAddressImpl addr = new SOAPAddressImpl();
            addr.setLocationURI(port.getLocation());
            newPort.addExtensibilityElement(addr);
        }
        return newPort;
    }

    private synchronized String newPortName(String protocol) {
        return protocol + "Port" + String.valueOf(this.currPortNum++);
    }

    private static String getTargetNamespace(LSID lsid) {
        if (lsid == null) {
            return "http://www.omg.org/LSID/2003/Standard/WSDL";
        }
        return "http://" + lsid.getAuthority() + "/" + "availableServices?" + lsid.toString();
    }

    private String getPortKey(LSIDPort port) {
        return (port.getServiceName() != null ? port.getServiceName() : "LSIDService") + ":" + port.getName();
    }

    private static void registerFTP(ExtensionRegistry reg) {
        reg.registerDeserializer(class$javax$wsdl$Port == null ? (class$javax$wsdl$Port = LSIDWSDLWrapper.class$("javax.wsdl.Port")) : class$javax$wsdl$Port, FTPLocation.DEFAULT_ELEMENT_TYPE, (ExtensionDeserializer)new FTPLocationSerializer());
        reg.registerDeserializer(class$javax$wsdl$BindingOutput == null ? (class$javax$wsdl$BindingOutput = LSIDWSDLWrapper.class$("javax.wsdl.BindingOutput")) : class$javax$wsdl$BindingOutput, FTPOutput.DEFAULT_ELEMENT_TYPE, (ExtensionDeserializer)new FTPOutputSerializer());
        reg.registerDeserializer(class$javax$wsdl$BindingOperation == null ? (class$javax$wsdl$BindingOperation = LSIDWSDLWrapper.class$("javax.wsdl.BindingOperation")) : class$javax$wsdl$BindingOperation, FTPOperation.DEFAULT_ELEMENT_TYPE, (ExtensionDeserializer)new FTPOperationSerializer());
        reg.registerDeserializer(class$javax$wsdl$Binding == null ? (class$javax$wsdl$Binding = LSIDWSDLWrapper.class$("javax.wsdl.Binding")) : class$javax$wsdl$Binding, FTPBinding.DEFAULT_ELEMENT_TYPE, (ExtensionDeserializer)new FTPBindingSerializer());
        reg.registerSerializer(class$javax$wsdl$Port == null ? (class$javax$wsdl$Port = LSIDWSDLWrapper.class$("javax.wsdl.Port")) : class$javax$wsdl$Port, FTPLocation.DEFAULT_ELEMENT_TYPE, (ExtensionSerializer)new FTPLocationSerializer());
        reg.registerSerializer(class$javax$wsdl$BindingOutput == null ? (class$javax$wsdl$BindingOutput = LSIDWSDLWrapper.class$("javax.wsdl.BindingOutput")) : class$javax$wsdl$BindingOutput, FTPOutput.DEFAULT_ELEMENT_TYPE, (ExtensionSerializer)new FTPOutputSerializer());
        reg.registerSerializer(class$javax$wsdl$BindingOperation == null ? (class$javax$wsdl$BindingOperation = LSIDWSDLWrapper.class$("javax.wsdl.BindingOperation")) : class$javax$wsdl$BindingOperation, FTPOperation.DEFAULT_ELEMENT_TYPE, (ExtensionSerializer)new FTPOperationSerializer());
        reg.registerSerializer(class$javax$wsdl$Binding == null ? (class$javax$wsdl$Binding = LSIDWSDLWrapper.class$("javax.wsdl.Binding")) : class$javax$wsdl$Binding, FTPBinding.DEFAULT_ELEMENT_TYPE, (ExtensionSerializer)new FTPBindingSerializer());
    }

    private static void registerFile(ExtensionRegistry reg) {
        reg.registerDeserializer(class$javax$wsdl$Port == null ? (class$javax$wsdl$Port = LSIDWSDLWrapper.class$("javax.wsdl.Port")) : class$javax$wsdl$Port, FileLocation.DEFAULT_ELEMENT_TYPE, (ExtensionDeserializer)new FileLocationSerializer());
        reg.registerDeserializer(class$javax$wsdl$BindingOutput == null ? (class$javax$wsdl$BindingOutput = LSIDWSDLWrapper.class$("javax.wsdl.BindingOutput")) : class$javax$wsdl$BindingOutput, FileOutput.DEFAULT_ELEMENT_TYPE, (ExtensionDeserializer)new FileOutputSerializer());
        reg.registerDeserializer(class$javax$wsdl$BindingOperation == null ? (class$javax$wsdl$BindingOperation = LSIDWSDLWrapper.class$("javax.wsdl.BindingOperation")) : class$javax$wsdl$BindingOperation, FileOperation.DEFAULT_ELEMENT_TYPE, (ExtensionDeserializer)new FileOperationSerializer());
        reg.registerDeserializer(class$javax$wsdl$Binding == null ? (class$javax$wsdl$Binding = LSIDWSDLWrapper.class$("javax.wsdl.Binding")) : class$javax$wsdl$Binding, FileBinding.DEFAULT_ELEMENT_TYPE, (ExtensionDeserializer)new FileBindingSerializer());
        reg.registerSerializer(class$javax$wsdl$Port == null ? (class$javax$wsdl$Port = LSIDWSDLWrapper.class$("javax.wsdl.Port")) : class$javax$wsdl$Port, FileLocation.DEFAULT_ELEMENT_TYPE, (ExtensionSerializer)new FileLocationSerializer());
        reg.registerSerializer(class$javax$wsdl$BindingOutput == null ? (class$javax$wsdl$BindingOutput = LSIDWSDLWrapper.class$("javax.wsdl.BindingOutput")) : class$javax$wsdl$BindingOutput, FileOutput.DEFAULT_ELEMENT_TYPE, (ExtensionSerializer)new FileOutputSerializer());
        reg.registerSerializer(class$javax$wsdl$BindingOperation == null ? (class$javax$wsdl$BindingOperation = LSIDWSDLWrapper.class$("javax.wsdl.BindingOperation")) : class$javax$wsdl$BindingOperation, FileOperation.DEFAULT_ELEMENT_TYPE, (ExtensionSerializer)new FileOperationSerializer());
        reg.registerSerializer(class$javax$wsdl$Binding == null ? (class$javax$wsdl$Binding = LSIDWSDLWrapper.class$("javax.wsdl.Binding")) : class$javax$wsdl$Binding, FileBinding.DEFAULT_ELEMENT_TYPE, (ExtensionSerializer)new FileBindingSerializer());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        IMPORT_MAPS.put("LSIDPortTypes.wsdl", "LSIDPortTypes.wsdl");
        IMPORT_MAPS.put("LSIDDataServiceSOAPBindings.wsdl", "LSIDDataServiceSOAPBindings.wsdl");
        IMPORT_MAPS.put("LSIDDataServiceHTTPBindings.wsdl", "LSIDDataServiceHTTPBindings.wsdl");
        IMPORT_MAPS.put("LSIDDataServiceFTPBindings.wsdl", "LSIDDataServiceFTPBindings.wsdl");
        IMPORT_MAPS.put("LSIDDataServiceFileBindings.wsdl", "LSIDDataServiceFileBindings.wsdl");
        IMPORT_MAPS.put("LSIDAuthorityServiceSOAPBindings.wsdl", "LSIDAuthorityServiceSOAPBindings.wsdl");
        IMPORT_MAPS.put("LSIDAuthorityServiceHTTPBindings.wsdl", "LSIDAuthorityServiceHTTPBindings.wsdl");
    }

    class LSIDStandardPortImpl
    implements LSIDDataPort,
    LSIDMetadataPort,
    LSIDAuthorityPort {
        private String name = null;
        private String serviceName = null;
        private String location;
        private String protocol;
        private String path;
        private LSIDCredentials lsidCredentials = null;
        private Map headers = new HashMap();

        LSIDStandardPortImpl() {
        }

        public void addProtocolHeader(String name, String value) {
            this.headers.put(name, value);
        }

        public Map getProtocolHeaders() {
            return this.headers;
        }

        public LSIDCredentials getLsidCredentials() {
            LSIDCredentials portCreds;
            if (this.lsidCredentials == null && (portCreds = new LSIDCredentials(this)).keys().hasMoreElements()) {
                this.lsidCredentials = portCreds;
            }
            return this.lsidCredentials;
        }

        public void setLsidCredentials(LSIDCredentials lsidCredentials) {
            this.lsidCredentials = lsidCredentials;
        }

        public String getName() {
            return this.name;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPath() {
            return this.path;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getKey() {
            return this.serviceName + ":" + this.name;
        }
    }

    class LSIDWSDLLocator
    implements WSDLLocator {
        String wsdlStr = null;
        InputStream wsdlStream = null;
        String lastImportURI = null;

        LSIDWSDLLocator(InputStream wsdlStream) {
            this.wsdlStream = wsdlStream;
        }

        LSIDWSDLLocator(String wsdlStr) {
            this.wsdlStr = wsdlStr;
        }

        public Reader getBaseReader() {
            if (this.wsdlStream != null) {
                return new InputStreamReader(this.wsdlStream);
            }
            String res = (String)IMPORT_MAPS.get(this.wsdlStr);
            if (res != null) {
                InputStream resource = LSIDWSDLWrapper.this.getClass().getResourceAsStream(res);
                if (resource == null) {
                    System.err.println("Failed to load resource: " + resource);
                    return null;
                }
                return new InputStreamReader(resource);
            }
            return new StringReader(this.wsdlStr);
        }

        public String getBaseURI() {
            return "localhost";
        }

        public Reader getImportReader(String parentLocation, String relativeLocation) {
            this.lastImportURI = relativeLocation;
            String res = (String)IMPORT_MAPS.get(relativeLocation);
            if (res != null) {
                InputStream resource = LSIDWSDLWrapper.this.getClass().getResourceAsStream(res);
                if (resource == null) {
                    System.err.println("Failed to load resource: " + res);
                    return null;
                }
                return new InputStreamReader(resource);
            }
            ImportMapChoice imc = LSIDResolver.getConfig().getImportMap(relativeLocation);
            if (imc != null) {
                String resource = imc.getResource();
                if (resource != null) {
                    InputStream in = this.getClass().getResourceAsStream(resource);
                    if (in == null) {
                        System.err.println("Error loading custom import for " + relativeLocation);
                        return null;
                    }
                    return new InputStreamReader(in);
                }
                File file = new File(imc.getFile());
                if (file.exists()) {
                    System.err.println("Error loading custom import for " + relativeLocation);
                    return null;
                }
                try {
                    return new FileReader(file);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    System.err.println("Error loading custom import for " + relativeLocation + " from file: " + file);
                    return null;
                }
            }
            try {
                URL contextURL = parentLocation != null ? StringUtils.getURL(null, parentLocation) : null;
                URL url = StringUtils.getURL(contextURL, relativeLocation);
                return new InputStreamReader(url.openStream());
            }
            catch (Exception e) {
                System.err.println("Error loading import at: " + parentLocation + "|" + relativeLocation);
                e.printStackTrace();
                return null;
            }
        }

        public String getLatestImportURI() {
            return this.lastImportURI;
        }

        public InputSource getBaseInputSource() {
            return new InputSource(this.getBaseReader());
        }

        public InputSource getImportInputSource(String arg0, String arg1) {
            return new InputSource(this.getImportReader(arg0, arg1));
        }
    }
}

