/*
 * Decompiled with CFR 0.152.
 */
package com.simonstl.sax.xlink;

import com.simonstl.sax.xlink.Link;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class LinkSet {
    private TreeMap linksContainer = new TreeMap();

    public void addLink(Link link) {
        if (link != null) {
            String string = link.getFromNode().getURL().toString();
            if (this.linksContainer.containsKey(string)) {
                Object v = this.linksContainer.get(string);
                if (v instanceof Link) {
                    Vector<Link> vector = new Vector<Link>();
                    vector.add((Link)v);
                    vector.add(link);
                    this.linksContainer.remove(string);
                    this.linksContainer.put(string, vector);
                } else {
                    ((Vector)v).add(link);
                }
            } else {
                this.linksContainer.put(string, link);
            }
        }
    }

    public void addUniqueLink(Link link) {
        if (link != null) {
            String string = link.getFromNode().getURL().toString();
            if (this.linksContainer.containsKey(string)) {
                Object v = this.linksContainer.get(string);
                if (v instanceof Link) {
                    if (link.equalsAsLink((Link)v)) {
                        return;
                    }
                    Vector<Link> vector = new Vector<Link>();
                    vector.add((Link)v);
                    vector.add(link);
                    this.linksContainer.remove(string);
                    this.linksContainer.put(string, vector);
                } else {
                    Enumeration enumeration = ((Vector)v).elements();
                    while (enumeration.hasMoreElements()) {
                        if (!link.equalsAsLink((Link)enumeration.nextElement())) continue;
                        return;
                    }
                    ((Vector)v).add(link);
                }
            } else {
                this.linksContainer.put(string, link);
            }
        }
    }

    public boolean containsLink(Link link) {
        String string;
        if (link != null && this.linksContainer.containsKey(string = link.getFromNode().getURL().toString())) {
            Object v = this.linksContainer.get(string);
            if (v instanceof Link) {
                return link.equalsAsLink((Link)v);
            }
            Enumeration enumeration = ((Vector)v).elements();
            while (enumeration.hasMoreElements()) {
                if (!link.equalsAsLink((Link)enumeration.nextElement())) continue;
                return true;
            }
        }
        return false;
    }

    public LinkSet getByFromURLFile(URL uRL) {
        LinkSet linkSet = new LinkSet();
        Iterator iterator = this.getAllLinks();
        while (iterator.hasNext()) {
            Link link;
            Object e = iterator.next();
            if (e instanceof Link) {
                link = (Link)e;
                if (!link.getFromNode().getURL().sameFile(uRL)) continue;
                linkSet.addLink(link);
                continue;
            }
            Enumeration enumeration = ((Vector)e).elements();
            while (enumeration.hasMoreElements()) {
                link = (Link)enumeration.nextElement();
                if (!link.getFromNode().getURL().sameFile(uRL)) continue;
                linkSet.addLink(link);
            }
        }
        return linkSet;
    }

    public LinkSet getByFromURLFileFragment(String string) {
        LinkSet linkSet = new LinkSet();
        if (string != null && this.linksContainer.containsKey(string)) {
            Object v = this.linksContainer.get(string);
            if (v instanceof Link) {
                linkSet.addLink((Link)v);
            } else {
                Enumeration enumeration = ((Vector)v).elements();
                while (enumeration.hasMoreElements()) {
                    linkSet.addLink((Link)enumeration.nextElement());
                }
            }
        }
        return linkSet;
    }

    public LinkSet getByFromURLFileFragment_StartsWith(String string) {
        LinkSet linkSet = new LinkSet();
        SortedMap sortedMap = this.linksContainer.tailMap(string);
        if (sortedMap != null && !sortedMap.isEmpty()) {
            boolean bl = true;
            Iterator iterator = sortedMap.values().iterator();
            while (bl && iterator.hasNext()) {
                Link link;
                Object v = iterator.next();
                if (v instanceof Link) {
                    link = (Link)v;
                    if (link.getFromNode().getURL().toString().startsWith(string)) {
                        linkSet.addLink(link);
                        continue;
                    }
                    bl = false;
                    continue;
                }
                link = (Link)((Vector)v).firstElement();
                if (link.getFromNode().getURL().toString().startsWith(string)) {
                    Enumeration enumeration = ((Vector)v).elements();
                    while (enumeration.hasMoreElements()) {
                        linkSet.addLink((Link)enumeration.nextElement());
                    }
                    continue;
                }
                bl = false;
            }
        }
        return linkSet;
    }

    public LinkSet getByFromFragment(String string) {
        LinkSet linkSet = new LinkSet();
        if (string != null) {
            Iterator iterator = this.getAllLinks();
            while (iterator.hasNext()) {
                Link link;
                Object e = iterator.next();
                if (e instanceof Link) {
                    link = (Link)e;
                    if (!link.getFromNode().getURL().getRef().equals(string)) continue;
                    linkSet.addLink(link);
                    continue;
                }
                Enumeration enumeration = ((Vector)e).elements();
                while (enumeration.hasMoreElements()) {
                    link = (Link)enumeration.nextElement();
                    if (!link.getFromNode().getURL().getRef().equals(string)) continue;
                    linkSet.addLink(link);
                }
            }
        }
        return linkSet;
    }

    public LinkSet getByRole(String string) {
        LinkSet linkSet = new LinkSet();
        if (string != null) {
            Iterator iterator = this.getAllLinks();
            while (iterator.hasNext()) {
                Link link;
                Object e = iterator.next();
                if (e instanceof Link) {
                    link = (Link)e;
                    if (!link.getInfo().getLinkRole().equals(string)) continue;
                    linkSet.addLink(link);
                    continue;
                }
                Enumeration enumeration = ((Vector)e).elements();
                while (enumeration.hasMoreElements()) {
                    link = (Link)enumeration.nextElement();
                    if (!link.getInfo().getLinkRole().equals(string)) continue;
                    linkSet.addLink(link);
                }
            }
        }
        return linkSet;
    }

    public LinkSet getByFromFragmentStartsWith(String string) {
        LinkSet linkSet = new LinkSet();
        if (string != null) {
            Iterator iterator = this.getAllLinks();
            while (iterator.hasNext()) {
                Link link;
                Object e = iterator.next();
                if (e instanceof Link) {
                    link = (Link)e;
                    if (!link.getFromNode().getURL().getRef().startsWith(string)) continue;
                    linkSet.addLink(link);
                    continue;
                }
                Enumeration enumeration = ((Vector)e).elements();
                while (enumeration.hasMoreElements()) {
                    link = (Link)enumeration.nextElement();
                    if (!link.getFromNode().getURL().getRef().startsWith(string)) continue;
                    linkSet.addLink(link);
                }
            }
        }
        return linkSet;
    }

    public LinkSet getByShow(String string) {
        LinkSet linkSet = new LinkSet();
        if (string != null) {
            Iterator iterator = this.getAllLinks();
            while (iterator.hasNext()) {
                Link link;
                Object e = iterator.next();
                if (e instanceof Link) {
                    link = (Link)e;
                    if (!string.equals(link.getArc().getShow())) continue;
                    linkSet.addLink(link);
                    continue;
                }
                Enumeration enumeration = ((Vector)e).elements();
                while (enumeration.hasMoreElements()) {
                    link = (Link)enumeration.nextElement();
                    if (!string.equals(link.getArc().getShow())) continue;
                    linkSet.addLink(link);
                }
            }
        }
        return linkSet;
    }

    public LinkSet getByActuate(String string) {
        LinkSet linkSet = new LinkSet();
        if (string != null) {
            Iterator iterator = this.getAllLinks();
            while (iterator.hasNext()) {
                Link link;
                Object e = iterator.next();
                if (e instanceof Link) {
                    link = (Link)e;
                    if (!string.equals(link.getArc().getActuate())) continue;
                    linkSet.addLink(link);
                    continue;
                }
                Enumeration enumeration = ((Vector)e).elements();
                while (enumeration.hasMoreElements()) {
                    link = (Link)enumeration.nextElement();
                    if (!string.equals(link.getArc().getActuate())) continue;
                    linkSet.addLink(link);
                }
            }
        }
        return linkSet;
    }

    public LinkSet getLinkbaseLinks() {
        LinkSet linkSet = new LinkSet();
        Iterator iterator = this.getAllLinks();
        while (iterator.hasNext()) {
            Link link;
            Object e = iterator.next();
            if (e instanceof Link) {
                link = (Link)e;
                if (!link.isLinkbaseLink()) continue;
                linkSet.addLink(link);
                continue;
            }
            Enumeration enumeration = ((Vector)e).elements();
            while (enumeration.hasMoreElements()) {
                link = (Link)enumeration.nextElement();
                if (!link.isLinkbaseLink()) continue;
                linkSet.addLink(link);
            }
        }
        return linkSet;
    }

    public LinkSet getLinkbaseLinksByActuate(String string) {
        LinkSet linkSet = new LinkSet();
        if (string != null) {
            Iterator iterator = this.getAllLinks();
            while (iterator.hasNext()) {
                Link link;
                Object e = iterator.next();
                if (e instanceof Link) {
                    link = (Link)e;
                    if (!link.isLinkbaseLink() || !string.equals(link.getArc().getActuate())) continue;
                    linkSet.addLink(link);
                    continue;
                }
                Enumeration enumeration = ((Vector)e).elements();
                while (enumeration.hasMoreElements()) {
                    link = (Link)enumeration.nextElement();
                    if (!link.isLinkbaseLink() || !string.equals(link.getArc().getActuate())) continue;
                    linkSet.addLink(link);
                }
            }
        }
        return linkSet;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.getAllLinks();
        while (iterator.hasNext()) {
            Link link;
            Object e = iterator.next();
            if (e instanceof Link) {
                link = (Link)e;
                stringBuffer.append(link.toString()).append("\n");
                continue;
            }
            Enumeration enumeration = ((Vector)e).elements();
            while (enumeration.hasMoreElements()) {
                link = (Link)enumeration.nextElement();
                stringBuffer.append(link.toString()).append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public List toList() {
        Vector<Link> vector = new Vector<Link>();
        Iterator iterator = this.getAllLinks();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Link) {
                vector.add((Link)e);
                continue;
            }
            Enumeration enumeration = ((Vector)e).elements();
            while (enumeration.hasMoreElements()) {
                vector.add((Link)enumeration.nextElement());
            }
        }
        return vector;
    }

    public void addLinkSet(LinkSet linkSet) {
        if (linkSet != null) {
            Iterator iterator = linkSet.getAllLinks();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof Link) {
                    this.addLink((Link)e);
                    continue;
                }
                Enumeration enumeration = ((Vector)e).elements();
                while (enumeration.hasMoreElements()) {
                    this.addLink((Link)enumeration.nextElement());
                }
            }
        }
    }

    private Iterator getAllLinks() {
        return this.linksContainer.values().iterator();
    }

    public boolean isEmpty() {
        return this.linksContainer.isEmpty();
    }

    public int size() {
        int n = 0;
        Iterator iterator = this.getAllLinks();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            n += e instanceof Link ? 1 : ((Vector)e).size();
        }
        return n;
    }

    public boolean isUnique(Link link) {
        String string;
        int n = 0;
        if (link != null && this.linksContainer.containsKey(string = link.getFromNode().getURL().toString())) {
            Object v = this.linksContainer.get(string);
            if (v instanceof Link) {
                if (link.equalsAsLink((Link)v)) {
                    ++n;
                }
            } else {
                Enumeration enumeration = ((Vector)v).elements();
                while (enumeration.hasMoreElements()) {
                    if (!link.equalsAsLink((Link)enumeration.nextElement())) continue;
                    ++n;
                }
            }
        }
        return n <= 1;
    }

    public Link firstLink() {
        if (!this.linksContainer.isEmpty()) {
            Object v = this.linksContainer.get(this.linksContainer.firstKey());
            if (v instanceof Link) {
                return (Link)v;
            }
            return (Link)((Vector)v).firstElement();
        }
        return null;
    }

    public void removeLink(Link link) {
        String string;
        if (link != null && this.linksContainer.containsKey(string = link.getFromNode().getURL().toString())) {
            Object v = this.linksContainer.get(string);
            if (v instanceof Link) {
                if (link.equalsAsLink((Link)v)) {
                    this.linksContainer.remove(string);
                }
            } else {
                Vector vector = (Vector)v;
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    Link link2 = (Link)vector.elementAt(i);
                    if (!link.equalsAsLink(link2)) continue;
                    vector.removeElementAt(i--);
                    --n;
                }
                if (vector.size() == 0) {
                    this.linksContainer.remove(string);
                }
            }
        }
    }

    public void removeLinkSet(LinkSet linkSet) {
        if (linkSet == null || linkSet.size() == 0) {
            return;
        }
        Iterator iterator = linkSet.getAllLinks();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Link) {
                this.removeLink((Link)e);
                continue;
            }
            Enumeration enumeration = ((Vector)e).elements();
            while (enumeration.hasMoreElements()) {
                this.removeLink((Link)enumeration.nextElement());
            }
        }
    }

    public void removeAllLinks() {
        this.linksContainer.clear();
    }

    public void removeLinkbaseLinks() {
        Iterator iterator = this.getAllLinks();
        while (iterator.hasNext()) {
            Link link;
            Object e = iterator.next();
            if (e instanceof Link) {
                link = (Link)e;
                if (!link.isLinkbaseLink()) continue;
                this.removeLink(link);
                continue;
            }
            Enumeration enumeration = ((Vector)e).elements();
            while (enumeration.hasMoreElements()) {
                link = (Link)enumeration.nextElement();
                if (!link.isLinkbaseLink()) continue;
                this.removeLink(link);
            }
        }
    }
}

