/*
 * Decompiled with CFR 0.152.
 */
package com.skaringa.javaxml.serializers;

import com.skaringa.javaxml.DeserializerException;
import com.skaringa.javaxml.SerializerException;
import com.skaringa.javaxml.handler.DocumentOutputHandlerInterface;
import com.skaringa.javaxml.serializers.AbstractSerializer;
import com.skaringa.javaxml.serializers.ArrayHelper;
import com.skaringa.javaxml.serializers.ComponentSerializer;
import com.skaringa.javaxml.serializers.SerializerRegistry;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.xml.sax.Attributes;

public class ArraySerializer
extends AbstractSerializer {
    static final String TYPENAME = "array";

    public void serialize(Object object, Class clazz, String string, Map map, Set set, DocumentOutputHandlerInterface documentOutputHandlerInterface) throws SerializerException {
        Class<?> clazz2 = clazz.getComponentType();
        this.startElement(object, this.getXMLTypeName(), string, map, documentOutputHandlerInterface);
        if (object != null) {
            int n = Array.getLength(object);
            int n2 = 0;
            while (n2 < n) {
                Object object2 = Array.get(object, n2);
                Class<?> clazz3 = object2 == null ? clazz2 : object2.getClass();
                ComponentSerializer componentSerializer = SerializerRegistry.getInstance().getSerializer(clazz3);
                componentSerializer.serialize(object2, clazz3, "el", map, set, documentOutputHandlerInterface);
                ++n2;
            }
        }
        documentOutputHandlerInterface.endElement(string);
    }

    public String getXMLTypeName() {
        return TYPENAME;
    }

    public Object startDeserialize(String string, Attributes attributes, Object object) throws DeserializerException {
        Vector vector = null;
        String string2 = attributes.getValue("xsi:nil");
        if (string2 == null || string2.equals("false")) {
            vector = new Vector();
        }
        Class<?> clazz = AbstractSerializer.getFieldType(object, string).getComponentType();
        return new ArrayHelper(vector, clazz);
    }

    public void setMember(Object object, String string, Object object2) throws DeserializerException {
        if (!string.equals("el")) {
            throw new DeserializerException("element el expected as child of arrays");
        }
        this.checkSequence(object);
        ArrayHelper arrayHelper = (ArrayHelper)object;
        if (arrayHelper.getVector() == null) {
            throw new DeserializerException("child of null object is forbidden");
        }
        arrayHelper.add(object2);
    }

    public Object endDeserialize(Object object, String string) throws DeserializerException {
        this.checkSequence(object);
        ArrayHelper arrayHelper = (ArrayHelper)object;
        return arrayHelper.getArray();
    }

    private void checkSequence(Object object) throws DeserializerException {
        if (!(object instanceof ArrayHelper)) {
            throw new DeserializerException("invalid sequence: array expected, but was: " + object.getClass().getName());
        }
    }

    public void writeXMLTypeDefinition(Class clazz, DocumentOutputHandlerInterface documentOutputHandlerInterface) throws SerializerException {
        this.writeXMLCollectionDef("el", null, documentOutputHandlerInterface);
    }

    public void addUsedClasses(Class clazz, Set set) throws SerializerException {
        set.add(clazz);
    }
}

