/*
 * Decompiled with CFR 0.152.
 */
package com.skaringa.javaxml.serializers;

import com.skaringa.javaxml.DeserializerException;
import com.skaringa.javaxml.SerializerException;
import com.skaringa.javaxml.handler.DocumentOutputHandlerInterface;
import com.skaringa.javaxml.handler.sax.AttrImpl;
import com.skaringa.javaxml.impl.PropertyHelper;
import com.skaringa.javaxml.serializers.AbstractSerializer;
import com.skaringa.javaxml.serializers.ComponentSerializer;
import com.skaringa.javaxml.serializers.SerializerRegistry;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Category;
import org.xml.sax.Attributes;

public class ObjectSerializer
extends AbstractSerializer {
    private static Category _category = Category.getInstance(class$com$skaringa$javaxml$serializers$ObjectSerializer == null ? (class$com$skaringa$javaxml$serializers$ObjectSerializer = ObjectSerializer.class$("com.skaringa.javaxml.serializers.ObjectSerializer")) : class$com$skaringa$javaxml$serializers$ObjectSerializer);
    private String _xmlTypeName;
    static /* synthetic */ Class class$com$skaringa$javaxml$serializers$ObjectSerializer;
    static /* synthetic */ Class class$java$lang$Object;

    ObjectSerializer(String string) {
        this._xmlTypeName = string;
    }

    public void serialize(Object object, Class clazz, String string, Map map, Set set, DocumentOutputHandlerInterface documentOutputHandlerInterface) throws SerializerException {
        boolean bl = PropertyHelper.parseBoolean(map, "omit_xsi_type");
        boolean bl2 = PropertyHelper.parseBoolean(map, "omit_xsi_nil");
        boolean bl3 = PropertyHelper.parseBoolean(map, "omit_id");
        boolean bl4 = false;
        if (object != null) {
            object = this.writeReplaceObject(object);
        }
        AttrImpl attrImpl = new AttrImpl();
        if (object != null && !bl3) {
            Integer n = new Integer(System.identityHashCode(object));
            if (set.contains(n)) {
                bl4 = true;
            } else {
                set.add(n);
            }
            StringBuffer stringBuffer = new StringBuffer("i");
            stringBuffer.append(n);
            attrImpl.addAttribute(bl4 ? "reference" : "id", stringBuffer.toString());
        }
        if (!bl) {
            attrImpl.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "xsi", "type", clazz.getName());
        }
        if (object == null && !bl2) {
            attrImpl.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "xsi", "nil", "true");
        }
        documentOutputHandlerInterface.startElement(string, attrImpl);
        if (object != null && !bl4) {
            this.inspectObject(object, object.getClass(), map, set, documentOutputHandlerInterface);
        }
        documentOutputHandlerInterface.endElement(string);
    }

    public String getXMLTypeName() {
        return this._xmlTypeName;
    }

    public void writeXMLTypeDefinition(Class clazz, DocumentOutputHandlerInterface documentOutputHandlerInterface) throws SerializerException {
        AttrImpl attrImpl = new AttrImpl();
        attrImpl.addAttribute("name", clazz.getName());
        documentOutputHandlerInterface.startElement("xsd:complexType", attrImpl);
        this.processExtensionType(clazz, documentOutputHandlerInterface);
        documentOutputHandlerInterface.endElement("xsd:complexType");
    }

    public Object startDeserialize(String string, Attributes attributes, Object object) throws DeserializerException {
        Object var4_4 = null;
        String string2 = attributes.getValue("xsi:nil");
        try {
            if (string2 == null || string2.equals("false")) {
                Class<?> clazz = Class.forName(this._xmlTypeName);
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                var4_4 = constructor.newInstance(new Object[0]);
            }
        }
        catch (InstantiationException instantiationException) {
            throw new DeserializerException("can't instantiate class: " + this._xmlTypeName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DeserializerException("class not found: " + this._xmlTypeName);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DeserializerException("can't access default ctor of class: " + this._xmlTypeName);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new DeserializerException("no default ctor found for class: " + this._xmlTypeName);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new DeserializerException("exception in initializer: " + invocationTargetException.getMessage());
        }
        return var4_4;
    }

    public Object endDeserialize(Object object, String string) throws DeserializerException {
        if (object != null) {
            object = this.readResolveObject(object);
        }
        return object;
    }

    public void setMember(Object object, String string, Object object2) throws DeserializerException {
        try {
            Field field = AbstractSerializer.getField(object, string);
            if (field == null) {
                throw new DeserializerException("no such field: " + string);
            }
            int n = field.getModifiers();
            if (!Modifier.isFinal(n)) {
                _category.debug("set " + string + " = " + object2);
                field.setAccessible(true);
                field.set(object, object2);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DeserializerException("Setting " + string + " to " + object2.getClass().getName() + "(" + object2 + ")" + " threw IllegalAccessException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DeserializerException("Setting " + string + " to " + object2.getClass().getName() + "(" + object2 + ")" + " threw IllegalArgumentException");
        }
    }

    private void inspectObject(Object object, Class clazz, Map map, Set set, DocumentOutputHandlerInterface documentOutputHandlerInterface) throws SerializerException {
        if (!clazz.equals(class$java$lang$Object == null ? (class$java$lang$Object = ObjectSerializer.class$("java.lang.Object")) : class$java$lang$Object)) {
            this.inspectObject(object, clazz.getSuperclass(), map, set, documentOutputHandlerInterface);
        }
        AccessibleObject[] accessibleObjectArray = AbstractSerializer.getFieldsToSerialize(clazz);
        AccessibleObject.setAccessible(accessibleObjectArray, true);
        int n = 0;
        while (n < accessibleObjectArray.length) {
            Object object2;
            String string = ((Field)accessibleObjectArray[n]).getName();
            try {
                object2 = ((Field)accessibleObjectArray[n]).get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SerializerException("can't access element " + string);
            }
            Class<?> clazz2 = object2 == null ? ((Field)accessibleObjectArray[n]).getType() : object2.getClass();
            ComponentSerializer componentSerializer = SerializerRegistry.getInstance().getSerializer(clazz2);
            componentSerializer.serialize(object2, clazz2, string, map, set, documentOutputHandlerInterface);
            ++n;
        }
    }

    private void processExtensionType(Class clazz, DocumentOutputHandlerInterface documentOutputHandlerInterface) throws SerializerException {
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            documentOutputHandlerInterface.startElement("xsd:complexContent");
            ComponentSerializer componentSerializer = SerializerRegistry.getInstance().getSerializer(clazz2);
            AttrImpl attrImpl = new AttrImpl();
            attrImpl.addAttribute("base", componentSerializer.getXMLTypeName());
            documentOutputHandlerInterface.startElement("xsd:extension", attrImpl);
            this.processFieldTypes(clazz, documentOutputHandlerInterface);
            documentOutputHandlerInterface.endElement("xsd:extension");
            documentOutputHandlerInterface.endElement("xsd:complexContent");
        } else {
            AttrImpl attrImpl = new AttrImpl();
            attrImpl.addAttribute("name", "id");
            attrImpl.addAttribute("type", "xsd:ID");
            documentOutputHandlerInterface.startElement("xsd:attribute", attrImpl);
            documentOutputHandlerInterface.endElement("xsd:attribute");
            attrImpl = new AttrImpl();
            attrImpl.addAttribute("name", "reference");
            attrImpl.addAttribute("type", "xsd:IDREF");
            documentOutputHandlerInterface.startElement("xsd:attribute", attrImpl);
            documentOutputHandlerInterface.endElement("xsd:attribute");
        }
    }

    private void processFieldTypes(Class clazz, DocumentOutputHandlerInterface documentOutputHandlerInterface) throws SerializerException {
        Field[] fieldArray = AbstractSerializer.getFieldsToSerialize(clazz);
        if (fieldArray.length > 0) {
            documentOutputHandlerInterface.startElement("xsd:sequence");
            int n = 0;
            while (n < fieldArray.length) {
                String string = fieldArray[n].getName();
                Class<?> clazz2 = fieldArray[n].getType();
                ComponentSerializer componentSerializer = SerializerRegistry.getInstance().getSerializer(clazz2);
                AttrImpl attrImpl = new AttrImpl();
                attrImpl.addAttribute("name", string);
                attrImpl.addAttribute("type", componentSerializer.getXMLTypeName());
                attrImpl.addAttribute("nillable", "true");
                attrImpl.addAttribute("minOccurs", "0");
                documentOutputHandlerInterface.startElement("xsd:element", attrImpl);
                documentOutputHandlerInterface.endElement("xsd:element");
                ++n;
            }
            documentOutputHandlerInterface.endElement("xsd:sequence");
        }
    }

    private Object readResolveObject(Object object) throws DeserializerException {
        try {
            Method method = object.getClass().getMethod("skaReadResolve", new Class[0]);
            if (_category.isDebugEnabled()) {
                _category.debug("about to call: skaReadResolve of class: " + this._xmlTypeName);
            }
            return method.invoke(object, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DeserializerException("can't access method skaReadResolve of class: " + this._xmlTypeName);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new DeserializerException("exception in skaReadResolve: " + invocationTargetException.getMessage());
        }
    }

    private Object writeReplaceObject(Object object) throws SerializerException {
        try {
            Method method = object.getClass().getMethod("skaWriteReplace", new Class[0]);
            if (_category.isDebugEnabled()) {
                _category.debug("about to call: skaWriteReplace of class: " + this._xmlTypeName);
            }
            return method.invoke(object, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SerializerException("can't access method skaWriteReplace of class: " + this._xmlTypeName);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SerializerException("exception in skaWriteReplace: " + invocationTargetException.getMessage());
        }
    }

    public void addUsedClasses(Class clazz, Set set) throws SerializerException {
        Object object;
        if (set.contains(clazz)) {
            return;
        }
        SerializerRegistry serializerRegistry = SerializerRegistry.getInstance();
        HashMap hashMap = new HashMap();
        set.add(clazz);
        Field[] fieldArray = AbstractSerializer.getFieldsToSerialize(clazz);
        int n = 0;
        while (n < fieldArray.length) {
            object = fieldArray[n].getType();
            ComponentSerializer componentSerializer = serializerRegistry.getSerializer((Class)object);
            componentSerializer.addUsedClasses((Class)object, set);
            ++n;
        }
        clazz = clazz.getSuperclass();
        while (clazz != null) {
            object = serializerRegistry.getSerializer(clazz);
            object.addUsedClasses(clazz, set);
            clazz = clazz.getSuperclass();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

