/*
 * Decompiled with CFR 0.152.
 */
package dom;

import java.util.Vector;
import org.apache.xerces.dom.ASDOMImplementationImpl;
import org.apache.xerces.dom3.DOMConfiguration;
import org.apache.xerces.dom3.DOMError;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.dom3.as.ASModel;
import org.apache.xerces.dom3.as.DOMASBuilder;
import org.apache.xerces.dom3.as.DOMImplementationAS;

public class ASBuilder
implements DOMErrorHandler {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            ASBuilder.printUsage();
            System.exit(1);
        }
        DOMImplementationAS dOMImplementationAS = (DOMImplementationAS)((Object)ASDOMImplementationImpl.getDOMImplementation());
        DOMASBuilder dOMASBuilder = dOMImplementationAS.createDOMASBuilder();
        DOMConfiguration dOMConfiguration = dOMASBuilder.getConfig();
        dOMConfiguration.setParameter("error-handler", (Object)new ASBuilder());
        boolean bl = false;
        String string = null;
        int n = 0;
        string = stringArray[n];
        if (string.equals("-f")) {
            bl = true;
            string = stringArray[++n];
        } else if (string.equals("-F")) {
            bl = false;
            string = stringArray[++n];
        }
        dOMConfiguration.setParameter(NAMESPACES_FEATURE_ID, (Object)Boolean.TRUE);
        dOMConfiguration.setParameter(VALIDATION_FEATURE_ID, (Object)Boolean.TRUE);
        dOMConfiguration.setParameter(SCHEMA_VALIDATION_FEATURE_ID, (Object)Boolean.TRUE);
        dOMConfiguration.setParameter(SCHEMA_FULL_CHECKING_FEATURE_ID, (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        if (!string.equals("-a")) {
            ASBuilder.printUsage();
            System.exit(1);
        }
        ++n;
        Vector<String> vector = new Vector<String>();
        while (n < stringArray.length && !(string = stringArray[n]).startsWith("-")) {
            vector.addElement(string);
            ++n;
        }
        if (vector.size() == 0) {
            ASBuilder.printUsage();
            System.exit(1);
        }
        Vector<String> vector2 = null;
        if (n < stringArray.length) {
            if (!string.equals("-i")) {
                ASBuilder.printUsage();
                System.exit(1);
            }
            ++n;
            vector2 = new Vector<String>();
            while (n < stringArray.length && !(string = stringArray[n]).startsWith("-")) {
                vector2.addElement(string);
                ++n;
            }
            if (vector2.size() == 0 || n != stringArray.length) {
                ASBuilder.printUsage();
                System.exit(1);
            }
        }
        try {
            ASModel aSModel = null;
            n = 0;
            while (n < vector.size()) {
                aSModel = dOMASBuilder.parseASURI((String)vector.elementAt(n));
                dOMASBuilder.setAbstractSchema(aSModel);
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        if (vector2 != null) {
            try {
                n = 0;
                while (n < vector2.size()) {
                    dOMASBuilder.parseURI((String)vector2.elementAt(n));
                    ++n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static void printUsage() {
        System.err.println("usage: java dom.ASBuilder [-f|-F] -a uri ... [-i uri ...]");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -f  | -F    Turn on/off Schema full checking.");
        System.err.println("  -a uri ...  Provide a list of schema documents.");
        System.err.println("  -i uri ...  Provide a list of instalce documents to validate.");
        System.err.println();
        System.err.println("default:");
        System.err.print("  Schema full checking:     ");
        System.err.println("off");
        System.err.println();
        System.err.println("notes:");
        System.err.println("DOM Level 3 APIs might change in the future.");
    }

    public boolean handleError(DOMError dOMError) {
        System.err.print("[");
        switch (dOMError.getSeverity()) {
            case 0: {
                System.err.print("Warning");
                break;
            }
            case 1: {
                System.err.print("Error");
                break;
            }
            case 2: {
                System.err.print("Fatal Error");
            }
        }
        System.err.print("] ");
        String string = dOMError.getLocation().getUri();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            System.err.print(string);
        }
        System.err.print(':');
        System.err.print(dOMError.getLocation().getLineNumber());
        System.err.print(':');
        System.err.print(dOMError.getLocation().getColumnNumber());
        System.err.print(": ");
        System.err.print(dOMError.getMessage());
        System.err.println();
        System.err.flush();
        return dOMError.getSeverity() != 2;
    }
}

