/*
 * Decompiled with CFR 0.152.
 */
package flybase;

import flybase.Utils;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.ResourceBundle;

public class Native {
    public static final int kSysUnknown = 0;
    public static final int kSysMac = 1;
    public static final int kSysMSWin = 2;
    public static final int kSysXWin = 3;
    public static final int kSysOS2 = 4;
    public static final int kSysUntested = -1;
    public static final int mac = 1;
    public static final int mswin = 2;
    public static final int xwin = 3;
    public static final int os2 = 4;
    protected static int systemFlavor = -1;
    protected static String lineEnd = null;
    public static boolean standardLineEnd;
    private static final Object tmpFileLock;
    private static int tempnum;
    private static String tempFold;

    public static int SystemFlavor() {
        if (systemFlavor == -1) {
            String string = System.getProperty("os.name");
            systemFlavor = (string = string.toLowerCase()).startsWith("mac") ? 1 : (string.startsWith("windows") ? 2 : (string.startsWith("os/2") ? 4 : (System.getProperty("file.separator").equals("\\") ? 2 : (System.getProperty("line.separator").equals("\n\r") ? 2 : 3))));
        }
        return systemFlavor;
    }

    public static String SystemFlavors() {
        if (systemFlavor == -1) {
            Native.SystemFlavor();
        }
        switch (systemFlavor) {
            case 1: {
                return new String("mac");
            }
            case 2: {
                return new String("mswin");
            }
            case 4: {
                return new String("os2");
            }
            case 3: {
                return new String("xwin");
            }
        }
        return new String("unknown");
    }

    public static String LineEnd() {
        if (standardLineEnd) {
            return "\n";
        }
        if (lineEnd == null) {
            lineEnd = System.getProperty("line.separator");
        }
        return lineEnd;
    }

    public static String LineEnd(int n) {
        String string = new String(Native.LineEnd());
        while (--n > 0) {
            string = string + Native.LineEnd();
        }
        return string;
    }

    public static String filePath(String string) {
        String string2;
        char c;
        if (string == null) {
            return null;
        }
        char c2 = File.separatorChar;
        if (systemFlavor == -1) {
            Native.SystemFlavor();
        }
        switch (systemFlavor) {
            case 1: {
                c = ':';
                string2 = "";
                break;
            }
            case 2: 
            case 4: {
                c = '\\';
                string2 = "\\";
                break;
            }
            default: {
                c = '/';
                string2 = "/";
            }
        }
        boolean bl = string.charAt(0) == c2;
        String string3 = File.separator + File.separator;
        int n = string.indexOf(string3);
        while (n >= 0) {
            string = string.substring(0, n) + string.substring(n + 1);
            n = string.indexOf(string3);
        }
        String string4 = string.replace(c2, c);
        string4 = Utils.decode(string4);
        if (bl) {
            string4 = string2 + string4.substring(1);
        }
        return string4;
    }

    public static String tempFolder() {
        if (tempFold == null) {
            String string = null;
            File file = null;
            try {
                file = File.createTempFile("dummy", "");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (file == null) {
                if (systemFlavor == -1) {
                    Native.SystemFlavor();
                }
                switch (systemFlavor) {
                    case 1: {
                        break;
                    }
                    case 3: {
                        ResourceBundle resourceBundle = ResourceBundle.getBundle("ca.ucalgary.bluejay.proxy.data.readseqProps");
                        file = new File(resourceBundle.getString("tmpfile"), "");
                        break;
                    }
                    case 2: 
                    case 4: {
                        file = new File("\\tmp", "");
                        if (file == null || !file.exists()) {
                            file = new File("\\temp", "");
                        }
                        if (file != null && file.exists()) break;
                        file = new File("c:\\temp", "");
                    }
                }
            }
            if (file != null && file.exists() && file.isDirectory()) {
                string = file.getPath();
            }
            if (string == null || string.length() == 0) {
                string = System.getProperty("user.dir", "") + "/";
            }
            tempFold = string;
        }
        return tempFold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String tempFilename(String string, String string2) {
        if (string == null) {
            string = "dclap";
        }
        if (string2 == null) {
            string2 = ".tmp";
        }
        Object object = tmpFileLock;
        synchronized (object) {
            if (tempnum == -1) {
                tempnum = new Random().nextInt() & 0xFFFF;
            }
            string = string + Integer.toString(++tempnum) + string2;
        }
        return string;
    }

    public static final String tempFilename(String string) {
        return Native.tempFilename("dclap", string);
    }

    public static final File tempFile() {
        return Native.tempFile(".tmp");
    }

    public static File tempFile(String string) {
        String string2 = Native.tempFolder();
        if (string2 == null || string2.length() == 0) {
            return new File(Native.tempFilename(string));
        }
        return new File(string2, Native.tempFilename(string));
    }

    static {
        Native.SystemFlavor();
        standardLineEnd = false;
        tmpFileLock = new Object();
        tempnum = -1;
        tempFold = null;
    }
}

