/*
 * Decompiled with CFR 0.152.
 */
package flybase;

import java.io.CharConversionException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;

public class OpenString
implements Serializable {
    public char[] value;
    public int offset;
    public int count;
    private static final long serialVersionUID = -6849794470754667710L;
    private static boolean v11hash;
    transient int hashcode;

    public OpenString() {
        this.value = new char[0];
    }

    public OpenString(OpenString openString) {
        this(openString.offset, openString.count, openString.value);
    }

    public OpenString(String string) {
        this.count = string.length();
        this.value = new char[this.count];
        string.getChars(0, this.count, this.value, 0);
    }

    public OpenString(char[] cArray) {
        this.count = cArray.length;
        this.value = cArray;
    }

    public OpenString(char[] cArray, int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > cArray.length - n2) {
            throw new StringIndexOutOfBoundsException(n + n2);
        }
        this.value = cArray;
        this.count = n2;
        this.offset = n;
    }

    public OpenString(byte[] byArray, int n, int n2, int n3) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 < 0) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 > byArray.length - n3) {
            throw new StringIndexOutOfBoundsException(n2 + n3);
        }
        char[] cArray = new char[n3];
        this.count = n3;
        this.value = cArray;
        if (n == 0) {
            int n4 = n3;
            while (n4-- > 0) {
                cArray[n4] = (char)(byArray[n4 + n2] & 0xFF);
            }
        } else {
            n <<= 8;
            int n5 = n3;
            while (n5-- > 0) {
                cArray[n5] = (char)(n | byArray[n5 + n2] & 0xFF);
            }
        }
    }

    public OpenString(byte[] byArray, int n) {
        this(byArray, n, 0, byArray.length);
    }

    protected OpenString(byte[] byArray, int n, int n2, ByteToCharConverter byteToCharConverter) {
        int n3 = byteToCharConverter.getMaxCharsPerByte() * n2;
        this.value = new char[n3];
        try {
            this.count = byteToCharConverter.convert(byArray, n, n + n2, this.value, 0, n3);
            this.count += byteToCharConverter.flush(this.value, byteToCharConverter.nextCharIndex(), n3);
        }
        catch (CharConversionException charConversionException) {
            this.count = byteToCharConverter.nextCharIndex();
        }
        if (this.count < n3) {
            char[] cArray = new char[this.count];
            System.arraycopy(this.value, 0, cArray, 0, this.count);
            this.value = cArray;
        }
    }

    public OpenString(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        this(byArray, n, n2, ByteToCharConverter.getConverter((String)string));
    }

    public OpenString(byte[] byArray, String string) throws UnsupportedEncodingException {
        this(byArray, 0, byArray.length, string);
    }

    public OpenString(byte[] byArray, int n, int n2) {
        this(byArray, n, n2, ByteToCharConverter.getDefault());
    }

    public OpenString(byte[] byArray) {
        this(byArray, 0, byArray.length, ByteToCharConverter.getDefault());
    }

    public OpenString(int n, int n2, char[] cArray) {
        this.value = cArray;
        this.offset = n;
        this.count = n2;
    }

    public final int length() {
        return this.count;
    }

    public char[] getValue() {
        return this.value;
    }

    public void setValue(char[] cArray) {
        this.value = cArray;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int n) {
        this.offset = n;
    }

    public final void setLength(int n) {
        this.count = n;
    }

    public void setCharAt(int n, char c) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.value[n + this.offset] = c;
    }

    public char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[n + this.offset];
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        System.arraycopy(this.value, this.offset + n, cArray, n3, n2 - n);
    }

    public void getBytes(int n, int n2, byte[] byArray, int n3) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        int n4 = n3;
        int n5 = this.offset + n2;
        int n6 = this.offset + n;
        while (n6 < n5) {
            byArray[n4++] = (byte)this.value[n6++];
        }
    }

    protected byte[] getBytes(CharToByteConverter charToByteConverter) {
        int n;
        charToByteConverter.reset();
        int n2 = charToByteConverter.getMaxBytesPerChar() * this.count;
        byte[] byArray = new byte[n2];
        try {
            n = charToByteConverter.convert(this.value, this.offset, this.offset + this.count, byArray, 0, n2);
            n += charToByteConverter.flush(byArray, charToByteConverter.nextByteIndex(), n2);
        }
        catch (CharConversionException charConversionException) {
            n = charToByteConverter.nextByteIndex();
        }
        if (n < n2) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            return byArray2;
        }
        return byArray;
    }

    public final byte[] getBytes(String string) throws UnsupportedEncodingException {
        return this.getBytes(CharToByteConverter.getConverter((String)string));
    }

    public final byte[] getBytes() {
        return this.getBytes(CharToByteConverter.getDefault());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof String) {
            object = new OpenString((String)object);
        }
        if (object instanceof OpenString) {
            OpenString openString = (OpenString)object;
            int n = this.count;
            if (n == openString.count) {
                char[] cArray = this.value;
                char[] cArray2 = openString.value;
                int n2 = this.offset;
                int n3 = openString.offset;
                while (n-- != 0) {
                    if (cArray[n2++] == cArray2[n3++]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public final boolean equalsIgnoreCase(OpenString openString) {
        return openString != null && openString.count == this.count && this.regionMatches(true, 0, openString, 0, this.count);
    }

    public final boolean equalsIgnoreCase(String string) {
        return string != null && string.length() == this.count && this.regionMatches(true, 0, string, 0, this.count);
    }

    public int compareTo(OpenString openString) {
        int n = this.count;
        int n2 = openString.count;
        int n3 = Math.min(n, n2);
        char[] cArray = this.value;
        char[] cArray2 = openString.value;
        int n4 = this.offset;
        int n5 = openString.offset;
        while (n3-- != 0) {
            char c;
            char c2;
            if ((c2 = cArray[n4++]) == (c = cArray2[n5++])) continue;
            return c2 - c;
        }
        return n - n2;
    }

    public int compareTo(OpenString openString, boolean bl) {
        int n = this.count;
        int n2 = openString.count;
        int n3 = Math.min(n, n2);
        char[] cArray = this.value;
        char[] cArray2 = openString.value;
        int n4 = this.offset;
        int n5 = openString.offset;
        while (n3-- != 0) {
            char c = cArray[n4++];
            char c2 = cArray2[n5++];
            if (bl) {
                c = Character.toUpperCase(c);
                c2 = Character.toUpperCase(c2);
            }
            if (c == c2) continue;
            return c - c2;
        }
        return n - n2;
    }

    public int dictionaryCompareTo(OpenString openString, boolean bl) {
        int n = this.count;
        int n2 = openString.count;
        int n3 = Math.min(n, n2);
        char[] cArray = this.value;
        char[] cArray2 = openString.value;
        int n4 = this.offset;
        int n5 = openString.offset;
        while (n3-- != 0) {
            char c = '\u0000';
            while (n4 < n && !Character.isLetterOrDigit(c)) {
                c = cArray[n4++];
            }
            char c2 = '\u0000';
            while (n5 < n2 && !Character.isLetterOrDigit(c2)) {
                c2 = cArray2[n5++];
            }
            if (bl) {
                c = Character.toUpperCase(c);
                c2 = Character.toUpperCase(c2);
            }
            if (c == c2) continue;
            return c - c2;
        }
        return n - n2;
    }

    public boolean regionMatches(int n, OpenString openString, int n2, int n3) {
        char[] cArray = this.value;
        int n4 = this.offset + n;
        int n5 = this.offset + this.count;
        char[] cArray2 = openString.value;
        int n6 = openString.offset + n2;
        if (n2 < 0 || n < 0 || n > this.count - n3 || n2 > openString.count - n3) {
            return false;
        }
        while (n3-- > 0) {
            if (cArray[n4++] == cArray2[n6++]) continue;
            return false;
        }
        return true;
    }

    public boolean regionMatches(int n, String string, int n2, int n3) {
        int n4 = string.length();
        if (n2 < 0 || n < 0 || n > this.count - n3 || n2 > n4 - n3) {
            return false;
        }
        char[] cArray = this.value;
        int n5 = this.offset + n;
        int n6 = n2;
        while (n3-- > 0) {
            if (cArray[n5++] == string.charAt(n6++)) continue;
            return false;
        }
        return true;
    }

    public boolean regionMatches(boolean bl, int n, OpenString openString, int n2, int n3) {
        char[] cArray = this.value;
        int n4 = this.offset + n;
        int n5 = this.offset + this.count;
        char[] cArray2 = openString.value;
        int n6 = openString.offset + n2;
        if (n2 < 0 || n < 0 || n > this.count - n3 || n2 > openString.count - n3) {
            return false;
        }
        while (n3-- > 0) {
            char c;
            char c2;
            char c3;
            char c4;
            if ((c4 = cArray[n4++]) == (c3 = cArray2[n6++]) || bl && ((c2 = Character.toUpperCase(c4)) == (c = Character.toUpperCase(c3)) || Character.toLowerCase(c2) == Character.toLowerCase(c))) continue;
            return false;
        }
        return true;
    }

    public boolean regionMatches(boolean bl, int n, String string, int n2, int n3) {
        if (n2 < 0 || n < 0 || n > this.count - n3 || n2 > string.length() - n3) {
            return false;
        }
        char[] cArray = this.value;
        int n4 = this.offset + n;
        int n5 = this.offset + this.count;
        int n6 = n2;
        while (n3-- > 0) {
            char c;
            char c2;
            char c3;
            char c4;
            if ((c4 = cArray[n4++]) == (c3 = string.charAt(n6++)) || bl && ((c2 = Character.toUpperCase(c4)) == (c = Character.toUpperCase(c3)) || Character.toLowerCase(c2) == Character.toLowerCase(c))) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(OpenString openString, int n) {
        char[] cArray = this.value;
        int n2 = this.offset + n;
        int n3 = this.offset + this.count;
        char[] cArray2 = openString.value;
        int n4 = openString.offset;
        int n5 = openString.count;
        if (n < 0 || n > this.count - n5) {
            return false;
        }
        while (--n5 >= 0) {
            if (cArray[n2++] == cArray2[n4++]) continue;
            return false;
        }
        return true;
    }

    public final boolean startsWith(OpenString openString) {
        return this.startsWith(openString, 0);
    }

    public final boolean startsWith(String string, int n) {
        return this.startsWith(new OpenString(string), n);
    }

    public final boolean startsWith(String string) {
        return this.startsWith(new OpenString(string), 0);
    }

    public final boolean endsWith(OpenString openString) {
        return this.startsWith(openString, this.count - openString.count);
    }

    public int hashCode() {
        if (this.hashcode != 0) {
            return this.hashcode;
        }
        this.hashcode = v11hash ? this.hashCode11() : this.hashCode12();
        return this.hashcode;
    }

    public int hashCode11() {
        int n = 0;
        int n2 = this.offset;
        char[] cArray = this.value;
        int n3 = this.count;
        if (n3 < 16) {
            for (int i = n3; i > 0; --i) {
                n = n * 37 + cArray[n2++];
            }
        } else {
            int n4 = n3 / 8;
            int n5 = n3;
            while (n5 > 0) {
                n = n * 39 + cArray[n2];
                n5 -= n4;
                n2 += n4;
            }
        }
        return n;
    }

    public int hashCode12() {
        int n = 0;
        int n2 = this.offset;
        char[] cArray = this.value;
        int n3 = this.count;
        for (int i = 0; i < n3; ++i) {
            n = 31 * n + cArray[n2++];
        }
        return n;
    }

    public final int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public int indexOf(int n, int n2) {
        int n3 = this.offset + this.count;
        char[] cArray = this.value;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.count) {
            return -1;
        }
        for (int i = this.offset + n2; i < n3; ++i) {
            if (cArray[i] != n) continue;
            return i - this.offset;
        }
        return -1;
    }

    public final int lastIndexOf(int n) {
        return this.lastIndexOf(n, this.count - 1);
    }

    public int lastIndexOf(int n, int n2) {
        int n3 = this.offset;
        char[] cArray = this.value;
        for (int i = this.offset + (n2 >= this.count ? this.count - 1 : n2); i >= n3; --i) {
            if (cArray[i] != n) continue;
            return i - this.offset;
        }
        return -1;
    }

    public final int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public final int indexOf(String string, int n) {
        return this.indexOf(new OpenString(string), n);
    }

    public final int indexOf(OpenString openString) {
        return this.indexOf(openString, 0);
    }

    public int indexOf(OpenString openString, int n) {
        char[] cArray = this.value;
        char[] cArray2 = openString.value;
        int n2 = this.offset + (this.count - openString.count);
        if (n < 0) {
            n = 0;
        } else if (n >= this.count) {
            return -1;
        }
        if (openString.count == 0) {
            return n;
        }
        int n3 = openString.offset;
        char c = cArray2[n3];
        int n4 = this.offset + n;
        block0: while (true) {
            if (n4 <= n2 && cArray[n4] != c) {
                ++n4;
                continue;
            }
            if (n4 > n2) {
                return -1;
            }
            int n5 = n4 + 1;
            int n6 = n5 + openString.count - 1;
            int n7 = n3 + 1;
            while (n5 < n6) {
                if (cArray[n5++] == cArray2[n7++]) continue;
                ++n4;
                continue block0;
            }
            break;
        }
        return n4 - this.offset;
    }

    public final int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    public final int lastIndexOf(String string, int n) {
        return this.lastIndexOf(new OpenString(string), n);
    }

    public final int lastIndexOf(OpenString openString) {
        return this.lastIndexOf(openString, this.count);
    }

    public int lastIndexOf(OpenString openString, int n) {
        if (n < 0) {
            return -1;
        }
        if (n > this.count - openString.count) {
            n = this.count - openString.count;
        }
        if (openString.count == 0) {
            return n;
        }
        char[] cArray = this.value;
        char[] cArray2 = openString.value;
        for (int i = this.offset + n; i >= this.offset; --i) {
            int n2 = openString.count;
            int n3 = i;
            int n4 = openString.offset;
            while (cArray[n3++] == cArray2[n4++]) {
                if (--n2 > 0) continue;
                return i - this.offset;
            }
        }
        return -1;
    }

    public final OpenString substring(int n) {
        return this.substring(n, this.length());
    }

    public OpenString substring(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        return n == 0 && n2 == this.count ? this : new OpenString(this.offset + n, n2 - n, this.value);
    }

    public OpenString concat(OpenString openString) {
        int n = openString.length();
        if (n == 0) {
            return this;
        }
        char[] cArray = new char[this.count + n];
        this.getChars(0, this.count, cArray, 0);
        openString.getChars(0, n, cArray, this.count);
        return new OpenString(0, this.count + n, cArray);
    }

    public OpenString replace(char c, char n) {
        if (c != n) {
            int n2 = this.count;
            int n3 = -1;
            while (++n3 < n2 && this.value[this.offset + n3] != c) {
            }
            if (n3 < n2) {
                int n4;
                char[] cArray = new char[n2];
                for (n4 = 0; n4 < n3; ++n4) {
                    cArray[n4] = this.value[this.offset + n4];
                }
                while (n3 < n2) {
                    n4 = this.value[this.offset + n3];
                    cArray[n3] = n4 == c ? n : n4;
                    ++n3;
                }
                return new OpenString(0, n2, cArray);
            }
        }
        return this;
    }

    public void lowerCase() {
        this.hashcode = 0;
        int n = this.count;
        while (n-- > 0) {
            this.value[this.offset + n] = Character.toLowerCase(this.value[this.offset + n]);
        }
    }

    public void upperCase() {
        this.hashcode = 0;
        int n = this.count;
        while (n-- > 0) {
            this.value[this.offset + n] = Character.toUpperCase(this.value[this.offset + n]);
        }
    }

    public String toLowerCase() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.count;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(Character.toLowerCase(this.value[this.offset + i]));
        }
        return stringBuffer.toString();
    }

    public String toUpperCase() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.count;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(Character.toUpperCase(this.value[this.offset + i]));
        }
        return stringBuffer.toString();
    }

    public OpenString trim() {
        int n;
        int n2 = this.count;
        for (n = 0; n < n2 && this.value[this.offset + n] <= ' '; ++n) {
        }
        while (n < n2 && this.value[this.offset + n2 - 1] <= ' ') {
            --n2;
        }
        return n > 0 || n2 < this.count ? this.substring(n, n2) : this;
    }

    public final String toString() {
        return new String(this.value, this.offset, this.count);
    }

    public char[] toCharArray() {
        int n = this.length();
        char[] cArray = new char[n];
        this.getChars(0, n, cArray, 0);
        return cArray;
    }

    public static final OpenString valueOf(char[] cArray) {
        return new OpenString(0, cArray.length, cArray);
    }

    public static final OpenString valueOf(char[] cArray, int n, int n2) {
        return new OpenString(n, n2, cArray);
    }

    public static final OpenString copyValueOf(char[] cArray, int n, int n2) {
        return new OpenString(cArray, n, n2);
    }

    public static final OpenString copyValueOf(char[] cArray) {
        return OpenString.copyValueOf(cArray, 0, cArray.length);
    }

    static {
        String string = System.getProperty("java.version", "1.0.0");
        v11hash = string.startsWith("1.1") || string.startsWith("1.0");
    }
}

