/*
 * Decompiled with CFR 0.152.
 */
package iubio.bioseq;

import iubio.bioseq.Bioseq;
import iubio.bioseq.SeqInfo;
import java.io.File;
import java.io.RandomAccessFile;

public class BioseqFiled
extends Bioseq {
    static final int kMaxbuf = 20480;
    protected RandomAccessFile raf;
    protected File file;
    protected boolean istempfile;
    protected boolean readwrite;
    protected boolean needsFiling;
    protected long bufoffset;
    protected long bufend;
    protected long foffset;
    protected long flength;
    protected boolean endFile;

    public BioseqFiled() {
        this(0);
    }

    public BioseqFiled(int n) {
        super(n);
    }

    public BioseqFiled(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public BioseqFiled(byte[] byArray, int n, int n2) {
        super(byArray, n, n2);
    }

    public BioseqFiled(char[] cArray) {
        this(cArray, 0, cArray.length);
    }

    public BioseqFiled(char[] cArray, int n, int n2) {
        super(cArray, n, n2);
    }

    public BioseqFiled(String string) {
        super(string);
    }

    public BioseqFiled(File file, boolean bl) {
        super(0);
        this.readwrite = bl;
        this.copyFrom(file);
    }

    public void copyFrom(Object object) {
        if (object instanceof File) {
            this.copyFrom((File)object);
        } else {
            super.copyFrom(object);
        }
    }

    public void copyFrom(File file) {
        this.finibf();
        this.file = file;
        this.istempfile = false;
        this.initbf();
    }

    protected void finibf() {
        try {
            if (this.raf != null) {
                this.raf.close();
                this.raf = null;
            }
            if (this.istempfile && this.file != null) {
                this.file.delete();
                this.file = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void initbf() {
        this.bufoffset = 0L;
        this.bufend = 0L;
        if (this.bSeq == null) {
            this.bSeq = new byte[0];
        }
        try {
            this.raf = new RandomAccessFile(this.file, this.readwrite ? "rw" : "r");
            this.setFileOffset(0L, this.raf.length());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void finalize() throws Throwable {
        this.finibf();
        super.finalize();
    }

    public void setFileOffset(long l, long l2) {
        if (l != this.foffset || l2 != this.flength) {
            this.bufoffset = 0L;
            this.bufend = 0L;
            this.foffset = l;
            this.flength = l2;
        }
    }

    public boolean endOfFile() {
        return this.endFile;
    }

    public long fileLength() {
        if (this.raf == null) {
            return 0L;
        }
        try {
            return this.raf.length();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public int scanForEnd(int n, Object object) {
        if (this.raf == null) {
            this.endFile = true;
            return -1;
        }
        int n2 = 0;
        long l = 0L;
        BioseqFiled bioseqFiled = null;
        if (object instanceof BioseqFiled) {
            bioseqFiled = (BioseqFiled)object;
            l = bioseqFiled.foffset + bioseqFiled.flength;
            n2 = n - 1;
        }
        if (l >= this.fileLength()) {
            this.setFileOffset(l, 0L);
            this.endFile = true;
            return n2;
        }
        long l2 = l;
        long l3 = l;
        long l4 = l;
        int n3 = 1;
        byte[] byArray = new byte[20480];
        while (n2 < n && n3 > 0) {
            int n4;
            n3 = this.readBytes(l2, byArray, 0, 20480);
            boolean bl = true;
            for (n4 = 0; n4 < n3 && bl; ++n4) {
                if (byArray[n4] != 10 && byArray[n4] != 13) continue;
                if (n4 > 1 || l2 != l || n4 == 1 && byArray[0] >= 32) {
                    if (++n2 < n) {
                        l4 = (long)(1 + n4) + l2;
                        break;
                    }
                    bl = false;
                    break;
                }
                if (l2 != l || n4 != 0 && (n4 != 1 || byArray[0] >= 32)) continue;
                ++l4;
            }
            l2 += (long)n4;
        }
        if (n3 <= 0) {
            this.endFile = true;
        }
        this.setFileOffset(l4, l2 - l4);
        return n2;
    }

    public int length() {
        return this.flength > 0L ? (int)this.flength : this.bSeq.length;
    }

    public void setbases(byte[] byArray) {
        this.bSeq = byArray;
    }

    public void setbase(int n, byte by) {
        if (this.bSeq.length > n) {
            this.bSeq[n] = by;
        }
    }

    public byte basebyte(int n) {
        if (this.raf != null) {
            if ((long)n >= this.bufoffset && (long)n < this.bufend) {
                return this.bSeq[n - (int)this.bufoffset];
            }
            int n2 = this.readBases(n, 20480);
            if ((long)n >= this.bufoffset && (long)n < this.bufend) {
                return this.bSeq[n - (int)this.bufoffset];
            }
            return 0;
        }
        if (n < this.bSeq.length) {
            return this.bSeq[n];
        }
        return 0;
    }

    public boolean isBytes() {
        if (this.raf != null) {
            return false;
        }
        return this.bSeq != null && this.bSeq.length > 0;
    }

    public byte[] toBytes(int n) {
        if (this.isBytes()) {
            return this.bSeq;
        }
        return this.toBytes(0, -1, n);
    }

    protected int readBytes(long l, byte[] byArray, int n, int n2) {
        try {
            this.raf.seek(l);
            return this.raf.read(byArray, n, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    protected int readBases(int n, int n2) {
        try {
            if (this.bSeq.length < n2) {
                this.bSeq = new byte[n2];
            }
            this.bufend = this.bufoffset = (long)n;
            this.raf.seek((long)n + this.foffset);
            int n3 = this.raf.read(this.bSeq, 0, n2);
            this.bufend = this.bufoffset + (long)n3;
            return n3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public byte[] toBytes(int n, int n2, int n3) {
        if (n < 0) {
            n = 0;
        }
        if (this.bSeq != null) {
            int n4;
            if (n == 0 && n2 == this.bSeq.length) {
                return this.bSeq;
            }
            if (this.raf != null) {
                int n5;
                n4 = (int)this.flength;
                if (n2 > 0 && n2 < n4) {
                    n4 = n2;
                }
                if ((n5 = this.readBases(n, n4)) < 0) {
                    return null;
                }
                if (n5 == n4) {
                    return this.bSeq;
                }
            }
            n4 = this.bSeq.length - n;
            if (n2 > 0 && n2 < n4) {
                n4 = n2;
            }
            byte[] byArray = new byte[n4];
            System.arraycopy(this.bSeq, n, byArray, 0, n4);
            return byArray;
        }
        return null;
    }

    public char[] toChars(int n, int n2, int n3) {
        byte[] byArray = this.isBytes() ? this.bSeq : this.toBytes(n, n2, n3);
        if (n < 0) {
            n = 0;
        }
        if (byArray != null) {
            int n4 = byArray.length - n;
            if (n2 > 0 && n2 < n4) {
                n4 = n2;
            }
            char[] cArray = new char[n4];
            for (int i = 0; i < n4; ++i) {
                cArray[i] = (char)byArray[i + n];
            }
            return cArray;
        }
        return null;
    }

    public Object clone() {
        BioseqFiled bioseqFiled = (BioseqFiled)super.clone();
        return bioseqFiled;
    }

    public int getSeqtype() {
        byte[] byArray;
        int n = this.length();
        if (this.isBytes()) {
            byArray = this.bSeq;
        } else {
            n = Math.min(n, 8192);
            byArray = this.toBytes(0, n, 0);
        }
        SeqInfo seqInfo = SeqInfo.getSeqInfo(n, true, false);
        seqInfo.add(byArray, 0, n);
        return seqInfo.getKind();
    }

    public SeqInfo getSeqStats(int n, int n2) {
        byte[] byArray;
        if (this.isBytes()) {
            byArray = this.bSeq;
        } else {
            byArray = this.toBytes(n, n2, 0);
            n = 0;
        }
        SeqInfo seqInfo = SeqInfo.getSeqInfo(n2, false, true);
        seqInfo.add(byArray, n, n2);
        return seqInfo;
    }
}

