/*
 * Decompiled with CFR 0.152.
 */
package iubio.bioseq;

import iubio.bioseq.BaseKind;
import iubio.bioseq.SeqInfo;

class SeqKind
extends SeqInfo {
    public static int kMaxSeqtest = 500;
    public boolean shorttest = true;
    public boolean wantcrc = false;
    protected int na;
    protected int aa;
    protected int po;
    protected int nt;
    protected int nu;
    protected int ns;
    protected int no;
    protected int numa;
    protected int numg;
    protected int numc;
    protected int numt;
    protected int testlen;

    public SeqKind() {
        this.init(0);
    }

    public SeqKind(int n) {
        this.init(n);
    }

    public SeqKind(int n, boolean bl, boolean bl2) {
        this.shorttest = bl;
        this.wantcrc = bl2;
        this.init(n);
    }

    public void init(int n) {
        this.na = 0;
        this.aa = 0;
        this.po = 0;
        this.nt = 0;
        this.nu = 0;
        this.ns = 0;
        this.no = 0;
        this.numa = 0;
        this.numc = 0;
        this.numg = 0;
        this.numt = 0;
        this.basecount = 0;
        this.seqtype = 0;
        this.checksum = 0xFFFFFFFFL;
        this.testlen = this.shorttest && (n > kMaxSeqtest || n < 1) ? kMaxSeqtest : n;
    }

    public long getChecksum() {
        return this.checksum ^ 0xFFFFFFFFL;
    }

    public int[] getACGTcounts() {
        int n = this.basecount - this.numa - this.numc - this.numg - this.numt;
        return new int[]{this.numa, this.numc, this.numg, this.numt, n};
    }

    public int getKind() {
        this.seqtype = this.basecount < 2 || this.no > 0 || this.po + this.aa + this.na == 0 ? (short)0 : (this.po > 0 ? (short)4 : (this.aa == 0 ? (this.nu > this.nt ? (short)2 : (short)1) : (this.na > this.aa ? (short)3 : (short)4)));
        return this.seqtype;
    }

    private final void add1(int n) {
        ++this.basecount;
        if (BaseKind.isProtonly(n)) {
            ++this.po;
        } else if (BaseKind.isPrimenuc(n)) {
            ++this.na;
            if (BaseKind.isDnanuc(n)) {
                ++this.nt;
            } else if (BaseKind.isRnanuc(n)) {
                ++this.nu;
            }
            switch (n) {
                case 65: 
                case 97: {
                    ++this.numa;
                    break;
                }
                case 67: 
                case 99: {
                    ++this.numc;
                    break;
                }
                case 71: 
                case 103: {
                    ++this.numg;
                    break;
                }
                case 84: 
                case 116: {
                    ++this.numt;
                }
            }
        } else if (BaseKind.isAmino(n)) {
            ++this.aa;
        } else if (BaseKind.isSeqsym(n)) {
            ++this.ns;
        } else if (BaseKind.isAlphaseq(n)) {
            ++this.no;
        }
    }

    private final void addcrc(int n) {
        if (n >= 97 && n <= 122) {
            n -= 32;
        }
        this.checksum = BaseKind.crctab[((int)this.checksum ^ n) & 0xFF] ^ this.checksum >> 8;
    }

    public final void add(byte[] byArray, int n, int n2) {
        n2 = Math.min(n2, this.testlen);
        for (int i = 0; i < n2; ++i) {
            this.add(byArray[n + i]);
        }
        this.getKind();
    }

    public final void add(char[] cArray, int n, int n2) {
        n2 = Math.min(n2, this.testlen);
        for (int i = 0; i < n2; ++i) {
            this.add(cArray[n + i]);
        }
        this.getKind();
    }

    public final void add(String string, int n, int n2) {
        n2 = Math.min(n2, this.testlen);
        for (int i = 0; i < n2; ++i) {
            this.add(string.charAt(n + i));
        }
        this.getKind();
    }

    public final void add(int n) {
        if (n > 32 && (n < 48 || n > 57)) {
            this.add1(n);
            if (this.wantcrc) {
                this.addcrc(n);
            }
        }
    }
}

