/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import Acme.Fmt;
import flybase.AppResources;
import flybase.Debug;
import flybase.FastHashtable;
import flybase.FastProperties;
import flybase.FastVector;
import flybase.OpenString;
import iubio.bioseq.Bioseq;
import iubio.bioseq.SeqInfo;
import iubio.bioseq.SeqRange;
import iubio.readseq.BioseqDoc;
import iubio.readseq.DocItem;
import iubio.readseq.FeatureItem;
import iubio.readseq.FeatureNote;
import iubio.readseq.PrintableDocItem;
import iubio.readseq.XmlDoc;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class BioseqDocImpl
implements BioseqDoc,
Cloneable {
    public static String bioseqprop = "BioseqDoc";
    public static String gbfeatname = "Features";
    protected static FastHashtable biodockeys = new FastHashtable();
    protected static FastHashtable biodockinds = new FastHashtable();
    protected static FastHashtable biodoclabels = new FastHashtable();
    protected static String[] gbfeatures;
    protected static String[] gbqualifiers;
    protected FastVector rootdoc;
    protected FastVector featlist;
    protected Hashtable wantedFeatures;
    protected SeqRange wantedRange;
    protected boolean fFromForeignFormat;
    protected boolean featWrit;
    protected boolean dontWriteId;
    protected boolean notWantedFeature;
    protected boolean wantExtractionLoc;
    protected int docItemAt;
    protected DocItem curDocitem;
    protected FeatureItem curFieldItem;
    protected int lastlev = 1;
    protected boolean skipdocs;
    protected String lastfld;
    protected int inFeatures = 0;
    protected FastHashtable keepFields;
    protected int featStartItem;
    public int kLinewidth = 79;
    protected int indent;
    protected int subindent;
    protected int linesout;
    protected PrintWriter pr;
    public static final String sExtractionFeature = "extracted_range";
    public static final String sExtractRangeFeature = "extract_range";

    private static void getBioseqdocProperties() {
        BioseqDocImpl.putdocval("kUnknown", 0, "Other field");
        BioseqDocImpl.putdocval("kBioseqSet", 1, "Biosequence collection");
        BioseqDocImpl.putdocval("kBioseq", 2, "Biosequence record");
        BioseqDocImpl.putdocval("kBioseqDoc", 3, "Documentation");
        BioseqDocImpl.putdocval("kName", 10, "Locus name");
        BioseqDocImpl.putdocval("kDivision", 11, "Databank division");
        BioseqDocImpl.putdocval("kDataclass", 12, "Data class");
        BioseqDocImpl.putdocval("kDescription", 20, "Description");
        BioseqDocImpl.putdocval("kAccession", 30, "Accession");
        BioseqDocImpl.putdocval("kNid", 31, "NID (part id)");
        BioseqDocImpl.putdocval("kVersion", 32, "Version");
        BioseqDocImpl.putdocval("kKeywords", 40, "Keywords");
        BioseqDocImpl.putdocval("kSource", 50, "Organism source");
        BioseqDocImpl.putdocval("kTaxonomy", 51, "Organism taxonomy");
        BioseqDocImpl.putdocval("kReference", 60, "Reference number");
        BioseqDocImpl.putdocval("kAuthor", 61, "Reference author");
        BioseqDocImpl.putdocval("kTitle", 62, "Reference title");
        BioseqDocImpl.putdocval("kJournal", 63, "Reference journal");
        BioseqDocImpl.putdocval("kRefCrossref", 64, "Reference database ID (Medline)");
        BioseqDocImpl.putdocval("kRefSeqindex", 65, "Reference sequence index");
        BioseqDocImpl.putdocval("kFeatureTable", 70, "Feature table");
        BioseqDocImpl.putdocval("kFeatureItem", 71, "Feature item");
        BioseqDocImpl.putdocval("kFeatureNote", 72, "Feature note");
        BioseqDocImpl.putdocval("kFeatureKey", 73, "Feature name");
        BioseqDocImpl.putdocval("kFeatureValue", 74, "Feature value");
        BioseqDocImpl.putdocval("kFeatureLocation", 75, "Feature location");
        BioseqDocImpl.putdocval("kDate", 80, "Date");
        BioseqDocImpl.putdocval("kCrossRef", 90, "Database cross reference");
        BioseqDocImpl.putdocval("kComment", 100, "Comment ");
        BioseqDocImpl.putdocval("kSeqstats", 110, "Sequence statistics");
        BioseqDocImpl.putdocval("kNumA", 117, "No. A bases");
        BioseqDocImpl.putdocval("kNumC", 118, "No. C bases");
        BioseqDocImpl.putdocval("kNumG", 119, "No. G bases");
        BioseqDocImpl.putdocval("kNumT", 120, "No. T bases");
        BioseqDocImpl.putdocval("kNumN", 121, "No. other bases");
        BioseqDocImpl.putdocval("kSeqdata", 111, "Sequence data");
        BioseqDocImpl.putdocval("kSeqlen", 112, "Sequence length");
        BioseqDocImpl.putdocval("kSeqkind", 113, "Molecule kind");
        BioseqDocImpl.putdocval("kChecksum", 114, "Sequence checksum");
        BioseqDocImpl.putdocval("kSeqcircle", 115, "Circular sequence");
        BioseqDocImpl.putdocval("kStrand", 116, "Sequence strandedness");
        BioseqDocImpl.putdocval("kBlank", 200, "blank line");
    }

    private static void putdocval(String string, int n, String string2) {
        Integer n2 = new Integer(n);
        biodockeys.put(string, n2);
        biodockinds.put(n2, string);
        biodoclabels.put(n2, string2);
    }

    public static String[] getStandardQualifiersList() {
        if (gbqualifiers == null) {
            BioseqDocImpl.getStandardFeatureList();
        }
        return gbqualifiers;
    }

    public static String[] getStandardFeatureList() {
        if (gbfeatures == null) {
            try {
                String string;
                String string2 = System.getProperty(gbfeatname, gbfeatname);
                string2 = AppResources.global.findPath(string2 + ".properties");
                Debug.println("Feature list: " + string2);
                InputStream inputStream = AppResources.global.getStream(string2);
                DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
                FastVector fastVector = new FastVector();
                FastVector fastVector2 = new FastVector();
                boolean bl = false;
                do {
                    if ((string = dataInputStream.readLine()) == null) continue;
                    if ((string = string.trim()).indexOf("FEATURES") > 0) {
                        bl = false;
                        continue;
                    }
                    if (string.indexOf("QUALIFIERS") > 0) {
                        bl = true;
                        continue;
                    }
                    if (string.length() <= 0 || string.startsWith("#")) continue;
                    if (bl) {
                        fastVector2.addElement(string);
                    } else {
                        fastVector.addElement(string);
                    }
                    Debug.print(string + ", ");
                } while (string != null);
                gbfeatures = new String[fastVector.size()];
                fastVector.copyInto(gbfeatures);
                gbqualifiers = new String[fastVector2.size()];
                fastVector2.copyInto(gbqualifiers);
                Debug.println();
                Debug.println(" n = " + fastVector.size());
                inputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return gbfeatures;
    }

    public BioseqDocImpl() {
        this.rootdoc = new FastVector();
        this.featlist = new FastVector();
    }

    public BioseqDocImpl(BioseqDoc bioseqDoc) {
        this.setSourceDoc(bioseqDoc);
    }

    public abstract String getFieldName(int var1);

    public abstract String getBiodockey(String var1);

    public abstract void addDocLine(String var1);

    public void addDocLine(OpenString openString) {
        this.addDocLine(openString.toString());
    }

    public static String getBiodockey(int n) {
        return (String)biodockinds.get(new Integer(n));
    }

    public static String getBiodoclabel(int n) {
        return (String)biodoclabels.get(new Integer(n));
    }

    public Integer getBiodocInteger(String string) {
        String string2 = this.getBiodockey(string);
        return string2 == null ? null : (Integer)biodockeys.get(string2);
    }

    public int getBiodocKind(String string) {
        String string2 = this.getBiodockey(string);
        if (string2 == null) {
            return 0;
        }
        Integer n = (Integer)biodockeys.get(string2);
        if (n == null) {
            return 0;
        }
        return n;
    }

    protected static void getDocProperties(String string, FastProperties fastProperties, FastHashtable fastHashtable) {
        fastProperties.loadProperties(string);
        Enumeration enumeration = fastProperties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = fastProperties.getProperty(string2);
            fastHashtable.put(string3, string2);
        }
    }

    public Object clone() {
        try {
            Object object;
            int n;
            BioseqDocImpl bioseqDocImpl = (BioseqDocImpl)super.clone();
            if (this.rootdoc != null) {
                bioseqDocImpl.rootdoc = (FastVector)this.rootdoc.clone();
                for (n = 0; n < this.rootdoc.size(); ++n) {
                    object = bioseqDocImpl.rootdoc.elementAt(n);
                    if (object instanceof DocItem) {
                        object = ((DocItem)object).clone();
                    }
                    bioseqDocImpl.rootdoc.setElementAt(object, n);
                }
            }
            if (this.wantedFeatures != null) {
                // empty if block
            }
            if (this.featlist != null) {
                bioseqDocImpl.featlist = (FastVector)this.featlist.clone();
                for (n = 0; n < bioseqDocImpl.featlist.size(); ++n) {
                    object = bioseqDocImpl.featlist.elementAt(n);
                    if (object instanceof DocItem) {
                        object = ((DocItem)object).clone();
                    }
                    bioseqDocImpl.featlist.setElementAt(object, n);
                }
            }
            return bioseqDocImpl;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error(cloneNotSupportedException.toString());
        }
    }

    public String getID() {
        return this.getDocField(10);
    }

    public String getTitle() {
        return this.getDocField(20);
    }

    public boolean hasFeatures() {
        return this.featlist != null && this.featlist.size() > 0;
    }

    public boolean hasDocument() {
        return this.rootdoc != null && this.rootdoc.size() > 0;
    }

    public FastVector documents() {
        return this.rootdoc;
    }

    public FastVector features() {
        return this.featlist;
    }

    public void setSourceDoc(BioseqDoc bioseqDoc) {
        this.rootdoc = bioseqDoc.documents();
        this.featlist = bioseqDoc.features();
        if (bioseqDoc instanceof BioseqDocImpl) {
            this.copyWanted((BioseqDocImpl)bioseqDoc);
        }
        this.fFromForeignFormat = true;
    }

    public final String getDocField(int n) {
        DocItem docItem = this.findDocItem(this.rootdoc, n, 0);
        if (docItem == null) {
            return null;
        }
        return docItem.getValue();
    }

    public final String getDocField(FastVector fastVector, int n, int n2) {
        DocItem docItem = this.findDocItem(fastVector, n, n2);
        if (docItem == null) {
            return null;
        }
        return docItem.getValue();
    }

    public void deleteDocItem(int n) {
        DocItem docItem = this.findDocItem(this.rootdoc, n, 0);
        if (docItem != null) {
            this.rootdoc.removeElement(docItem);
        }
    }

    public void deleteDocItem(FastVector fastVector, int n, int n2) {
        DocItem docItem = this.findDocItem(fastVector, n, n2);
        if (docItem != null) {
            fastVector.removeElement(docItem);
        }
    }

    public final void replaceDocItem(int n, DocItem docItem) {
        if (docItem == null) {
            this.deleteDocItem(n);
        } else {
            DocItem docItem2 = this.findDocItem(this.rootdoc, n, 0);
            if (docItem2 != null && this.docItemAt > -1) {
                this.rootdoc.setElementAt(docItem, this.docItemAt);
            } else {
                this.addDocField(docItem);
            }
        }
    }

    public final DocItem findDocItem(int n, int n2) {
        return this.findDocItem(this.rootdoc, n, n2);
    }

    public DocItem findDocItem(FastVector fastVector, int n, int n2) {
        Object object = null;
        this.docItemAt = -1;
        if (fastVector != null) {
            int n3 = 0;
            for (int i = 0; i < fastVector.size(); ++i) {
                try {
                    DocItem docItem;
                    object = fastVector.elementAt(i);
                    if (object instanceof DocItem) {
                        docItem = (DocItem)object;
                        if (docItem.getKind() == n) {
                            this.docItemAt = i;
                            if (n3 == n2) {
                                return docItem;
                            }
                            ++n3;
                        }
                        continue;
                    }
                    if (!(object instanceof FastVector) || (docItem = this.findDocItem((FastVector)object, n, n2)) == null) continue;
                    return docItem;
                }
                catch (Exception exception) {
                    System.err.println("failure in getDocField(" + n + ") for object " + object);
                    exception.printStackTrace();
                }
            }
        }
        return null;
    }

    public final String getDocField(String string) {
        return this.getDocField(string, 0);
    }

    public final String getFeature(String string) {
        return this.getDocField(this.features(), string, 0);
    }

    public final String getDocField(String string, int n) {
        DocItem docItem = this.findDocItem(this.rootdoc, string, n);
        if (docItem == null) {
            return null;
        }
        return docItem.getValue();
    }

    public final String getDocField(FastVector fastVector, String string, int n) {
        DocItem docItem = this.findDocItem(fastVector, string, n);
        if (docItem == null) {
            return null;
        }
        return docItem.getValue();
    }

    public DocItem findDocItem(FastVector fastVector, String string, int n) {
        if (fastVector != null) {
            int n2 = 0;
            for (int i = 0; i < fastVector.size(); ++i) {
                DocItem docItem;
                Object object = fastVector.elementAt(i);
                if (object instanceof DocItem) {
                    docItem = (DocItem)object;
                    if (!docItem.sameName(string)) continue;
                    if (n2 == n) {
                        return docItem;
                    }
                    ++n2;
                    continue;
                }
                if (!(object instanceof FastVector) || (docItem = this.findDocItem((FastVector)object, string, n)) == null) continue;
                return docItem;
            }
        }
        return null;
    }

    public FeatureItem getCurFieldItem() {
        return this.curFieldItem;
    }

    public void setCurFieldItem(FeatureItem featureItem) {
        this.curFieldItem = featureItem;
    }

    public void setKeepField(int n) {
        if (this.keepFields == null) {
            this.keepFields = new FastHashtable();
        }
        Integer n2 = new Integer(n);
        this.keepFields.put(n2, n2);
    }

    protected boolean keepField(int n) {
        return this.keepFields == null || this.keepFields.get(new Integer(n)) != null;
    }

    public void setSkipDocs(boolean bl) {
        this.skipdocs = bl;
        if (bl) {
            this.setKeepField(10);
            this.setKeepField(20);
            this.setKeepField(30);
            this.setKeepField(111);
        } else {
            this.keepFields = null;
        }
    }

    public void addBasicName(String string) {
        int n;
        if (string == null) {
            return;
        }
        if ((string = string.trim()).indexOf("checksum") > 0) {
            n = string.indexOf("bases");
            if (n < 0) {
                n = string.indexOf(" bp");
            }
            if (n > 0) {
                while (n > 0 && string.charAt(n) != ',') {
                    --n;
                }
                if (n > 0) {
                    string = string.substring(0, n);
                }
            }
        }
        if ((n = string.indexOf(32)) <= 0) {
            n = string.length();
        }
        if (n > 30) {
            n = 30;
        }
        if (n == string.length()) {
            this.replaceDocField(10, string);
        } else {
            String string2 = string.substring(0, n);
            this.replaceDocField(10, string2);
            this.addDocField(20, string);
        }
    }

    public void addComment(String string) {
        this.addDocField(this.getFieldName(100), string, 1, false);
    }

    public void addDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
        String string = simpleDateFormat.format(date);
        this.addDocField(this.getFieldName(80), string, 1, false);
    }

    public void addSequenceStats(Bioseq bioseq) {
        SeqInfo seqInfo = bioseq.getSeqStats();
        this.replaceDocField(112, String.valueOf(bioseq.length()));
        this.replaceDocField(113, seqInfo.getKindLabel());
        int[] nArray = null;
        if (seqInfo.getKind() != 4) {
            nArray = seqInfo.getACGTcounts();
        }
        if (nArray != null) {
            this.replaceDocField(117, String.valueOf(nArray[0]));
            this.replaceDocField(118, String.valueOf(nArray[1]));
            this.replaceDocField(119, String.valueOf(nArray[2]));
            this.replaceDocField(120, String.valueOf(nArray[3]));
            this.replaceDocField(121, String.valueOf(nArray[4]));
        }
    }

    public void addDocText(String string) {
        this.inFeatures = 0;
        this.addText(string);
    }

    public void addFeatureText(String string) {
        this.inFeatures = 2;
        this.addText(string);
    }

    protected void addText(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            this.addDocLine(stringTokenizer.nextToken());
        }
    }

    public void addDocField(DocItem docItem) {
        if (docItem != null) {
            this.curDocitem = docItem;
            this.rootdoc.addElement(docItem);
        }
    }

    public void addDocField(int n, String string) {
        String string2 = this.getFieldName(n);
        this.addDocField(string2, string, n, 1, false);
    }

    public void replaceDocField(int n, String string) {
        String string2 = this.getFieldName(n);
        DocItem docItem = new DocItem(string2, string, n, 1);
        this.replaceDocItem(n, docItem);
    }

    public void addDocField(String string, String string2, int n, boolean bl) {
        int n2 = this.getBiodocKind(string);
        this.addDocField(string, string2, n2, n, bl);
    }

    public void addDocField(String string, String string2, int n, int n2, boolean bl) {
        if (!this.keepField(n)) {
            return;
        }
        if (bl && this.curDocitem != null) {
            this.curDocitem.appendValue(string2);
        } else {
            this.addDocField(new DocItem(string, string2, n, n2));
            this.lastlev = n2;
        }
    }

    public void addDocField(String string, String string2, String string3, int n, boolean bl) {
        int n2 = this.getBiodocKind(string);
        this.addDocField(string, string2, string3, n2, n, bl);
    }

    public void addDocField(String string, String string2, String string3, int n, int n2, boolean bl) {
        if (!this.keepField(n)) {
            return;
        }
        if (bl && this.curDocitem != null) {
            this.curDocitem.appendValue(string2);
        } else {
            this.addDocField(new DocItem(string, string2, string3, n, n2));
            this.lastlev = n2;
        }
    }

    public void addFeatureNote(FeatureItem featureItem, String string, String string2) {
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        FeatureNote featureNote = new FeatureNote(string, string2);
        if (featureItem != null) {
            featureItem.putNote(featureNote);
        }
    }

    public void addFeatureNote(FeatureItem featureItem, String string, String string2, String string3) {
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        FeatureNote featureNote = new FeatureNote(string, string2, string3);
        if (featureItem != null) {
            featureItem.putNote(featureNote);
        }
    }

    public void addFeatureNote(FeatureItem featureItem, String string) {
        if (string != null) {
            String string2;
            int n = string.indexOf(61);
            if (n < 0) {
                string2 = string;
                string = "";
            } else {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
            }
            this.addFeatureNote(featureItem, string2, string);
        }
    }

    public void addFeatureNote(String string, FeatureItem featureItem, String string2) {
        if (string2 != null) {
            String string3;
            int n = string2.indexOf(61);
            if (n < 0) {
                string3 = string2;
                string2 = "";
            } else {
                string3 = string2.substring(0, n);
                string2 = string2.substring(n + 1);
            }
            this.addFeatureNote(featureItem, string3, string2, string);
        }
    }

    public void addFeatureNote(String string, String string2) {
        this.addFeatureNote(this.curFieldItem, string, string2);
    }

    public void addFeatureNote(String string) {
        this.addFeatureNote(this.curFieldItem, string);
    }

    public void addFeature(FeatureItem featureItem) {
        if (featureItem != null) {
            this.featlist.addElement(featureItem);
            this.curFieldItem = featureItem;
        }
    }

    public FeatureItem addFeature(String string, SeqRange seqRange) {
        this.addFeature(new FeatureItem(string, seqRange, 4));
        return this.curFieldItem;
    }

    public void addFeatures(FastVector fastVector) {
        FastVector fastVector2 = this.features();
        for (int i = 0; i < fastVector.size(); ++i) {
            Object object = fastVector.elementAt(i);
            if (!(object instanceof FeatureItem) || this.findFeature(object) != null) continue;
            object = ((FeatureItem)object).clone();
            fastVector2.addElement((FeatureItem)object);
        }
    }

    public void addFeature(String string, String string2, int n, boolean bl) {
        if (n == 4 ? !this.keepField(71) : n == 5 && !this.keepField(72)) {
            return;
        }
        if (n == 4) {
            if (bl && this.curFieldItem != null) {
                this.curFieldItem.appendValue(string2);
            } else {
                this.addFeature(new FeatureItem(string, string2, 4));
            }
        } else if (this.curFieldItem != null) {
            if (!string2.startsWith("/")) {
                this.curFieldItem.appendNote(string2);
            } else {
                this.addFeatureNote(this.curFieldItem, string2);
            }
        }
    }

    public void addFeature(String string, String string2, String string3, int n, boolean bl) {
        if (n == 4) {
            if (!this.keepField(71)) {
                System.out.println("level == kFeatField, !keepField(kFeatureItem)");
                return;
            }
        } else if (n == 5 && !this.keepField(72)) {
            return;
        }
        if (n == 4) {
            if (bl && this.curFieldItem != null) {
                this.curFieldItem.appendValue(string2);
            } else {
                this.addFeature(new FeatureItem(string, string2, string3, 4));
            }
        } else if (this.curFieldItem != null) {
            if (!string2.startsWith("/")) {
                this.curFieldItem.appendNote(string2);
            } else {
                this.addFeatureNote(string3, this.curFieldItem, string2);
            }
        }
    }

    public void deleteFeature(String string, SeqRange seqRange) {
        FeatureItem featureItem = this.findFeature(string, seqRange);
        if (featureItem != null) {
            this.features().removeElement(featureItem);
        }
    }

    public FeatureItem findFeature(String string, SeqRange seqRange) {
        FastVector fastVector = this.features();
        int n = fastVector.size();
        for (int i = 0; i < n; ++i) {
            FeatureItem featureItem = (FeatureItem)fastVector.elementAt(i);
            if (!(seqRange == null ? featureItem.getName().equals(string) : (string == null ? featureItem.getLocation().intersects(seqRange) : featureItem.getName().equals(string) && featureItem.getLocation().intersects(seqRange)))) continue;
            return featureItem;
        }
        return null;
    }

    public FeatureItem findFeature(String string) {
        FastVector fastVector = this.features();
        int n = fastVector.size();
        for (int i = 0; i < n; ++i) {
            FeatureItem featureItem = (FeatureItem)fastVector.elementAt(i);
            if (!featureItem.getName().equals(string)) continue;
            return featureItem;
        }
        return null;
    }

    public FeatureItem findFeature(Object object) {
        FastVector fastVector = this.features();
        int n = fastVector.size();
        for (int i = 0; i < n; ++i) {
            FeatureItem featureItem = (FeatureItem)fastVector.elementAt(i);
            if (!featureItem.equals(object)) continue;
            return featureItem;
        }
        return null;
    }

    public final FeatureItem[] findFeatures(SeqRange seqRange) {
        return this.findFeatures((String)null, seqRange);
    }

    public final FeatureItem[] findFeatures(String string) {
        return this.findFeatures(string, (SeqRange)null);
    }

    public FeatureItem[] findFeatures(String string, SeqRange seqRange) {
        Vector vector = this.findFeatures(string, seqRange, null);
        Object[] objectArray = new FeatureItem[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public final Vector findFeatures(SeqRange seqRange, Vector vector) {
        return this.findFeatures((String)null, seqRange, vector);
    }

    public final Vector findFeatures(String string, Vector vector) {
        return this.findFeatures(string, null, vector);
    }

    public Vector findFeatures(String string, SeqRange seqRange, Vector vector) {
        if (vector == null) {
            vector = new Vector<FeatureItem>();
        }
        FastVector fastVector = this.features();
        int n = fastVector.size();
        for (int i = 0; i < n; ++i) {
            FeatureItem featureItem = (FeatureItem)fastVector.elementAt(i);
            if (seqRange == null) {
                if (!featureItem.getName().equals(string)) continue;
                vector.addElement(featureItem);
                continue;
            }
            if (string != null && !featureItem.getName().equals(string) || !featureItem.getLocation().intersects(seqRange)) continue;
            vector.addElement(featureItem);
        }
        return vector;
    }

    public Vector findFeatures(Hashtable hashtable, SeqRange seqRange, Vector vector) {
        if (hashtable == null) {
            return this.findFeatures(seqRange, (Vector)vector);
        }
        if (vector == null) {
            vector = new Vector<FeatureItem>();
        }
        FastVector fastVector = this.features();
        int n = fastVector.size();
        for (int i = 0; i < n; ++i) {
            FeatureItem featureItem = (FeatureItem)fastVector.elementAt(i);
            String string = featureItem.getName();
            if (hashtable.get(string) == null || seqRange != null && !featureItem.getLocation().intersects(seqRange)) continue;
            vector.addElement(featureItem);
        }
        return vector;
    }

    public String[] getFeaturesAt(SeqRange seqRange) {
        Vector<String> vector = new Vector<String>();
        FastVector fastVector = this.features();
        int n = fastVector.size();
        for (int i = 0; i < n; ++i) {
            FeatureItem featureItem = (FeatureItem)fastVector.elementAt(i);
            if (!featureItem.getLocation().intersects(seqRange)) continue;
            vector.addElement(featureItem.getName());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void updateRange(int n, int n2, int n3, byte[] byArray) {
        FastVector fastVector = this.features();
        int n4 = fastVector.size();
        for (int i = 0; i < n4; ++i) {
            FeatureItem featureItem = (FeatureItem)fastVector.elementAt(i);
            featureItem.updateRange(n, n2, n3, byArray);
        }
    }

    public final void removeRange(SeqRange seqRange) {
        for (SeqRange seqRange2 = seqRange; seqRange2 != null; seqRange2 = seqRange2.next()) {
            this.updateRange(1, seqRange2.start(), seqRange2.nbases(), null);
        }
    }

    public final void insertRange(SeqRange seqRange) {
        for (SeqRange seqRange2 = seqRange; seqRange2 != null; seqRange2 = seqRange2.next()) {
            this.updateRange(2, seqRange2.start(), seqRange2.nbases(), null);
        }
    }

    public Hashtable wantedFeatures() {
        return this.wantedFeatures;
    }

    public SeqRange wantedRange() {
        return this.wantedRange;
    }

    public boolean isNotWantedFeature() {
        return this.notWantedFeature;
    }

    protected void copyWanted(BioseqDocImpl bioseqDocImpl) {
        this.setWantedFeatures(bioseqDocImpl.wantedFeatures, bioseqDocImpl.wantedRange);
    }

    public void setWantedFeatures(Hashtable hashtable) {
        this.setWantedFeatures(hashtable, null);
    }

    public void setWantedFeatures(Hashtable hashtable, SeqRange seqRange) {
        boolean bl = true;
        if (hashtable != null) {
            try {
                this.wantExtractionLoc = hashtable.size() == 1 && hashtable.containsKey(sExtractRangeFeature);
                bl = !"false".equals(hashtable.elements().nextElement());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setWantedFeatures(bl, hashtable, seqRange);
    }

    public void setWantedFeatures(boolean bl, Hashtable hashtable, SeqRange seqRange) {
        this.wantedFeatures = hashtable;
        this.wantedRange = seqRange;
        this.notWantedFeature = !bl;
    }

    public final SeqRange getFeatureRanges(int n, int n2) {
        SeqRange seqRange;
        this.wantedRange = seqRange = this.getFeatureRanges(this.wantedFeatures, n, n2);
        return seqRange;
    }

    public SeqRange getFeatureRanges(Hashtable hashtable, int n, int n2) {
        if (hashtable == null) {
            return null;
        }
        boolean bl = false;
        FastVector fastVector = this.features();
        boolean bl2 = hashtable.size() == 1 && hashtable.containsKey(sExtractRangeFeature);
        SeqRange seqRange = new SeqRange();
        SeqRange seqRange2 = this.wantedRange != null && !this.wantedRange.isEmpty() ? this.wantedRange : new SeqRange(n, n2);
        int n3 = fastVector.size();
        for (int i = 0; i < n3; ++i) {
            FeatureItem featureItem = (FeatureItem)fastVector.elementAt(i);
            String string = featureItem.getName();
            if (hashtable.get(string) == null) continue;
            bl = true;
            SeqRange seqRange3 = featureItem.getLocation();
            if (!seqRange3.intersectsMax(seqRange2)) continue;
            if (bl2) {
                seqRange = seqRange3;
                break;
            }
            seqRange = seqRange.joinRange(seqRange3);
        }
        if (this.notWantedFeature) {
            if (bl) {
                seqRange = seqRange.invert(n2);
            } else {
                return null;
            }
        }
        if (Debug.isOn) {
            Debug.println("getFeatureRanges: " + seqRange);
        }
        return seqRange;
    }

    public int linesWritten() {
        return this.linesout;
    }

    public int getIndent() {
        return this.indent;
    }

    final String spaces(int n) {
        return Fmt.fmt("", n);
    }

    protected String getFieldLabel(DocItem docItem) {
        return this.getFieldLabel(docItem.getLevel(), docItem);
    }

    public String getContinueLabel(DocItem docItem) {
        switch (docItem.getLevel()) {
            default: {
                return this.getFieldLabel(3, docItem);
            }
            case 4: 
            case 5: 
            case 6: 
        }
        return this.getFieldLabel(6, docItem);
    }

    protected String getFieldLabel(int n, DocItem docItem) {
        this.indent = 5;
        return Fmt.fmt(docItem.getName(), this.indent, 2);
    }

    protected String getFieldValue(DocItem docItem) {
        char c;
        String string = docItem.getValue();
        if (string != null && string.length() > 1 && docItem.getLevel() == 5 && (c = string.charAt(0)) != '\"' && c != '\'' && (c < '0' || c > '9')) {
            string = '\"' + string + '\"';
        }
        return string;
    }

    protected final String getTrimFieldValue(DocItem docItem) {
        return this.getTrimFieldValue(docItem.getValue());
    }

    protected String getTrimFieldValue(String string) {
        if (string != null) {
            char c;
            string = string.replace('\n', ' ');
            int n = (string = string.trim()).length();
            if (n > 1 && ((c = string.charAt(0)) == '\"' || c == '\'') && string.charAt(n - 1) == c) {
                string = string.substring(1, n - 1);
            }
        }
        return string;
    }

    public void setOutput(Writer writer) {
        if (writer instanceof PrintWriter) {
            this.pr = (PrintWriter)writer;
        } else {
            BufferedWriter bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
            this.pr = new PrintWriter(bufferedWriter);
        }
        this.linesout = 0;
        this.indent = 0;
    }

    public void setOutput(OutputStream outputStream) {
        BufferedOutputStream bufferedOutputStream = outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream);
        this.pr = new PrintWriter(bufferedOutputStream);
        this.indent = 0;
        this.linesout = 0;
    }

    public int writeTo(Writer writer) {
        return this.writeTo(writer, false);
    }

    public int writeTo(Writer writer, boolean bl) {
        this.dontWriteId = !bl;
        this.setOutput(writer);
        this.writeAllText();
        return this.linesWritten();
    }

    public int compareTo(Writer writer, BioseqDocImpl bioseqDocImpl) {
        int n;
        this.setOutput(writer);
        int n2 = this.compareDocVectors("Document", this.documents(), bioseqDocImpl.documents());
        if (n2 == 0 && this.documents().size() > 0) {
            this.pr.println("# Document is same for n=" + this.documents().size());
        }
        if ((n = this.compareDocVectors("Features", this.features(), bioseqDocImpl.features())) == 0 && this.features().size() > 0) {
            this.pr.println("# Features are same for n=" + this.features().size());
        }
        return this.linesWritten();
    }

    protected int compareDocVectors(String string, FastVector fastVector, FastVector fastVector2) {
        boolean bl;
        int n = 0;
        if (fastVector == null && fastVector2 == null) {
            return 0;
        }
        if (fastVector == null || fastVector2 == null) {
            return this.diff(string + " null", String.valueOf(fastVector == null), String.valueOf(fastVector2 == null));
        }
        if (fastVector.size() != fastVector2.size()) {
            n += this.diff(string + " count: ", String.valueOf(fastVector.size()), String.valueOf(fastVector2.size()));
        }
        boolean bl2 = bl = this.documents() == fastVector;
        if (bl) {
            int n2 = 0;
            int n3 = 0;
            Enumeration enumeration = biodockinds.keys();
            while (enumeration.hasMoreElements()) {
                Integer n4 = (Integer)enumeration.nextElement();
                n2 = n4;
                n3 = 0;
                boolean bl3 = true;
                while (bl3) {
                    DocItem docItem = this.findDocItem(fastVector, n2, n3);
                    DocItem docItem2 = this.findDocItem(fastVector2, n2, n3);
                    boolean bl4 = bl3 = docItem != null && docItem2 != null;
                    if (bl3) {
                        n += this.compareDocItems("Document", docItem, docItem2);
                    } else if (docItem == null && docItem2 != null) {
                        string = BioseqDocImpl.getBiodoclabel(docItem2.getKind());
                        if (n3 > 0) {
                            string = string + " " + String.valueOf(n3 + 1);
                        }
                        n += this.compareDocItems(string, docItem, docItem2);
                    }
                    ++n3;
                }
            }
        } else {
            int n5 = Math.min(fastVector.size(), fastVector2.size());
            for (int i = 0; i < n5; ++i) {
                n += this.compareDocItems(string, (DocItem)fastVector.elementAt(i), (DocItem)fastVector2.elementAt(i));
            }
        }
        return n;
    }

    protected int compareDocItems(String string, DocItem docItem, DocItem docItem2) {
        int n = 0;
        if (docItem == null && docItem2 == null) {
            return 0;
        }
        if (docItem == null || docItem2 == null) {
            String string2 = docItem == null ? "(missing)" : this.getTrimFieldValue(docItem);
            String string3 = docItem2 == null ? "(missing)" : this.getTrimFieldValue(docItem2);
            return n += this.diff(string, string2, string3);
        }
        boolean bl = string.startsWith("Doc");
        if (!docItem.equals(docItem2)) {
            if (bl && !docItem.sameKind(docItem2)) {
                n += this.diff("kind: ", BioseqDocImpl.getBiodoclabel(docItem.getKind()), BioseqDocImpl.getBiodoclabel(docItem2.getKind()));
            }
            if (!bl && !docItem.sameName(docItem2)) {
                n += this.diff("key: ", docItem.getName(), docItem2.getName());
            }
            if (!docItem.sameValue(docItem2.getValue())) {
                String string4;
                string = BioseqDocImpl.getBiodoclabel(docItem.getKind()) + " value: ";
                String string5 = this.getTrimFieldValue(docItem);
                if (!string5.equals(string4 = this.getTrimFieldValue(docItem2))) {
                    n += this.diff(string, string5, string4);
                }
            }
        }
        if (docItem instanceof FeatureItem && docItem2 instanceof FeatureItem) {
            n += this.compareDocVectors("Notes ", ((FeatureItem)docItem).notes, ((FeatureItem)docItem2).notes);
        }
        return n;
    }

    protected int diff(String string, String string2, String string3) {
        this.pr.print(Fmt.fmt(string, 15, 2) + " ");
        this.pr.print(Fmt.fmt(string2, 15));
        this.pr.print(" != ");
        this.pr.print(Fmt.fmt(string3, 15));
        this.pr.println();
        ++this.linesout;
        return 1;
    }

    public void writeAllText() {
        this.featWrit = false;
        this.writeTextTop(this.rootdoc, true);
        if (!this.featWrit && this.features().size() > 0) {
            String string = this.getFieldName(70);
            this.writeDocItem(new DocItem(string, "", 70, 1), true);
        }
        this.pr.flush();
    }

    public void writeDocumentText() {
        this.writeTextTop(this.documents(), false);
    }

    public void writeFeatureText() {
        this.writeTextTop(this.features(), false);
    }

    public String getDocumentText() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.setOutput(new PrintWriter(byteArrayOutputStream));
        this.writeDocumentText();
        this.pr.flush();
        return byteArrayOutputStream.toString();
    }

    public String getFeatureText() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.setOutput(new PrintWriter(byteArrayOutputStream));
        this.writeFeatureText();
        this.pr.flush();
        return byteArrayOutputStream.toString();
    }

    protected void writeTextTop(FastVector fastVector, boolean bl) {
        this.writeDocVector(fastVector, bl);
    }

    protected void writeDocVector(FastVector fastVector, boolean bl) {
        for (int i = 0; i < fastVector.size(); ++i) {
            this.writeDocItem((DocItem)fastVector.elementAt(i), bl);
        }
    }

    protected boolean wantFeature(DocItem docItem) {
        String string = docItem.getName();
        if (sExtractRangeFeature.equals(string)) {
            return false;
        }
        if (sExtractionFeature.equals(string)) {
            return true;
        }
        if (this.wantedFeatures == null || this.wantExtractionLoc) {
            return true;
        }
        String string2 = (String)this.wantedFeatures.get(string);
        if (string2 == null) {
            return this.notWantedFeature;
        }
        if ("true".equals(string2)) {
            return true;
        }
        if ("false".equals(string2)) {
            return false;
        }
        return this.notWantedFeature;
    }

    protected void writeExtractionFeature() {
        if (this.wantedFeatures != null && this.wantedRange != null) {
            String string = this instanceof XmlDoc ? "" : "\"";
            FeatureItem featureItem = new FeatureItem(sExtractionFeature, this.wantedRange, 4);
            featureItem.putNote(new FeatureNote("/note", string + "Range of sequence extracted from original, due to feature selection." + "  Feature locations are not valid for this sequence, but for original." + string));
            this.writeDocItem(featureItem, false);
        }
    }

    protected boolean writeKeyValue(DocItem docItem) {
        String string = this.getFieldLabel(docItem);
        String string2 = this.getFieldValue(docItem);
        if (string != null) {
            if (docItem instanceof PrintableDocItem) {
                ((PrintableDocItem)((Object)docItem)).print(this.pr, this, string, string2);
            } else {
                this.pr.print(string);
                if (docItem.getLevel() == 5) {
                    this.indent += this.subindent;
                }
                while (string2 != null) {
                    if ((string2 = this.writeWrapText(string2, this.indent, this.kLinewidth)) == null) continue;
                    String string3 = this.getContinueLabel(docItem);
                    this.pr.print(string3);
                }
            }
            return true;
        }
        return false;
    }

    protected void adjustFeatureLoc(DocItem docItem) {
        if (!this.wantExtractionLoc || docItem instanceof FeatureItem) {
            // empty if block
        }
    }

    protected void writeDocItem(DocItem docItem, boolean bl) {
        switch (docItem.getKind()) {
            case 111: {
                return;
            }
            case 10: {
                if (this.dontWriteId) break;
                this.writeKeyValue(docItem);
                break;
            }
            case 70: {
                if (this.featWrit || !this.writeKeyValue(docItem) || !bl) break;
                this.writeDocVector(this.features(), bl);
                this.writeExtractionFeature();
                this.featWrit = true;
                break;
            }
            case 71: {
                if (!this.wantFeature(docItem) || !this.writeKeyValue(docItem) || !(docItem instanceof FeatureItem)) break;
                FeatureItem featureItem = (FeatureItem)docItem;
                if (featureItem.notes == null) break;
                this.writeDocVector(featureItem.notes, false);
                break;
            }
            case 72: {
                this.writeKeyValue(docItem);
                break;
            }
            default: {
                if (!this.wantFeature(docItem)) break;
                this.writeKeyValue(docItem);
            }
        }
    }

    public String writeWrapText(String string) {
        return this.writeWrapText(string, this.indent, this.kLinewidth);
    }

    protected String writeWrapText(String string, int n, int n2) {
        String string2 = null;
        int n3 = n2 - n;
        int n4 = string.length();
        int n5 = n3 + 2;
        int n6 = string.indexOf(10);
        if (n6 < 0) {
            n6 = string.indexOf(13);
        }
        if (n6 >= 0 && n6 <= n5) {
            if (n6 < n4) {
                string2 = string.substring(n6 + 1).trim();
            }
            string = string.substring(0, n6);
        } else if (n4 > n3) {
            n6 = string.lastIndexOf(32, n5);
            if (n6 < 0 && (n6 = string.lastIndexOf(44, n5)) > 0) {
                ++n6;
            }
            if (n6 < 0 && (n6 = string.lastIndexOf(59, n5)) > 0) {
                ++n6;
            }
            if (n6 < 0 && (n6 = string.lastIndexOf(46, n5)) > 0) {
                ++n6;
            }
            if (n6 < 0) {
                n6 = n3;
            }
            if (n6 > 10) {
                string2 = string.substring(n6).trim();
                string = string.substring(0, n6);
            }
        }
        this.pr.println(string);
        ++this.linesout;
        return string2;
    }

    static {
        BioseqDocImpl.getBioseqdocProperties();
    }
}

