/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import Acme.Fmt;
import flybase.FastProperties;
import flybase.OpenString;
import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqReaderIface;
import iubio.readseq.BioseqWriterIface;

public class BioseqFormats {
    public static int kNoformat = -1;
    public static int kUnknown = 0;
    public static int kMaxFormat = 30;
    public static int kIG = 1;
    public static int kGenBank = 2;
    public static int kNBRF = 3;
    public static int kEMBL = 4;
    public static int kGCG = 5;
    public static int kStrider = 6;
    public static int kFitch = 7;
    public static int kPearson = 8;
    public static int kZuker = 9;
    public static int kOlsen = 10;
    public static int kPhylip2 = 11;
    public static int kPhylip4;
    public static int kPhylip;
    public static int kPlain;
    public static int kPIR;
    public static int kMSF;
    public static int kASN1;
    public static int kPAUP;
    public static int kPretty;
    static int nforms;
    static BioseqFormat[] formats;
    public static String tablestr;

    public static int nFormats() {
        return nforms;
    }

    public static int register(BioseqFormat bioseqFormat) {
        if (formats == null) {
            formats = new BioseqFormat[kMaxFormat];
            nforms = 0;
            BioseqFormats.formats[0] = new BioseqFormat();
        }
        if (formats.length + 1 <= nforms) {
            int n = nforms * 2;
            BioseqFormat[] bioseqFormatArray = new BioseqFormat[n];
            System.arraycopy(formats, 0, bioseqFormatArray, 0, nforms);
            formats = bioseqFormatArray;
        }
        BioseqFormats.formats[++BioseqFormats.nforms] = bioseqFormat;
        bioseqFormat.setFormatID(nforms);
        return nforms;
    }

    public static int indexFromFormat(int n) {
        return n;
    }

    public static BioseqFormat bioseqFormat(int n) {
        if (n >= 0 && n <= nforms) {
            return formats[n];
        }
        return null;
    }

    public static void formatTestInit() {
        for (int i = 0; i <= nforms; ++i) {
            formats[i].formatTestInit();
        }
    }

    public static int recordStartLine(int n) {
        return formats[n].recordStartLine();
    }

    public static int formatTestLikelihood(int n) {
        return formats[n].formatTestLikelihood();
    }

    public static boolean formatTestLine(int n, OpenString openString, int n2, int n3) {
        return formats[n].formatTestLine(openString, n2, n3);
    }

    public static boolean formatTestLine(int n, String string, int n2, int n3) {
        return formats[n].formatTestLine(new OpenString(string), n2, n3);
    }

    public static String formatName(int n) {
        try {
            return formats[n].formatName();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String formatNameFromIndex(int n) {
        if (n >= 0 && n <= nforms) {
            boolean bl;
            String string = formats[n].formatName();
            boolean bl2 = !formats[n].canread();
            boolean bl3 = bl = !formats[n].canwrite();
            if (bl2 && bl) {
                string = string + " [no read/write]";
            } else if (bl2) {
                string = string + " [write only]";
            } else if (bl) {
                string = string + " [read only]";
            }
            return string;
        }
        return "";
    }

    static final String spc(boolean bl, String string, int n, int n2) {
        if (bl) {
            string = Fmt.fmt(string, n, n2);
            return string;
        }
        return string;
    }

    static final String isyes(boolean bl) {
        if (bl) {
            return "yes ";
        }
        return "-- ";
    }

    public static String getInfo(int n, String string) {
        String string2 = "\t";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = true;
        boolean bl8 = true;
        if (string.indexOf("tab") >= 0) {
            string2 = "\t";
        } else if (string.indexOf("space") >= 0) {
            bl3 = true;
            string2 = "  ";
        } else if (string.indexOf("html") >= 0) {
            bl2 = true;
            string2 = "</TD><TD>";
        } else if (string.indexOf("short") >= 0) {
            bl6 = true;
            bl3 = true;
            string2 = "  ";
        }
        if (string.indexOf("noread") >= 0) {
            bl7 = false;
        }
        if (string.indexOf("nowrite") >= 0) {
            bl8 = false;
        }
        if (string.indexOf("toc") >= 0) {
            bl4 = true;
        }
        if (string.indexOf("href") >= 0) {
            bl5 = true;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string.indexOf("header") >= 0) {
            if (bl2) {
                if (string.indexOf("header1") < 0) {
                    stringBuffer.append(tablestr);
                }
                stringBuffer.append("<TR bgcolor=\"#99CCFF\"><TH align=left>");
                string2 = "</TH><TH align=left>";
            }
            stringBuffer.append(BioseqFormats.spc(bl3, "ID", 3, 0));
            stringBuffer.append(string2);
            stringBuffer.append(BioseqFormats.spc(bl3, "Name", 14, 2));
            stringBuffer.append(string2);
            if (bl7) {
                stringBuffer.append(BioseqFormats.spc(bl3, "Read", 5, 0));
                stringBuffer.append(string2);
            }
            if (bl8) {
                stringBuffer.append(BioseqFormats.spc(bl3, "Write", 5, 0));
                stringBuffer.append(string2);
            }
            if (!bl6) {
                stringBuffer.append(BioseqFormats.spc(bl3, "Int'leaf", 8, 0));
                stringBuffer.append(string2);
            }
            stringBuffer.append(BioseqFormats.spc(bl3, "Features", 8, 0));
            stringBuffer.append(string2);
            stringBuffer.append(BioseqFormats.spc(bl3, "Sequence", 8, 0));
            stringBuffer.append(string2);
            if (!bl6) {
                stringBuffer.append(BioseqFormats.spc(bl3, "Suffix", 6, 2));
                stringBuffer.append(string2);
                stringBuffer.append(BioseqFormats.spc(false, "Content-type", 19, 2));
            }
            if (bl2) {
                stringBuffer.append("</TH></TR>");
            }
        } else if (string.indexOf("footer") >= 0) {
            if (bl2) {
                stringBuffer.append("</TABLE>");
            }
        } else {
            BioseqFormat bioseqFormat = BioseqFormats.bioseqFormat(n);
            if (bioseqFormat != null && (bl8 || !bl7 || bioseqFormat.canread()) && (bl7 || !bl8 || bioseqFormat.canwrite())) {
                String string3 = String.valueOf(bioseqFormat.formatID());
                if (bl2) {
                    stringBuffer.append("<TR><TD>");
                    if (bl4) {
                        stringBuffer.append("<A href=\"#fmt" + string3 + "\">");
                    } else if (bl5) {
                        stringBuffer.append("<A name=\"fmt" + string3 + "\">");
                    }
                }
                stringBuffer.append(BioseqFormats.spc(bl3, string3, 3, 0));
                if (bl4 || bl5) {
                    stringBuffer.append("</A>");
                }
                stringBuffer.append(string2);
                stringBuffer.append(BioseqFormats.spc(bl3, bioseqFormat.formatName(), 14, 2));
                stringBuffer.append(string2);
                if (bl7) {
                    stringBuffer.append(BioseqFormats.spc(bl3, BioseqFormats.isyes(bioseqFormat.canread()), 5, 0));
                    stringBuffer.append(string2);
                }
                if (bl8) {
                    stringBuffer.append(BioseqFormats.spc(bl3, BioseqFormats.isyes(bioseqFormat.canwrite()), 5, 0));
                    stringBuffer.append(string2);
                }
                if (!bl6) {
                    stringBuffer.append(BioseqFormats.spc(bl3, BioseqFormats.isyes(bioseqFormat.interleaved()), 8, 0));
                    stringBuffer.append(string2);
                }
                stringBuffer.append(BioseqFormats.spc(bl3, BioseqFormats.isyes(bioseqFormat.hasdoc()), 8, 0));
                stringBuffer.append(string2);
                stringBuffer.append(BioseqFormats.spc(bl3, BioseqFormats.isyes(bioseqFormat.hasseq()), 8, 0));
                stringBuffer.append(string2);
                if (!bl6) {
                    stringBuffer.append(BioseqFormats.spc(bl3, bioseqFormat.formatSuffix(), 6, 2));
                    stringBuffer.append(string2);
                    stringBuffer.append(BioseqFormats.spc(false, bioseqFormat.contentType(), 19, 2));
                }
                if (bl2) {
                    stringBuffer.append("</TD></TR>");
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String formatSuffixFromIndex(int n) {
        return BioseqFormats.formatSuffix(n);
    }

    public static String formatSuffix(int n) {
        if (n >= 0 && n <= nforms) {
            return formats[n].formatSuffix();
        }
        return "";
    }

    public static String contentTypeFromIndex(int n) {
        return BioseqFormats.contentType(n);
    }

    public static String contentType(int n) {
        if (n >= 0 && n <= nforms) {
            return formats[n].contentType();
        }
        return "biosequence/*";
    }

    public static int formatFromIndex(int n) {
        if (n >= 0 && n <= nforms) {
            return formats[n].formatID();
        }
        return kUnknown;
    }

    public static int getFormatId(String string) {
        int n = kUnknown;
        if (string == null || string.length() < 1) {
            return n;
        }
        int n2 = string.indexOf(124);
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        if (Character.isDigit((string = string.trim()).charAt(0))) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n = kUnknown;
            }
        }
        if (n == kUnknown) {
            n = BioseqFormats.formatFromContentType(string);
        }
        if (n == kUnknown) {
            n = BioseqFormats.formatFromName(string);
        }
        return n;
    }

    public static int formatFromName(String string) {
        String string2;
        int n;
        if (string != null && string.length() > 1) {
            for (n = 1; n <= nforms; ++n) {
                int n2;
                string2 = null;
                String string3 = new String(formats[n].formatName());
                do {
                    if ((n2 = string3.indexOf(124)) > 0) {
                        string2 = string3.substring(n2 + 1).trim();
                        string3 = string3.substring(0, n2).trim();
                    }
                    if (string.equalsIgnoreCase(string3)) {
                        return formats[n].formatID();
                    }
                    string3 = string2;
                } while (n2 > 0);
            }
        }
        for (n = 0; n <= nforms; ++n) {
            System.err.println("Checking format " + n + ": " + formats[n]);
            string2 = formats[n].formatSuffix();
            if (string2.startsWith(".")) {
                string2 = string2.substring(1);
            }
            if (!string.equalsIgnoreCase(string2)) continue;
            return formats[n].formatID();
        }
        return kUnknown;
    }

    public static int formatFromContentType(String string) {
        if (string != null && string.length() > 1) {
            for (int i = 1; i <= nforms; ++i) {
                String string2 = formats[i].contentType();
                if (!string.equalsIgnoreCase(string2)) continue;
                return formats[i].formatID();
            }
        }
        return kUnknown;
    }

    public static boolean canread(int n) {
        try {
            return formats[n].canread();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean canwrite(int n) {
        try {
            return formats[n].canwrite();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final BioseqWriterIface newWriter(int n) {
        return BioseqFormats.newWriter(n, 2);
    }

    public static BioseqWriterIface newWriter(int n, int n2) {
        try {
            if (!formats[n].canwrite()) {
                return null;
            }
            BioseqWriterIface bioseqWriterIface = formats[n].newWriter();
            bioseqWriterIface.setFormatID(n);
            return bioseqWriterIface;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static BioseqReaderIface newReader(int n) {
        try {
            if (!formats[n].canread()) {
                return null;
            }
            BioseqReaderIface bioseqReaderIface = formats[n].newReader();
            bioseqReaderIface.setFormatID(n);
            return bioseqReaderIface;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static void loadClasses() {
        FastProperties fastProperties = new FastProperties();
        fastProperties.loadProperties("BioseqFormats");
        String string = fastProperties.getProperty("formats");
        if (string == null) {
            return;
        }
        int n = 0;
        while (n >= 0) {
            String string2;
            int n2 = string.indexOf(44, n);
            if (n2 > n) {
                string2 = string.substring(n, n2);
                n = n2 + 1;
            } else {
                string2 = string.substring(n);
                n = -1;
            }
            if ((string2 = string2.trim()).length() <= 0) continue;
            try {
                Class<?> clazz = new BioseqFormats().getClass().getClassLoader().loadClass(string2);
                BioseqFormats.register((BioseqFormat)clazz.newInstance());
            }
            catch (Exception exception) {
                System.err.println("Error loading class: '" + string2 + "'" + exception);
            }
        }
    }

    static {
        kPhylip = kPhylip4 = 12;
        kPlain = 13;
        kPIR = 14;
        kMSF = 15;
        kASN1 = 16;
        kPAUP = 17;
        kPretty = 18;
        BioseqFormats.loadClasses();
        tablestr = "<TABLE bgcolor=\"white\" border=0 CELLSPACING=0 CELLPADDING=4>";
    }
}

