/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Debug;
import flybase.OpenString;
import flybase.Utils;
import iubio.bioseq.BaseKind;
import iubio.bioseq.Bioseq;
import iubio.readseq.BasicBioseqDoc;
import iubio.readseq.BioseqReaderIface;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.MessageApp;
import iubio.readseq.SeqFileInfo;
import iubio.readseq.TestBiobase;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public abstract class BioseqReader
implements BioseqReaderIface {
    public static String tempFile = "bioseqtemp.";
    public static boolean verbose;
    public static String lineEnd;
    static final boolean useBioseqBytes = true;
    static final int kBigChunk = 500000;
    int readChunkSize = 2048;
    int readFreeSize = this.readChunkSize * 100;
    public static MessageApp messageapp;
    protected boolean skipdocs;
    protected int formatId = -1;
    protected int seqlen;
    protected int seqoffset;
    protected int seqlencount;
    protected int maxseqlen;
    protected int memstep;
    protected int choice;
    protected int nseq;
    protected int margin = 0;
    protected int err = 0;
    protected int atseq = 0;
    protected boolean addit = true;
    protected boolean addfirst = false;
    protected boolean addend = true;
    protected boolean needString = false;
    protected boolean allDone = false;
    protected boolean ungetline = false;
    protected boolean ungetend = false;
    protected String idword = SeqFileInfo.gBlankSeqid;
    protected String seqid = SeqFileInfo.gBlankSeqid;
    protected Object seqdoc;
    private Bioseq seq;
    private byte[] bases;
    protected static final int kUseTester = 1;
    protected static final int kAnyChar = 2;
    protected static final int kAlphaChar = 3;
    protected TestBiobase testbase = new TestBiobase();
    protected int testbaseKind = 3;
    protected int nWaiting = 0;
    protected OpenString sWaiting = new OpenString("");
    private Reader fIns;
    private int lastc = -1;
    private final int kMaxbuf = 8192;
    private int nbuf = 0;
    private boolean fEof = false;
    private OpenString osbuf;
    private char[] osval;
    private int oslinei;
    private int oslen;
    private int osnewlinesize = 1;
    private char osnewline;

    public BioseqReader() {
    }

    public BioseqReader(Reader reader) {
        this();
        this.setInput(reader);
    }

    public static void message(String string) {
        if (messageapp != null) {
            messageapp.infomessage(string);
        } else {
            System.err.println(string);
        }
    }

    public void setChoice(int n) {
        this.choice = n;
    }

    public int formatID() {
        return this.formatId;
    }

    public void setFormatID(int n) {
        this.formatId = n;
    }

    public Reader getInput() {
        return this.fIns;
    }

    public void setInput(InputStream inputStream) {
        throw new Error("InputStream not supported");
    }

    public void setInput(Reader reader) {
        this.fIns = reader;
        this.fEof = false;
        this.setReaderBuf(this.fIns);
    }

    public void doRead() throws IOException {
        if (this.fIns == null) {
            throw new FileNotFoundException();
        }
        this.read();
        if (this.seqdoc == null) {
            this.seqdoc = new BasicBioseqDoc(this.seqid.toString());
        }
    }

    public int getNseq() {
        return this.nseq;
    }

    protected void setNseq(int n) {
        this.nseq = n;
    }

    public int getReadChunkSize() {
        return this.readChunkSize;
    }

    public void setReadChunkSize(int n) {
        this.readChunkSize = Math.min(500000, Math.max(n, 2048));
        this.readFreeSize = Math.max(this.readChunkSize, Math.min(500000, this.readChunkSize * 100));
        Debug.println("BioseqReader.setReadChunkSize=" + this.readChunkSize);
    }

    protected void clearSeqBuffer() {
        if (this.maxseqlen > this.readFreeSize) {
            this.maxseqlen = 0;
            this.seqlen = 0;
            this.bases = null;
        }
    }

    public void resetSeq() {
        this.seqlencount = 0;
        this.seqlen = 0;
        this.allDone = false;
        this.idword = SeqFileInfo.gBlankSeqid;
        this.seqid = SeqFileInfo.gBlankSeqid;
    }

    public void skipPastHeader(int n) {
        try {
            OpenString openString;
            int n2;
            for (n2 = n; n2 > 0; --n2) {
                this.getline();
            }
            do {
                if ((openString = this.getline()) == null) continue;
                for (n2 = openString.length() - 1; n2 > 0 && openString.charAt(n2) <= ' '; --n2) {
                }
            } while (openString != null && n2 == 0 && !this.endOfFile());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void copyto(SeqFileInfo seqFileInfo) {
        if (seqFileInfo == null) {
            return;
        }
        if (seqFileInfo.err == 0) {
            seqFileInfo.err = this.err;
        }
        seqFileInfo.seqlen = this.seqlen;
        seqFileInfo.seqdoc = this.seqdoc;
        if (seqFileInfo.err == 0 && (this.seqlen > 0 || this.seqdoc != null)) {
            seqFileInfo.atseq = this.atseq;
            if (this.atseq > seqFileInfo.nseq) {
                seqFileInfo.nseq = this.atseq;
            }
            seqFileInfo.seqid = this.seqid;
            seqFileInfo.checkSeqID();
            seqFileInfo.seq = this.seqlen > 0 ? new Bioseq(this.bases, 0, this.seqlen) : null;
            this.clearSeqBuffer();
        }
    }

    public void setSkipDocs(boolean bl) {
        this.skipdocs = bl;
    }

    public void readTo(BioseqWriterIface bioseqWriterIface, int n) throws IOException {
        int n2 = n;
        this.setSkipDocs(!bioseqWriterIface.wantsDocument());
        boolean bl = true;
        int n3 = 1;
        while (bl) {
            this.skipPastHeader(n2);
            n2 = 0;
            SeqFileInfo seqFileInfo = this.readOne(n3);
            if (seqFileInfo == null) {
                bl = false;
            } else {
                if (Debug.isOn || verbose) {
                    BioseqReader.message("read " + n3 + " id=" + seqFileInfo.seqid + " seqlen=" + seqFileInfo.seqlen);
                }
                if (bioseqWriterIface.setSeq(seqFileInfo)) {
                    bioseqWriterIface.writeSeqRecord();
                }
            }
            ++n3;
        }
    }

    public SeqFileInfo readOne(int n) throws IOException {
        this.resetSeq();
        this.setChoice(n);
        if (this.endOfFile()) {
            return null;
        }
        this.doRead();
        if (this.err != 0) {
            Debug.println("readOne error " + this.err);
        }
        SeqFileInfo seqFileInfo = new SeqFileInfo();
        this.copyto(seqFileInfo);
        seqFileInfo.nseq = this.getNseq();
        return seqFileInfo;
    }

    public boolean endOfSequence() {
        return false;
    }

    private final int testbase(int n) {
        switch (this.testbaseKind) {
            default: {
                if (n <= 32 || n >= 48 && n <= 57) {
                    return 0;
                }
                return n;
            }
            case 2: {
                if (n < 32) {
                    return 0;
                }
                return n;
            }
            case 1: 
        }
        return this.testbase.isSeqChar(n);
    }

    protected final void addseq(OpenString openString, int n) {
        this.addseq(openString, n, openString.length());
    }

    protected void addseq(OpenString openString, int n, int n2) {
        if (!this.addit) {
            return;
        }
        char[] cArray = openString.getValue();
        n2 += (n += openString.getOffset());
        for (int i = n; i < n2; ++i) {
            int n3 = this.testbase(cArray[i]);
            if (n3 <= 0) continue;
            if (this.seqlen >= this.maxseqlen && !this.expand()) {
                return;
            }
            this.bases[this.seqlen++] = (byte)n3;
        }
    }

    protected void setSeqoffset(int n) {
        if (!this.addit) {
            return;
        }
        this.seqoffset = n;
        byte by = (byte)BaseKind.indelEdge;
        for (int i = 0; i < n; ++i) {
            if (this.seqlen >= this.maxseqlen && !this.expand()) {
                return;
            }
            this.bases[this.seqlen++] = by;
        }
    }

    protected void addseq(char[] cArray, int n, int n2) {
        if (!this.addit) {
            return;
        }
        n2 += n;
        for (int i = n; i < n2; ++i) {
            int n3 = this.testbase(cArray[i]);
            if (n3 <= 0) continue;
            if (this.seqlen >= this.maxseqlen && !this.expand()) {
                return;
            }
            this.bases[this.seqlen++] = (byte)n3;
        }
    }

    protected final void countseq(OpenString openString, int n) {
        this.countseq(openString, n, openString.length());
    }

    protected void countseq(OpenString openString, int n, int n2) {
        char[] cArray = openString.getValue();
        n2 += (n += openString.getOffset());
        for (int i = n; i < n2; ++i) {
            if (this.testbase(cArray[i]) <= 0) continue;
            ++this.seqlencount;
        }
    }

    protected void countseq(char[] cArray, int n, int n2) {
        n2 += n;
        for (int i = n; i < n2; ++i) {
            if (this.testbase(cArray[i]) <= 0) continue;
            ++this.seqlencount;
        }
    }

    protected int countseqline(char[] cArray, int n, int n2) {
        int n3 = 0;
        n2 += n;
        for (int i = n; i < n2; ++i) {
            if (this.testbase(cArray[i]) <= 0) continue;
            ++n3;
        }
        return n3;
    }

    protected void addinfo(String string) {
        string = Utils.formatNum(this.atseq, 3) + ")  " + string.trim() + lineEnd;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (this.seqlen >= this.maxseqlen && !this.expand()) {
                return;
            }
            this.bases[this.seqlen++] = (byte)c;
        }
    }

    protected boolean expand() {
        this.maxseqlen += this.readChunkSize;
        ++this.memstep;
        if (this.bases == null) {
            this.bases = new byte[this.maxseqlen];
        } else {
            byte[] byArray = new byte[this.maxseqlen];
            System.arraycopy(this.bases, 0, byArray, 0, this.seqlen);
            this.bases = byArray;
        }
        return this.bases != null;
    }

    protected final char getreadbuf(int n) {
        return this.osval[this.oslinei + n];
    }

    protected final void setreadbuf(int n, char c) {
        this.osval[this.oslinei + n] = c;
    }

    protected final char[] getreadchars() {
        return this.osval;
    }

    protected final int getreadcharofs() {
        return this.oslinei;
    }

    public boolean endOfFile() {
        return this.fEof;
    }

    public void ungetline() {
        this.ungetline = true;
    }

    private void setReaderBuf(Reader reader) {
        this.oslinei = 0;
        this.oslen = 0;
        if (this.osbuf != null) {
            this.osbuf.setLength(0);
        }
    }

    public void reset() {
        this.atseq = 0;
        this.err = 0;
        this.seqlencount = 0;
        this.seqlen = 0;
        this.nbuf = 0;
        this.allDone = false;
        this.ungetline = false;
        this.fEof = false;
        if (this.fIns != null) {
            try {
                this.fIns.reset();
                this.fEof = !this.fIns.ready();
                this.setReaderBuf(this.fIns);
            }
            catch (IOException iOException) {
                Debug.println(this.getClass().getName() + ".reset() err=" + iOException.getMessage());
            }
        }
    }

    public void getlineBuf() throws IOException {
        if (this.ungetline) {
            this.ungetline = false;
            this.bufToString();
        } else {
            this.readLine();
        }
    }

    public OpenString getline() throws IOException {
        if (this.ungetline) {
            this.ungetline = false;
            this.bufToString();
        } else {
            this.readLine();
        }
        return this.sWaiting;
    }

    final OpenString bufToOs(int n, int n2) {
        int n3 = this.oslinei + n;
        return this.osbuf.substring(n3, n3 + n2);
    }

    protected final void bufToString() {
        int n = this.oslinei + this.nbuf;
        this.sWaiting = n > this.oslen ? this.osbuf.substring(this.oslinei) : this.osbuf.substring(this.oslinei, n);
        this.nWaiting = this.sWaiting.length();
    }

    protected final void readLine() throws IOException {
        int n;
        if (this.nbuf > 0) {
            this.oslinei += this.nbuf;
            this.nbuf = 0;
        }
        if (this.osbuf == null) {
            this.getOsBuf();
        }
        if ((n = this.osbuf.indexOf(this.osnewline, this.oslinei)) < this.oslinei) {
            this.getOsBuf();
            n = this.osbuf.indexOf(this.osnewline, this.oslinei);
        }
        if (n < this.oslinei) {
            this.sWaiting = this.oslinei >= this.oslen ? new OpenString("") : this.osbuf.substring(this.oslinei);
        } else {
            int n2 = n + this.osnewlinesize;
            if (n2 > this.oslen) {
                n2 = this.oslen;
            }
            this.sWaiting = this.osbuf.substring(this.oslinei, n2);
        }
        this.nWaiting = this.nbuf = this.sWaiting.length();
    }

    private void getOsBuf() throws IOException {
        int n;
        int n2;
        int n3;
        if (this.osbuf == null) {
            n3 = 0;
            n = n2 = 8192;
            this.osval = new char[n2];
            this.osbuf = new OpenString(this.osval);
            this.oslinei = 0;
            this.oslen = 0;
        } else {
            n3 = this.oslen - this.oslinei;
            n2 = 8192 - n3;
            n = this.osbuf.length();
            if (n3 > 0) {
                System.arraycopy(this.osval, this.oslinei, this.osval, 0, n3);
            }
            this.oslinei = 0;
            this.oslen = n3;
        }
        int n4 = this.fIns.read(this.osval, n3, n2);
        if (n4 < 0) {
            if (this.oslen <= 0) {
                this.fEof = true;
            }
        } else {
            this.oslen += n4;
        }
        if (this.oslen != n) {
            this.osbuf = new OpenString(this.osval, 0, this.oslen);
        }
        if (this.osnewline == '\u0000') {
            this.osnewlinesize = 1;
            for (int i = 0; i < this.oslen; ++i) {
                if (this.osval[i] == '\n') {
                    this.osnewline = (char)10;
                    if (this.osval[i + 1] != '\r') break;
                    this.osnewlinesize = 2;
                    break;
                }
                if (this.osval[i] != '\r') continue;
                this.osnewline = (char)13;
                if (this.osval[i + 1] != '\n') break;
                this.osnewlinesize = 2;
                break;
            }
        }
    }

    protected int indexOfBuf(char c) {
        return this.sWaiting.indexOf(c);
    }

    protected int indexOfBuf(String string) {
        return this.sWaiting.indexOf(string);
    }

    protected final OpenString bufSubstring(int n, int n2) {
        return this.bufToOs(n, n2 - n);
    }

    protected final OpenString bufSubstring(int n) {
        return this.bufToOs(0, n);
    }

    protected void read() throws IOException {
        this.readLoop();
    }

    protected void readLoop() throws IOException {
        boolean bl;
        ++this.atseq;
        if (this.choice == -1) {
            this.addit = false;
        } else {
            boolean bl2 = this.addit = this.atseq == this.choice;
        }
        if (this.addit) {
            this.seqlencount = 0;
            this.seqlen = 0;
        }
        if (this.addfirst) {
            this.addseq(this.sWaiting, 0, this.nWaiting);
        }
        do {
            this.getlineBuf();
            boolean bl3 = bl = this.endOfFile() || this.endOfSequence();
            if (!this.addit || !this.addend && bl || this.nWaiting <= this.margin) continue;
            this.addseq(this.sWaiting, this.margin, this.nWaiting - this.margin);
        } while (!bl);
        if (this.choice == -1) {
            this.addinfo(this.seqid);
        } else {
            boolean bl4 = this.allDone = this.atseq >= this.choice;
            if (this.allDone && this.ungetend) {
                this.ungetline();
            }
        }
    }

    static {
        lineEnd = "\n";
        lineEnd = System.getProperty("line.separator");
        messageapp = null;
    }
}

