/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import Acme.Fmt;
import iubio.readseq.BioseqReader;
import iubio.readseq.InterleavedSeqWriter;

class ClustalSeqWriter
extends InterleavedSeqWriter {
    int lastlen;
    String lenerr;

    ClustalSeqWriter() {
    }

    public void writeRecordStart() {
        super.writeRecordStart();
        this.opts.spacer = 0;
        this.opts.seqwidth = 60;
        this.opts.nameleft = true;
        this.opts.nameflags = 2;
        this.opts.namewidth = 15;
        this.opts.tab = 1;
    }

    public void writeDoc() {
        super.writeDoc();
    }

    protected void interleaf(int n) {
        this.writeln(Fmt.fmt(" ", 16, 34));
        this.writeln();
    }

    protected void interleaveHeader() {
        this.writeln("CLUSTAL W (1.8) multiple sequence alignment");
        this.writeln();
        this.writeln();
    }

    public boolean setSeq(Object object, int n, int n2, String string, Object object2, int n3, int n4) {
        if (this.lastlen > 0 && n2 != this.lastlen) {
            if (this.lenerr == null) {
                this.lenerr = String.valueOf(this.lastlen) + " != ";
            }
            this.lenerr = this.lenerr + String.valueOf(n2) + ", ";
            n2 = this.lastlen;
        } else {
            this.lastlen = n2;
        }
        return super.setSeq(object, n, n2, string, object2, n3, n4);
    }

    public void writeTrailer() {
        if (this.lenerr != null) {
            BioseqReader.message("Warning: this format requires equal sequence lengths.");
            BioseqReader.message("       : lengths are padded/truncated to " + this.lastlen);
            BioseqReader.message("       : " + this.lenerr);
        }
        super.writeTrailer();
    }
}

