/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import Acme.Fmt;
import flybase.Debug;
import iubio.bioseq.SeqInfo;
import iubio.readseq.BioseqDoc;
import iubio.readseq.BioseqWriter;
import iubio.readseq.EmblDoc;
import iubio.readseq.SeqFileInfo;
import iubio.readseq.SwissDoc;

class EmblSeqWriter
extends BioseqWriter {
    static final int seqwidth = 60;
    static final int ktab = 5;
    static final int kspacer = 10;
    static final int knumwidth = 8;
    static final int knumflags = 0;
    protected int seqkind;

    EmblSeqWriter() {
    }

    public void writeRecordStart() {
        super.writeRecordStart();
        this.opts.tab = 5;
        this.opts.spacer = 10;
        this.opts.seqwidth = 60;
        this.opts.numright = true;
        this.opts.numwidth = 8;
        this.seqkind = this.bioseq.getSeqtype();
        if (this.seqkind == 4) {
            this.setChecksum(true);
        }
    }

    public void writeRecordEnd() {
        this.writeln("//");
    }

    public void writeSeq() {
        int n;
        int n2;
        int n3 = 0;
        boolean bl = true;
        if (this.bioseq.isBytes() && this.testbaseKind != 1) {
            byte[] byArray = this.bioseq.toBytes();
            for (n2 = 0; n2 < this.seqlen; ++n2) {
                if (bl) {
                    for (n = 0; n < 5; ++n) {
                        this.writeByte(32);
                    }
                    bl = false;
                }
                this.writeByte(byArray[this.offset + n2]);
                if (n2 % 60 == 59) {
                    this.writeString("  " + Fmt.fmt(n2 + this.opts.origin, 8, 0));
                    this.writeln();
                    bl = true;
                    continue;
                }
                if (n2 % 10 != 9) continue;
                this.writeByte(32);
            }
        } else {
            for (n2 = 0; n2 < this.seqlen; ++n2) {
                if (bl) {
                    for (n = 0; n < 5; ++n) {
                        this.writeByte(32);
                    }
                    bl = false;
                }
                char c = this.bioseq.base(this.offset + n2, this.fBasePart);
                if (this.testbaseKind == 1) {
                    c = (char)this.testbase.outSeqChar(c);
                }
                if (c <= '\u0000') continue;
                this.writeByte(c);
                if (n3 % 60 == 59) {
                    this.writeString("  " + Fmt.fmt(n3 + this.opts.origin, 8, 0));
                    this.writeln();
                    bl = true;
                } else if (n3 % 10 == 9) {
                    this.writeByte(32);
                }
                ++n3;
            }
        }
        if (!bl) {
            int n4 = this.seqlen % 60;
            if (n4 > 0) {
                n4 = 60 - n4;
                n4 += (n4 - 1) / 10;
            }
            for (n = 0; n < n4; ++n) {
                this.writeByte(32);
            }
            this.writeString("  " + Fmt.fmt(this.seqlen - 1 + this.opts.origin, 8, 0));
            this.writeln();
        }
    }

    protected void writeID() {
        this.writeString("ID   ");
        if (this.seqkind == 4) {
            this.writeString(Fmt.fmt(this.idword, 15, 2));
            this.writeString(" STANDARD;      PRT; ");
            this.writeString(String.valueOf(this.seqlen));
            this.writeln(" AA.");
        } else {
            this.writeString(Fmt.fmt(this.idword, 11, 2));
            this.writeString(" standard; ");
            this.writeString(SeqInfo.getKindLabel(this.seqkind));
            if (Debug.isOn) {
                this.writeString("; debug");
            }
            this.writeString("; UNC; ");
            this.writeString(String.valueOf(this.seqlen));
            this.writeln(" BP.");
        }
    }

    protected final void writeTitle() {
        this.writeString("DE   ");
        this.writeln(this.seqid);
    }

    protected void writeSeqStats(String string) {
        if (this.seqkind == 4) {
            this.writeString("SQ   SEQUENCE ");
            this.writeString(Fmt.fmt(this.seqlen, 5, 0));
            this.writeString(" AA;");
            this.writeString(Fmt.fmt(string, 10, 0));
            this.writeString(" CRC32;");
            this.writeln();
        } else {
            if (string.length() > 0) {
                this.writeString("CC   ");
                this.writeString(string);
                this.writeln(" CRC32;");
            }
            this.writeString("SQ   Sequence ");
            this.writeString(String.valueOf(this.seqlen));
            this.writeln(" BP;");
        }
    }

    public void writeDoc() {
        String string = this.checksumString();
        int n = string.indexOf(" checksum");
        if (n > 0) {
            string = string.substring(0, n);
        }
        if (this.seqdoc instanceof BioseqDoc) {
            EmblDoc emblDoc = this.seqkind == 4 ? new SwissDoc((BioseqDoc)this.seqdoc) : new EmblDoc((BioseqDoc)this.seqdoc);
            boolean bl = true;
            String string2 = emblDoc.getID();
            if (string2 == null || !this.idword.startsWith(SeqFileInfo.gBlankSeqid) && !string2.equals(this.idword)) {
                this.writeID();
                bl = false;
            }
            if (!bl && emblDoc.getTitle() == null) {
                this.writeTitle();
            }
            emblDoc.replaceDocField(112, String.valueOf(this.seqlen));
            if (string.length() > 0) {
                emblDoc.replaceDocField(114, string);
            }
            this.linesout += emblDoc.writeTo(this.douts, bl);
            if (emblDoc.getDocField(110) == null) {
                if (this.seqkind != 4 && emblDoc.getDocField(114) != null) {
                    string = "";
                }
                this.writeSeqStats(string);
            }
        } else {
            this.writeID();
            this.writeTitle();
            this.writeSeqStats(string);
        }
    }
}

