/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

class HTMLFilterReader
extends FilterReader {
    final int kMaxbuf = 128;
    private char[] inbuf = new char[128];
    private int nbuf;
    private int atbuf;
    private int skipbytes;
    private boolean didskipbytes;

    public HTMLFilterReader(Reader reader, int n) {
        super(reader);
        this.skipbytes = n;
    }

    public void reset() throws IOException {
        this.in.reset();
        if (this.skipbytes > 0) {
            this.in.skip(this.skipbytes);
            this.didskipbytes = true;
        }
    }

    public boolean ready() throws IOException {
        if (this.didskipbytes) {
            return true;
        }
        return this.in.ready();
    }

    public int read() throws IOException {
        int n;
        this.didskipbytes = false;
        if (this.nbuf > 0) {
            if (this.atbuf < this.nbuf) {
                return this.inbuf[this.atbuf++];
            }
            this.nbuf = 0;
            this.atbuf = 0;
        }
        if ((n = this.in.read()) == 60) {
            while (n != 62) {
                n = this.in.read();
                if (n >= 0) continue;
                return n;
            }
            return this.read();
        }
        if (n == 38) {
            if (this.nbuf < 128) {
                this.inbuf[this.nbuf++] = (char)n;
            }
            while (n != 59 && this.nbuf < 128) {
                n = this.in.read();
                if (n < 0) {
                    return this.inbuf[this.atbuf++];
                }
                this.inbuf[this.nbuf++] = (char)n;
            }
            String string = new String(this.inbuf, this.atbuf, this.nbuf - this.atbuf);
            if ("&lt;".equals(string)) {
                this.nbuf = this.atbuf;
                return 60;
            }
            if ("&gt;".equals(string)) {
                this.nbuf = this.atbuf;
                return 62;
            }
            if ("&amp;".equals(string)) {
                this.nbuf = this.atbuf;
                return 38;
            }
            if ("&nbsp;".equals(string)) {
                this.nbuf = this.atbuf;
                return 32;
            }
            return this.inbuf[this.atbuf++];
        }
        return n;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = this.read();
            if (n4 < 0) {
                return i == 0 ? -1 : n3;
            }
            cArray[n + i] = (char)n4;
            ++n3;
        }
        return n3;
    }
}

