/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import Acme.Fmt;
import iubio.readseq.BioseqDoc;
import iubio.readseq.BioseqWriter;
import java.io.IOException;

class PirSeqWriter
extends BioseqWriter {
    PirSeqWriter() {
    }

    public void writeRecordStart() {
        super.writeRecordStart();
        this.opts.numwidth = 7;
        this.opts.seqwidth = 30;
        this.opts.spacer = -9;
        this.opts.numleft = true;
    }

    public void writeHeader() throws IOException {
        super.writeHeader();
        this.writeln("\\\\\\");
    }

    public void writeRecordEnd() {
        this.writeln("///");
    }

    public void writeDoc() {
        int n;
        String string;
        this.writeString("ENTRY           ");
        this.writeString(this.idword);
        this.writeln(" ");
        this.writeString("TITLE           ");
        String string2 = this.seqid;
        if (this.seqdoc instanceof BioseqDoc && (string = ((BioseqDoc)this.seqdoc).getTitle()) != null) {
            string2 = string;
        }
        this.writeString(string2);
        this.writeString(" ");
        this.writeString(String.valueOf(this.seqlen));
        this.writeString(" bases  ");
        this.writeln(this.checksumString());
        this.writeln("SEQUENCE        ");
        for (n = 0; n < this.opts.numwidth; ++n) {
            this.writeByte(32);
        }
        for (n = 5; n <= this.opts.seqwidth; n += 5) {
            this.writeString(Fmt.fmt(n, 10));
        }
        this.writeln();
    }
}

