/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import iubio.readseq.Readseq;
import iubio.readseq.RsInputFile;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

class RsInputStream
extends RsInputFile {
    protected InputStream fInsOrig;

    RsInputStream(InputStream inputStream) throws IOException {
        this.fInsOrig = inputStream;
        this.openStream();
    }

    RsInputStream() throws IOException {
    }

    protected void openStream() throws IOException {
        this.in = new InputStreamReader(this.fInsOrig);
        this.lock = this.in;
        this.makeRewindable();
    }

    public void reset() throws IOException {
        if (this.fInfile == null) {
            this.makeRewindable();
        } else {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.openFile();
        }
    }

    public void makeRewindable() {
        if (this.fInfile == null) {
            this.fInfile = Readseq.tempFile();
            try {
                int n;
                FileWriter fileWriter = new FileWriter(this.fInfile);
                char[] cArray = new char[8192];
                do {
                    if ((n = this.in.read(cArray)) <= 0) continue;
                    fileWriter.write(cArray, 0, n);
                } while (n >= 0);
                fileWriter.close();
                this.openFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (this.fInfile != null) {
            this.fInfile.delete();
            this.fInfile = null;
        }
    }
}

