/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

public class SeqFileInfo
implements Cloneable {
    public static String gBlankSeqid = "nameless";
    public static String gMaskName = "#Mask";
    public static boolean gWriteMask = true;
    public static int gBlanknum = 0;
    public int format;
    public int skiplines;
    public int err;
    public int atseq;
    public int nseq;
    public long modtime;
    public int seqlen;
    public int offset;
    public boolean ismask = false;
    public boolean hasmask = false;
    public Object seq;
    public Object seqdoc;
    public String seqid = gBlankSeqid;
    public Object extradata;

    public SeqFileInfo() {
    }

    public SeqFileInfo(Object object, int n, int n2) {
        this.seq = object;
        this.offset = n;
        this.seqlen = n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append(": id=");
        stringBuffer.append(this.seqid);
        stringBuffer.append(", length=");
        stringBuffer.append(this.seqlen);
        stringBuffer.append(", hasdoc=");
        stringBuffer.append(this.hasdoc());
        return stringBuffer.toString();
    }

    public final int length() {
        return this.seqlen;
    }

    public void setlength(int n) {
        this.seqlen = n;
    }

    public final int offset() {
        return this.offset;
    }

    public void setoffset(int n) {
        this.offset = n;
    }

    public final Object getseqObject() {
        return this.seq;
    }

    public void setseq(Object object) {
        this.seq = object;
    }

    public final Object getdocObject() {
        return this.seqdoc;
    }

    public void setdoc(Object object) {
        this.seqdoc = object;
    }

    public final Object getextraObject() {
        return this.extradata;
    }

    public void setextra(Object object) {
        this.extradata = object;
    }

    public final boolean hasseq() {
        return this.seq != null && this.seqlen > 0;
    }

    public final boolean hasdoc() {
        return this.seqdoc != null;
    }

    public final boolean hasid() {
        return this.seqid != null && this.seqid.length() > 0 && !this.seqid.startsWith(gBlankSeqid);
    }

    public final boolean hasmask() {
        return this.ismask || this.hasmask;
    }

    public final String getID() {
        return this.seqid;
    }

    public final void setSeqID(String string) {
        this.seqid = string;
        this.checkSeqID();
    }

    public void checkSeqID() {
        this.ismask = false;
        String string = this.seqid;
        if (string != null && string.length() > 0) {
            int n = string.indexOf(gMaskName);
            if (n > 0) {
                this.ismask = true;
                string = string.substring(0, n);
            }
            this.seqid = SeqFileInfo.cleanSeqID(string);
        }
    }

    public static String getNextBlankID() {
        return gBlankSeqid + "_" + String.valueOf(++gBlanknum);
    }

    public static String getNextBlankID(String string) {
        return string + "_" + String.valueOf(++gBlanknum);
    }

    public static String cleanSeqID(String string) {
        int n = (string = string.trim()).indexOf(32);
        if (n > 0) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf(44)) > 0) {
            string = string.substring(0, n);
        }
        string = string.replace('\n', '_').replace('\r', '_').replace(' ', '_').replace('.', '_');
        return string;
    }

    public void copyto(SeqFileInfo seqFileInfo) {
        seqFileInfo.format = this.format;
        seqFileInfo.skiplines = this.skiplines;
        seqFileInfo.err = this.err;
        seqFileInfo.atseq = this.atseq;
        seqFileInfo.nseq = this.nseq;
        seqFileInfo.modtime = this.modtime;
        seqFileInfo.seqlen = this.seqlen;
        seqFileInfo.offset = this.offset;
        seqFileInfo.ismask = this.ismask;
        seqFileInfo.hasmask = this.hasmask;
        seqFileInfo.seq = this.seq;
        seqFileInfo.seqdoc = this.seqdoc;
        seqFileInfo.seqid = this.seqid;
    }

    public Object clone() {
        try {
            SeqFileInfo seqFileInfo = (SeqFileInfo)super.clone();
            seqFileInfo.seqid = gBlankSeqid;
            seqFileInfo.hasmask = false;
            seqFileInfo.ismask = false;
            seqFileInfo.seqlen = 0;
            seqFileInfo.offset = 0;
            seqFileInfo.seq = null;
            seqFileInfo.seqdoc = null;
            seqFileInfo.modtime = 0L;
            return seqFileInfo;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error(cloneNotSupportedException.toString());
        }
    }
}

