/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.AppResources;
import flybase.Environ;
import flybase.Utils;
import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqFormats;
import iubio.readseq.app;
import iubio.readseq.cgi;
import iubio.readseq.run;
import iubio.readseq.test;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class help {
    public static String kReadseq2Help = "rez/Readseq2-help.html";
    public boolean dohtml;
    public PrintStream out;
    boolean didfmthead = false;

    public static void main(String[] stringArray) {
        help help2 = new help(stringArray);
    }

    public help() {
        this.help(null, System.out);
    }

    public help(String[] stringArray) {
        this.help(stringArray, System.out);
    }

    public help(PrintStream printStream) {
        this.help(null, printStream);
    }

    public help(String[] stringArray, PrintStream printStream) {
        this.help(stringArray, printStream);
    }

    public help(boolean bl, boolean bl2, PrintStream printStream) {
        this.dohtml = bl2;
        this.out = printStream;
    }

    public void help(String[] stringArray, PrintStream printStream) {
        if (printStream == null) {
            printStream = System.out;
        }
        this.out = printStream;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i].toLowerCase();
                if (string.startsWith("-")) {
                    string = string.substring(1);
                }
                if (string.indexOf("html") >= 0) {
                    this.dohtml = true;
                    continue;
                }
                if (string.startsWith("h")) {
                    bl = true;
                    continue;
                }
                if (string.startsWith("m")) {
                    bl2 = true;
                    continue;
                }
                if (!string.startsWith("f")) continue;
                bl3 = true;
            }
        }
        if (bl || !bl2 && !bl3) {
            this.mainHelp();
        }
        if (bl2) {
            this.extraHelp();
        }
        if (bl3) {
            this.formatHelp();
        }
    }

    public void mainHelp() {
        this.out.println(" For basic help     : java -cp readseq.jar help ");
        this.out.println(" For more details   : java -cp readseq.jar help more ");
        this.out.println(" For format details : java -cp readseq.jar help formats ");
        String string = Environ.gEnv.get("APP_SOURCE_URL");
        if (string.length() > 0) {
            this.out.println("  Home of this package");
            if (this.dohtml) {
                this.out.println("    <a href=\"" + string + "\">" + string + "</a>");
            } else {
                this.out.println("    " + string);
            }
        }
        this.out.println("Programs available in this package");
        this.rule();
        app.appusage(this.out);
        this.rule();
        cgi.cgiusage(this.out);
        this.rule();
        test.testusage(this.out);
        this.rule();
        run.usage(this.out);
        this.rule();
    }

    public void extraHelp() {
        String string = AppResources.global.getData(kReadseq2Help);
        if (string == null) {
            this.out.println("No extra help found in " + kReadseq2Help);
        } else if (this.dohtml) {
            this.out.println(string);
        } else {
            this.out.println(Utils.htmlToText(string));
        }
    }

    public void formatHelp() {
        if (this.dohtml) {
            int n;
            this.out.println("<HTML><TITLE>Readseq: Formats</TITLE><BODY>");
            this.out.println("<B>Known biosequence formats:</B><BR>");
            this.out.println(BioseqFormats.getInfo(0, "html-header"));
            for (n = 1; n <= BioseqFormats.nFormats(); ++n) {
                String string = BioseqFormats.getInfo(n, "html-command-line-toc");
                this.out.println(string);
            }
            this.out.println(BioseqFormats.getInfo(0, "html-footer"));
            this.rule();
            this.out.println("<P>");
            for (n = 1; n <= BioseqFormats.nFormats(); ++n) {
                this.formatDoc(n);
            }
            this.out.println("&nbsp;&nbsp; (Int'leaf = interleaved format; Features = documentation/features are parsed)");
        } else {
            this.out.println("Known biosequence formats:");
            int n = BioseqFormats.nFormats();
            for (int i = 1; i <= n; ++i) {
                this.formatDoc(i);
            }
            this.out.println(BioseqFormats.getInfo(0, "space-footer"));
            this.out.println("   (Int'leaf = interleaved format; Features = documentation/features are parsed)");
        }
    }

    public void formatDocEnd() {
        this.out.println(BioseqFormats.getInfo(0, this.dohtml ? "html-footer" : "space-footer"));
    }

    public void formatDoc(int n) {
        String string;
        if (!this.didfmthead) {
            string = BioseqFormats.getInfo(0, this.dohtml ? "html-header" : "space-header");
            if (this.dohtml) {
                string = "<A name=\"fmt" + n + "\">&nbsp</a>" + string;
            }
            this.out.println(string);
        } else {
            string = BioseqFormats.getInfo(0, this.dohtml ? "html-header1" : "space-header1");
            this.out.println(string);
        }
        string = BioseqFormats.getInfo(n, this.dohtml ? "html-command-line" : "space-command-line");
        this.out.println(string);
        if (this.dohtml) {
            this.out.println(BioseqFormats.getInfo(0, "html-footer"));
        } else {
            this.out.println();
        }
        BioseqFormat bioseqFormat = BioseqFormats.bioseqFormat(n);
        InputStream inputStream = bioseqFormat.getDocument();
        if (inputStream == null) {
            this.out.println("No format details ");
        } else {
            try {
                String string2 = System.getProperty("line.separator");
                StringBuffer stringBuffer = new StringBuffer();
                DataInputStream dataInputStream = new DataInputStream(inputStream);
                while ((string = dataInputStream.readLine()) != null) {
                    stringBuffer.append(string);
                    stringBuffer.append(string2);
                }
                string = stringBuffer.toString();
                int n2 = string.indexOf("<BODY>");
                if (n2 > 0) {
                    string = string.substring(n2 + "<BODY>".length());
                }
                if ((n2 = string.indexOf("</BODY>")) > 0) {
                    string = string.substring(0, n2);
                }
                if (this.dohtml) {
                    this.out.println(string);
                } else {
                    this.out.println(Utils.htmlToText(string));
                }
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.rule();
    }

    public void rule() {
        if (this.dohtml) {
            this.out.print("<HR width=\"50%\" align=left>");
        } else {
            for (int i = 0; i < 30; ++i) {
                this.out.print('-');
            }
        }
        this.out.println();
    }
}

