/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.text.CollationKey;
import java.text.Collator;
import java.util.Locale;
import javax.help.Merge;
import javax.help.MergeHelpUtilities;
import javax.help.NavigatorView;
import javax.help.TreeItem;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class SortMerge
extends Merge {
    private static boolean debug = false;

    public SortMerge(NavigatorView navigatorView, NavigatorView navigatorView2) {
        super(navigatorView, navigatorView2);
    }

    public TreeNode processMerge(TreeNode treeNode) {
        this.masterNode = (DefaultMutableTreeNode)treeNode;
        if (this.masterNode == null) {
            this.masterNode = new DefaultMutableTreeNode();
        }
        if (this.slaveNode == null) {
            this.slaveNode = new DefaultMutableTreeNode();
        }
        if (this.masterNode.equals(this.slaveNode)) {
            SortMerge.debug(" returns: " + this.masterNode);
            SortMerge.sortNode(this.masterNode, this.locale);
            return this.masterNode;
        }
        if (this.slaveNode.getChildCount() == 0 && this.masterNode.getChildCount() == 0 || this.slaveNode.getChildCount() == 0) {
            SortMerge.debug(" returns masternode : " + this.masterNode);
            SortMerge.sortNode(this.masterNode, this.locale);
            return this.masterNode;
        }
        if (this.masterNode.getChildCount() == 0) {
            SortMerge.debug(" returns modified masternode : " + this.masterNode);
            while (this.slaveNode.getChildCount() > 0) {
                this.masterNode.add((DefaultMutableTreeNode)this.slaveNode.getFirstChild());
            }
            SortMerge.sortNode(this.masterNode, this.locale);
            return this.masterNode;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = MergeHelpUtilities.compareNodes(this.masterNode, this.slaveNode);
        SortMerge.sortNode(defaultMutableTreeNode, this.locale);
        return defaultMutableTreeNode;
    }

    public static DefaultMutableTreeNode sortNode(DefaultMutableTreeNode defaultMutableTreeNode, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        SortMerge.setMergeType(defaultMutableTreeNode);
        String string = MergeHelpUtilities.getMergeType(defaultMutableTreeNode);
        if (string == null || string.equals("javax.help.SortMerge")) {
            int n;
            int n2 = defaultMutableTreeNode.getChildCount();
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode();
            Collator collator = Collator.getInstance(locale);
            CollationKey[] collationKeyArray = new CollationKey[n2];
            int n3 = 0;
            while (n3 < n2) {
                String string2 = MergeHelpUtilities.getNodeName((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n3));
                SortMerge.debug("String , i:" + string2 + " , " + n3);
                collationKeyArray[n3] = collator.getCollationKey(string2);
                ++n3;
            }
            int n4 = 0;
            while (n4 < n2) {
                n = n4;
                while (n < n2) {
                    SortMerge.debug("i,j :" + n4 + " , " + n);
                    if (collationKeyArray[n4] != null && collationKeyArray[n4].compareTo(collationKeyArray[n]) > 0) {
                        CollationKey collationKey = collationKeyArray[n];
                        collationKeyArray[n] = collationKeyArray[n4];
                        collationKeyArray[n4] = collationKey;
                    }
                    ++n;
                }
                ++n4;
            }
            n = 0;
            while (n < n2) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = MergeHelpUtilities.getChildWithName(defaultMutableTreeNode, collationKeyArray[n].getSourceString());
                if (defaultMutableTreeNode3 != null) {
                    defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                }
                ++n;
            }
            while (defaultMutableTreeNode2.getChildCount() > 0) {
                defaultMutableTreeNode.add((DefaultMutableTreeNode)defaultMutableTreeNode2.getFirstChild());
            }
        }
        int n = 0;
        while (n < defaultMutableTreeNode.getChildCount()) {
            SortMerge.sortNode((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n), locale);
            ++n;
        }
        return defaultMutableTreeNode;
    }

    public static void setMergeType(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        if (defaultMutableTreeNode2 == null) {
            TreeItem treeItem = (TreeItem)defaultMutableTreeNode.getUserObject();
            if (treeItem != null && treeItem.getMergeType() == null) {
                treeItem.setMergeType("javax.help.SortMerge");
            }
        } else {
            TreeItem treeItem = (TreeItem)defaultMutableTreeNode.getUserObject();
            TreeItem treeItem2 = (TreeItem)defaultMutableTreeNode2.getUserObject();
            if (treeItem.getMergeType() == null && treeItem2 != null) {
                treeItem.setMergeType(treeItem2.getMergeType());
            }
        }
    }

    private static void debug(String string) {
        if (debug) {
            System.out.println("SortMerge :" + string);
        }
    }
}

