/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis;

import java.util.Enumeration;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Chain;
import org.apache.axis.Handler;
import org.apache.axis.HandlerIterationStrategy;
import org.apache.axis.InternalException;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.strategies.InvocationStrategy;
import org.apache.axis.strategies.WSDLGenStrategy;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleChain
extends BasicHandler
implements Chain {
    private static Log log = LogFactory.getLog(SimpleChain.class.getName());
    protected Vector handlers = new Vector();
    protected boolean invoked = false;
    private String CAUGHTFAULT_PROPERTY = "org.apache.axis.SimpleChain.caughtFaultInResponse";
    private static final HandlerIterationStrategy iVisitor = new InvocationStrategy();
    private static final HandlerIterationStrategy wsdlVisitor = new WSDLGenStrategy();

    public void init() {
        for (int i = 0; i < this.handlers.size(); ++i) {
            ((Handler)this.handlers.elementAt(i)).init();
        }
    }

    public void cleanup() {
        for (int i = 0; i < this.handlers.size(); ++i) {
            ((Handler)this.handlers.elementAt(i)).cleanup();
        }
    }

    public void invoke(MessageContext messageContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SimpleChain::invoke");
        }
        this.invoked = true;
        this.doVisiting(messageContext, iVisitor);
        if (log.isDebugEnabled()) {
            log.debug("Exit: SimpleChain::invoke");
        }
    }

    public void generateWSDL(MessageContext messageContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SimpleChain::generateWSDL");
        }
        this.invoked = true;
        this.doVisiting(messageContext, wsdlVisitor);
        if (log.isDebugEnabled()) {
            log.debug("Exit: SimpleChain::generateWSDL");
        }
    }

    private void doVisiting(MessageContext messageContext, HandlerIterationStrategy handlerIterationStrategy) throws AxisFault {
        int n = 0;
        try {
            Enumeration enumeration = this.handlers.elements();
            while (enumeration.hasMoreElements()) {
                Handler handler = (Handler)enumeration.nextElement();
                handlerIterationStrategy.visit(handler, messageContext);
                ++n;
            }
        }
        catch (AxisFault axisFault) {
            if (!messageContext.isPropertyTrue(this.CAUGHTFAULT_PROPERTY)) {
                Message message = new Message(axisFault);
                messageContext.setResponseMessage(message);
                messageContext.setProperty(this.CAUGHTFAULT_PROPERTY, Boolean.TRUE);
            }
            while (--n >= 0) {
                ((Handler)this.handlers.elementAt(n)).onFault(messageContext);
            }
            throw axisFault;
        }
    }

    public void onFault(MessageContext messageContext) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SimpleChain::onFault");
        }
        for (int i = this.handlers.size() - 1; i >= 0; --i) {
            ((Handler)this.handlers.elementAt(i)).onFault(messageContext);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SimpleChain::onFault");
        }
    }

    public boolean canHandleBlock(QName qName) {
        for (int i = 0; i < this.handlers.size(); ++i) {
            if (!((Handler)this.handlers.elementAt(i)).canHandleBlock(qName)) continue;
            return true;
        }
        return false;
    }

    public void addHandler(Handler handler) {
        if (handler == null) {
            throw new InternalException(Messages.getMessage("nullHandler00", "SimpleChain::addHandler"));
        }
        if (this.invoked) {
            throw new InternalException(Messages.getMessage("addAfterInvoke00", "SimpleChain::addHandler"));
        }
        this.handlers.add(handler);
    }

    public boolean contains(Handler handler) {
        return this.handlers.contains(handler);
    }

    public Handler[] getHandlers() {
        if (this.handlers.size() == 0) {
            return null;
        }
        Handler[] handlerArray = new Handler[this.handlers.size()];
        return this.handlers.toArray(handlerArray);
    }

    public Element getDeploymentData(Document document) {
        Object object;
        int n;
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("enter00", "SimpleChain::getDeploymentData"));
        }
        Element element = document.createElementNS("", "chain");
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.handlers.size(); ++n) {
            if (n != 0) {
                stringBuffer.append(",");
            }
            object = (Handler)this.handlers.elementAt(n);
            stringBuffer.append(object.getName());
        }
        if (n > 0) {
            element.setAttribute("flow", stringBuffer.toString());
        }
        if (this.options != null) {
            object = this.options.keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                Object v = this.options.get(string);
                Element element2 = document.createElementNS("", "option");
                element2.setAttribute("name", string);
                element2.setAttribute("value", v.toString());
                element.appendChild(element2);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SimpleChain::getDeploymentData");
        }
        return element;
    }
}

