/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.client;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.Options;
import org.apache.axis.utils.StringUtils;
import org.apache.commons.logging.Log;

public class AdminClient {
    protected static Log log = LogFactory.getLog(AdminClient.class.getName());
    private static ThreadLocal defaultConfiguration = new ThreadLocal();
    protected Call call;
    protected static final String ROOT_UNDEPLOY = WSDDConstants.QNAME_UNDEPLOY.getLocalPart();

    public static void setDefaultConfiguration(EngineConfiguration engineConfiguration) {
        defaultConfiguration.set(engineConfiguration);
    }

    private static String getUsageInfo() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Messages.getMessage("acUsage00")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage01")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage02")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage03")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage04")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage05")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage06")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage07")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage08")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage09")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage10")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage11")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage12")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage13")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage14")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage15")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage16")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage17")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage18")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage19")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage20")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage21")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage22")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage23")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage24")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage25")).append(string);
        stringBuffer.append(Messages.getMessage("acUsage26")).append(string);
        return stringBuffer.toString();
    }

    public AdminClient() {
        try {
            this.initAdminClient();
        }
        catch (ServiceException serviceException) {
            System.err.println(Messages.getMessage("couldntCall00") + ": " + serviceException);
            this.call = null;
        }
    }

    public AdminClient(boolean bl) throws ServiceException {
        this.initAdminClient();
    }

    private void initAdminClient() throws ServiceException {
        EngineConfiguration engineConfiguration = (EngineConfiguration)defaultConfiguration.get();
        Service service = engineConfiguration != null ? new Service(engineConfiguration) : new Service();
        this.call = (Call)service.createCall();
    }

    public Call getCall() {
        return this.call;
    }

    public String list(Options options) throws Exception {
        this.processOpts(options);
        return this.list();
    }

    public String list() throws Exception {
        log.debug(Messages.getMessage("doList00"));
        String string = "<m:list xmlns:m=\"http://xml.apache.org/axis/wsdd/\"/>";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        return this.process(byteArrayInputStream);
    }

    public String quit(Options options) throws Exception {
        this.processOpts(options);
        return this.quit();
    }

    public String quit() throws Exception {
        log.debug(Messages.getMessage("doQuit00"));
        String string = "<m:quit xmlns:m=\"http://xml.apache.org/axis/wsdd/\"/>";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        return this.process(byteArrayInputStream);
    }

    public String undeployHandler(String string) throws Exception {
        log.debug(Messages.getMessage("doQuit00"));
        String string2 = "<m:" + ROOT_UNDEPLOY + " xmlns:m=\"" + "http://xml.apache.org/axis/wsdd/" + "\">" + "<handler name=\"" + string + "\"/>" + "</m:" + ROOT_UNDEPLOY + ">";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        return this.process(byteArrayInputStream);
    }

    public String undeployService(String string) throws Exception {
        log.debug(Messages.getMessage("doQuit00"));
        String string2 = "<m:" + ROOT_UNDEPLOY + " xmlns:m=\"" + "http://xml.apache.org/axis/wsdd/" + "\">" + "<service name=\"" + string + "\"/>" + "</m:" + ROOT_UNDEPLOY + ">";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        return this.process(byteArrayInputStream);
    }

    public String process(String[] stringArray) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        Options options = new Options(stringArray);
        options.setDefaultURL("http://localhost:8080/axis/services/AdminService");
        if (options.isFlagSet('d') > 0) {
            // empty if block
        }
        if ((stringArray = options.getRemainingArgs()) == null || options.isFlagSet('?') > 0) {
            System.out.println(Messages.getMessage("usage00", "AdminClient [Options] [list | <deployment-descriptor-files>]"));
            System.out.println("");
            System.out.println(AdminClient.getUsageInfo());
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            ByteArrayInputStream byteArrayInputStream = null;
            if (stringArray[i].equals("list")) {
                stringBuffer.append(this.list(options));
                continue;
            }
            if (stringArray[i].equals("quit")) {
                stringBuffer.append(this.quit(options));
                continue;
            }
            if (stringArray[i].equals("passwd")) {
                System.out.println(Messages.getMessage("changePwd00"));
                if (stringArray[i + 1] == null) {
                    System.err.println(Messages.getMessage("needPwd00"));
                    return null;
                }
                object = "<m:passwd xmlns:m=\"http://xml.apache.org/axis/wsdd/\">";
                object = (String)object + stringArray[i + 1];
                object = (String)object + "</m:passwd>";
                byteArrayInputStream = new ByteArrayInputStream(((String)object).getBytes());
                ++i;
                stringBuffer.append(this.process(options, byteArrayInputStream));
                continue;
            }
            if (stringArray[i].indexOf(File.pathSeparatorChar) == -1) {
                System.out.println(Messages.getMessage("processFile00", stringArray[i]));
                stringBuffer.append(this.process(options, stringArray[i]));
                continue;
            }
            object = null;
            object = new StringTokenizer(stringArray[i], File.pathSeparator);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken();
                System.out.println(Messages.getMessage("processFile00", string));
                stringBuffer.append(this.process(options, string));
                if (!((StringTokenizer)object).hasMoreTokens()) continue;
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public void processOpts(Options options) throws Exception {
        if (this.call == null) {
            throw new Exception(Messages.getMessage("nullCall00"));
        }
        URL uRL = new URL(options.getURL());
        this.setTargetEndpointAddress(uRL);
        this.setLogin(options.getUser(), options.getPassword());
        String string = options.isValueSet('t');
        this.setTransport(string);
    }

    public void setLogin(String string, String string2) {
        this.call.setUsername(string);
        this.call.setPassword(string2);
    }

    public void setTargetEndpointAddress(URL uRL) {
        this.call.setTargetEndpointAddress(uRL);
    }

    public void setTransport(String string) {
        if (string != null && !string.equals("")) {
            this.call.setProperty("transport_name", string);
        }
    }

    public String process(InputStream inputStream) throws Exception {
        return this.process(null, inputStream);
    }

    public String process(URL uRL) throws Exception {
        return this.process(null, uRL.openStream());
    }

    public String process(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        String string2 = this.process(null, fileInputStream);
        return string2;
    }

    public String process(Options options, String string) throws Exception {
        this.processOpts(options);
        return this.process(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String process(Options options, InputStream inputStream) throws Exception {
        try {
            if (this.call == null) {
                throw new Exception(Messages.getMessage("nullCall00"));
            }
            if (options != null) {
                this.processOpts(options);
            }
            this.call.setUseSOAPAction(true);
            this.call.setSOAPActionURI("urn:AdminService");
            Vector vector = null;
            Object[] objectArray = new Object[]{new SOAPBodyElement(inputStream)};
            vector = (Vector)this.call.invoke(objectArray);
            if (vector == null || vector.isEmpty()) {
                throw new AxisFault(Messages.getMessage("nullResponse00"));
            }
            SOAPBodyElement sOAPBodyElement = (SOAPBodyElement)vector.elementAt(0);
            String string = sOAPBodyElement.toString();
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    public static void main(String[] stringArray) {
        try {
            AdminClient adminClient = new AdminClient();
            String string = adminClient.process(stringArray);
            if (string != null) {
                System.out.println(StringUtils.unescapeNumericChar(string));
            } else {
                System.exit(1);
            }
        }
        catch (AxisFault axisFault) {
            System.err.println(Messages.getMessage("exception00") + " " + axisFault.dumpToString());
            System.exit(1);
        }
        catch (Exception exception) {
            System.err.println(Messages.getMessage("exception00") + " " + exception.getMessage());
            System.exit(1);
        }
    }
}

