/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.compiler;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.axis.components.compiler.AbstractCompiler;
import org.apache.axis.components.compiler.CompilerError;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class Javac
extends AbstractCompiler {
    protected static Log log = LogFactory.getLog(Javac.class.getName());
    public static final String CLASSIC_CLASS = "sun.tools.javac.Main";
    public static final String MODERN_CLASS = "com.sun.tools.javac.main.Main";
    private boolean modern = false;

    public Javac() {
        ClassLoader classLoader = this.getClassLoader();
        try {
            ClassUtils.forName(MODERN_CLASS, true, classLoader);
            this.modern = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.debug(Messages.getMessage("noModernCompiler"));
            try {
                ClassUtils.forName(CLASSIC_CLASS, true, classLoader);
                this.modern = false;
            }
            catch (Exception exception) {
                log.error(Messages.getMessage("noCompiler00"), exception);
                throw new RuntimeException(Messages.getMessage("noCompiler00"));
            }
        }
        log.debug(Messages.getMessage("compilerClass", this.modern ? MODERN_CLASS : CLASSIC_CLASS));
    }

    private ClassLoader getClassLoader() {
        File file;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL uRL = null;
        String string = System.getProperty("java.home");
        if (string != null && (file = new File(string + "/../lib/tools.jar")).exists()) {
            try {
                uRL = file.toURL();
                classLoader = new URLClassLoader(new URL[]{uRL}, classLoader);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return classLoader;
    }

    public boolean compile() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        try {
            Object t;
            Object object;
            Class clazz = ClassUtils.forName(this.modern ? MODERN_CLASS : CLASSIC_CLASS, true, this.getClassLoader());
            if (this.modern) {
                object = new PrintWriter(new OutputStreamWriter(byteArrayOutputStream));
                Constructor constructor = clazz.getConstructor(String.class, PrintWriter.class);
                t = constructor.newInstance("javac", object);
            } else {
                Constructor constructor = clazz.getConstructor(OutputStream.class, String.class);
                t = constructor.newInstance(byteArrayOutputStream, "javac");
            }
            object = clazz.getMethod("compile", String[].class);
            if (this.modern) {
                int n = (Integer)((Method)object).invoke(t, new Object[]{this.toStringArray(this.fillArguments(new ArrayList()))});
                bl = n == 0;
                log.debug("Compilation Returned: " + Integer.toString(n));
            } else {
                Boolean bl2 = (Boolean)((Method)object).invoke(t, new Object[]{this.toStringArray(this.fillArguments(new ArrayList()))});
                bl = bl2;
            }
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("noCompiler00"), exception);
            throw new RuntimeException(Messages.getMessage("noCompiler00"));
        }
        this.errors = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        return bl;
    }

    protected List parseStream(BufferedReader bufferedReader) throws IOException {
        if (this.modern) {
            return this.parseModernStream(bufferedReader);
        }
        return this.parseClassicStream(bufferedReader);
    }

    protected List parseModernStream(BufferedReader bufferedReader) throws IOException {
        ArrayList<CompilerError> arrayList = new ArrayList<CompilerError>();
        String string = null;
        StringBuffer stringBuffer = null;
        while (true) {
            stringBuffer = new StringBuffer();
            do {
                if ((string = bufferedReader.readLine()) == null) {
                    if (stringBuffer.length() > 0) {
                        arrayList.add(new CompilerError("\n" + stringBuffer.toString()));
                    }
                    return arrayList;
                }
                log.debug(string);
                stringBuffer.append(string);
                stringBuffer.append('\n');
            } while (!string.endsWith("^"));
            arrayList.add(this.parseModernError(stringBuffer.toString()));
        }
    }

    private CompilerError parseModernError(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        try {
            String string2;
            int n;
            String string3 = stringTokenizer.nextToken();
            if (string3.length() == 1) {
                string3 = new StringBuffer(string3).append(":").append(stringTokenizer.nextToken()).toString();
            }
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            String string4 = stringTokenizer.nextToken("\n").substring(1);
            String string5 = stringTokenizer.nextToken("\n");
            int n3 = string5.indexOf(" ", n = (string2 = stringTokenizer.nextToken("\n")).indexOf("^"));
            if (n3 == -1) {
                n3 = string5.length();
            }
            return new CompilerError(string3, false, n2, n, n2, n3, string4);
        }
        catch (NoSuchElementException noSuchElementException) {
            return new CompilerError(Messages.getMessage("noMoreTokens", string));
        }
        catch (Exception exception) {
            return new CompilerError(Messages.getMessage("cantParse", string));
        }
    }

    protected List parseClassicStream(BufferedReader bufferedReader) throws IOException {
        ArrayList<CompilerError> arrayList = null;
        String string = null;
        StringBuffer stringBuffer = null;
        while (true) {
            stringBuffer = new StringBuffer();
            for (int i = 0; i < 3; ++i) {
                string = bufferedReader.readLine();
                if (string == null) {
                    return arrayList;
                }
                log.debug(string);
                stringBuffer.append(string);
                stringBuffer.append('\n');
            }
            if (arrayList == null) {
                arrayList = new ArrayList<CompilerError>();
            }
            arrayList.add(this.parseClassicError(stringBuffer.toString()));
        }
    }

    private CompilerError parseClassicError(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        try {
            String string2;
            int n;
            String string3 = stringTokenizer.nextToken();
            if (string3.length() == 1) {
                string3 = new StringBuffer(string3).append(":").append(stringTokenizer.nextToken()).toString();
            }
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            String string4 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreElements()) {
                string4 = string4 + stringTokenizer.nextToken();
            }
            stringTokenizer = new StringTokenizer(string4.trim(), "\n");
            String string5 = stringTokenizer.nextToken();
            String string6 = stringTokenizer.nextToken();
            int n3 = string6.indexOf(" ", n = (string2 = stringTokenizer.nextToken()).indexOf("^"));
            if (n3 == -1) {
                n3 = string6.length();
            }
            return new CompilerError(this.srcDir + File.separator + string3, true, n2, n, n2, n3, string5);
        }
        catch (NoSuchElementException noSuchElementException) {
            return new CompilerError(Messages.getMessage("noMoreTokens", string));
        }
        catch (Exception exception) {
            return new CompilerError(Messages.getMessage("cantParse", string));
        }
    }

    public String toString() {
        return Messages.getMessage("sunJavac");
    }
}

