/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.encoding;

import org.apache.axis.components.encoding.XMLEncoder;
import org.apache.axis.utils.Messages;

public abstract class AbstractXMLEncoder
implements XMLEncoder {
    protected static final String AMP = "&amp;";
    protected static final String QUOTE = "&quot;";
    protected static final String LESS = "&lt;";
    protected static final String GREATER = "&gt;";
    protected static final String LF = "\n";
    protected static final String CR = "\r";
    protected static final String TAB = "\t";

    public abstract String getEncoding();

    public String encode(String string) {
        if (string == null) {
            return "";
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = null;
        block9: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '&': {
                    if (stringBuffer == null) {
                        stringBuffer = this.getInitialByteArray(string, i);
                    }
                    stringBuffer.append(AMP);
                    continue block9;
                }
                case '\"': {
                    if (stringBuffer == null) {
                        stringBuffer = this.getInitialByteArray(string, i);
                    }
                    stringBuffer.append(QUOTE);
                    continue block9;
                }
                case '<': {
                    if (stringBuffer == null) {
                        stringBuffer = this.getInitialByteArray(string, i);
                    }
                    stringBuffer.append(LESS);
                    continue block9;
                }
                case '>': {
                    if (stringBuffer == null) {
                        stringBuffer = this.getInitialByteArray(string, i);
                    }
                    stringBuffer.append(GREATER);
                    continue block9;
                }
                case '\n': {
                    if (stringBuffer == null) {
                        stringBuffer = this.getInitialByteArray(string, i);
                    }
                    stringBuffer.append(LF);
                    continue block9;
                }
                case '\r': {
                    if (stringBuffer == null) {
                        stringBuffer = this.getInitialByteArray(string, i);
                    }
                    stringBuffer.append(CR);
                    continue block9;
                }
                case '\t': {
                    if (stringBuffer == null) {
                        stringBuffer = this.getInitialByteArray(string, i);
                    }
                    stringBuffer.append(TAB);
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        throw new IllegalArgumentException(Messages.getMessage("invalidXmlCharacter00", Integer.toHexString(c), string));
                    }
                    if (stringBuffer == null) continue block9;
                    stringBuffer.append(c);
                }
            }
        }
        if (stringBuffer == null) {
            return string;
        }
        return stringBuffer.toString();
    }

    protected StringBuffer getInitialByteArray(String string, int n) {
        return new StringBuffer(string.substring(0, n));
    }
}

