/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.jms;

import java.util.HashMap;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Call;
import org.apache.axis.transport.jms.JMSURLHelper;

public abstract class JMSVendorAdapter {
    public static final int SEND_ACTION = 0;
    public static final int CONNECT_ACTION = 1;
    public static final int SUBSCRIBE_ACTION = 2;
    public static final int RECEIVE_ACTION = 3;
    public static final int ON_EXCEPTION_ACTION = 4;

    public abstract QueueConnectionFactory getQueueConnectionFactory(HashMap var1) throws Exception;

    public abstract TopicConnectionFactory getTopicConnectionFactory(HashMap var1) throws Exception;

    public abstract void addVendorConnectionFactoryProperties(JMSURLHelper var1, HashMap var2);

    public abstract boolean isMatchingConnectionFactory(ConnectionFactory var1, JMSURLHelper var2, HashMap var3);

    public String getVendorId() {
        int n;
        String string = this.getClass().getName();
        if (string.endsWith("VendorAdapter")) {
            n = string.lastIndexOf("VendorAdapter");
            string = string.substring(0, n);
        }
        if ((n = string.lastIndexOf(".")) > 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public HashMap getJMSConnectorProperties(JMSURLHelper jMSURLHelper) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("transport.jms.EndpointAddress", jMSURLHelper);
        String string7 = jMSURLHelper.getPropertyValue("clientID");
        if (string7 != null) {
            hashMap.put("transport.jms.clientID", string7);
        }
        if ((string6 = jMSURLHelper.getPropertyValue("connectRetryInterval")) != null) {
            hashMap.put("transport.jms.connectRetryInterval", string6);
        }
        if ((string5 = jMSURLHelper.getPropertyValue("interactRetryInterval")) != null) {
            hashMap.put("transport.jms.interactRetryInterval", string5);
        }
        if ((string4 = jMSURLHelper.getPropertyValue("domain")) != null) {
            hashMap.put("transport.jms.domain", string4);
        }
        if ((string3 = jMSURLHelper.getPropertyValue("numRetries")) != null) {
            hashMap.put("transport.jms.numRetries", string3);
        }
        if ((string2 = jMSURLHelper.getPropertyValue("numSessions")) != null) {
            hashMap.put("transport.jms.numSessions", string2);
        }
        if ((string = jMSURLHelper.getPropertyValue("timeoutTime")) != null) {
            hashMap.put("transport.jms.timeoutTime", string);
        }
        return hashMap;
    }

    public HashMap getJMSConnectionFactoryProperties(JMSURLHelper jMSURLHelper) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("transport.jms.EndpointAddress", jMSURLHelper);
        String string = jMSURLHelper.getPropertyValue("domain");
        if (string != null) {
            hashMap.put("transport.jms.domain", string);
        }
        this.addVendorConnectionFactoryProperties(jMSURLHelper, hashMap);
        return hashMap;
    }

    public Queue getQueue(QueueSession queueSession, String string) throws Exception {
        return queueSession.createQueue(string);
    }

    public Topic getTopic(TopicSession topicSession, String string) throws Exception {
        return topicSession.createTopic(string);
    }

    public boolean isRecoverable(Throwable throwable, int n) {
        if (throwable instanceof RuntimeException || throwable instanceof Error || throwable instanceof JMSSecurityException || throwable instanceof InvalidDestinationException) {
            return false;
        }
        return n != 4;
    }

    public void setProperties(Message message, HashMap hashMap) throws JMSException {
        for (String string : hashMap.keySet()) {
            String string2 = (String)hashMap.get(string);
            message.setStringProperty(string, string2);
        }
    }

    public void setupMessageContext(MessageContext messageContext, Call call, JMSURLHelper jMSURLHelper) {
        Object object = null;
        String string = null;
        if (jMSURLHelper != null) {
            string = jMSURLHelper.getDestination();
        }
        if (string != null) {
            messageContext.setProperty("transport.jms.Destination", string);
        } else {
            object = call.getProperty("transport.jms.Destination");
            if (object != null && object instanceof String) {
                messageContext.setProperty("transport.jms.Destination", object);
            } else {
                messageContext.removeProperty("transport.jms.Destination");
            }
        }
        String string2 = null;
        if (jMSURLHelper != null) {
            string2 = jMSURLHelper.getPropertyValue("deliveryMode");
        }
        if (string2 != null) {
            int n = 1;
            if (string2.equalsIgnoreCase("Persistent")) {
                n = 2;
            } else if (string2.equalsIgnoreCase("Nonpersistent")) {
                n = 1;
            }
            messageContext.setProperty("transport.jms.deliveryMode", new Integer(n));
        } else {
            object = call.getProperty("transport.jms.deliveryMode");
            if (object != null && object instanceof Integer) {
                messageContext.setProperty("transport.jms.deliveryMode", object);
            } else {
                messageContext.removeProperty("transport.jms.deliveryMode");
            }
        }
        String string3 = null;
        if (jMSURLHelper != null) {
            string3 = jMSURLHelper.getPropertyValue("priority");
        }
        if (string3 != null) {
            messageContext.setProperty("transport.jms.priority", Integer.valueOf(string3));
        } else {
            object = call.getProperty("transport.jms.priority");
            if (object != null && object instanceof Integer) {
                messageContext.setProperty("transport.jms.priority", object);
            } else {
                messageContext.removeProperty("transport.jms.priority");
            }
        }
        String string4 = null;
        if (jMSURLHelper != null) {
            string4 = jMSURLHelper.getPropertyValue("ttl");
        }
        if (string4 != null) {
            messageContext.setProperty("transport.jms.ttl", Long.valueOf(string4));
        } else {
            object = call.getProperty("transport.jms.ttl");
            if (object != null && object instanceof Long) {
                messageContext.setProperty("transport.jms.ttl", object);
            } else {
                messageContext.removeProperty("transport.jms.ttl");
            }
        }
        String string5 = null;
        if (jMSURLHelper != null) {
            string5 = jMSURLHelper.getPropertyValue("waitForResponse");
        }
        if (string5 != null) {
            messageContext.setProperty("transport.jms.waitForResponse", Boolean.valueOf(string5));
        } else {
            object = call.getProperty("transport.jms.waitForResponse");
            if (object != null && object instanceof Boolean) {
                messageContext.setProperty("transport.jms.waitForResponse", object);
            } else {
                messageContext.removeProperty("transport.jms.waitForResponse");
            }
        }
        this.setupApplicationProperties(messageContext, call, jMSURLHelper);
    }

    public void setupApplicationProperties(MessageContext messageContext, Call call, JMSURLHelper jMSURLHelper) {
        Object object;
        Object object2;
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        if (jMSURLHelper != null && jMSURLHelper.getApplicationProperties() != null) {
            object2 = jMSURLHelper.getApplicationProperties().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                hashMap.put(object, jMSURLHelper.getPropertyValue((String)object));
            }
        }
        if ((object2 = (Map)messageContext.getProperty("transport.jms.msgProps")) != null) {
            hashMap.putAll((Map<Object, String>)object2);
        }
        if ((object = (Map)call.getProperty("transport.jms.msgProps")) != null) {
            hashMap.putAll((Map<Object, String>)object);
        }
        messageContext.setProperty("transport.jms.msgProps", hashMap);
    }
}

