/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.net;

import org.apache.axis.AxisProperties;
import org.apache.axis.components.net.CommonsHTTPClientProperties;

public class DefaultCommonsHTTPClientProperties
implements CommonsHTTPClientProperties {
    public static final String MAXIMUM_TOTAL_CONNECTIONS_PROPERTY_KEY = "axis.http.client.maximum.total.connections";
    public static final String MAXIMUM_CONNECTIONS_PER_HOST_PROPERTY_KEY = "axis.http.client.maximum.connections.per.host";
    public static final String CONNECTION_POOL_TIMEOUT_KEY = "axis.http.client.connection.pool.timeout";
    public static final String CONNECTION_DEFAULT_CONNECTION_TIMEOUT_KEY = "axis.http.client.connection.default.connection.timeout";
    public static final String CONNECTION_DEFAULT_SO_TIMEOUT_KEY = "axis.http.client.connection.default.so.timeout";

    protected final int getIntegerProperty(String string, String string2) {
        return Integer.parseInt(AxisProperties.getProperty(string, string2));
    }

    public int getMaximumTotalConnections() {
        int n = this.getIntegerProperty(MAXIMUM_TOTAL_CONNECTIONS_PROPERTY_KEY, "20");
        if (n < 1) {
            throw new IllegalStateException("axis.http.client.maximum.total.connections must be > 1");
        }
        return n;
    }

    public int getMaximumConnectionsPerHost() {
        int n = this.getIntegerProperty(MAXIMUM_CONNECTIONS_PER_HOST_PROPERTY_KEY, "2");
        if (n < 1) {
            throw new IllegalStateException("axis.http.client.maximum.connections.per.host must be > 1");
        }
        return n;
    }

    public int getConnectionPoolTimeout() {
        int n = this.getIntegerProperty(CONNECTION_POOL_TIMEOUT_KEY, "0");
        if (n < 0) {
            throw new IllegalStateException("axis.http.client.connection.pool.timeout must be >= 0");
        }
        return n;
    }

    public int getDefaultConnectionTimeout() {
        int n = this.getIntegerProperty(CONNECTION_DEFAULT_CONNECTION_TIMEOUT_KEY, "0");
        if (n < 0) {
            throw new IllegalStateException("axis.http.client.connection.default.connection.timeout must be >= 0");
        }
        return n;
    }

    public int getDefaultSoTimeout() {
        int n = this.getIntegerProperty(CONNECTION_DEFAULT_SO_TIMEOUT_KEY, "0");
        if (n < 0) {
            throw new IllegalStateException("axis.http.client.connection.default.so.timeout must be >= 0");
        }
        return n;
    }
}

