/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.net;

import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Hashtable;
import org.apache.axis.components.net.JSSESocketFactory;
import org.apache.axis.components.net.SecureSocketFactory;
import sun.security.provider.Sun;

public class SunJSSESocketFactory
extends JSSESocketFactory
implements SecureSocketFactory {
    private String keystoreType;
    static String defaultKeystoreType = "JKS";
    static String defaultProtocol = "TLS";
    static String defaultAlgorithm = "SunX509";
    static boolean defaultClientAuth = false;
    private boolean clientAuth = false;
    static String defaultKeystoreFile = System.getProperty("user.home") + "/.keystore";
    static String defaultKeyPass = "changeit";

    public SunJSSESocketFactory(Hashtable hashtable) {
        super(hashtable);
    }

    protected void initFactory() throws IOException {
        try {
            Security.addProvider(new Sun());
            Security.addProvider((java.security.Provider)new Provider());
            SSLContext sSLContext = this.getContext();
            this.sslFactory = sSLContext.getSocketFactory();
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(exception.getMessage());
        }
    }

    protected SSLContext getContext() throws Exception {
        TrustManagerFactory trustManagerFactory;
        String string;
        String string2;
        String string3;
        if (this.attributes == null) {
            SSLContext sSLContext = SSLContext.getInstance((String)"SSL");
            sSLContext.init(null, null, null);
            return sSLContext;
        }
        String string4 = (String)this.attributes.get("keystore");
        if (string4 == null) {
            string4 = defaultKeystoreFile;
        }
        this.keystoreType = (String)this.attributes.get("keystoreType");
        if (this.keystoreType == null) {
            this.keystoreType = defaultKeystoreType;
        }
        this.clientAuth = null != (String)this.attributes.get("clientauth");
        String string5 = (String)this.attributes.get("keypass");
        if (string5 == null) {
            string5 = defaultKeyPass;
        }
        if ((string3 = (String)this.attributes.get("keystorePass")) == null) {
            string3 = string5;
        }
        if ((string2 = (String)this.attributes.get("protocol")) == null) {
            string2 = defaultProtocol;
        }
        if ((string = (String)this.attributes.get("algorithm")) == null) {
            string = defaultAlgorithm;
        }
        KeyStore keyStore = this.initKeyStore(string4, string3);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance((String)string);
        keyManagerFactory.init(keyStore, string5.toCharArray());
        TrustManager[] trustManagerArray = null;
        if (this.clientAuth) {
            trustManagerFactory = TrustManagerFactory.getInstance((String)"SunX509");
            trustManagerFactory.init(keyStore);
            trustManagerArray = trustManagerFactory.getTrustManagers();
        }
        trustManagerFactory = SSLContext.getInstance((String)string2);
        trustManagerFactory.init(keyManagerFactory.getKeyManagers(), trustManagerArray, new SecureRandom());
        return trustManagerFactory;
    }

    private KeyStore initKeyStore(String string, String string2) throws IOException {
        try {
            KeyStore keyStore = KeyStore.getInstance(this.keystoreType);
            FileInputStream fileInputStream = new FileInputStream(string);
            keyStore.load(fileInputStream, string2.toCharArray());
            return keyStore;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException("Exception trying to load keystore " + string + ": " + exception.getMessage());
        }
    }
}

