/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.uuid;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.axis.components.uuid.UUIDGen;

public class SimpleUUIDGen
implements UUIDGen {
    private static final BigInteger countStart = new BigInteger("-12219292800000");
    private static final int clock_sequence = new Random().nextInt(16384);
    private static final byte ZERO = 48;
    private static final byte ONE = 49;
    private static Random secureRandom = null;

    private static final String leftZeroPadString(String string, int n) {
        if (string.length() < n) {
            int n2 = n - string.length();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
            string = stringBuffer.toString();
        }
        return string;
    }

    public String nextUUID() {
        BigInteger bigInteger = BigInteger.valueOf(System.currentTimeMillis());
        BigInteger bigInteger2 = bigInteger.subtract(countStart);
        BigInteger bigInteger3 = bigInteger2.multiply(BigInteger.valueOf(10000L));
        byte[] byArray = SimpleUUIDGen.leftZeroPadString(bigInteger3.toString(2), 60).getBytes();
        byte[] byArray2 = new byte[32];
        for (int i = 0; i < 32; ++i) {
            byArray2[i] = byArray[byArray.length - i - 1];
        }
        byte[] byArray3 = new byte[16];
        for (int i = 0; i < 16; ++i) {
            byArray3[i] = byArray[byArray.length - 32 - i - 1];
        }
        byte[] byArray4 = new byte[16];
        for (int i = 0; i < 12; ++i) {
            byArray4[i] = byArray[byArray.length - 48 - i - 1];
        }
        byArray4[12] = 49;
        byArray4[13] = 48;
        byArray4[14] = 48;
        byArray4[15] = 48;
        BigInteger bigInteger4 = BigInteger.valueOf(clock_sequence);
        byte[] byArray5 = SimpleUUIDGen.leftZeroPadString(bigInteger4.toString(2), 14).getBytes();
        byte[] byArray6 = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray6[i] = byArray5[byArray5.length - i - 1];
        }
        byte[] byArray7 = new byte[8];
        for (int i = 0; i < 6; ++i) {
            byArray7[i] = byArray5[byArray5.length - 8 - i - 1];
        }
        byArray7[6] = 48;
        byArray7[7] = 49;
        String string = Long.toHexString(new BigInteger(new String(SimpleUUIDGen.reverseArray(byArray2)), 2).longValue());
        string = SimpleUUIDGen.leftZeroPadString(string, 8);
        String string2 = Long.toHexString(new BigInteger(new String(SimpleUUIDGen.reverseArray(byArray3)), 2).longValue());
        string2 = SimpleUUIDGen.leftZeroPadString(string2, 4);
        String string3 = Long.toHexString(new BigInteger(new String(SimpleUUIDGen.reverseArray(byArray4)), 2).longValue());
        string3 = SimpleUUIDGen.leftZeroPadString(string3, 4);
        String string4 = Long.toHexString(new BigInteger(new String(SimpleUUIDGen.reverseArray(byArray7)), 2).longValue());
        string4 = SimpleUUIDGen.leftZeroPadString(string4, 2);
        String string5 = Long.toHexString(new BigInteger(new String(SimpleUUIDGen.reverseArray(byArray6)), 2).longValue());
        string5 = SimpleUUIDGen.leftZeroPadString(string5, 2);
        long l = secureRandom.nextLong();
        l = Math.abs(l);
        while (l > 0x800000000000L) {
            l = secureRandom.nextLong();
            l = Math.abs(l);
        }
        BigInteger bigInteger5 = BigInteger.valueOf(l);
        byte[] byArray8 = SimpleUUIDGen.leftZeroPadString(bigInteger5.toString(2), 47).getBytes();
        byte[] byArray9 = new byte[48];
        for (int i = 0; i < 47; ++i) {
            byArray9[i] = byArray8[byArray8.length - i - 1];
        }
        byArray9[47] = 49;
        String string6 = Long.toHexString(new BigInteger(new String(SimpleUUIDGen.reverseArray(byArray9)), 2).longValue());
        string6 = SimpleUUIDGen.leftZeroPadString(string6, 12);
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("-");
        stringBuffer.append(string2);
        stringBuffer.append("-");
        stringBuffer.append(string3);
        stringBuffer.append("-");
        stringBuffer.append(string4);
        stringBuffer.append(string5);
        stringBuffer.append("-");
        stringBuffer.append(string6);
        return stringBuffer.toString().toUpperCase();
    }

    private static byte[] reverseArray(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = byArray[byArray2.length - 1 - i];
        }
        return byArray2;
    }

    static {
        try {
            secureRandom = SecureRandom.getInstance("SHA1PRNG", "SUN");
        }
        catch (Exception exception) {
            secureRandom = new Random();
        }
    }
}

