/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.configuration;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.ConfigurationException;
import org.apache.axis.Handler;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.deployment.wsdd.WSDDGlobalConfiguration;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.utils.Admin;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;

public class FileProvider
implements WSDDEngineConfiguration {
    protected static Log log = LogFactory.getLog(FileProvider.class.getName());
    private WSDDDeployment deployment = null;
    private String filename;
    private File configFile = null;
    private InputStream myInputStream = null;
    private boolean readOnly = true;
    private boolean searchClasspath = true;

    public FileProvider(String string) {
        this.filename = string;
        this.configFile = new File(string);
        this.check();
    }

    public FileProvider(String string, String string2) throws ConfigurationException {
        this.filename = string2;
        File file = new File(string);
        if (!(file.exists() && file.isDirectory() && file.canRead())) {
            throw new ConfigurationException(Messages.getMessage("invalidConfigFilePath", string));
        }
        this.configFile = new File(string, string2);
        this.check();
    }

    private void check() {
        try {
            this.readOnly = this.configFile.canRead() & !this.configFile.canWrite();
        }
        catch (SecurityException securityException) {
            this.readOnly = true;
        }
        if (this.readOnly) {
            log.info(Messages.getMessage("readOnlyConfigFile"));
        }
    }

    public FileProvider(InputStream inputStream) {
        this.setInputStream(inputStream);
    }

    public void setInputStream(InputStream inputStream) {
        this.myInputStream = inputStream;
    }

    private InputStream getInputStream() {
        return this.myInputStream;
    }

    public WSDDDeployment getDeployment() {
        return this.deployment;
    }

    public void setDeployment(WSDDDeployment wSDDDeployment) {
        this.deployment = wSDDDeployment;
    }

    public void setSearchClasspath(boolean bl) {
        this.searchClasspath = bl;
    }

    public void configureEngine(AxisEngine axisEngine) throws ConfigurationException {
        try {
            block6: {
                if (this.getInputStream() == null) {
                    try {
                        this.setInputStream(new FileInputStream(this.configFile));
                    }
                    catch (Exception exception) {
                        if (!this.searchClasspath) break block6;
                        this.setInputStream(ClassUtils.getResourceAsStream(axisEngine.getClass(), this.filename, true));
                    }
                }
            }
            if (this.getInputStream() == null) {
                throw new ConfigurationException(Messages.getMessage("noConfigFile"));
            }
            WSDDDocument wSDDDocument = new WSDDDocument(XMLUtils.newDocument(this.getInputStream()));
            this.deployment = wSDDDocument.getDeployment();
            this.deployment.configureEngine(axisEngine);
            axisEngine.refreshGlobalOptions();
            this.setInputStream(null);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception);
        }
    }

    public void writeEngineConfig(AxisEngine axisEngine) throws ConfigurationException {
        if (!this.readOnly) {
            try {
                Document document = Admin.listConfig(axisEngine);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.configFile), XMLUtils.getEncoding());
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(outputStreamWriter));
                XMLUtils.DocumentToWriter(document, printWriter);
                printWriter.println();
                printWriter.close();
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception);
            }
        }
    }

    public Handler getHandler(QName qName) throws ConfigurationException {
        return this.deployment.getHandler(qName);
    }

    public SOAPService getService(QName qName) throws ConfigurationException {
        SOAPService sOAPService = this.deployment.getService(qName);
        if (sOAPService == null) {
            throw new ConfigurationException(Messages.getMessage("noService10", qName.toString()));
        }
        return sOAPService;
    }

    public SOAPService getServiceByNamespaceURI(String string) throws ConfigurationException {
        return this.deployment.getServiceByNamespaceURI(string);
    }

    public Handler getTransport(QName qName) throws ConfigurationException {
        return this.deployment.getTransport(qName);
    }

    public TypeMappingRegistry getTypeMappingRegistry() throws ConfigurationException {
        return this.deployment.getTypeMappingRegistry();
    }

    public Handler getGlobalRequest() throws ConfigurationException {
        return this.deployment.getGlobalRequest();
    }

    public Handler getGlobalResponse() throws ConfigurationException {
        return this.deployment.getGlobalResponse();
    }

    public Hashtable getGlobalOptions() throws ConfigurationException {
        WSDDGlobalConfiguration wSDDGlobalConfiguration = this.deployment.getGlobalConfiguration();
        if (wSDDGlobalConfiguration != null) {
            return wSDDGlobalConfiguration.getParametersTable();
        }
        return null;
    }

    public Iterator getDeployedServices() throws ConfigurationException {
        return this.deployment.getDeployedServices();
    }

    public List getRoles() {
        return this.deployment.getRoles();
    }
}

