/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.utils.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class WSDDElement
extends WSDDConstants
implements Serializable {
    private String name;

    public WSDDElement() {
    }

    public WSDDElement(Element element) throws WSDDException {
        this.validateCandidateElement(element);
    }

    protected abstract QName getElementName();

    private void validateCandidateElement(Element element) throws WSDDException {
        QName qName = this.getElementName();
        if (null == element || null == element.getNamespaceURI() || null == element.getLocalName() || !element.getNamespaceURI().equals(qName.getNamespaceURI()) || !element.getLocalName().equals(qName.getLocalPart())) {
            throw new WSDDException(Messages.getMessage("invalidWSDD00", element.getLocalName(), qName.getLocalPart()));
        }
    }

    public Element getChildElement(Element element, String string) {
        Element[] elementArray = this.getChildElements(element, string);
        if (elementArray.length == 0) {
            return null;
        }
        return elementArray[0];
    }

    public Element[] getChildElements(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        Vector<Element> vector = new Vector<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(element2 = (Element)node).getLocalName().equals(string)) continue;
            vector.add(element2);
        }
        Element[] elementArray = new Element[vector.size()];
        vector.toArray(elementArray);
        return elementArray;
    }

    public abstract void writeToContext(SerializationContext var1) throws IOException;
}

