/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDOperation;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.deployment.wsdd.providers.WSDDBsfProvider;
import org.apache.axis.deployment.wsdd.providers.WSDDComProvider;
import org.apache.axis.deployment.wsdd.providers.WSDDHandlerProvider;
import org.apache.axis.deployment.wsdd.providers.WSDDJavaCORBAProvider;
import org.apache.axis.deployment.wsdd.providers.WSDDJavaEJBProvider;
import org.apache.axis.deployment.wsdd.providers.WSDDJavaMsgProvider;
import org.apache.axis.deployment.wsdd.providers.WSDDJavaRMIProvider;
import org.apache.axis.deployment.wsdd.providers.WSDDJavaRPCProvider;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.names.DiscoverServiceNames;
import org.apache.commons.logging.Log;

public abstract class WSDDProvider {
    protected static Log log = LogFactory.getLog(WSDDProvider.class.getName());
    private static final String PLUGABLE_PROVIDER_FILENAME = "org.apache.axis.deployment.wsdd.Provider";
    private static Hashtable providers = new Hashtable();

    private static void loadPluggableProviders() {
        ClassLoader classLoader = WSDDProvider.class.getClassLoader();
        ClassLoaders classLoaders = new ClassLoaders();
        classLoaders.put(classLoader);
        DiscoverServiceNames discoverServiceNames = new DiscoverServiceNames(classLoaders);
        ResourceNameIterator resourceNameIterator = discoverServiceNames.findResourceNames(PLUGABLE_PROVIDER_FILENAME);
        while (resourceNameIterator.hasNext()) {
            Object object;
            String string = resourceNameIterator.nextResourceName();
            try {
                Object obj = Class.forName(string).newInstance();
                if (!(obj instanceof WSDDProvider)) continue;
                object = (WSDDProvider)obj;
                String string2 = ((WSDDProvider)object).getName();
                QName qName = new QName("http://xml.apache.org/axis/wsdd/providers/java", string2);
                providers.put(qName, object);
            }
            catch (Exception exception) {
                object = exception + JavaUtils.LS + JavaUtils.stackToString(exception);
                log.info(Messages.getMessage("exception01", (String)object));
            }
        }
    }

    public static void registerProvider(QName qName, WSDDProvider wSDDProvider) {
        providers.put(qName, wSDDProvider);
    }

    public WSDDOperation[] getOperations() {
        return null;
    }

    public WSDDOperation getOperation(String string) {
        return null;
    }

    public static Handler getInstance(QName qName, WSDDService wSDDService, EngineConfiguration engineConfiguration) throws Exception {
        if (qName == null) {
            throw new WSDDException(Messages.getMessage("nullProvider00"));
        }
        WSDDProvider wSDDProvider = (WSDDProvider)providers.get(qName);
        if (wSDDProvider == null) {
            throw new WSDDException(Messages.getMessage("noMatchingProvider00", qName.toString()));
        }
        return wSDDProvider.newProviderInstance(wSDDService, engineConfiguration);
    }

    public abstract Handler newProviderInstance(WSDDService var1, EngineConfiguration var2) throws Exception;

    public abstract String getName();

    static {
        providers.put(WSDDConstants.QNAME_JAVARPC_PROVIDER, new WSDDJavaRPCProvider());
        providers.put(WSDDConstants.QNAME_JAVAMSG_PROVIDER, new WSDDJavaMsgProvider());
        providers.put(WSDDConstants.QNAME_HANDLER_PROVIDER, new WSDDHandlerProvider());
        providers.put(WSDDConstants.QNAME_EJB_PROVIDER, new WSDDJavaEJBProvider());
        providers.put(WSDDConstants.QNAME_COM_PROVIDER, new WSDDComProvider());
        providers.put(WSDDConstants.QNAME_BSF_PROVIDER, new WSDDBsfProvider());
        providers.put(WSDDConstants.QNAME_CORBA_PROVIDER, new WSDDJavaCORBAProvider());
        providers.put(WSDDConstants.QNAME_RMI_PROVIDER, new WSDDJavaRMIProvider());
        try {
            WSDDProvider.loadPluggableProviders();
        }
        catch (Throwable throwable) {
            String string = throwable + JavaUtils.LS + JavaUtils.stackToString(throwable);
            log.info(Messages.getMessage("exception01", string));
        }
    }
}

