/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.FaultableHandler;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.attachments.AttachmentsImpl;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.deployment.wsdd.WSDDArrayMapping;
import org.apache.axis.deployment.wsdd.WSDDBeanMapping;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDDocumentation;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDFaultFlow;
import org.apache.axis.deployment.wsdd.WSDDJAXRPCHandlerInfoChain;
import org.apache.axis.deployment.wsdd.WSDDNonFatalException;
import org.apache.axis.deployment.wsdd.WSDDOperation;
import org.apache.axis.deployment.wsdd.WSDDProvider;
import org.apache.axis.deployment.wsdd.WSDDRequestFlow;
import org.apache.axis.deployment.wsdd.WSDDResponseFlow;
import org.apache.axis.deployment.wsdd.WSDDTargetedChain;
import org.apache.axis.deployment.wsdd.WSDDTypeMapping;
import org.apache.axis.deployment.wsdd.WSDDTypeMappingContainer;
import org.apache.axis.description.JavaServiceDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.TypeMappingRegistryImpl;
import org.apache.axis.encoding.ser.ArraySerializerFactory;
import org.apache.axis.encoding.ser.BaseDeserializerFactory;
import org.apache.axis.encoding.ser.BaseSerializerFactory;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDService
extends WSDDTargetedChain
implements WSDDTypeMappingContainer {
    private TypeMappingRegistry tmr = null;
    private Vector faultFlows = new Vector();
    private Vector typeMappings = new Vector();
    private Vector operations = new Vector();
    private Vector namespaces = new Vector();
    private List roles = new ArrayList();
    private String descriptionURL;
    private Style style = Style.DEFAULT;
    private Use use = Use.DEFAULT;
    private transient SOAPService cachedService = null;
    private QName providerQName;
    private WSDDJAXRPCHandlerInfoChain _wsddHIchain;
    JavaServiceDesc desc = new JavaServiceDesc();
    private boolean streaming = false;
    private int sendType = 1;

    public WSDDService() {
    }

    public WSDDService(Element element) throws WSDDException {
        super(element);
        Element element2;
        String string;
        Object object;
        Object object2;
        String string2;
        String string3;
        this.desc.setName(this.getQName().getLocalPart());
        String string4 = element.getAttribute("style");
        if (string4 != null && !string4.equals("")) {
            this.style = Style.getStyle(string4, Style.DEFAULT);
            this.desc.setStyle(this.style);
            this.providerQName = this.style.getProvider();
        }
        if ((string3 = element.getAttribute("use")) != null && !string3.equals("")) {
            this.use = Use.getUse(string3, Use.DEFAULT);
            this.desc.setUse(this.use);
        } else if (this.style != Style.RPC) {
            this.use = Use.LITERAL;
            this.desc.setUse(this.use);
        }
        String string5 = element.getAttribute("streaming");
        if (string5 != null && string5.equals("on")) {
            this.streaming = true;
        }
        if ((string2 = element.getAttribute("attachment")) != null && !string2.equals("")) {
            this.sendType = AttachmentsImpl.getSendType(string2);
        }
        Element[] elementArray = this.getChildElements(element, "operation");
        for (int i = 0; i < elementArray.length; ++i) {
            WSDDOperation wSDDOperation = new WSDDOperation(elementArray[i], this.desc);
            this.addOperation(wSDDOperation);
        }
        Element[] elementArray2 = this.getChildElements(element, "typeMapping");
        for (int i = 0; i < elementArray2.length; ++i) {
            WSDDTypeMapping wSDDTypeMapping = new WSDDTypeMapping(elementArray2[i]);
            this.typeMappings.add(wSDDTypeMapping);
        }
        Element[] elementArray3 = this.getChildElements(element, "beanMapping");
        for (int i = 0; i < elementArray3.length; ++i) {
            WSDDBeanMapping wSDDBeanMapping = new WSDDBeanMapping(elementArray3[i]);
            this.typeMappings.add(wSDDBeanMapping);
        }
        Element[] elementArray4 = this.getChildElements(element, "arrayMapping");
        for (int i = 0; i < elementArray4.length; ++i) {
            WSDDArrayMapping wSDDArrayMapping = new WSDDArrayMapping(elementArray4[i]);
            this.typeMappings.add(wSDDArrayMapping);
        }
        Element[] elementArray5 = this.getChildElements(element, "namespace");
        for (int i = 0; i < elementArray5.length; ++i) {
            String string6 = XMLUtils.getChildCharacterData(elementArray5[i]);
            this.namespaces.add(string6);
        }
        if (!this.namespaces.isEmpty()) {
            this.desc.setNamespaceMappings(this.namespaces);
        }
        Element[] elementArray6 = this.getChildElements(element, "role");
        for (int i = 0; i < elementArray6.length; ++i) {
            object2 = XMLUtils.getChildCharacterData(elementArray6[i]);
            this.roles.add(object2);
        }
        Element element3 = this.getChildElement(element, "wsdlFile");
        if (element3 != null) {
            object2 = XMLUtils.getChildCharacterData(element3);
            this.desc.setWSDLFile(((String)object2).trim());
        }
        if ((object2 = this.getChildElement(element, "documentation")) != null) {
            object = new WSDDDocumentation((Element)object2);
            this.desc.setDocumentation(((WSDDDocumentation)object).getValue());
        }
        if ((object = this.getChildElement(element, "endpointURL")) != null) {
            string = XMLUtils.getChildCharacterData((Element)object);
            this.desc.setEndpointURL(string);
        }
        if ((string = element.getAttribute("provider")) != null && !string.equals("")) {
            this.providerQName = XMLUtils.getQNameFromString(string, element);
            if (WSDDConstants.QNAME_JAVAMSG_PROVIDER.equals(this.providerQName)) {
                this.desc.setStyle(Style.MESSAGE);
            }
        }
        if ((element2 = this.getChildElement(element, "handlerInfoChain")) != null) {
            this._wsddHIchain = new WSDDJAXRPCHandlerInfoChain(element2);
        }
        this.initTMR();
        this.validateDescriptors();
    }

    protected void initTMR() throws WSDDException {
        if (this.tmr == null) {
            this.createTMR();
            for (int i = 0; i < this.typeMappings.size(); ++i) {
                this.deployTypeMapping((WSDDTypeMapping)this.typeMappings.get(i));
            }
        }
    }

    private void createTMR() {
        this.tmr = new TypeMappingRegistryImpl(false);
        String string = this.getParameter("typeMappingVersion");
        ((TypeMappingRegistryImpl)this.tmr).doRegisterFromVersion(string);
    }

    public void validateDescriptors() throws WSDDException {
        if (this.tmr == null) {
            this.initTMR();
        }
        this.desc.setTypeMappingRegistry(this.tmr);
        this.desc.setTypeMapping(this.getTypeMapping(this.desc.getUse().getEncoding()));
        String string = this.getParameter("allowedMethods");
        if (string != null && !"*".equals(string)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            this.desc.setAllowedMethods(arrayList);
        }
    }

    public void addTypeMapping(WSDDTypeMapping wSDDTypeMapping) {
        this.typeMappings.add(wSDDTypeMapping);
    }

    public void addOperation(WSDDOperation wSDDOperation) {
        this.operations.add(wSDDOperation);
        this.desc.addOperationDesc(wSDDOperation.getOperationDesc());
    }

    protected QName getElementName() {
        return QNAME_SERVICE;
    }

    public String getServiceDescriptionURL() {
        return this.descriptionURL;
    }

    public void setServiceDescriptionURL(String string) {
        this.descriptionURL = string;
    }

    public QName getProviderQName() {
        return this.providerQName;
    }

    public void setProviderQName(QName qName) {
        this.providerQName = qName;
    }

    public ServiceDesc getServiceDesc() {
        return this.desc;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Use getUse() {
        return this.use;
    }

    public void setUse(Use use) {
        this.use = use;
    }

    public WSDDFaultFlow[] getFaultFlows() {
        WSDDFaultFlow[] wSDDFaultFlowArray = new WSDDFaultFlow[this.faultFlows.size()];
        this.faultFlows.toArray(wSDDFaultFlowArray);
        return wSDDFaultFlowArray;
    }

    public Vector getNamespaces() {
        return this.namespaces;
    }

    public WSDDFaultFlow getFaultFlow(QName qName) {
        WSDDFaultFlow[] wSDDFaultFlowArray = this.getFaultFlows();
        for (int i = 0; i < wSDDFaultFlowArray.length; ++i) {
            if (!wSDDFaultFlowArray[i].getQName().equals(qName)) continue;
            return wSDDFaultFlowArray[i];
        }
        return null;
    }

    public Handler makeNewInstance(EngineConfiguration engineConfiguration) throws ConfigurationException {
        WSDDFaultFlow[] wSDDFaultFlowArray;
        if (this.cachedService != null) {
            return this.cachedService;
        }
        this.initTMR();
        Handler handler = null;
        WSDDRequestFlow wSDDRequestFlow = this.getRequestFlow();
        if (wSDDRequestFlow != null) {
            handler = wSDDRequestFlow.getInstance(engineConfiguration);
        }
        Handler handler2 = null;
        if (this.providerQName != null) {
            try {
                handler2 = WSDDProvider.getInstance(this.providerQName, this, engineConfiguration);
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception);
            }
            if (handler2 == null) {
                throw new WSDDException(Messages.getMessage("couldntConstructProvider00"));
            }
        }
        Handler handler3 = null;
        WSDDResponseFlow wSDDResponseFlow = this.getResponseFlow();
        if (wSDDResponseFlow != null) {
            handler3 = wSDDResponseFlow.getInstance(engineConfiguration);
        }
        SOAPService sOAPService = new SOAPService(handler, handler2, handler3);
        sOAPService.setStyle(this.style);
        sOAPService.setUse(this.use);
        sOAPService.setServiceDescription(this.desc);
        sOAPService.setHighFidelityRecording(!this.streaming);
        sOAPService.setSendType(this.sendType);
        if (this.getQName() != null) {
            sOAPService.setName(this.getQName().getLocalPart());
        }
        sOAPService.setOptions(this.getParametersTable());
        sOAPService.setRoles(this.roles);
        sOAPService.setEngine(((WSDDDeployment)engineConfiguration).getEngine());
        if (this.use != Use.ENCODED) {
            sOAPService.setOption("sendMultiRefs", Boolean.FALSE);
            sOAPService.setOption("sendXsiTypes", Boolean.FALSE);
        }
        if (this._wsddHIchain != null) {
            wSDDFaultFlowArray = this._wsddHIchain.getHandlerChainFactory();
            sOAPService.setOption("handlerInfoChain", wSDDFaultFlowArray);
        }
        AxisEngine.normaliseOptions(sOAPService);
        wSDDFaultFlowArray = this.getFaultFlows();
        if (wSDDFaultFlowArray != null && wSDDFaultFlowArray.length > 0) {
            FaultableHandler faultableHandler = new FaultableHandler(sOAPService);
            for (int i = 0; i < wSDDFaultFlowArray.length; ++i) {
                WSDDFaultFlow wSDDFaultFlow = wSDDFaultFlowArray[i];
                Handler handler4 = wSDDFaultFlow.getInstance(engineConfiguration);
                faultableHandler.setOption("fault-" + wSDDFaultFlow.getQName().getLocalPart(), handler4);
            }
        }
        try {
            sOAPService.getInitializedServiceDesc(MessageContext.getCurrentContext());
        }
        catch (AxisFault axisFault) {
            throw new ConfigurationException(axisFault);
        }
        this.cachedService = sOAPService;
        return sOAPService;
    }

    public void deployTypeMapping(WSDDTypeMapping wSDDTypeMapping) throws WSDDException {
        if (!this.typeMappings.contains(wSDDTypeMapping)) {
            this.typeMappings.add(wSDDTypeMapping);
        }
        if (this.tmr == null) {
            this.createTMR();
        }
        try {
            String string = wSDDTypeMapping.getEncodingStyle();
            if (string == null) {
                string = this.use.getEncoding();
            }
            TypeMapping typeMapping = this.tmr.getOrMakeTypeMapping(string);
            this.desc.setTypeMappingRegistry(this.tmr);
            this.desc.setTypeMapping(typeMapping);
            SerializerFactory serializerFactory = null;
            DeserializerFactory deserializerFactory = null;
            if (wSDDTypeMapping.getSerializerName() != null && !wSDDTypeMapping.getSerializerName().equals("")) {
                serializerFactory = BaseSerializerFactory.createFactory(wSDDTypeMapping.getSerializer(), wSDDTypeMapping.getLanguageSpecificType(), wSDDTypeMapping.getQName());
            }
            if (wSDDTypeMapping instanceof WSDDArrayMapping && serializerFactory instanceof ArraySerializerFactory) {
                WSDDArrayMapping wSDDArrayMapping = (WSDDArrayMapping)wSDDTypeMapping;
                ArraySerializerFactory arraySerializerFactory = (ArraySerializerFactory)serializerFactory;
                arraySerializerFactory.setComponentType(wSDDArrayMapping.getInnerType());
            }
            if (wSDDTypeMapping.getDeserializerName() != null && !wSDDTypeMapping.getDeserializerName().equals("")) {
                deserializerFactory = BaseDeserializerFactory.createFactory(wSDDTypeMapping.getDeserializer(), wSDDTypeMapping.getLanguageSpecificType(), wSDDTypeMapping.getQName());
            }
            typeMapping.register(wSDDTypeMapping.getLanguageSpecificType(), wSDDTypeMapping.getQName(), serializerFactory, deserializerFactory);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.error(Messages.getMessage("unabletoDeployTypemapping00", wSDDTypeMapping.getQName().toString()), classNotFoundException);
            throw new WSDDNonFatalException(classNotFoundException);
        }
        catch (Exception exception) {
            throw new WSDDException(exception);
        }
    }

    public void writeToContext(SerializationContext serializationContext) throws IOException {
        int n;
        AttributesImpl attributesImpl = new AttributesImpl();
        QName qName = this.getQName();
        if (qName != null) {
            attributesImpl.addAttribute("", "name", "name", "CDATA", serializationContext.qName2String(qName));
        }
        if (this.providerQName != null) {
            attributesImpl.addAttribute("", "provider", "provider", "CDATA", serializationContext.qName2String(this.providerQName));
        }
        if (this.style != Style.DEFAULT) {
            attributesImpl.addAttribute("", "style", "style", "CDATA", this.style.getName());
        }
        if (this.use != Use.DEFAULT) {
            attributesImpl.addAttribute("", "use", "use", "CDATA", this.use.getName());
        }
        if (this.streaming) {
            attributesImpl.addAttribute("", "streaming", "streaming", "CDATA", "on");
        }
        if (this.sendType != 1) {
            attributesImpl.addAttribute("", "attachment", "attachment", "CDATA", AttachmentsImpl.getSendTypeString(this.sendType));
        }
        serializationContext.startElement(WSDDConstants.QNAME_SERVICE, attributesImpl);
        if (this.desc.getWSDLFile() != null) {
            serializationContext.startElement(QNAME_WSDLFILE, null);
            serializationContext.writeSafeString(this.desc.getWSDLFile());
            serializationContext.endElement();
        }
        if (this.desc.getDocumentation() != null) {
            WSDDDocumentation wSDDDocumentation = new WSDDDocumentation(this.desc.getDocumentation());
            wSDDDocumentation.writeToContext(serializationContext);
        }
        for (n = 0; n < this.operations.size(); ++n) {
            WSDDOperation wSDDOperation = (WSDDOperation)this.operations.elementAt(n);
            wSDDOperation.writeToContext(serializationContext);
        }
        this.writeFlowsToContext(serializationContext);
        this.writeParamsToContext(serializationContext);
        for (n = 0; n < this.typeMappings.size(); ++n) {
            ((WSDDTypeMapping)this.typeMappings.elementAt(n)).writeToContext(serializationContext);
        }
        for (n = 0; n < this.namespaces.size(); ++n) {
            serializationContext.startElement(QNAME_NAMESPACE, null);
            serializationContext.writeString((String)this.namespaces.get(n));
            serializationContext.endElement();
        }
        String string = this.desc.getEndpointURL();
        if (string != null) {
            serializationContext.startElement(QNAME_ENDPOINTURL, null);
            serializationContext.writeSafeString(string);
            serializationContext.endElement();
        }
        if (this._wsddHIchain != null) {
            this._wsddHIchain.writeToContext(serializationContext);
        }
        serializationContext.endElement();
    }

    public void setCachedService(SOAPService sOAPService) {
        this.cachedService = sOAPService;
    }

    public Vector getTypeMappings() {
        return this.typeMappings;
    }

    public void setTypeMappings(Vector vector) {
        this.typeMappings = vector;
    }

    public void deployToRegistry(WSDDDeployment wSDDDeployment) {
        wSDDDeployment.addService(this);
        wSDDDeployment.registerNamespaceForService(this.getQName().getLocalPart(), this);
        for (int i = 0; i < this.namespaces.size(); ++i) {
            String string = (String)this.namespaces.elementAt(i);
            wSDDDeployment.registerNamespaceForService(string, this);
        }
        super.deployToRegistry(wSDDDeployment);
    }

    public void removeNamespaceMappings(WSDDDeployment wSDDDeployment) {
        for (int i = 0; i < this.namespaces.size(); ++i) {
            String string = (String)this.namespaces.elementAt(i);
            wSDDDeployment.removeNamespaceMapping(string);
        }
        wSDDDeployment.removeNamespaceMapping(this.getQName().getLocalPart());
    }

    public TypeMapping getTypeMapping(String string) {
        if (this.tmr == null) {
            return null;
        }
        return this.tmr.getOrMakeTypeMapping(string);
    }

    public WSDDJAXRPCHandlerInfoChain getHandlerInfoChain() {
        return this._wsddHIchain;
    }

    public void setHandlerInfoChain(WSDDJAXRPCHandlerInfoChain wSDDJAXRPCHandlerInfoChain) {
        this._wsddHIchain = wSDDJAXRPCHandlerInfoChain;
    }
}

