/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.ConfigurationException;
import org.apache.axis.MessageContext;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDElement;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDTypeMapping;
import org.apache.axis.deployment.wsdd.WSDDTypeMappingContainer;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.utils.Messages;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDUndeployment
extends WSDDElement
implements WSDDTypeMappingContainer {
    private Vector handlers = new Vector();
    private Vector chains = new Vector();
    private Vector services = new Vector();
    private Vector transports = new Vector();
    private Vector typeMappings = new Vector();

    public void addHandler(QName qName) {
        this.handlers.add(qName);
    }

    public void addChain(QName qName) {
        this.chains.add(qName);
    }

    public void addTransport(QName qName) {
        this.transports.add(qName);
    }

    public void addService(QName qName) {
        this.services.add(qName);
    }

    public void deployTypeMapping(WSDDTypeMapping wSDDTypeMapping) throws WSDDException {
        this.typeMappings.add(wSDDTypeMapping);
    }

    public WSDDUndeployment() {
    }

    private QName getQName(Element element) throws WSDDException {
        String string = element.getAttribute("name");
        if (string == null || "".equals(string)) {
            throw new WSDDException(Messages.getMessage("badNameAttr00"));
        }
        return new QName("", string);
    }

    public WSDDUndeployment(Element element) throws WSDDException {
        super(element);
        int n;
        Element[] elementArray = this.getChildElements(element, "handler");
        for (n = 0; n < elementArray.length; ++n) {
            this.addHandler(this.getQName(elementArray[n]));
        }
        elementArray = this.getChildElements(element, "chain");
        for (n = 0; n < elementArray.length; ++n) {
            this.addChain(this.getQName(elementArray[n]));
        }
        elementArray = this.getChildElements(element, "transport");
        for (n = 0; n < elementArray.length; ++n) {
            this.addTransport(this.getQName(elementArray[n]));
        }
        elementArray = this.getChildElements(element, "service");
        for (n = 0; n < elementArray.length; ++n) {
            this.addService(this.getQName(elementArray[n]));
        }
    }

    protected QName getElementName() {
        return QNAME_UNDEPLOY;
    }

    public void undeployFromRegistry(WSDDDeployment wSDDDeployment) throws ConfigurationException {
        QName qName;
        int n;
        for (n = 0; n < this.handlers.size(); ++n) {
            qName = (QName)this.handlers.get(n);
            wSDDDeployment.undeployHandler(qName);
        }
        for (n = 0; n < this.chains.size(); ++n) {
            qName = (QName)this.chains.get(n);
            wSDDDeployment.undeployHandler(qName);
        }
        for (n = 0; n < this.transports.size(); ++n) {
            qName = (QName)this.transports.get(n);
            wSDDDeployment.undeployTransport(qName);
        }
        for (n = 0; n < this.services.size(); ++n) {
            qName = (QName)this.services.get(n);
            try {
                SOAPService sOAPService;
                String string = qName.getLocalPart();
                MessageContext messageContext = MessageContext.getCurrentContext();
                if (messageContext != null && (sOAPService = messageContext.getAxisEngine().getService(string)) != null) {
                    sOAPService.clearSessions();
                }
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception);
            }
            wSDDDeployment.undeployService(qName);
        }
    }

    private void writeElement(SerializationContext serializationContext, QName qName, QName qName2) throws IOException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "name", "name", "CDATA", serializationContext.qName2String(qName2));
        serializationContext.startElement(qName, attributesImpl);
        serializationContext.endElement();
    }

    public void writeToContext(SerializationContext serializationContext) throws IOException {
        serializationContext.registerPrefixForURI("", "http://xml.apache.org/axis/wsdd/");
        serializationContext.startElement(WSDDConstants.QNAME_UNDEPLOY, null);
        for (QName qName : this.handlers) {
            this.writeElement(serializationContext, QNAME_HANDLER, qName);
        }
        for (QName qName : this.chains) {
            this.writeElement(serializationContext, QNAME_CHAIN, qName);
        }
        for (QName qName : this.services) {
            this.writeElement(serializationContext, QNAME_SERVICE, qName);
        }
        for (QName qName : this.transports) {
            this.writeElement(serializationContext, QNAME_TRANSPORT, qName);
        }
        for (WSDDTypeMapping wSDDTypeMapping : this.typeMappings) {
            wSDDTypeMapping.writeToContext(serializationContext);
        }
        serializationContext.endElement();
    }

    public WSDDTypeMapping[] getTypeMappings() {
        WSDDTypeMapping[] wSDDTypeMappingArray = new WSDDTypeMapping[this.typeMappings.size()];
        this.typeMappings.toArray(wSDDTypeMappingArray);
        return wSDDTypeMappingArray;
    }
}

