/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.description;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.Holder;
import javax.xml.rpc.server.ServiceLifecycle;
import org.apache.axis.AxisFault;
import org.apache.axis.AxisProperties;
import org.apache.axis.AxisServiceConfig;
import org.apache.axis.Constants;
import org.apache.axis.InternalException;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.description.FaultDesc;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.DefaultTypeMappingImpl;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.TypeMappingRegistryImpl;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.bytecode.ParamNameExtractor;
import org.apache.axis.wsdl.Skeleton;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JavaServiceDesc
implements ServiceDesc {
    protected static Log log = LogFactory.getLog(JavaServiceDesc.class.getName());
    private String name = null;
    private String documentation = null;
    private Style style = Style.RPC;
    private Use use = Use.ENCODED;
    private boolean useSet = false;
    private ArrayList operations = new ArrayList();
    private List namespaceMappings = null;
    private String wsdlFileName = null;
    private String endpointURL = null;
    private HashMap properties = null;
    private HashMap name2OperationsMap = null;
    private HashMap qname2OperationsMap = null;
    private transient HashMap method2OperationMap = new HashMap();
    private List allowedMethods = null;
    private List disallowedMethods = null;
    private Class implClass = null;
    private boolean isSkeletonClass = false;
    private transient Method skelMethod = null;
    private ArrayList stopClasses = null;
    private transient HashMap method2ParamsMap = new HashMap();
    private OperationDesc messageServiceDefaultOp = null;
    private ArrayList completedNames = new ArrayList();
    private TypeMapping tm = null;
    private TypeMappingRegistry tmr = null;
    private boolean haveAllSkeletonMethods = false;
    private boolean introspectionComplete = false;

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
        if (!this.useSet) {
            this.use = style == Style.RPC ? Use.ENCODED : Use.LITERAL;
        }
    }

    public Use getUse() {
        return this.use;
    }

    public void setUse(Use use) {
        this.useSet = true;
        this.use = use;
    }

    public boolean isWrapped() {
        return this.style == Style.RPC || this.style == Style.WRAPPED;
    }

    public String getWSDLFile() {
        return this.wsdlFileName;
    }

    public void setWSDLFile(String string) {
        this.wsdlFileName = string;
    }

    public List getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(List list) {
        this.allowedMethods = list;
    }

    public Class getImplClass() {
        return this.implClass;
    }

    public void setImplClass(Class clazz) {
        if (this.implClass != null) {
            throw new IllegalArgumentException(Messages.getMessage("implAlreadySet"));
        }
        this.implClass = clazz;
        if (Skeleton.class.isAssignableFrom(clazz)) {
            this.isSkeletonClass = true;
            this.loadSkeletonOperations();
        }
    }

    private void loadSkeletonOperations() {
        Method method = null;
        try {
            method = this.implClass.getDeclaredMethod("getOperationDescs", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (method == null) {
            return;
        }
        try {
            Collection collection = (Collection)method.invoke((Object)this.implClass, (Object[])null);
            for (OperationDesc operationDesc : collection) {
                this.addOperationDesc(operationDesc);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("exception00"), illegalAccessException);
            }
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("exception00"), illegalArgumentException);
            }
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("exception00"), invocationTargetException);
            }
            return;
        }
        this.haveAllSkeletonMethods = true;
    }

    public TypeMapping getTypeMapping() {
        if (this.tm == null) {
            return DefaultTypeMappingImpl.getSingletonDelegate();
        }
        return this.tm;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.tm = typeMapping;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String string) {
        this.documentation = string;
    }

    public ArrayList getStopClasses() {
        return this.stopClasses;
    }

    public void setStopClasses(ArrayList arrayList) {
        this.stopClasses = arrayList;
    }

    public List getDisallowedMethods() {
        return this.disallowedMethods;
    }

    public void setDisallowedMethods(List list) {
        this.disallowedMethods = list;
    }

    public void removeOperationDesc(OperationDesc operationDesc) {
        Object object;
        ArrayList arrayList;
        this.operations.remove(operationDesc);
        operationDesc.setParent(null);
        if (this.name2OperationsMap != null && (arrayList = (ArrayList)this.name2OperationsMap.get(object = operationDesc.getName())) != null) {
            arrayList.remove(operationDesc);
            if (arrayList.size() == 0) {
                this.name2OperationsMap.remove(object);
            }
        }
        if (this.qname2OperationsMap != null && (arrayList = (ArrayList)this.qname2OperationsMap.get(object = operationDesc.getElementQName())) != null) {
            arrayList.remove(operationDesc);
        }
        if (this.method2OperationMap != null && (object = operationDesc.getMethod()) != null) {
            this.method2OperationMap.remove(object);
        }
    }

    public void addOperationDesc(OperationDesc operationDesc) {
        String string;
        ArrayList<OperationDesc> arrayList;
        this.operations.add(operationDesc);
        operationDesc.setParent(this);
        if (this.name2OperationsMap == null) {
            this.name2OperationsMap = new HashMap();
        }
        if ((arrayList = (ArrayList<OperationDesc>)this.name2OperationsMap.get(string = operationDesc.getName())) == null) {
            arrayList = new ArrayList<OperationDesc>();
            this.name2OperationsMap.put(string, arrayList);
        } else if (JavaUtils.isTrue(AxisProperties.getProperty("axis.ws-i.bp11.compatibility")) && arrayList.size() > 0) {
            throw new RuntimeException(Messages.getMessage("noOverloadedOperations", string));
        }
        arrayList.add(operationDesc);
    }

    public ArrayList getOperations() {
        this.loadServiceDescByIntrospection();
        return this.operations;
    }

    public OperationDesc[] getOperationsByName(String string) {
        this.getSyncedOperationsForName(this.implClass, string);
        if (this.name2OperationsMap == null) {
            return null;
        }
        ArrayList arrayList = (ArrayList)this.name2OperationsMap.get(string);
        if (arrayList == null) {
            return null;
        }
        OperationDesc[] operationDescArray = new OperationDesc[arrayList.size()];
        return arrayList.toArray(operationDescArray);
    }

    public OperationDesc getOperationByName(String string) {
        this.getSyncedOperationsForName(this.implClass, string);
        if (this.name2OperationsMap == null) {
            return null;
        }
        ArrayList arrayList = (ArrayList)this.name2OperationsMap.get(string);
        if (arrayList == null) {
            return null;
        }
        return (OperationDesc)arrayList.get(0);
    }

    public OperationDesc getOperationByElementQName(QName qName) {
        OperationDesc[] operationDescArray = this.getOperationsByQName(qName);
        if (operationDescArray != null && operationDescArray.length > 0) {
            return operationDescArray[0];
        }
        return null;
    }

    public OperationDesc[] getOperationsByQName(QName qName) {
        Object object;
        this.initQNameMap();
        ArrayList arrayList = (ArrayList)this.qname2OperationsMap.get(qName);
        if (arrayList == null) {
            if (this.name2OperationsMap != null) {
                if (this.isWrapped() || this.style == Style.MESSAGE && this.getDefaultNamespace() == null) {
                    arrayList = (ArrayList)this.name2OperationsMap.get(qName.getLocalPart());
                } else {
                    object = this.name2OperationsMap.get(qName.getLocalPart());
                    if (object != null) {
                        arrayList = new ArrayList((Collection)object);
                        Iterator iterator = arrayList.iterator();
                        while (iterator.hasNext()) {
                            OperationDesc operationDesc = (OperationDesc)iterator.next();
                            if (Style.WRAPPED == operationDesc.getStyle()) continue;
                            iterator.remove();
                        }
                    }
                }
            }
            if (this.style == Style.MESSAGE && this.messageServiceDefaultOp != null) {
                return new OperationDesc[]{this.messageServiceDefaultOp};
            }
            if (arrayList == null) {
                return null;
            }
        }
        this.getSyncedOperationsForName(this.implClass, ((OperationDesc)arrayList.get(0)).getName());
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                Method method = ((OperationDesc)object).getMethod();
                Method method2 = ((OperationDesc)object2).getMethod();
                return method.getParameterTypes().length - method2.getParameterTypes().length;
            }
        });
        object = new OperationDesc[arrayList.size()];
        return (OperationDesc[])arrayList.toArray((T[])object);
    }

    private synchronized void initQNameMap() {
        if (this.qname2OperationsMap == null) {
            this.loadServiceDescByIntrospection();
            this.qname2OperationsMap = new HashMap();
            for (OperationDesc operationDesc : this.operations) {
                QName qName = operationDesc.getElementQName();
                ArrayList<OperationDesc> arrayList = (ArrayList<OperationDesc>)this.qname2OperationsMap.get(qName);
                if (arrayList == null) {
                    arrayList = new ArrayList<OperationDesc>();
                    this.qname2OperationsMap.put(qName, arrayList);
                }
                arrayList.add(operationDesc);
            }
        }
    }

    private void syncOperationToClass(OperationDesc operationDesc, Class clazz) {
        Object object;
        if (operationDesc.getMethod() != null) {
            return;
        }
        Method[] methodArray = this.getMethods(clazz);
        Object object2 = null;
        for (int i = 0; i < methodArray.length; ++i) {
            int n;
            object = methodArray[i];
            if (!Modifier.isPublic(((Method)object).getModifiers()) || !((Method)object).getName().equals(operationDesc.getName()) || this.method2OperationMap.get(object) != null) continue;
            if (this.style == Style.MESSAGE) {
                int n2 = this.checkMessageMethod((Method)object);
                if (n2 == -4) continue;
                if (n2 == -1) {
                    throw new InternalException("Couldn't match method to any of the allowable message-style patterns!");
                }
                operationDesc.setMessageOperationStyle(n2);
                object2 = object;
                break;
            }
            Class<?>[] classArray = ((Method)object).getParameterTypes();
            if (classArray.length != operationDesc.getNumParams()) continue;
            boolean bl = false;
            for (n = 0; n < classArray.length; ++n) {
                ParameterDesc parameterDesc;
                QName qName;
                Class clazz2;
                Class clazz3 = clazz2 = classArray[n];
                if (Holder.class.isAssignableFrom(clazz2)) {
                    clazz3 = JavaUtils.getHolderValueType(clazz2);
                }
                if ((qName = (parameterDesc = operationDesc.getParameter(n)).getTypeQName()) == null) {
                    qName = this.getTypeMapping().getTypeQName(clazz3);
                    parameterDesc.setTypeQName(qName);
                } else {
                    Class clazz4 = parameterDesc.getJavaType();
                    if (clazz4 != null && JavaUtils.getHolderValueType(clazz4) != null) {
                        clazz4 = JavaUtils.getHolderValueType(clazz4);
                    }
                    if (clazz4 == null) {
                        clazz4 = this.getTypeMapping().getClassForQName(parameterDesc.getTypeQName(), clazz2);
                    }
                    if (clazz4 != null) {
                        if (!JavaUtils.isConvertable(clazz4, clazz3)) break;
                        if (!clazz3.isAssignableFrom(clazz4)) {
                            bl = true;
                        }
                    }
                }
                parameterDesc.setJavaType(clazz2);
            }
            if (n != classArray.length) continue;
            object2 = object;
            if (!bl) break;
        }
        if (object2 != null) {
            Class<?> clazz5 = ((Method)object2).getReturnType();
            operationDesc.setReturnClass(clazz5);
            object = operationDesc.getReturnType();
            if (object == null) {
                operationDesc.setReturnType(this.getTypeMapping().getTypeQName(clazz5));
            }
            this.createFaultMetadata((Method)object2, operationDesc);
            operationDesc.setMethod((Method)object2);
            this.method2OperationMap.put(object2, operationDesc);
            return;
        }
        Class clazz6 = clazz.getSuperclass();
        if (!(clazz6 == null || clazz6.getName().startsWith("java.") || clazz6.getName().startsWith("javax.") || this.stopClasses != null && this.stopClasses.contains(clazz6.getName()))) {
            this.syncOperationToClass(operationDesc, clazz6);
        }
        if (operationDesc.getMethod() == null) {
            object = new InternalException(Messages.getMessage("serviceDescOperSync00", operationDesc.getName(), clazz.getName()));
            throw object;
        }
    }

    private Method[] getMethods(Class clazz) {
        if (clazz.isInterface()) {
            return clazz.getMethods();
        }
        return clazz.getDeclaredMethods();
    }

    private int checkMessageMethod(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length == 1) {
            if (classArray[0] == Element[].class && method.getReturnType() == Element[].class) {
                return 3;
            }
            if (classArray[0] == SOAPBodyElement[].class && method.getReturnType() == SOAPBodyElement[].class) {
                return 1;
            }
            if (classArray[0] == Document.class && method.getReturnType() == Document.class) {
                return 4;
            }
        } else if (classArray.length == 2 && (classArray[0] == SOAPEnvelope.class && classArray[1] == SOAPEnvelope.class || classArray[0] == javax.xml.soap.SOAPEnvelope.class && classArray[1] == javax.xml.soap.SOAPEnvelope.class && method.getReturnType() == Void.TYPE)) {
            return 2;
        }
        if (null != this.allowedMethods && !this.allowedMethods.isEmpty()) {
            throw new InternalException(Messages.getMessage("badMsgMethodParams", method.getName()));
        }
        return -4;
    }

    public void loadServiceDescByIntrospection() {
        this.loadServiceDescByIntrospection(this.implClass);
        this.completedNames = null;
    }

    public void loadServiceDescByIntrospection(Class clazz) {
        Iterator iterator;
        if (this.introspectionComplete || clazz == null) {
            return;
        }
        this.implClass = clazz;
        if (Skeleton.class.isAssignableFrom(clazz)) {
            this.isSkeletonClass = true;
            this.loadSkeletonOperations();
        }
        AxisServiceConfig axisServiceConfig = null;
        try {
            iterator = clazz.getDeclaredMethod("getAxisServiceConfig", new Class[0]);
            if (iterator != null && Modifier.isStatic(((Method)((Object)iterator)).getModifiers())) {
                axisServiceConfig = (AxisServiceConfig)((Method)((Object)iterator)).invoke(null, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (axisServiceConfig != null && (iterator = axisServiceConfig.getAllowedMethods()) != null && !"*".equals(iterator)) {
            Serializable serializable = new ArrayList();
            StringTokenizer stringTokenizer = new StringTokenizer((String)((Object)iterator), " ,");
            while (stringTokenizer.hasMoreTokens()) {
                ((ArrayList)serializable).add(stringTokenizer.nextToken());
            }
            this.setAllowedMethods((List)((Object)serializable));
        }
        this.loadServiceDescByIntrospectionRecursive(clazz);
        for (Serializable serializable : this.operations) {
            if (((OperationDesc)serializable).getMethod() != null) continue;
            throw new InternalException(Messages.getMessage("badWSDDOperation", ((OperationDesc)serializable).getName(), "" + ((OperationDesc)serializable).getNumParams()));
        }
        if (this.style == Style.MESSAGE && this.operations.size() == 1) {
            this.messageServiceDefaultOp = (OperationDesc)this.operations.get(0);
        }
        this.introspectionComplete = true;
    }

    private boolean isServiceLifeCycleMethod(Class clazz, Method method) {
        Class<?>[] classArray;
        Class<?>[] classArray2;
        String string;
        return ServiceLifecycle.class.isAssignableFrom(clazz) && ((string = method.getName()).equals("init") ? (classArray2 = method.getParameterTypes()) != null && classArray2.length == 1 && classArray2[0] == Object.class && method.getReturnType() == Void.TYPE : string.equals("destroy") && (classArray = method.getParameterTypes()) != null && classArray.length == 0 && method.getReturnType() == Void.TYPE);
    }

    private void loadServiceDescByIntrospectionRecursive(Class clazz) {
        if (Skeleton.class.equals((Object)clazz)) {
            return;
        }
        Method[] methodArray = this.getMethods(clazz);
        for (int i = 0; i < methodArray.length; ++i) {
            if (!Modifier.isPublic(methodArray[i].getModifiers()) || this.isServiceLifeCycleMethod(clazz, methodArray[i])) continue;
            this.getSyncedOperationsForName(clazz, methodArray[i].getName());
        }
        if (clazz.isInterface()) {
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                Class<?> clazz2 = classArray[i];
                if (clazz2.getName().startsWith("java.") || clazz2.getName().startsWith("javax.") || this.stopClasses != null && this.stopClasses.contains(clazz2.getName())) continue;
                this.loadServiceDescByIntrospectionRecursive(clazz2);
            }
        } else {
            Class clazz3 = clazz.getSuperclass();
            if (!(clazz3 == null || clazz3.getName().startsWith("java.") || clazz3.getName().startsWith("javax.") || this.stopClasses != null && this.stopClasses.contains(clazz3.getName()))) {
                this.loadServiceDescByIntrospectionRecursive(clazz3);
            }
        }
    }

    public void loadServiceDescByIntrospection(Class clazz, TypeMapping typeMapping) {
        this.implClass = clazz;
        this.tm = typeMapping;
        if (Skeleton.class.isAssignableFrom(this.implClass)) {
            this.isSkeletonClass = true;
            this.loadSkeletonOperations();
        }
        this.loadServiceDescByIntrospection();
    }

    private void getSyncedOperationsForName(Class clazz, String string) {
        List list;
        if (this.isSkeletonClass && (string.equals("getOperationDescByName") || string.equals("getOperationDescs"))) {
            return;
        }
        if (clazz == null) {
            return;
        }
        if (this.completedNames == null || this.completedNames.contains(string)) {
            return;
        }
        if (this.allowedMethods != null && !this.allowedMethods.contains(string)) {
            return;
        }
        if (this.disallowedMethods != null && this.disallowedMethods.contains(string)) {
            return;
        }
        if (this.isSkeletonClass && !this.haveAllSkeletonMethods) {
            if (this.skelMethod == null) {
                try {
                    this.skelMethod = clazz.getDeclaredMethod("getOperationDescByName", String.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (this.skelMethod == null) {
                    return;
                }
            }
            try {
                list = (List)this.skelMethod.invoke((Object)clazz, string);
                if (list != null) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        this.addOperationDesc((OperationDesc)iterator.next());
                    }
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("exception00"), illegalAccessException);
                }
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("exception00"), illegalArgumentException);
                }
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("exception00"), invocationTargetException);
                }
                return;
            }
        }
        if (this.name2OperationsMap != null && (list = (ArrayList)this.name2OperationsMap.get(string)) != null) {
            for (OperationDesc operationDesc : list) {
                if (operationDesc.getMethod() != null) continue;
                this.syncOperationToClass(operationDesc, clazz);
            }
        }
        this.createOperationsForName(clazz, string);
        this.completedNames.add(string);
    }

    private String getUniqueOperationName(String string) {
        String string2;
        int n = 1;
        while (this.name2OperationsMap.get(string2 = string + n++) != null) {
        }
        return string2;
    }

    private void createOperationsForName(Class clazz, String string) {
        if (this.isSkeletonClass && (string.equals("getOperationDescByName") || string.equals("getOperationDescs"))) {
            return;
        }
        Method[] methodArray = this.getMethods(clazz);
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!Modifier.isPublic(method.getModifiers()) || !method.getName().equals(string) || this.isServiceLifeCycleMethod(clazz, method)) continue;
            this.createOperationForMethod(method);
        }
        Class clazz2 = clazz.getSuperclass();
        if (!(clazz2 == null || clazz2.getName().startsWith("java.") || clazz2.getName().startsWith("javax.") || this.stopClasses != null && this.stopClasses.contains(clazz2.getName()))) {
            this.createOperationsForName(clazz2, string);
        }
    }

    private void createOperationForMethod(Method method) {
        int n;
        Object object;
        Object object2;
        OperationDesc operationDesc;
        int n2;
        ArrayList arrayList;
        if (this.method2OperationMap.get(method) != null) {
            return;
        }
        Class<?>[] classArray = method.getParameterTypes();
        ArrayList arrayList2 = arrayList = this.name2OperationsMap == null ? null : (ArrayList)this.name2OperationsMap.get(method.getName());
        if (arrayList != null && !arrayList.isEmpty()) {
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                operationDesc = (OperationDesc)arrayList.get(n2);
                object2 = operationDesc.getMethod();
                if (object2 == null || classArray.length != ((Class<?>[])(object = ((Method)object2).getParameterTypes())).length) continue;
                for (n = 0; n < ((Class<?>[])object).length && object[n].equals(classArray[n]); ++n) {
                }
                if (n != ((Class<?>[])object).length) continue;
                return;
            }
        }
        n2 = JavaUtils.isTrue(AxisProperties.getProperty("axis.ws-i.bp11.compatibility"));
        operationDesc = new OperationDesc();
        object2 = method.getName();
        if (n2 != 0 && this.name2OperationsMap != null) {
            object = this.name2OperationsMap.keySet();
            object2 = JavaUtils.getUniqueValue(object, (String)object2);
        }
        operationDesc.setName((String)object2);
        object = "";
        if (this.namespaceMappings != null && !this.namespaceMappings.isEmpty()) {
            object = (String)this.namespaceMappings.get(0);
        }
        if (object.length() == 0) {
            object = Namespaces.makeNamespace(method.getDeclaringClass().getName());
        }
        operationDesc.setElementQName(new QName((String)object, (String)object2));
        operationDesc.setMethod(method);
        if (this.style == Style.MESSAGE) {
            n = this.checkMessageMethod(method);
            if (n == -4) {
                return;
            }
            if (n == -1) {
                throw new InternalException("Couldn't match method to any of the allowable message-style patterns!");
            }
            operationDesc.setMessageOperationStyle(n);
            operationDesc.setReturnClass(Object.class);
            operationDesc.setReturnType(Constants.XSD_ANYTYPE);
        } else {
            Class<?> clazz = method.getReturnType();
            operationDesc.setReturnClass(clazz);
            QName qName = this.getTypeQName(clazz);
            operationDesc.setReturnType(qName);
            String[] stringArray = this.getParamNames(method);
            for (int i = 0; i < classArray.length; ++i) {
                String string;
                Class<?> clazz2 = classArray[i];
                ParameterDesc parameterDesc = new ParameterDesc();
                String string2 = string = this.style == Style.RPC ? "" : operationDesc.getElementQName().getNamespaceURI();
                if (stringArray != null && stringArray[i] != null && stringArray[i].length() > 0) {
                    parameterDesc.setQName(new QName(string, stringArray[i]));
                } else {
                    parameterDesc.setQName(new QName(string, "in" + i));
                }
                Class clazz3 = JavaUtils.getHolderValueType(clazz2);
                if (clazz3 != null) {
                    parameterDesc.setMode((byte)3);
                    parameterDesc.setTypeQName(this.getTypeQName(clazz3));
                } else {
                    parameterDesc.setMode((byte)1);
                    parameterDesc.setTypeQName(this.getTypeQName(clazz2));
                }
                parameterDesc.setJavaType(clazz2);
                operationDesc.addParameter(parameterDesc);
            }
        }
        this.createFaultMetadata(method, operationDesc);
        this.addOperationDesc(operationDesc);
        this.method2OperationMap.put(method, operationDesc);
    }

    private QName getTypeQName(Class clazz) {
        QName qName;
        TypeMapping typeMapping = this.getTypeMapping();
        qName = this.style == Style.RPC ? typeMapping.getTypeQName(clazz) : ((qName = typeMapping.getTypeQNameExact(clazz)) == null && clazz.isArray() ? typeMapping.getTypeQName(clazz.getComponentType()) : typeMapping.getTypeQName(clazz));
        return qName;
    }

    private void createFaultMetadata(Method method, OperationDesc operationDesc) {
        Class<?>[] classArray = method.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            Object object;
            boolean bl;
            Class<?> clazz = classArray[i];
            if (clazz == RemoteException.class || clazz == AxisFault.class || clazz.getName().startsWith("java.") || clazz.getName().startsWith("javax.")) continue;
            FaultDesc faultDesc = operationDesc.getFaultByClass(clazz, false);
            if (faultDesc == null) {
                faultDesc = new FaultDesc();
                bl = true;
            } else {
                bl = false;
            }
            QName qName = faultDesc.getXmlType();
            if (qName == null) {
                faultDesc.setXmlType(this.getTypeMapping().getTypeQName(clazz));
            }
            String string = clazz.getName();
            if (faultDesc.getClassName() == null) {
                faultDesc.setClassName(string);
            }
            if (faultDesc.getName() == null) {
                object = string.substring(string.lastIndexOf(46) + 1, string.length());
                faultDesc.setName((String)object);
            }
            if (faultDesc.getParameters() == null) {
                if (qName == null) {
                    qName = this.getTypeMapping().getTypeQName(clazz);
                }
                if ((object = faultDesc.getQName()) == null) {
                    object = new QName("", "fault");
                }
                ParameterDesc parameterDesc = new ParameterDesc((QName)object, 1, qName);
                parameterDesc.setJavaType(clazz);
                ArrayList<ParameterDesc> arrayList = new ArrayList<ParameterDesc>();
                arrayList.add(parameterDesc);
                faultDesc.setParameters(arrayList);
            }
            if (faultDesc.getQName() == null) {
                faultDesc.setQName(new QName(string));
            }
            if (!bl) continue;
            operationDesc.addFault(faultDesc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getParamNames(Method method) {
        HashMap hashMap = this.method2ParamsMap;
        synchronized (hashMap) {
            String[] stringArray = (String[])this.method2ParamsMap.get(method);
            if (stringArray != null) {
                return stringArray;
            }
            stringArray = ParamNameExtractor.getParameterNamesFromDebugInfo(method);
            this.method2ParamsMap.put(method, stringArray);
            return stringArray;
        }
    }

    public void setNamespaceMappings(List list) {
        this.namespaceMappings = list;
    }

    public String getDefaultNamespace() {
        if (this.namespaceMappings == null || this.namespaceMappings.isEmpty()) {
            return null;
        }
        return (String)this.namespaceMappings.get(0);
    }

    public void setDefaultNamespace(String string) {
        if (this.namespaceMappings == null) {
            this.namespaceMappings = new ArrayList();
        }
        this.namespaceMappings.add(0, string);
    }

    public void setProperty(String string, Object object) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(string, object);
    }

    public Object getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(string);
    }

    public String getEndpointURL() {
        return this.endpointURL;
    }

    public void setEndpointURL(String string) {
        this.endpointURL = string;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.tmr == null) {
            this.tmr = new TypeMappingRegistryImpl(false);
        }
        return this.tmr;
    }

    public void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        this.tmr = typeMappingRegistry;
    }

    public boolean isInitialized() {
        return this.implClass != null;
    }
}

